/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.sync;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactIdentity;
import io.olvid.engine.identity.databases.ContactIdentityDetails;
import io.olvid.engine.identity.databases.ContactTrustOrigin;
import io.olvid.engine.identity.databases.sync.IdentityDetailsSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContactSyncSnapshot
implements ObvSyncSnapshotNode {
    public static final String TRUSTED_DETAILS = "trusted_details";
    public static final String PUBLISHED_DETAILS = "published_details";
    public static final String ONE_TO_ONE = "one_to_one";
    public static final String REVOKED = "revoked";
    public static final String FORCEFULLY_TRUSTED = "forcefully_trusted";
    public static final String TRUST_LEVEL = "trust_level";
    public static final String TRUST_ORIGINS = "trust_origins";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(Arrays.asList("trusted_details", "published_details", "one_to_one", "revoked", "forcefully_trusted", "trust_level", "trust_origins"));
    public IdentityDetailsSyncSnapshot trusted_details;
    public IdentityDetailsSyncSnapshot published_details;
    public Boolean one_to_one;
    public Boolean revoked;
    public Boolean forcefully_trusted;
    public String trust_level;
    public List<TrustOrigin> trust_origins;
    public HashSet<String> domain;

    public static ContactSyncSnapshot of(IdentityManagerSession identityManagerSession, ContactIdentity contact) throws SQLException {
        ContactSyncSnapshot contactSyncSnapshot = new ContactSyncSnapshot();
        ContactIdentityDetails trustedDetails = contact.getTrustedDetails();
        contactSyncSnapshot.trusted_details = IdentityDetailsSyncSnapshot.of(identityManagerSession, trustedDetails);
        if (contact.getTrustedDetailsVersion() != contact.getPublishedDetailsVersion()) {
            ContactIdentityDetails publishedDetails = contact.getPublishedDetails();
            contactSyncSnapshot.published_details = IdentityDetailsSyncSnapshot.of(identityManagerSession, publishedDetails);
        }
        contactSyncSnapshot.one_to_one = contact.isOneToOne() ? Boolean.TRUE : (contact.isNotOneToOne() ? Boolean.FALSE : null);
        contactSyncSnapshot.revoked = contact.isRevokedAsCompromised() ? Boolean.valueOf(true) : null;
        contactSyncSnapshot.forcefully_trusted = contact.isForcefullyTrustedByUser() ? Boolean.valueOf(true) : null;
        contactSyncSnapshot.trust_level = contact.getTrustLevel().toString();
        contactSyncSnapshot.trust_origins = new ArrayList<TrustOrigin>();
        for (ContactTrustOrigin contactTrustOrigin : ContactTrustOrigin.getAll(identityManagerSession, contact.getContactIdentity(), contact.getOwnedIdentity())) {
            contactSyncSnapshot.trust_origins.add(TrustOrigin.of(contactTrustOrigin));
        }
        contactSyncSnapshot.domain = DEFAULT_DOMAIN;
        return contactSyncSnapshot;
    }

    @JsonIgnore
    public ContactIdentity restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        TrustLevel trustLevel;
        if (!this.domain.contains(TRUSTED_DETAILS)) {
            Logger.e("Trying to restore an incomplete ContactSyncSnapshot. Domain: " + String.valueOf(this.domain));
            throw new Exception();
        }
        ContactIdentityDetails trustedDetails = this.trusted_details.restoreContact(identityManagerSession, ownedIdentity, contactIdentity);
        ContactIdentityDetails publishedDetails = this.domain.contains(PUBLISHED_DETAILS) && this.published_details != null && !Objects.equals(this.trusted_details.version, this.published_details.version) ? this.published_details.restoreContact(identityManagerSession, ownedIdentity, contactIdentity) : null;
        TrustLevel trustLevel2 = trustLevel = this.domain.contains(TRUST_LEVEL) && this.trust_level != null ? TrustLevel.of(this.trust_level) : new TrustLevel(0, 0);
        int oneToOne = this.domain.contains(ONE_TO_ONE) && this.one_to_one != null ? (this.one_to_one.booleanValue() ? 1 : 0) : 2;
        ContactIdentity contactIdentityObject = new ContactIdentity(identityManagerSession, contactIdentity, ownedIdentity, trustedDetails.getVersion(), trustLevel, oneToOne);
        if (publishedDetails != null) {
            contactIdentityObject.publishedDetailsVersion = publishedDetails.getVersion();
        }
        contactIdentityObject.revokedAsCompromised = this.domain.contains(REVOKED) && this.revoked != null && this.revoked != false;
        contactIdentityObject.forcefullyTrustedByUser = this.domain.contains(FORCEFULLY_TRUSTED) && this.forcefully_trusted != null && this.forcefully_trusted != false;
        contactIdentityObject.insert();
        JsonKeycloakUserDetails jsonKeycloakUserDetails = identityManagerSession.identityDelegate.verifyKeycloakIdentitySignature(identityManagerSession.session, ownedIdentity, trustedDetails.getJsonIdentityDetailsWithVersionAndPhoto().getIdentityDetails().getSignedUserDetails());
        if (jsonKeycloakUserDetails != null) {
            contactIdentityObject.setCertifiedByOwnKeycloak(true, trustedDetails.getSerializedJsonDetails());
        }
        if (this.domain.contains(TRUST_ORIGINS) && this.trust_origins != null) {
            block9: for (TrustOrigin trustOrigin : this.trust_origins) {
                int trustType;
                Identity mediatorOrGroupOwnerIdentity = null;
                try {
                    if (trustOrigin.mediator_or_group_owner_identity != null) {
                        mediatorOrGroupOwnerIdentity = Identity.of(trustOrigin.mediator_or_group_owner_identity);
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                switch (TrustOrigin.TrustType.fromIntValue(trustOrigin.trust_type).ordinal()) {
                    case 0: {
                        trustType = 1;
                        break;
                    }
                    case 1: {
                        trustType = 3;
                        break;
                    }
                    case 2: {
                        trustType = 2;
                        break;
                    }
                    case 3: {
                        trustType = 4;
                        break;
                    }
                    case 4: {
                        trustType = 5;
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                ContactTrustOrigin contactTrustOrigin = new ContactTrustOrigin(identityManagerSession, contactIdentity, ownedIdentity, trustOrigin.timestamp, trustType, mediatorOrGroupOwnerIdentity, 0, trustOrigin.identity_server, trustOrigin.raw_obv_group_v2_identifier);
                contactTrustOrigin.insert();
            }
        }
        return contactIdentityObject;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TrustOrigin {
        public long timestamp;
        public int trust_type;
        public byte[] mediator_or_group_owner_identity;
        public String identity_server;
        public byte[] raw_obv_group_v2_identifier;

        private static TrustOrigin of(ContactTrustOrigin contactTrustOrigin) {
            io.olvid.engine.datatypes.containers.TrustOrigin trustOrigin = contactTrustOrigin.getTrustOrigin();
            TrustOrigin to = new TrustOrigin();
            to.timestamp = trustOrigin.getTimestamp();
            switch (trustOrigin.getType()) {
                case DIRECT: {
                    to.trust_type = TrustType.TYPE_DIRECT.value;
                    break;
                }
                case INTRODUCTION: {
                    to.trust_type = TrustType.TYPE_INTRODUCTION.value;
                    to.mediator_or_group_owner_identity = trustOrigin.getMediatorOrGroupOwnerIdentity().getBytes();
                    break;
                }
                case GROUP: {
                    to.trust_type = TrustType.TYPE_GROUP.value;
                    to.mediator_or_group_owner_identity = trustOrigin.getMediatorOrGroupOwnerIdentity().getBytes();
                    break;
                }
                case KEYCLOAK: {
                    to.trust_type = TrustType.TYPE_KEYCLOAK.value;
                    to.identity_server = trustOrigin.getKeycloakServer();
                    break;
                }
                case SERVER_GROUP_V2: {
                    to.trust_type = TrustType.TYPE_SERVER_GROUP_V2.value;
                    to.raw_obv_group_v2_identifier = trustOrigin.getGroupIdentifier().getBytes();
                }
            }
            return to;
        }

        static enum TrustType {
            TYPE_DIRECT(0),
            TYPE_GROUP(1),
            TYPE_INTRODUCTION(2),
            TYPE_KEYCLOAK(3),
            TYPE_SERVER_GROUP_V2(4);

            private static final Map<Integer, TrustType> valueMap;
            public final int value;

            private TrustType(int value) {
                this.value = value;
            }

            static TrustType fromIntValue(int value) {
                return valueMap.get(value);
            }

            static {
                valueMap = new HashMap<Integer, TrustType>();
                for (TrustType trustType : TrustType.values()) {
                    valueMap.put(trustType.value, trustType);
                }
            }
        }
    }
}

