/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases.backups;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.sync.ObvSyncDiff;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.backups.OwnedIdentityDeviceSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IdentityManagerDeviceSnapshot
implements ObvSyncSnapshotNode {
    public static final String OWNED_IDENTITIES = "owned_identities";
    static HashSet<String> DEFAULT_DOMAIN = new HashSet<String>(List.of("owned_identities"));
    @JsonSerialize(keyUsing=ObvBytesKey.KeySerializer.class)
    @JsonDeserialize(keyUsing=ObvBytesKey.KeyDeserializer.class)
    public HashMap<ObvBytesKey, OwnedIdentityDeviceSnapshot> owned_identities;
    public HashSet<String> domain;

    public static IdentityManagerDeviceSnapshot of(IdentityManagerSession identityManagerSession) throws SQLException {
        IdentityManagerDeviceSnapshot identityManagerDeviceSnapshot = new IdentityManagerDeviceSnapshot();
        identityManagerDeviceSnapshot.owned_identities = new HashMap();
        for (OwnedIdentity ownedIdentity : OwnedIdentity.getAll(identityManagerSession)) {
            identityManagerDeviceSnapshot.owned_identities.put(new ObvBytesKey(ownedIdentity.getOwnedIdentity().getBytes()), OwnedIdentityDeviceSnapshot.of(identityManagerSession, ownedIdentity));
        }
        identityManagerDeviceSnapshot.domain = DEFAULT_DOMAIN;
        return identityManagerDeviceSnapshot;
    }

    public boolean validate() {
        return this.domain.containsAll(DEFAULT_DOMAIN) && this.owned_identities != null;
    }

    @Override
    public boolean areContentsTheSame(ObvSyncSnapshotNode otherSnapshotNode) {
        return false;
    }

    @Override
    public List<ObvSyncDiff> computeDiff(ObvSyncSnapshotNode otherSnapshotNode) throws Exception {
        return null;
    }
}

