/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.UserData;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class ServerUserData
implements ObvDatabase {
    static final String TABLE_NAME = "server_user_data";
    private final IdentityManagerSession identityManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private UID label;
    static final String LABEL = "label";
    private long nextRefreshTimestamp;
    static final String NEXT_REFRESH_TIMESTAMP = "next_refresh_timestamp";
    private byte[] bytesGroupOwnerAndUidOrIdentifier;
    static final String BYTES_GROUP_OWNER_AND_UID_OR_IDENTIFIER = "bytes_group_owner_and_uid_or_identifier";
    private int userDataType;
    static final String USER_DATA_TYPE = "user_data_type";
    static final int TYPE_OWNED_IDENTITY = 1;
    static final int TYPE_GROUP = 2;
    static final int TYPE_GROUP_V2 = 3;

    public UserData getUserData() {
        switch (this.userDataType) {
            case 3: {
                return new UserData(this.ownedIdentity, this.label, this.nextRefreshTimestamp, UserData.Type.GROUP_V2, this.bytesGroupOwnerAndUidOrIdentifier);
            }
            case 2: {
                return new UserData(this.ownedIdentity, this.label, this.nextRefreshTimestamp, UserData.Type.GROUP, this.bytesGroupOwnerAndUidOrIdentifier);
            }
            case 1: {
                return new UserData(this.ownedIdentity, this.label, this.nextRefreshTimestamp, UserData.Type.OWNED_IDENTITY, null);
            }
        }
        return null;
    }

    public static ServerUserData createForOwnedIdentityDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity, UID label) {
        if (ownedIdentity == null || label == null) {
            return null;
        }
        try {
            long nextRefreshTimestamp = System.currentTimeMillis() + 604800000L;
            ServerUserData serverUserData = new ServerUserData(identityManagerSession, ownedIdentity, label, nextRefreshTimestamp, null, 1);
            serverUserData.insert();
            return serverUserData;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static ServerUserData createForOwnedGroupDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity, UID label, byte[] bytesGroupOwnerAndUid) {
        if (ownedIdentity == null || label == null || bytesGroupOwnerAndUid == null) {
            return null;
        }
        try {
            long nextRefreshTimestamp = System.currentTimeMillis() + 604800000L;
            ServerUserData serverUserData = new ServerUserData(identityManagerSession, ownedIdentity, label, nextRefreshTimestamp, bytesGroupOwnerAndUid, 2);
            serverUserData.insert();
            return serverUserData;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static ServerUserData createForGroupV2(IdentityManagerSession identityManagerSession, Identity ownedIdentity, UID label, byte[] bytesGroupIdentifier) {
        if (ownedIdentity == null || label == null || bytesGroupIdentifier == null) {
            return null;
        }
        try {
            long nextRefreshTimestamp = System.currentTimeMillis() + 604800000L;
            ServerUserData serverUserData = new ServerUserData(identityManagerSession, ownedIdentity, label, nextRefreshTimestamp, bytesGroupIdentifier, 3);
            serverUserData.insert();
            return serverUserData;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private ServerUserData(IdentityManagerSession identityManagerSession, Identity ownedIdentity, UID label, long nextRefreshTimestamp, byte[] bytesGroupOwnerAndUidOrIdentifier, int userDataType) {
        this.identityManagerSession = identityManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.label = label;
        this.nextRefreshTimestamp = nextRefreshTimestamp;
        this.bytesGroupOwnerAndUidOrIdentifier = bytesGroupOwnerAndUidOrIdentifier;
        this.userDataType = userDataType;
    }

    private ServerUserData(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            this.label = new UID(res.getBytes(LABEL));
            this.nextRefreshTimestamp = res.getLong(NEXT_REFRESH_TIMESTAMP);
            this.bytesGroupOwnerAndUidOrIdentifier = res.getBytes(BYTES_GROUP_OWNER_AND_UID_OR_IDENTIFIER);
            this.userDataType = res.getInt(USER_DATA_TYPE);
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS server_user_data (owned_identity BLOB NOT NULL, label BLOB NOT NULL, next_refresh_timestamp INT NOT NULL, bytes_group_owner_and_uid_or_identifier BLOB, user_data_type INT NOT NULL, CONSTRAINT PK_server_user_data PRIMARY KEY(owned_identity, label));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 21 && newVersion >= 21) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING server_user_data DATABASE FROM VERSION " + oldVersion + " TO 21");
                statement.execute("ALTER TABLE server_user_data RENAME TO old_server_user_data");
                statement.execute("CREATE TABLE IF NOT EXISTS server_user_data ( owned_identity BLOB NOT NULL,  label BLOB NOT NULL,  next_refresh_timestamp INT NOT NULL,  group_details_owner_and_uid BLOB, CONSTRAINT PK_server_user_data PRIMARY KEY(owned_identity, label));");
                statement.execute("INSERT INTO server_user_data (owned_identity, label, next_refresh_timestamp, group_details_owner_and_uid) SELECT owned_identity, label, next_refresh_timestamp, group_details_owner_and_uid FROM old_server_user_data");
                statement.execute("DROP TABLE old_server_user_data");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 21;
        }
        if (oldVersion < 32 && newVersion >= 32) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING server_user_data DATABASE FROM VERSION " + oldVersion + " TO 32");
                statement.execute("ALTER TABLE server_user_data RENAME TO old_server_user_data");
                statement.execute("CREATE TABLE server_user_data ( owned_identity BLOB NOT NULL,  label BLOB NOT NULL,  next_refresh_timestamp INT NOT NULL,  bytes_group_owner_and_uid_or_identifier BLOB,  user_data_type INT NOT NULL, CONSTRAINT PK_server_user_data PRIMARY KEY(owned_identity, label));");
                statement.execute("INSERT INTO server_user_data (owned_identity, label, next_refresh_timestamp, bytes_group_owner_and_uid_or_identifier, user_data_type) SELECT owned_identity, label, next_refresh_timestamp, group_details_owner_and_uid, CASE WHEN group_details_owner_and_uid IS NULL THEN 1 ELSE 2 END FROM old_server_user_data");
                statement.execute("DROP TABLE old_server_user_data");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 32;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ServerUserData.insert", "INSERT INTO server_user_data VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.label.getBytes());
            statement.setLong(3, this.nextRefreshTimestamp);
            statement.setBytes(4, this.bytesGroupOwnerAndUidOrIdentifier);
            statement.setInt(5, this.userDataType);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ServerUserData.delete", "DELETE FROM server_user_data WHERE owned_identity = ?  AND label = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.label.getBytes());
            statement.executeUpdate();
        }
    }

    public static ServerUserData get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, UID label) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ServerUserData.get", "SELECT * FROM server_user_data WHERE owned_identity = ? AND label = ?;");){
            ServerUserData serverUserData;
            block16: {
                ResultSet res;
                block14: {
                    ServerUserData serverUserData2;
                    block15: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setBytes(2, label.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            serverUserData2 = new ServerUserData(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return serverUserData2;
                }
                serverUserData = null;
                if (res == null) break block16;
                res.close();
            }
            return serverUserData;
        }
    }

    public static void deleteAllForOwnedIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ServerUserData.deleteAllForOwnedIdentity", "DELETE FROM server_user_data WHERE owned_identity = ?;");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static ServerUserData[] getAll(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ServerUserData.getAll", "SELECT * FROM server_user_data;");){
            ServerUserData[] serverUserDataArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ServerUserData> list = new ArrayList<ServerUserData>();
                    while (res.next()) {
                        list.add(new ServerUserData(identityManagerSession, res));
                    }
                    serverUserDataArray = list.toArray(new ServerUserData[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return serverUserDataArray;
        }
    }

    public void updateNextRefreshTimestamp() {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ServerUserData.updateNextRefreshTimestamp", "UPDATE server_user_data SET next_refresh_timestamp = ?  WHERE owned_identity = ?  AND label = ?;");){
            long timestamp = System.currentTimeMillis() + 604800000L;
            statement.setLong(1, timestamp);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.label.getBytes());
            statement.executeUpdate();
            this.nextRefreshTimestamp = timestamp;
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void wasCommitted() {
    }
}

