/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class PendingGroupMember
implements ObvDatabase {
    static final String TABLE_NAME = "pending_group_member";
    private final IdentityManagerSession identityManagerSession;
    private byte[] groupOwnerAndUid;
    static final String GROUP_OWNER_AND_UID = "group_owner_and_uid";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private String contactSerializedDetails;
    static final String CONTACT_SERIALIZED_DETAILS = "contact_display_name";
    public boolean declined;
    static final String DECLINED = "declined";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_DELETED = 2L;
    private static final long HOOK_BIT_DECLINED_TOGGLED = 4L;

    public byte[] getGroupOwnerAndUid() {
        return this.groupOwnerAndUid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public String getContactSerializedDetails() {
        return this.contactSerializedDetails;
    }

    public boolean isDeclined() {
        return this.declined;
    }

    public static PendingGroupMember create(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity, String contactSerializedDetails) {
        if (groupOwnerAndUid == null || ownedIdentity == null || contactIdentity == null || contactSerializedDetails == null) {
            return null;
        }
        try {
            PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, groupOwnerAndUid, ownedIdentity, contactIdentity, contactSerializedDetails);
            pendingGroupMember.insert();
            return pendingGroupMember;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public PendingGroupMember(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity, String contactSerializedDetails) {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
        this.contactSerializedDetails = contactSerializedDetails;
        this.declined = false;
    }

    private PendingGroupMember(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = res.getBytes(GROUP_OWNER_AND_UID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.contactSerializedDetails = res.getString(CONTACT_SERIALIZED_DETAILS);
        this.declined = res.getBoolean(DECLINED);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS pending_group_member (group_owner_and_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, contact_display_name TEXT NOT NULL, declined BIT NOT NULL, CONSTRAINT PK_pending_group_member PRIMARY KEY(group_owner_and_uid, owned_identity, contact_identity), FOREIGN KEY (group_owner_and_uid,owned_identity) REFERENCES contact_group(group_owner_and_uid,owned_identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING pending_group_member DATABASE FROM VERSION " + oldVersion + " TO 11");
                statement.execute("DROP TABLE pending_group_member");
                statement.execute("CREATE TABLE pending_group_member (group_owner_and_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, contact_display_name TEXT NOT NULL, declined BIT NOT NULL, CONSTRAINT PK_pending_group_member PRIMARY KEY(group_owner_and_uid, owned_identity, contact_identity), FOREIGN KEY (group_owner_and_uid,owned_identity) REFERENCES contact_group(group_owner_and_uid,owned_identity) ON DELETE CASCADE);");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion < 12 && newVersion >= 12) {
            statement = session.createStatement();
            try {
                statement.execute("DELETE FROM pending_group_member AS p  WHERE NOT EXISTS ( SELECT 1 FROM contact_group  WHERE group_owner_and_uid = p.group_owner_and_uid AND owned_identity = p.owned_identity )");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 12;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("PendingGroupMember.insert", "INSERT INTO pending_group_member VALUES (?,?,?,?,?);");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.setString(4, this.contactSerializedDetails);
            statement.setBoolean(5, this.declined);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("PendingGroupMember.delete", "DELETE FROM pending_group_member WHERE group_owner_and_uid = ? AND owned_identity = ? AND contact_identity = ?;");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static IdentityWithSerializedDetails[] getPendingMembersInGroup(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity) {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            return new IdentityWithSerializedDetails[0];
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("PendingGroupMember.getPendingMembersInGroup", "SELECT * FROM pending_group_member WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
            IdentityWithSerializedDetails[] identityWithSerializedDetailsArray;
            block16: {
                statement.setBytes(1, groupOwnerAndUid);
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<IdentityWithSerializedDetails> list = new ArrayList<IdentityWithSerializedDetails>();
                    while (res.next()) {
                        PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, res);
                        list.add(new IdentityWithSerializedDetails(pendingGroupMember.contactIdentity, pendingGroupMember.contactSerializedDetails));
                    }
                    identityWithSerializedDetailsArray = list.toArray(new IdentityWithSerializedDetails[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identityWithSerializedDetailsArray;
        }
        catch (SQLException e) {
            return new IdentityWithSerializedDetails[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Identity[] getDeclinedPendingMembersInGroup(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity) {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            return new Identity[0];
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("PendingGroupMember.getDeclinedPendingMembersInGroup", "SELECT * FROM pending_group_member WHERE group_owner_and_uid = ? AND owned_identity = ? AND declined = 1;");){
            Identity[] identityArray;
            block16: {
                statement.setBytes(1, groupOwnerAndUid);
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<Identity> list = new ArrayList<Identity>();
                    while (res.next()) {
                        PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, res);
                        list.add(pendingGroupMember.contactIdentity);
                    }
                    identityArray = list.toArray(new Identity[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identityArray;
        }
        catch (SQLException e) {
            return new Identity[0];
        }
    }

    public static PendingGroupMember get(IdentityManagerSession identityManagerSession, byte[] groupUid, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        if (groupUid == null || ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("PendingGroupMember.get", "SELECT * FROM pending_group_member WHERE group_owner_and_uid = ? AND owned_identity = ? AND contact_identity = ?;");){
            PendingGroupMember pendingGroupMember;
            block17: {
                ResultSet res;
                block15: {
                    PendingGroupMember pendingGroupMember2;
                    block16: {
                        statement.setBytes(1, groupUid);
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setBytes(3, contactIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            pendingGroupMember2 = new PendingGroupMember(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return pendingGroupMember2;
                }
                pendingGroupMember = null;
                if (res == null) break block17;
                res.close();
            }
            return pendingGroupMember;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static PendingGroupMember[] getAllInGroup(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity) {
        if (groupOwnerAndUid == null || ownedIdentity == null) {
            return new PendingGroupMember[0];
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("PendingGroupMember.getAllInGroup", "SELECT * FROM pending_group_member WHERE group_owner_and_uid = ? AND owned_identity = ?;");){
            PendingGroupMember[] pendingGroupMemberArray;
            block16: {
                statement.setBytes(1, groupOwnerAndUid);
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<PendingGroupMember> list = new ArrayList<PendingGroupMember>();
                    while (res.next()) {
                        PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, res);
                        list.add(pendingGroupMember);
                    }
                    pendingGroupMemberArray = list.toArray(new PendingGroupMember[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return pendingGroupMemberArray;
        }
        catch (SQLException e) {
            return new PendingGroupMember[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[][] getGroupOwnerAndUidOfGroupsWhereContactIsPending(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, boolean excludeDeclined) {
        if (ownedIdentity == null || contactIdentity == null) {
            return new byte[0][];
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("PendingGroupMember.getGroupOwnerAndUidOfGroupsWhereContactIsPending", "SELECT * FROM pending_group_member WHERE contact_identity = ?  AND owned_identity = ? " + (excludeDeclined ? " AND declined = 0 " : "") + " AND group_owner_and_uid IN (SELECT group_owner_and_uid FROM contact_group WHERE owned_identity = ? AND group_owner IS NULL);");){
            byte[][] byArray;
            block16: {
                statement.setBytes(1, contactIdentity.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                statement.setBytes(3, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    while (res.next()) {
                        PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, res);
                        list.add(pendingGroupMember.getGroupOwnerAndUid());
                    }
                    byArray = (byte[][])list.toArray((T[])new byte[0][]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return byArray;
        }
        catch (SQLException e) {
            return new byte[0][];
        }
    }

    public void setDeclined(boolean declined) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("PendingGroupMember.setDeclined", "UPDATE pending_group_member SET declined = ?  WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND contact_identity = ?;");){
            statement.setBoolean(1, declined);
            statement.setBytes(2, this.groupOwnerAndUid);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setBytes(4, this.contactIdentity.getBytes());
            statement.executeUpdate();
            this.declined = declined;
        }
        this.commitHookBits |= 4L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            userInfo.put("contact_serialized_details", this.contactSerializedDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_pending_group_member_added", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            userInfo.put("contact_serialized_details", this.contactSerializedDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_pending_group_member_removed", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            userInfo.put(DECLINED, this.declined);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_pending_group_member_declined_toggled", userInfo);
        }
        this.commitHookBits = 0L;
    }

    static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid) {
        PendingGroupMember[] pendingGroupMembers = PendingGroupMember.getAllInGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity);
        Pojo_0[] pojos = new Pojo_0[pendingGroupMembers.length];
        for (int i = 0; i < pendingGroupMembers.length; ++i) {
            pojos[i] = pendingGroupMembers[i].backup();
        }
        return pojos;
    }

    static void restoreAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid, Pojo_0[] pojos) throws SQLException {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            PendingGroupMember.restore(identityManagerSession, ownedIdentity, groupOwnerAndUid, pojo);
        }
    }

    private Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.contact_identity = this.contactIdentity.getBytes();
        pojo.serialized_details = this.contactSerializedDetails;
        pojo.declined = this.declined;
        return pojo;
    }

    static void restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid, Pojo_0 pojo) throws SQLException {
        try {
            PendingGroupMember pendingGroupMember = new PendingGroupMember(identityManagerSession, groupOwnerAndUid, ownedIdentity, Identity.of(pojo.contact_identity), pojo.serialized_details);
            pendingGroupMember.declined = pojo.declined;
            pendingGroupMember.insert();
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
    }

    public static class Pojo_0 {
        public byte[] contact_identity;
        public String serialized_details;
        public boolean declined;
    }
}

