/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class OwnedIdentityDetails
implements ObvDatabase {
    static final String TABLE_NAME = "owned_identity_details";
    private final IdentityManagerSession identityManagerSession;
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private int version;
    static final String VERSION = "version";
    private String serializedJsonDetails;
    static final String SERIALIZED_JSON_DETAILS = "serialized_json_details";
    private String photoUrl;
    static final String PHOTO_URL = "photo_url";
    private UID photoServerLabel;
    static final String PHOTO_SERVER_LABEL = "photo_server_label";
    private AuthEncKey photoServerKey;
    static final String PHOTO_SERVER_KEY = "photo_server_key";

    public int getVersion() {
        return this.version;
    }

    public String getSerializedJsonDetails() {
        return this.serializedJsonDetails;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public JsonIdentityDetails getJsonIdentityDetails() {
        try {
            return (JsonIdentityDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonIdentityDetails.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonIdentityDetailsWithVersionAndPhoto getJsonIdentityDetailsWithVersionAndPhoto() {
        try {
            JsonIdentityDetailsWithVersionAndPhoto json = new JsonIdentityDetailsWithVersionAndPhoto();
            json.setIdentityDetails((JsonIdentityDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonIdentityDetails.class));
            json.setVersion(this.version);
            json.setPhotoUrl(this.photoUrl);
            if (this.photoServerKey != null && this.photoServerLabel != null) {
                json.setPhotoServerLabel(this.photoServerLabel.getBytes());
                json.setPhotoServerKey(Encoded.of(this.photoServerKey).getBytes());
            }
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public UID getPhotoServerLabel() {
        return this.photoServerLabel;
    }

    public AuthEncKey getPhotoServerKey() {
        return this.photoServerKey;
    }

    public static OwnedIdentityDetails create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, String serializedJsonDetails) {
        if (ownedIdentity == null || serializedJsonDetails == null) {
            return null;
        }
        try {
            int newVersion = 1;
            try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.create", "SELECT * FROM owned_identity_details WHERE owned_identity = ?  ORDER BY version DESC LIMIT 1;");){
                statement.setBytes(1, ownedIdentity.getBytes());
                try (ResultSet res = statement.executeQuery();){
                    if (res.next()) {
                        newVersion = res.getInt(VERSION) + 1;
                    }
                }
            }
            OwnedIdentityDetails ownedIdentityDetails = new OwnedIdentityDetails(identityManagerSession, ownedIdentity, newVersion, serializedJsonDetails);
            ownedIdentityDetails.insert();
            return ownedIdentityDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static OwnedIdentityDetails create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto) {
        if (ownedIdentity == null || jsonIdentityDetailsWithVersionAndPhoto == null) {
            return null;
        }
        try {
            OwnedIdentityDetails ownedIdentityDetails = new OwnedIdentityDetails(identityManagerSession, ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto.getVersion(), identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails()));
            ownedIdentityDetails.photoServerKey = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() == null ? null : (AuthEncKey)new Encoded(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey();
            ownedIdentityDetails.photoServerLabel = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel() == null ? null : new UID(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel());
            ownedIdentityDetails.insert();
            return ownedIdentityDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static OwnedIdentityDetails copy(IdentityManagerSession identityManagerSession, Identity ownedIdentity, int version) {
        if (ownedIdentity == null) {
            return null;
        }
        try {
            int newVersion = version + 1;
            try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.copy", "SELECT * FROM owned_identity_details WHERE owned_identity = ?  ORDER BY version DESC LIMIT 1;");){
                statement.setBytes(1, ownedIdentity.getBytes());
                try (ResultSet res = statement.executeQuery();){
                    if (res.next()) {
                        newVersion = res.getInt(VERSION) + 1;
                    }
                }
            }
            OwnedIdentityDetails oldDetails = OwnedIdentityDetails.get(identityManagerSession, ownedIdentity, version);
            if (oldDetails == null) {
                return null;
            }
            OwnedIdentityDetails ownedIdentityDetails = new OwnedIdentityDetails(identityManagerSession, ownedIdentity, newVersion, oldDetails.serializedJsonDetails, oldDetails.photoUrl, oldDetails.photoServerLabel, oldDetails.photoServerKey);
            ownedIdentityDetails.insert();
            return ownedIdentityDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public OwnedIdentityDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity, int version, String serializedJsonDetails, String photoUrl, UID photoServerLabel, AuthEncKey photoServerKey) {
        this.identityManagerSession = identityManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.version = version;
        this.serializedJsonDetails = serializedJsonDetails;
        this.photoUrl = photoUrl;
        this.photoServerLabel = photoServerLabel;
        this.photoServerKey = photoServerKey;
    }

    private OwnedIdentityDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity, int version, String serializedJsonDetails) {
        this.identityManagerSession = identityManagerSession;
        this.ownedIdentity = ownedIdentity;
        this.version = version;
        this.serializedJsonDetails = serializedJsonDetails;
        this.photoUrl = null;
        this.photoServerLabel = null;
        this.photoServerKey = null;
    }

    private OwnedIdentityDetails(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.version = res.getInt(VERSION);
        this.serializedJsonDetails = res.getString(SERIALIZED_JSON_DETAILS);
        this.photoUrl = res.getString(PHOTO_URL);
        byte[] bytes = res.getBytes(PHOTO_SERVER_LABEL);
        this.photoServerLabel = bytes == null ? null : new UID(bytes);
        bytes = res.getBytes(PHOTO_SERVER_KEY);
        if (bytes == null) {
            this.photoServerKey = null;
        } else {
            try {
                this.photoServerKey = (AuthEncKey)new Encoded(bytes).decodeSymmetricKey();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.photoServerKey = null;
            }
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS owned_identity_details (owned_identity BLOB NOT NULL, version INT NOT NULL, serialized_json_details TEXT NOT NULL, photo_url TEXT, photo_server_label BLOB, photo_server_key BLOB, CONSTRAINT PK_owned_identity_details PRIMARY KEY(owned_identity, version));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.insert", "INSERT INTO owned_identity_details VALUES (?,?,?,?,?, ?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setInt(2, this.version);
            statement.setString(3, this.serializedJsonDetails);
            statement.setString(4, this.photoUrl);
            statement.setBytes(5, this.photoServerLabel == null ? null : this.photoServerLabel.getBytes());
            statement.setBytes(6, this.photoServerKey == null ? null : Encoded.of(this.photoServerKey).getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.delete", "DELETE FROM owned_identity_details WHERE owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setInt(2, this.version);
            statement.executeUpdate();
        }
    }

    public static OwnedIdentityDetails get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, int version) throws SQLException {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.get", "SELECT * FROM owned_identity_details WHERE owned_identity = ? AND version = ?;");){
            OwnedIdentityDetails ownedIdentityDetails;
            block17: {
                ResultSet res;
                block15: {
                    OwnedIdentityDetails ownedIdentityDetails2;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        statement.setInt(2, version);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            ownedIdentityDetails2 = new OwnedIdentityDetails(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedIdentityDetails2;
                }
                ownedIdentityDetails = null;
                if (res == null) break block17;
                res.close();
            }
            return ownedIdentityDetails;
        }
    }

    public static List<String> getAllPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.getAllPhotoUrl", "SELECT photo_url FROM owned_identity_details WHERE photo_url IS NOT NULL;");){
            ArrayList<String> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (res.next()) {
                        list.add(res.getString(PHOTO_URL));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<OwnedIdentityDetails> getAllWithMissingPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.getAllWithMissingPhotoUrl", "SELECT * FROM owned_identity_details WHERE photo_url IS NULL  AND photo_server_key IS NOT NULL  AND photo_server_label IS NOT NULL;");){
            ArrayList<OwnedIdentityDetails> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedIdentityDetails> list = new ArrayList<OwnedIdentityDetails>();
                    while (res.next()) {
                        list.add(new OwnedIdentityDetails(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<OwnedIdentityDetails> getAllForOwnedIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.getAllForOwnedIdentity", "SELECT * FROM owned_identity_details WHERE owned_identity = ?;");){
            ArrayList<OwnedIdentityDetails> arrayList;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedIdentityDetails> list = new ArrayList<OwnedIdentityDetails>();
                    while (res.next()) {
                        list.add(new OwnedIdentityDetails(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void cleanup(IdentityManagerSession identityManagerSession, Identity ownedIdentity, int publishedVersion, int latestVersion) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentityDetails.cleanup", "DELETE FROM owned_identity_details WHERE owned_identity = ?  AND version NOT IN (?,?);");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setInt(2, publishedVersion);
            statement.setInt(3, latestVersion);
            statement.executeUpdate();
        }
    }

    public void setJsonDetails(JsonIdentityDetails jsonIdentityDetails) throws Exception {
        if (jsonIdentityDetails == null) {
            throw new Exception();
        }
        String serializedJsonDetails = this.identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetails);
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.setJsonDetails", "UPDATE owned_identity_details SET serialized_json_details = ?  WHERE owned_identity = ?  AND version = ?;");){
            statement.setString(1, serializedJsonDetails);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.executeUpdate();
            this.serializedJsonDetails = serializedJsonDetails;
        }
    }

    public void setPhotoUrl(String photoUrl, boolean clearLabelAndKey) throws SQLException {
        if (clearLabelAndKey) {
            try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.setPhotoUrl", "UPDATE owned_identity_details SET photo_url = ?, photo_server_label = NULL, photo_server_key = NULL  WHERE owned_identity = ?  AND version = ?;");){
                statement.setString(1, photoUrl);
                statement.setBytes(2, this.ownedIdentity.getBytes());
                statement.setInt(3, this.version);
                statement.executeUpdate();
                this.photoUrl = photoUrl;
                this.photoServerKey = null;
                this.photoServerLabel = null;
            }
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.setPhotoUrl", "UPDATE owned_identity_details SET photo_url = ?  WHERE owned_identity = ?  AND version = ?;");){
            statement.setString(1, photoUrl);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.executeUpdate();
            this.photoUrl = photoUrl;
        }
    }

    public void setPhotoServerLabelAndKey(UID photoServerLabel, AuthEncKey photoServerKey) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentityDetails.setPhotoServerLabelAndKey", "UPDATE owned_identity_details SET photo_server_label = ?, photo_server_key = ?  WHERE owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, photoServerLabel.getBytes());
            statement.setBytes(2, Encoded.of(photoServerKey).getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.photoServerLabel = photoServerLabel;
            this.photoServerKey = photoServerKey;
        }
    }

    @Override
    public void wasCommitted() {
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.version = this.version;
        pojo.serialized_details = this.serializedJsonDetails;
        if (this.photoServerLabel != null) {
            pojo.photo_server_label = this.photoServerLabel.getBytes();
        }
        if (this.photoServerKey != null) {
            pojo.photo_server_key = Encoded.of(this.photoServerKey).getBytes();
        }
        return pojo;
    }

    public static OwnedIdentityDetails restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Pojo_0 pojo) throws SQLException {
        UID photoServerLabel = null;
        if (pojo.photo_server_label != null) {
            photoServerLabel = new UID(pojo.photo_server_label);
        }
        AuthEncKey photoServerKey = null;
        try {
            if (pojo.photo_server_key != null) {
                photoServerKey = (AuthEncKey)new Encoded(pojo.photo_server_key).decodeSymmetricKey();
            }
        }
        catch (DecodingException | ClassCastException e) {
            Logger.x(e);
        }
        OwnedIdentityDetails ownedIdentityDetails = new OwnedIdentityDetails(identityManagerSession, ownedIdentity, pojo.version, pojo.serialized_details, null, photoServerLabel, photoServerKey);
        ownedIdentityDetails.insert();
        if (photoServerLabel != null && photoServerKey != null) {
            ServerUserData.createForOwnedIdentityDetails(identityManagerSession, ownedIdentity, photoServerLabel);
        }
        return ownedIdentityDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public int version;
        public String serialized_details;
        public byte[] photo_server_label;
        public byte[] photo_server_key;
    }
}

