/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PrivateIdentity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.identity.databases.ContactGroup;
import io.olvid.engine.identity.databases.ContactGroupV2;
import io.olvid.engine.identity.databases.ContactIdentity;
import io.olvid.engine.identity.databases.KeycloakServer;
import io.olvid.engine.identity.databases.OwnedDevice;
import io.olvid.engine.identity.databases.OwnedIdentityDetails;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public class OwnedIdentity
implements ObvDatabase {
    static final String TABLE_NAME = "owned_identity";
    private final IdentityManagerSession identityManagerSession;
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "identity";
    private final byte[] privateIdentityBytes;
    static final String PRIVATE_IDENTITY = "private_identity";
    private int publishedDetailsVersion;
    static final String PUBLISHED_DETAILS_VERSION = "published_details_version";
    private int latestDetailsVersion;
    static final String LATEST_DETAILS_VERSION = "latest_details_version";
    private boolean active;
    static final String ACTIVE = "active";
    private String keycloakServerUrl;
    static final String KEYCLOAK_SERVER_URL = "keycloak_server_url";
    private boolean markedForDeletion;
    static final String MARKED_FOR_DELETION = "marked_for_deletion";
    private byte[] backupSeed;
    static final String BACKUP_SEED = "backup_seed";
    private PrivateIdentity privateIdentity = null;
    private UID labelToDelete;
    private JsonIdentityDetailsWithVersionAndPhoto hookDetails;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_IDENTITY_LIST_CHANGED = 1L;
    private static final long HOOK_BIT_IDENTITY_DETAILS_PUBLISHED = 2L;
    private static final long HOOK_BIT_SERVER_USER_DATA_CAN_BE_DELETED = 4L;
    private static final long HOOK_BIT_LATEST_IDENTITY_DETAILS_VERSION_CHANGED = 8L;
    private static final long HOOK_BIT_OWNED_IDENTITY_CHANGED_ACTIVE_STATUS = 16L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public PrivateIdentity getPrivateIdentity() {
        if (this.privateIdentity == null) {
            this.privateIdentity = PrivateIdentity.of(this.privateIdentityBytes);
        }
        return this.privateIdentity;
    }

    public int getPublishedDetailsVersion() {
        return this.publishedDetailsVersion;
    }

    public int getLatestDetailsVersion() {
        return this.latestDetailsVersion;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getKeycloakServerUrl() {
        return this.keycloakServerUrl;
    }

    public boolean isKeycloakManaged() {
        return this.keycloakServerUrl != null;
    }

    public boolean isMarkedForDeletion() {
        return this.markedForDeletion;
    }

    public BackupSeed getBackupSeed() {
        if (this.backupSeed != null) {
            try {
                return new BackupSeed(this.backupSeed);
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        return null;
    }

    public ContactIdentity[] getContactIdentities() {
        return ContactIdentity.getAll(this.identityManagerSession, this.ownedIdentity);
    }

    public UID[] getOtherDeviceUids() throws SQLException {
        OwnedDevice[] ownedDevices = OwnedDevice.getOtherDevicesOfOwnedIdentity(this.identityManagerSession, this.ownedIdentity);
        UID[] uids = new UID[ownedDevices.length];
        for (int i = 0; i < ownedDevices.length; ++i) {
            uids[i] = ownedDevices[i].getUid();
        }
        return uids;
    }

    public UID[] getAllDeviceUids() throws SQLException {
        return OwnedDevice.getAllDeviceUidsOfIdentity(this.identityManagerSession, this.ownedIdentity);
    }

    public UID getCurrentDeviceUid() throws SQLException {
        return OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.identityManagerSession, this.ownedIdentity).getUid();
    }

    public OwnedIdentityDetails getPublishedDetails() throws SQLException {
        return OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, this.publishedDetailsVersion);
    }

    public OwnedIdentityDetails getLatestDetails() throws SQLException {
        return OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, this.latestDetailsVersion);
    }

    public KeycloakServer getKeycloakServer() throws SQLException {
        if (this.keycloakServerUrl != null) {
            return KeycloakServer.get(this.identityManagerSession, this.keycloakServerUrl, this.ownedIdentity);
        }
        return null;
    }

    public ObvKeycloakState getKeycloakState() throws SQLException {
        KeycloakServer keycloakServer;
        if (this.keycloakServerUrl != null && (keycloakServer = KeycloakServer.get(this.identityManagerSession, this.keycloakServerUrl, this.ownedIdentity)) != null) {
            JsonWebKey signatureKey;
            JsonWebKeySet jwks;
            try {
                jwks = keycloakServer.getJwks();
                signatureKey = keycloakServer.getSignatureKey();
            }
            catch (Exception e) {
                jwks = null;
                signatureKey = null;
            }
            return new ObvKeycloakState(keycloakServer.getServerUrl(), keycloakServer.getClientId(), keycloakServer.getClientSecret(), jwks, signatureKey, keycloakServer.getSerializedAuthState(), keycloakServer.isTransferRestricted(), keycloakServer.getOwnApiKey(), keycloakServer.getLatestRevocationListTimestamp(), keycloakServer.getLatestGroupUpdateTimestamp());
        }
        return null;
    }

    public JsonWebKey getKeycloakSignatureKey() throws SQLException {
        KeycloakServer keycloakServer;
        if (this.keycloakServerUrl != null && (keycloakServer = KeycloakServer.get(this.identityManagerSession, this.keycloakServerUrl, this.ownedIdentity)) != null) {
            try {
                return keycloakServer.getSignatureKey();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getKeycloakUserId() throws SQLException {
        KeycloakServer keycloakServer;
        if (this.keycloakServerUrl != null && (keycloakServer = KeycloakServer.get(this.identityManagerSession, this.keycloakServerUrl, this.ownedIdentity)) != null) {
            return keycloakServer.getKeycloakUserId();
        }
        return null;
    }

    public void setLatestDetails(JsonIdentityDetails identityDetails) throws Exception {
        OwnedIdentityDetails ownedIdentityDetails;
        JsonIdentityDetails publishedDetails;
        if (identityDetails == null || identityDetails.isEmpty()) {
            return;
        }
        if (this.publishedDetailsVersion != this.latestDetailsVersion && (publishedDetails = this.getPublishedDetails().getJsonIdentityDetails()).equals(identityDetails)) {
            this.discardLatestDetails();
            return;
        }
        if (this.publishedDetailsVersion == this.latestDetailsVersion) {
            ownedIdentityDetails = OwnedIdentityDetails.copy(this.identityManagerSession, this.ownedIdentity, this.publishedDetailsVersion);
            try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setLatestDetails", "UPDATE owned_identity SET latest_details_version = ?  WHERE identity = ?;");){
                statement.setInt(1, ownedIdentityDetails.getVersion());
                statement.setBytes(2, this.ownedIdentity.getBytes());
                statement.executeUpdate();
                this.latestDetailsVersion = ownedIdentityDetails.getVersion();
                this.commitHookBits |= 8L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
        } else {
            ownedIdentityDetails = OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, this.latestDetailsVersion);
        }
        ownedIdentityDetails.setJsonDetails(identityDetails);
    }

    public void setPhoto(String srcAbsolutePhotoUrl) throws Exception {
        if (srcAbsolutePhotoUrl == null) {
            OwnedIdentityDetails ownedIdentityDetails;
            if (this.publishedDetailsVersion == this.latestDetailsVersion) {
                ownedIdentityDetails = OwnedIdentityDetails.copy(this.identityManagerSession, this.ownedIdentity, this.publishedDetailsVersion);
                try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setPhoto", "UPDATE owned_identity SET latest_details_version = ?  WHERE identity = ?;");){
                    statement.setInt(1, ownedIdentityDetails.getVersion());
                    statement.setBytes(2, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.latestDetailsVersion = ownedIdentityDetails.getVersion();
                    this.commitHookBits |= 8L;
                    this.identityManagerSession.session.addSessionCommitListener(this);
                }
            } else {
                ownedIdentityDetails = OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, this.latestDetailsVersion);
            }
            ownedIdentityDetails.setPhotoUrl(null, true);
        } else {
            String randFileName;
            SecureFile dstPhotoFile;
            OwnedIdentityDetails ownedIdentityDetails;
            SecureFile srcPhotoFile = new SecureFile(srcAbsolutePhotoUrl);
            if (!srcPhotoFile.canRead()) {
                return;
            }
            if (this.publishedDetailsVersion == this.latestDetailsVersion) {
                ownedIdentityDetails = OwnedIdentityDetails.copy(this.identityManagerSession, this.ownedIdentity, this.publishedDetailsVersion);
                try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setPhoto", "UPDATE owned_identity SET latest_details_version = ?  WHERE identity = ?;");){
                    statement.setInt(1, ownedIdentityDetails.getVersion());
                    statement.setBytes(2, this.ownedIdentity.getBytes());
                    statement.executeUpdate();
                    this.latestDetailsVersion = ownedIdentityDetails.getVersion();
                    this.commitHookBits |= 8L;
                    this.identityManagerSession.session.addSessionCommitListener(this);
                }
            } else {
                ownedIdentityDetails = OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, this.latestDetailsVersion);
            }
            String fileName = "identity_photos" + File.separator + Logger.toHexString(Arrays.copyOfRange(this.ownedIdentity.getBytes(), this.ownedIdentity.getBytes().length - 32, this.ownedIdentity.getBytes().length));
            Random random = new Random();
            while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
            }
            try (SecureFileInputStream is = new SecureFileInputStream(srcPhotoFile);
                 SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
                int length;
                byte[] buffer = new byte[4096];
                while ((length = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, length);
                }
            }
            ownedIdentityDetails.setPhotoUrl(randFileName, true);
        }
    }

    public boolean setOwnedIdentityDetailsFromOtherDevice(JsonIdentityDetailsWithVersionAndPhoto ownDetailsWithVersionAndPhoto) throws SQLException {
        int newDetailsVersion = ownDetailsWithVersionAndPhoto.getVersion();
        OwnedIdentityDetails currentPublishedDetails = this.getPublishedDetails();
        if (currentPublishedDetails == null) {
            Logger.e("In setOwnedIdentityDetailsFromOtherDevice: unable to read current published details!");
            throw new SQLException();
        }
        if (currentPublishedDetails.getVersion() >= newDetailsVersion) {
            return false;
        }
        OwnedIdentityDetails newPublishedDetails = OwnedIdentityDetails.create(this.identityManagerSession, this.ownedIdentity, ownDetailsWithVersionAndPhoto);
        if (newPublishedDetails == null) {
            Logger.e("In setOwnedIdentityDetailsFromOtherDevice: unable to create new details!");
            throw new SQLException();
        }
        if (Objects.equals(newPublishedDetails.getPhotoServerKey(), currentPublishedDetails.getPhotoServerKey()) && Objects.equals(newPublishedDetails.getPhotoServerLabel(), currentPublishedDetails.getPhotoServerLabel())) {
            newPublishedDetails.setPhotoUrl(currentPublishedDetails.getPhotoUrl(), false);
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setOwnedIdentityDetailsFromOtherDevice", "UPDATE owned_identity SET published_details_version = ?, latest_details_version = ?  WHERE identity = ?;");){
            statement.setInt(1, newDetailsVersion);
            statement.setInt(2, newDetailsVersion);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.publishedDetailsVersion = newDetailsVersion;
        }
        OwnedIdentityDetails.cleanup(this.identityManagerSession, this.ownedIdentity, newDetailsVersion, newDetailsVersion);
        this.hookDetails = newPublishedDetails.getJsonIdentityDetailsWithVersionAndPhoto();
        this.commitHookBits |= 0xAL;
        this.identityManagerSession.session.addSessionCommitListener(this);
        return newPublishedDetails.getPhotoUrl() == null && newPublishedDetails.getPhotoServerKey() != null && newPublishedDetails.getPhotoServerLabel() != null;
    }

    public void setDetailsDownloadedPhotoUrl(int version, byte[] photo) throws Exception {
        String randFileName;
        SecureFile dstPhotoFile;
        OwnedIdentityDetails ownedIdentityDetails = OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, version);
        if (ownedIdentityDetails == null) {
            return;
        }
        String fileName = "identity_photos" + File.separator + Logger.toHexString(Arrays.copyOfRange(this.ownedIdentity.getBytes(), this.ownedIdentity.getBytes().length - 32, this.ownedIdentity.getBytes().length));
        Random random = new Random();
        while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
        }
        try (SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
            os.write(photo, 0, photo.length);
        }
        ownedIdentityDetails.setPhotoUrl(randFileName, false);
        this.hookDetails = ownedIdentityDetails.getJsonIdentityDetailsWithVersionAndPhoto();
        this.commitHookBits |= 2L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    public void setPhotoLabelAndKey(int version, UID photoServerLabel, AuthEncKey photoServerKey) throws SQLException {
        OwnedIdentityDetails ownedIdentityDetails = OwnedIdentityDetails.get(this.identityManagerSession, this.ownedIdentity, version);
        if (ownedIdentityDetails != null) {
            ownedIdentityDetails.setPhotoServerLabelAndKey(photoServerLabel, photoServerKey);
        }
    }

    public int publishLatestDetails() throws SQLException {
        if (this.latestDetailsVersion == this.publishedDetailsVersion) {
            return -1;
        }
        OwnedIdentityDetails publishedDetails = this.getPublishedDetails();
        OwnedIdentityDetails latestDetails = this.getLatestDetails();
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.publishLatestDetails", "UPDATE owned_identity SET published_details_version = ?  WHERE identity = ?;");){
            statement.setInt(1, this.latestDetailsVersion);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.publishedDetailsVersion = this.latestDetailsVersion;
            this.commitHookBits |= 8L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        if (!(publishedDetails.getPhotoUrl() == null || latestDetails.getPhotoUrl() != null && latestDetails.getPhotoUrl().equals(publishedDetails.getPhotoUrl()) || publishedDetails.getPhotoServerLabel() == null)) {
            this.labelToDelete = publishedDetails.getPhotoServerLabel();
            this.commitHookBits |= 4L;
        }
        this.hookDetails = latestDetails.getJsonIdentityDetailsWithVersionAndPhoto();
        this.commitHookBits |= 2L;
        this.identityManagerSession.session.addSessionCommitListener(this);
        return this.latestDetailsVersion;
    }

    public void discardLatestDetails() throws SQLException {
        if (this.latestDetailsVersion == this.publishedDetailsVersion) {
            return;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.discardLatestDetails", "UPDATE owned_identity SET latest_details_version = ?  WHERE identity = ?;");){
            statement.setInt(1, this.publishedDetailsVersion);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.latestDetailsVersion = this.publishedDetailsVersion;
            this.commitHookBits |= 8L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setActive(boolean active) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setActive", "UPDATE owned_identity SET active = ?  WHERE identity = ?;");){
            statement.setBoolean(1, active);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.active = active;
            this.commitHookBits |= 0x10L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setKeycloakServerUrl(String keycloakServerUrl) throws SQLException {
        boolean deleteAllKeycloakGroups = !Objects.equals(keycloakServerUrl, this.keycloakServerUrl);
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setKeycloakServerUrl", "UPDATE owned_identity SET keycloak_server_url = ?  WHERE identity = ?;");){
            statement.setString(1, keycloakServerUrl);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.keycloakServerUrl = keycloakServerUrl;
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
            if (deleteAllKeycloakGroups) {
                ContactGroupV2.deleteAllKeycloakGroupsForOwnedIdentity(this.identityManagerSession, this.ownedIdentity);
            }
        }
    }

    public void markForDeletion() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.markedForDeletion", "UPDATE owned_identity SET marked_for_deletion = ?  WHERE identity = ?;");){
            statement.setBoolean(1, true);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.markedForDeletion = true;
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setBackupSeed(BackupSeed backupSeed) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.setBackupSeed", "UPDATE owned_identity SET backup_seed = ?  WHERE identity = ?;");){
            statement.setBytes(1, backupSeed.getBackupSeedBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.backupSeed = backupSeed.getBackupSeedBytes();
        }
    }

    public static OwnedIdentity create(IdentityManagerSession identityManagerSession, String server, Byte serverAuthenticationAlgoImplByte, Byte encryptionAlgoImplByte, JsonIdentityDetails identityDetails, String deviceDisplayName, PRNGService prng) {
        if (identityDetails == null || identityDetails.isEmpty()) {
            return null;
        }
        KeyPair serverAuthKeyPair = Suite.generateServerAuthenticationKeyPair(serverAuthenticationAlgoImplByte, prng);
        KeyPair encryptionKeyPair = Suite.generateEncryptionKeyPair(encryptionAlgoImplByte, prng);
        if (serverAuthKeyPair == null || encryptionKeyPair == null) {
            return null;
        }
        MACKey macKey = Suite.getDefaultMAC(0).generateKey(prng);
        BackupSeed backupSeed = BackupSeed.generate(prng);
        try {
            Identity identity = new Identity(server, (ServerAuthenticationPublicKey)serverAuthKeyPair.getPublicKey(), (EncryptionPublicKey)encryptionKeyPair.getPublicKey());
            PrivateIdentity privateIdentity = new PrivateIdentity(identity, (ServerAuthenticationPrivateKey)serverAuthKeyPair.getPrivateKey(), (EncryptionPrivateKey)encryptionKeyPair.getPrivateKey(), macKey);
            OwnedIdentityDetails ownedIdentityDetails = OwnedIdentityDetails.create(identityManagerSession, identity, identityManagerSession.jsonObjectMapper.writeValueAsString((Object)identityDetails));
            OwnedIdentity ownedIdentity = new OwnedIdentity(identityManagerSession, privateIdentity, backupSeed, ownedIdentityDetails.getVersion());
            ownedIdentity.insert();
            OwnedDevice.createCurrentDevice(identityManagerSession, identity, deviceDisplayName, prng);
            return ownedIdentity;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public OwnedIdentity(IdentityManagerSession identityManagerSession, PrivateIdentity privateIdentity, BackupSeed backupSeed, int detailsVersion) {
        this.identityManagerSession = identityManagerSession;
        this.ownedIdentity = privateIdentity.getPublicIdentity();
        this.privateIdentity = privateIdentity;
        this.privateIdentityBytes = privateIdentity.serialize();
        this.publishedDetailsVersion = detailsVersion;
        this.latestDetailsVersion = detailsVersion;
        this.active = true;
        this.keycloakServerUrl = null;
        this.markedForDeletion = false;
        this.backupSeed = backupSeed == null ? null : backupSeed.getBackupSeedBytes();
    }

    private OwnedIdentity(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.privateIdentityBytes = res.getBytes(PRIVATE_IDENTITY);
        this.publishedDetailsVersion = res.getInt(PUBLISHED_DETAILS_VERSION);
        this.latestDetailsVersion = res.getInt(LATEST_DETAILS_VERSION);
        this.active = res.getBoolean(ACTIVE);
        this.keycloakServerUrl = res.getString(KEYCLOAK_SERVER_URL);
        this.markedForDeletion = res.getBoolean(MARKED_FOR_DELETION);
        this.backupSeed = res.getBytes(BACKUP_SEED);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS owned_identity (identity BLOB PRIMARY KEY, private_identity BLOB NOT NULL, published_details_version INT NOT NULL, latest_details_version INT NOT NULL, active BIT NOT NULL, keycloak_server_url TEXT, marked_for_deletion BIT NOT NULL, backup_seed BLOB,  FOREIGN KEY (identity, published_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, latest_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, keycloak_server_url) REFERENCES keycloak_server(owned_identity, server_url));");
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        block62: {
            if (oldVersion >= 5 || newVersion < 5) break block62;
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE owned_identity RENAME TO old_owned_identities");
                statement.execute("CREATE TABLE IF NOT EXISTS owned_identity_details ( owned_identity BLOB NOT NULL,  version INT NOT NULL,  serialized_json_details TEXT NOT NULL,  photo_url TEXT,  photo_server_label BLOB,  photo_server_key BLOB,  CONSTRAINT PK_owned_identity_details PRIMARY KEY(owned_identity, version));");
                statement.execute("CREATE TABLE IF NOT EXISTS owned_identity ( identity BLOB PRIMARY KEY,  private_identity BLOB NOT NULL,  published_details_version INT NOT NULL,  latest_details_version INT NOT NULL,  single_use BIT NOT NULL,  api_key VARCHAR NOT NULL,  FOREIGN KEY (identity, published_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, latest_details_version) REFERENCES owned_identity_details(owned_identity, version));");
                objectMapper = new ObjectMapper();
                res = statement.executeQuery("SELECT * FROM old_owned_identities");
lbl12:
                // 2 sources

                try {
                    while (res.next()) {
                        preparedStatement = session.prepareStatement("INSERT INTO owned_identity VALUES (?,?,?,?,?, ?);");
                        try {
                            preparedStatement.setBytes(1, res.getBytes(1));
                            preparedStatement.setBytes(2, res.getBytes(2));
                            preparedStatement.setInt(3, 1);
                            preparedStatement.setInt(4, 1);
                            preparedStatement.setBoolean(5, res.getBoolean(4));
                            preparedStatement.setString(6, res.getString(5));
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                        }
                        preparedStatement = session.prepareStatement("INSERT INTO owned_identity_details VALUES (?,?,?,?,?, ?);");
                        preparedStatement.setBytes(1, res.getBytes(1));
                        preparedStatement.setInt(2, 1);
                        map = new HashMap<String, String>();
                        map.put("first_name", res.getString(3));
                        try {
                            preparedStatement.setString(3, objectMapper.writeValueAsString(map));
                        }
                        catch (Exception e) {
                            Logger.x(e);
                            if (preparedStatement == null) continue;
                            preparedStatement.close();
                            continue;
                        }
                        try {
                            preparedStatement.setString(4, null);
                            preparedStatement.setBytes(5, null);
                            preparedStatement.setBytes(6, null);
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement == null) ** GOTO lbl12
                            preparedStatement.close();
                        }
                    }
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
                statement.execute("DROP TABLE old_owned_identities");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 5;
        }
        if (oldVersion < 15 && newVersion >= 15) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `owned_identity` DATABASE FROM VERSION " + oldVersion + " TO 15");
                statement.execute("ALTER TABLE owned_identity RENAME TO old_owned_identity");
                statement.execute("CREATE TABLE IF NOT EXISTS owned_identity ( identity BLOB PRIMARY KEY,  private_identity BLOB NOT NULL,  published_details_version INT NOT NULL,  latest_details_version INT NOT NULL,  api_key VARCHAR NOT NULL,  active BIT NOT NULL,  FOREIGN KEY (identity, published_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, latest_details_version) REFERENCES owned_identity_details(owned_identity, version));");
                statement.execute("INSERT INTO owned_identity SELECT identity, private_identity, published_details_version, latest_details_version, api_key, 1 FROM old_owned_identity");
                statement.execute("DROP TABLE old_owned_identity");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 15;
        }
        if (oldVersion < 20 && newVersion >= 20) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `owned_identity` DATABASE FROM VERSION " + oldVersion + " TO 20");
                statement.execute("ALTER TABLE owned_identity RENAME TO old_owned_identity");
                statement.execute("CREATE TABLE IF NOT EXISTS owned_identity ( identity BLOB PRIMARY KEY,  private_identity BLOB NOT NULL,  published_details_version INT NOT NULL,  latest_details_version INT NOT NULL,  api_key VARCHAR NOT NULL,  active BIT NOT NULL,  keycloak_server_url TEXT,  FOREIGN KEY (identity, published_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, latest_details_version) REFERENCES owned_identity_details(owned_identity, version), FOREIGN KEY (identity, keycloak_server_url) REFERENCES keycloak_server(owned_identity, server_url) ON DELETE SET NULL);");
                statement.execute("INSERT INTO owned_identity SELECT identity, private_identity, published_details_version, latest_details_version, api_key, active, NULL FROM old_owned_identity");
                statement.execute("DROP TABLE old_owned_identity");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 20;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `owned_identity` DATABASE FROM VERSION " + oldVersion + " TO 35");
                statement.execute("ALTER TABLE owned_identity DROP COLUMN api_key");
                statement.execute("ALTER TABLE owned_identity ADD COLUMN marked_for_deletion BIT NOT NULL DEFAULT 0");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
        if (oldVersion < 44 && newVersion >= 44) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `owned_identity` DATABASE FROM VERSION " + oldVersion + " TO 44");
                statement.execute("ALTER TABLE owned_identity ADD COLUMN backup_seed BLOB");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 44;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.insert", "INSERT INTO owned_identity VALUES (?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.setBytes(2, this.privateIdentityBytes);
            statement.setInt(3, this.publishedDetailsVersion);
            statement.setInt(4, this.latestDetailsVersion);
            statement.setBoolean(5, this.active);
            statement.setString(6, this.keycloakServerUrl);
            statement.setBoolean(7, this.markedForDeletion);
            statement.setBytes(8, this.backupSeed);
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Running OwnedIdentity delete outside a transaction");
            throw new SQLException();
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.delete", "DELETE FROM owned_identity WHERE identity = ?;");){
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        statement = this.identityManagerSession.session.prepareStatement("OwnedIdentity.delete", "DELETE FROM owned_identity_details WHERE owned_identity = ?;");
        try {
            statement.setBytes(1, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    public static OwnedIdentity get(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentity.get", "SELECT * FROM owned_identity WHERE identity = ?;");){
            OwnedIdentity ownedIdentity2;
            block17: {
                ResultSet res;
                block15: {
                    OwnedIdentity ownedIdentity3;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            ownedIdentity3 = new OwnedIdentity(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedIdentity3;
                }
                ownedIdentity2 = null;
                if (res == null) break block17;
                res.close();
            }
            return ownedIdentity2;
        }
    }

    public static boolean isActive(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        if (ownedIdentity == null) {
            return false;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentity.isActive", "SELECT active FROM owned_identity WHERE identity = ?;");){
            boolean bl;
            block17: {
                ResultSet res;
                block15: {
                    boolean bl2;
                    block16: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            bl2 = res.getBoolean(ACTIVE);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return bl2;
                }
                bl = false;
                if (res == null) break block17;
                res.close();
            }
            return bl;
        }
    }

    public static OwnedIdentity[] getAll(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentity.getAll", "SELECT * FROM owned_identity WHERE marked_for_deletion == 0;");){
            OwnedIdentity[] ownedIdentityArray;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedIdentity> list = new ArrayList<OwnedIdentity>();
                    while (res.next()) {
                        list.add(new OwnedIdentity(identityManagerSession, res));
                    }
                    ownedIdentityArray = list.toArray(new OwnedIdentity[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return ownedIdentityArray;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String getSerializedPublishedDetails(IdentityManagerSession identityManagerSession, Identity ownedIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedIdentity.getSerializedPublishedDetails", "SELECT details.serialized_json_details FROM owned_identity AS identity  INNER JOIN owned_identity_details AS details  ON identity.identity = details.owned_identity AND identity.published_details_version = details.version WHERE identity.identity = ?;");){
            String string;
            block18: {
                ResultSet res;
                block16: {
                    String string2;
                    block17: {
                        statement.setBytes(1, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block16;
                            string2 = res.getString(1);
                            if (res == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return string2;
                }
                string = null;
                if (res == null) break block18;
                res.close();
            }
            return string;
        }
        catch (SQLException e) {
            return null;
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_owned_identity_list_updated", Collections.emptyMap());
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put(TABLE_NAME, this.ownedIdentity);
            userInfo.put("identity_details", this.hookDetails);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_owned_identity_published_details_updated", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.ownedIdentity);
            userInfo.put("label", this.labelToDelete);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_server_user_data_can_be_deleted", userInfo);
        }
        if ((this.commitHookBits & 8L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.ownedIdentity);
            userInfo.put("has_unpublished", this.latestDetailsVersion != this.publishedDetailsVersion);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_latest_owned_identity_details_updated", userInfo);
        }
        if ((this.commitHookBits & 0x10L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(TABLE_NAME, this.ownedIdentity);
            userInfo.put(ACTIVE, this.active);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_owned_identity_changed_active_status", userInfo);
            if (this.active) {
                this.identityManagerSession.notificationPostingDelegate.postNotification("backup_notification_profile_backup_needed", Map.of(TABLE_NAME, this.ownedIdentity));
            }
        }
        this.commitHookBits = 0L;
    }

    public static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession) throws SQLException {
        OwnedIdentity[] ownedIdentities = OwnedIdentity.getAll(identityManagerSession);
        Pojo_0[] pojos = new Pojo_0[ownedIdentities.length];
        for (int i = 0; i < ownedIdentities.length; ++i) {
            pojos[i] = ownedIdentities[i].backup();
        }
        return pojos;
    }

    private Pojo_0 backup() throws SQLException {
        Pojo_0 pojo = new Pojo_0();
        pojo.owned_identity = this.ownedIdentity.getBytes();
        pojo.private_identity = this.backupPrivateIdentity();
        pojo.published_details = this.getPublishedDetails().backup();
        if (this.latestDetailsVersion != this.publishedDetailsVersion) {
            pojo.latest_details = this.getLatestDetails().backup();
        }
        pojo.active = this.active;
        if (this.keycloakServerUrl != null) {
            pojo.keycloak = this.getKeycloakServer().backup();
        }
        pojo.contact_identities = ContactIdentity.backupAll(this.identityManagerSession, this.ownedIdentity);
        pojo.owned_groups = ContactGroup.backupAllForOwner(this.identityManagerSession, this.ownedIdentity, this.ownedIdentity);
        pojo.groups_v2 = ContactGroupV2.backupAll(this.identityManagerSession, this.ownedIdentity);
        return pojo;
    }

    public static ObvIdentity restore(IdentityManagerSession identityManagerSession, Pojo_0 pojo, String deviceDisplayName, PRNGService prng) throws SQLException {
        KeycloakServer keycloakServer;
        BackupSeed backupSeed;
        Identity ownedIdentity = null;
        try {
            ownedIdentity = Identity.of(pojo.owned_identity);
        }
        catch (DecodingException e) {
            Logger.e("Error recreating OwnedIdentity from backup!");
            Logger.x(e);
        }
        if (ownedIdentity == null) {
            return null;
        }
        PrivateIdentity privateIdentity = OwnedIdentity.restorePrivateIdentity(ownedIdentity, pojo.private_identity);
        if (privateIdentity == null) {
            return null;
        }
        OwnedIdentityDetails published_details = OwnedIdentityDetails.restore(identityManagerSession, ownedIdentity, pojo.published_details);
        OwnedIdentityDetails latest_details = null;
        if (pojo.latest_details != null && pojo.latest_details.version != pojo.published_details.version) {
            latest_details = OwnedIdentityDetails.restore(identityManagerSession, ownedIdentity, pojo.latest_details);
        }
        try {
            backupSeed = privateIdentity.getDeterministicBackupSeedForLegacyIdentity();
        }
        catch (Exception ignored) {
            backupSeed = null;
        }
        OwnedIdentity ownedIdentityObject = new OwnedIdentity(identityManagerSession, privateIdentity, backupSeed, published_details.getVersion());
        if (latest_details != null) {
            ownedIdentityObject.latestDetailsVersion = latest_details.getVersion();
        }
        ownedIdentityObject.active = pojo.active;
        ownedIdentityObject.insert();
        if (pojo.keycloak != null && (keycloakServer = KeycloakServer.restore(identityManagerSession, ownedIdentity, pojo.keycloak)) != null) {
            ownedIdentityObject.setKeycloakServerUrl(keycloakServer.getServerUrl());
        }
        OwnedDevice currentOwnedDevice = OwnedDevice.createCurrentDevice(identityManagerSession, ownedIdentity, deviceDisplayName, prng);
        currentOwnedDevice.setRawDeviceCapabilities(ObvCapability.capabilityListToStringArray(ObvCapability.currentCapabilities));
        return new ObvIdentity(ownedIdentity, published_details.getJsonIdentityDetails(), ownedIdentityObject.isKeycloakManaged(), pojo.active == null || pojo.active != false);
    }

    private PrivateIdentityPojo_0 backupPrivateIdentity() {
        PrivateIdentity privateId = this.getPrivateIdentity();
        PrivateIdentityPojo_0 privateIdentityPojo = new PrivateIdentityPojo_0();
        privateIdentityPojo.server_authentication_private_key = Encoded.of(privateId.getServerAuthenticationPrivateKey()).getBytes();
        privateIdentityPojo.encryption_private_key = Encoded.of(privateId.getEncryptionPrivateKey()).getBytes();
        privateIdentityPojo.mac_key = Encoded.of(privateId.getMacKey()).getBytes();
        return privateIdentityPojo;
    }

    private static PrivateIdentity restorePrivateIdentity(Identity publicIdentity, PrivateIdentityPojo_0 pojo) {
        try {
            ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(pojo.server_authentication_private_key).decodePrivateKey();
            EncryptionPrivateKey encryptionPrivateKey = (EncryptionPrivateKey)new Encoded(pojo.encryption_private_key).decodePrivateKey();
            MACKey macKey = (MACKey)new Encoded(pojo.mac_key).decodeSymmetricKey();
            return new PrivateIdentity(publicIdentity, serverAuthenticationPrivateKey, encryptionPrivateKey, macKey);
        }
        catch (DecodingException | ClassCastException e) {
            return null;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] owned_identity;
        public PrivateIdentityPojo_0 private_identity;
        public OwnedIdentityDetails.Pojo_0 published_details;
        public OwnedIdentityDetails.Pojo_0 latest_details;
        public Boolean active;
        public KeycloakServer.Pojo_0 keycloak;
        public ContactIdentity.Pojo_0[] contact_identities;
        public ContactGroup.Pojo_0[] owned_groups;
        public ContactGroupV2.Pojo_0[] groups_v2;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class PrivateIdentityPojo_0 {
        public byte[] server_authentication_private_key;
        public byte[] encryption_private_key;
        public byte[] mac_key;
    }
}

