/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.PreKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class OwnedDevice
implements ObvDatabase {
    static final String TABLE_NAME = "owned_device";
    private final IdentityManagerSession identityManagerSession;
    private UID uid;
    static final String UID_ = "uid";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "identity";
    private boolean isCurrentDevice;
    static final String IS_CURRENT_DEVICE = "is_current_device";
    private byte[] serializedDeviceCapabilities;
    static final String SERIALIZED_DEVICE_CAPABILITIES = "serialized_device_capabilities";
    private String displayName;
    static final String DISPLAY_NAME = "display_name";
    private Long expirationTimestamp;
    static final String EXPIRATION_TIMESTAMP = "expiration_timestamp";
    private Long lastRegistrationTimestamp;
    static final String LAST_REGISTRATION_TIMESTAMP = "last_registration_timestamp";
    private long latestChannelCreationPingTimestamp;
    static final String LATEST_CHANNEL_CREATION_PING_TIMESTAMP = "latest_channel_creation_ping_timestamp";
    private KeyId preKeyId;
    static final String PRE_KEY_ID = "pre_key_id";
    private EncryptionPublicKey preKeyEncryptionPublicKey;
    static final String PRE_KEY_ENCRYPTION_PUBLIC_KEY = "pre_key_encryption_public_key";
    private Long preKeyExpirationTimestamp;
    static final String PRE_KEY_EXPIRATION_TIMESTAMP = "pre_key_expiration_timestamp";
    boolean channelCreationAlreadyInProgress = false;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED_OTHER_DEVICE = 1L;
    private static final long HOOK_BIT_CAPABILITIES_UPDATED = 2L;
    private static final long HOOK_BIT_DEVICES_CHANGED = 4L;

    public UID getUid() {
        return this.uid;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public boolean isCurrentDevice() {
        return this.isCurrentDevice;
    }

    public boolean hasPreKey() {
        return this.preKeyId != null;
    }

    public PreKey getPreKey() {
        if (this.hasPreKey()) {
            return new PreKey(this.uid, this.preKeyId, this.preKeyEncryptionPublicKey, this.preKeyExpirationTimestamp);
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Long getExpirationTimestamp() {
        return this.expirationTimestamp;
    }

    public Long getLastRegistrationTimestamp() {
        return this.lastRegistrationTimestamp;
    }

    public List<ObvCapability> getDeviceCapabilities() {
        return ObvCapability.deserializeDeviceCapabilities(this.serializedDeviceCapabilities);
    }

    public String[] getRawDeviceCapabilities() {
        return ObvCapability.deserializeRawDeviceCapabilities(this.serializedDeviceCapabilities);
    }

    public long getLatestChannelCreationPingTimestamp() {
        return this.latestChannelCreationPingTimestamp;
    }

    public static OwnedDevice createOtherDevice(IdentityManagerSession identityManagerSession, UID uid, Identity identity, String displayName, Long expirationTimestamp, Long lastRegistrationTimestamp, PreKeyBlobOnServer preKeyBlob, boolean channelCreationAlreadyInProgress) {
        if (identity == null) {
            return null;
        }
        try {
            OwnedDevice ownedDevice = new OwnedDevice(identityManagerSession, uid, identity, false, preKeyBlob == null ? null : ObvCapability.serializeRawDeviceCapabilities(preKeyBlob.rawDeviceCapabilities), displayName, expirationTimestamp, lastRegistrationTimestamp, preKeyBlob == null ? null : preKeyBlob.preKey);
            ownedDevice.insert();
            ownedDevice.channelCreationAlreadyInProgress = channelCreationAlreadyInProgress;
            return ownedDevice;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static OwnedDevice createCurrentDevice(IdentityManagerSession identityManagerSession, Identity identity, String displayName, PRNGService prng) {
        if (identity == null) {
            return null;
        }
        UID uid = new UID(prng);
        try {
            OwnedDevice ownedDevice = new OwnedDevice(identityManagerSession, uid, identity, true, null, displayName, null, null, null);
            ownedDevice.insert();
            return ownedDevice;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private OwnedDevice(IdentityManagerSession identityManagerSession, UID uid, Identity ownedIdentity, boolean isCurrentDevice, byte[] serializedDeviceCapabilities, String displayName, Long expirationTimestamp, Long lastRegistrationTimestamp, PreKey preKey) {
        this.identityManagerSession = identityManagerSession;
        this.uid = uid;
        this.ownedIdentity = ownedIdentity;
        this.isCurrentDevice = isCurrentDevice;
        this.serializedDeviceCapabilities = serializedDeviceCapabilities;
        this.displayName = displayName;
        this.expirationTimestamp = expirationTimestamp;
        this.lastRegistrationTimestamp = lastRegistrationTimestamp;
        this.latestChannelCreationPingTimestamp = 0L;
        if (preKey != null) {
            this.preKeyId = preKey.keyId;
            this.preKeyEncryptionPublicKey = preKey.encryptionPublicKey;
            this.preKeyExpirationTimestamp = preKey.expirationTimestamp;
        }
    }

    private OwnedDevice(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.uid = new UID(res.getBytes(UID_));
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.isCurrentDevice = res.getBoolean(IS_CURRENT_DEVICE);
        this.serializedDeviceCapabilities = res.getBytes(SERIALIZED_DEVICE_CAPABILITIES);
        this.displayName = res.getString(DISPLAY_NAME);
        this.expirationTimestamp = res.getLong(EXPIRATION_TIMESTAMP);
        if (res.wasNull()) {
            this.expirationTimestamp = null;
        }
        this.lastRegistrationTimestamp = res.getLong(LAST_REGISTRATION_TIMESTAMP);
        if (res.wasNull()) {
            this.lastRegistrationTimestamp = null;
        }
        this.latestChannelCreationPingTimestamp = res.getLong(LATEST_CHANNEL_CREATION_PING_TIMESTAMP);
        byte[] preKeyIdBytes = res.getBytes(PRE_KEY_ID);
        this.preKeyId = preKeyIdBytes == null ? null : new KeyId(preKeyIdBytes);
        byte[] preKeyEncodedPublicKeyBytes = res.getBytes(PRE_KEY_ENCRYPTION_PUBLIC_KEY);
        if (preKeyEncodedPublicKeyBytes != null) {
            try {
                this.preKeyEncryptionPublicKey = (EncryptionPublicKey)new Encoded(preKeyEncodedPublicKeyBytes).decodePublicKey();
            }
            catch (DecodingException decodingException) {
                // empty catch block
            }
        }
        this.preKeyExpirationTimestamp = res.getLong(PRE_KEY_EXPIRATION_TIMESTAMP);
        if (res.wasNull()) {
            this.preKeyExpirationTimestamp = null;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS owned_device (uid BLOB PRIMARY KEY, identity BLOB NOT NULL, is_current_device BIT NOT NULL, serialized_device_capabilities BLOB DEFAULT NULL, display_name TEXT DEFAULT NULL, expiration_timestamp INTEGER DEFAULT NULL, last_registration_timestamp INTEGER DEFAULT NULL, latest_channel_creation_ping_timestamp BIGINT NOT NULL DEFAULT 0, pre_key_id BLOB DEFAULT NULL, pre_key_encryption_public_key BLOB DEFAULT NULL, pre_key_expiration_timestamp BIGINT DEFAULT NULL, FOREIGN KEY (identity) REFERENCES owned_identity (identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 27 && newVersion >= 27) {
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE owned_device ADD COLUMN `serialized_device_capabilities` BLOB DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 27;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            Logger.d("MIGRATING `owned_device` DATABASE FROM VERSION " + oldVersion + " TO 35");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE owned_device ADD COLUMN `display_name` TEXT DEFAULT NULL");
                statement.execute("ALTER TABLE owned_device ADD COLUMN `expiration_timestamp` INTEGER DEFAULT NULL");
                statement.execute("ALTER TABLE owned_device ADD COLUMN `last_registration_timestamp` INTEGER DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
        if (oldVersion < 41 && newVersion >= 41) {
            Logger.d("MIGRATING `owned_device` DATABASE FROM VERSION " + oldVersion + " TO 41");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE owned_device ADD COLUMN `latest_channel_creation_ping_timestamp` BIGINT NOT NULL DEFAULT 0");
                statement.execute("ALTER TABLE owned_device ADD COLUMN `pre_key_id` BLOB DEFAULT NULL");
                statement.execute("ALTER TABLE owned_device ADD COLUMN `pre_key_encryption_public_key` BLOB DEFAULT NULL");
                statement.execute("ALTER TABLE owned_device ADD COLUMN `pre_key_expiration_timestamp` BIGINT DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 41;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.insert", "INSERT INTO owned_device VALUES (?,?,?,?,?, ?,?,?,?,?, ?);");){
            statement.setBytes(1, this.uid.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBoolean(3, this.isCurrentDevice);
            statement.setBytes(4, this.serializedDeviceCapabilities);
            statement.setString(5, this.displayName);
            if (this.expirationTimestamp == null) {
                statement.setNull(6, 4);
            } else {
                statement.setLong(6, this.expirationTimestamp);
            }
            if (this.lastRegistrationTimestamp == null) {
                statement.setNull(7, 4);
            } else {
                statement.setLong(7, this.lastRegistrationTimestamp);
            }
            statement.setLong(8, this.latestChannelCreationPingTimestamp);
            if (this.preKeyId != null && this.preKeyEncryptionPublicKey != null && this.preKeyExpirationTimestamp != null) {
                statement.setBytes(9, this.preKeyId.getBytes());
                statement.setBytes(10, Encoded.of(this.preKeyEncryptionPublicKey).getBytes());
                statement.setLong(11, this.preKeyExpirationTimestamp);
            } else {
                statement.setBytes(9, null);
                statement.setBytes(10, null);
                statement.setNull(11, -5);
            }
            statement.executeUpdate();
            if (!this.isCurrentDevice) {
                this.commitHookBits |= 5L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.delete", "DELETE FROM owned_device WHERE uid = ?;");){
            statement.setBytes(1, this.uid.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 6L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public static OwnedDevice get(IdentityManagerSession identityManagerSession, UID ownedDeviceUid) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.get", "SELECT * FROM owned_device WHERE uid = ?;");){
            OwnedDevice ownedDevice;
            block16: {
                ResultSet res;
                block14: {
                    OwnedDevice ownedDevice2;
                    block15: {
                        statement.setBytes(1, ownedDeviceUid.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            ownedDevice2 = new OwnedDevice(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedDevice2;
                }
                ownedDevice = null;
                if (res == null) break block16;
                res.close();
            }
            return ownedDevice;
        }
    }

    public static OwnedDevice getCurrentDeviceOfOwnedIdentity(IdentityManagerSession identityManagerSession, Identity identity) throws SQLException {
        if (identity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.getCurrentDeviceOfOwnedIdentity", "SELECT * FROM owned_device WHERE identity = ? AND is_current_device = 1;");){
            OwnedDevice ownedDevice;
            block17: {
                ResultSet res;
                block15: {
                    OwnedDevice ownedDevice2;
                    block16: {
                        statement.setBytes(1, identity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            ownedDevice2 = new OwnedDevice(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return ownedDevice2;
                }
                ownedDevice = null;
                if (res == null) break block17;
                res.close();
            }
            return ownedDevice;
        }
    }

    public static OwnedDevice[] getOtherDevicesOfOwnedIdentity(IdentityManagerSession identityManagerSession, Identity identity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.getOtherDevicesOfOwnedIdentity", "SELECT * FROM owned_device WHERE identity = ? AND is_current_device = 0;");){
            OwnedDevice[] ownedDeviceArray;
            block13: {
                statement.setBytes(1, identity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedDevice> list = new ArrayList<OwnedDevice>();
                    while (res.next()) {
                        list.add(new OwnedDevice(identityManagerSession, res));
                    }
                    ownedDeviceArray = list.toArray(new OwnedDevice[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return ownedDeviceArray;
        }
    }

    public static List<OwnedDevice> getAllDevicesOfIdentity(IdentityManagerSession identityManagerSession, Identity identity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.getAllDevicesOfIdentity", "SELECT * FROM owned_device WHERE identity = ?;");){
            ArrayList<OwnedDevice> arrayList;
            block13: {
                statement.setBytes(1, identity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedDevice> list = new ArrayList<OwnedDevice>();
                    while (res.next()) {
                        list.add(new OwnedDevice(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<OwnedDevice> getAllWithExpiredPreKey(IdentityManagerSession identityManagerSession, Identity ownedIdentity, long expirationTimestamp) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.getAllWithExpiredPreKey", "SELECT * FROM owned_device WHERE identity = ?  AND pre_key_expiration_timestamp < ?;");){
            ArrayList<OwnedDevice> arrayList;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setLong(2, expirationTimestamp);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<OwnedDevice> list = new ArrayList<OwnedDevice>();
                    while (res.next()) {
                        list.add(new OwnedDevice(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static UID[] getAllDeviceUidsOfIdentity(IdentityManagerSession identityManagerSession, Identity identity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("OwnedDevice.getAllDeviceUidsOfIdentity", "SELECT uid FROM owned_device WHERE identity = ?;");){
            UID[] uIDArray;
            block13: {
                statement.setBytes(1, identity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<UID> list = new ArrayList<UID>();
                    while (res.next()) {
                        list.add(new UID(res.getBytes(UID_)));
                    }
                    uIDArray = list.toArray(new UID[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return uIDArray;
        }
    }

    public void setRawDeviceCapabilities(String[] rawDeviceCapabilities) throws SQLException {
        byte[] serializedDeviceCapabilities = ObvCapability.serializeRawDeviceCapabilities(rawDeviceCapabilities);
        if (Arrays.equals(serializedDeviceCapabilities, this.serializedDeviceCapabilities)) {
            return;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.setRawDeviceCapabilities", "UPDATE owned_device SET serialized_device_capabilities = ?  WHERE uid = ?  AND identity = ?;");){
            statement.setBytes(1, serializedDeviceCapabilities);
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.serializedDeviceCapabilities = serializedDeviceCapabilities;
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setDisplayName(String displayName) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.setDisplayName", "UPDATE owned_device SET display_name = ?  WHERE uid = ?  AND identity = ?;");){
            statement.setString(1, displayName);
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.displayName = displayName;
            this.commitHookBits |= 4L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setLatestChannelCreationPingTimestamp(long timestamp) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.setLatestChannelCreationPingTimestamp", "UPDATE owned_device SET latest_channel_creation_ping_timestamp = ?  WHERE uid = ?  AND identity = ?;");){
            statement.setLong(1, timestamp);
            statement.setBytes(2, this.uid.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.lastRegistrationTimestamp = timestamp;
        }
    }

    public void setTimestamps(Long expirationTimestamp, Long lastRegistrationTimestamp) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.setTimestamps", "UPDATE owned_device SET expiration_timestamp = ?, last_registration_timestamp = ?  WHERE uid = ?  AND identity = ?;");){
            if (expirationTimestamp == null) {
                statement.setNull(1, 4);
            } else {
                statement.setLong(1, expirationTimestamp);
            }
            if (lastRegistrationTimestamp == null) {
                statement.setNull(2, 4);
            } else {
                statement.setLong(2, lastRegistrationTimestamp);
            }
            statement.setBytes(3, this.uid.getBytes());
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.expirationTimestamp = expirationTimestamp;
            this.lastRegistrationTimestamp = lastRegistrationTimestamp;
            this.commitHookBits |= 4L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setPreKey(PreKey preKey) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("OwnedDevice.setPreKey", "UPDATE owned_device SET pre_key_id = ?, pre_key_encryption_public_key = ?, pre_key_expiration_timestamp = ?  WHERE uid = ?  AND identity = ?;");){
            boolean preKeyAddedOrRemoved;
            if (preKey == null) {
                statement.setNull(1, 2004);
                statement.setNull(2, 2004);
                statement.setNull(3, -5);
                preKeyAddedOrRemoved = this.preKeyId != null;
                this.preKeyId = null;
                this.preKeyEncryptionPublicKey = null;
                this.preKeyExpirationTimestamp = null;
            } else {
                statement.setBytes(1, preKey.keyId.getBytes());
                statement.setBytes(2, Encoded.of(preKey.encryptionPublicKey).getBytes());
                statement.setLong(3, preKey.expirationTimestamp);
                preKeyAddedOrRemoved = this.preKeyId == null;
                this.preKeyId = preKey.keyId;
                this.preKeyEncryptionPublicKey = preKey.encryptionPublicKey;
                this.preKeyExpirationTimestamp = preKey.expirationTimestamp;
            }
            statement.setBytes(4, this.uid.getBytes());
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            if (preKeyAddedOrRemoved) {
                this.commitHookBits |= 4L;
                this.identityManagerSession.session.addSessionCommitListener(this);
            }
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put("device_uid", this.uid);
            userInfo.put("owned_identity", this.ownedIdentity);
            userInfo.put("channel_creation_already_in_progress", this.channelCreationAlreadyInProgress);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_owned_device", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("owned_identity", this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_own_capabilities_updated", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("owned_identity", this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_owned_device_list_changed", userInfo);
        }
        this.commitHookBits = 0L;
    }
}

