/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public class KeycloakServer
implements ObvDatabase {
    static final String TABLE_NAME = "keycloak_server";
    private final IdentityManagerSession identityManagerSession;
    private String serverUrl;
    static final String SERVER_URL = "server_url";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private String serializedJwks;
    static final String SERIALIZED_JWKS = "serialized_jwks";
    private String clientId;
    static final String CLIENT_ID = "client_id";
    private String clientSecret;
    static final String CLIENT_SECRET = "client_secret";
    private String keycloakUserId;
    static final String KEYCLOAK_USER_ID = "keycloak_user_id";
    private String serializedAuthState;
    static final String SERIALIZED_AUTH_STATE = "serialized_auth_state";
    private byte[] serializedPushTopics;
    static final String SERIALIZED_PUSH_TOPICS = "serialized_push_topics";
    private String serializedSignatureKey;
    static final String SERIALIZED_SIGNATURE_KEY = "serialized_signature_key";
    private String selfRevocationTestNonce;
    static final String SELF_REVOCATION_TEST_NONCE = "self_revocation_test_nonce";
    private long latestRevocationListTimestamp;
    static final String LATEST_REVOCATION_LIST_TIMESTAMP = "latest_revocation_list_timestamp";
    private long latestGroupUpdateTimestamp;
    static final String LATEST_GROUP_UPDATE_TIMESTAMP = "latest_group_update_timestamp";
    private String ownApiKey;
    static final String OWN_API_KEY = "own_api_key";
    private boolean transferRestricted;
    static final String TRANSFER_RESTRICTED = "transfer_restricted";

    public String getServerUrl() {
        return this.serverUrl;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public String getSerializedAuthState() {
        return this.serializedAuthState;
    }

    public String getKeycloakUserId() {
        return this.keycloakUserId;
    }

    public JsonWebKeySet getJwks() throws Exception {
        return new JsonWebKeySet(this.serializedJwks);
    }

    public String getSerializedJwks() {
        return this.serializedJwks;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public JsonWebKey getSignatureKey() throws Exception {
        if (this.serializedSignatureKey == null) {
            return null;
        }
        return JsonWebKey.Factory.newJwk((String)this.serializedSignatureKey);
    }

    public String getSerializedSignatureKey() {
        return this.serializedSignatureKey;
    }

    public String getSelfRevocationTestNonce() {
        return this.selfRevocationTestNonce;
    }

    public String getOwnApiKey() {
        return this.ownApiKey;
    }

    public boolean isTransferRestricted() {
        return this.transferRestricted;
    }

    public List<String> getPushTopics() {
        if (this.serializedPushTopics == null) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> res = new ArrayList<String>();
        int startPos = 0;
        for (int i = 0; i < this.serializedPushTopics.length; ++i) {
            if (this.serializedPushTopics[i] != 0) continue;
            res.add(new String(Arrays.copyOfRange(this.serializedPushTopics, startPos, i), StandardCharsets.UTF_8));
            startPos = i + 1;
        }
        if (startPos != this.serializedPushTopics.length) {
            res.add(new String(Arrays.copyOfRange(this.serializedPushTopics, startPos, this.serializedPushTopics.length), StandardCharsets.UTF_8));
        }
        return res;
    }

    public long getLatestRevocationListTimestamp() {
        return this.latestRevocationListTimestamp;
    }

    public long getLatestGroupUpdateTimestamp() {
        return this.latestGroupUpdateTimestamp;
    }

    public static KeycloakServer create(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String serializedJwks, String serializedKey, String clientId, String clientSecret, boolean transferRestricted) {
        if (serverUrl == null || ownedIdentity == null || serializedJwks == null) {
            return null;
        }
        try {
            KeycloakServer keycloakServer = new KeycloakServer(identityManagerSession, serverUrl, ownedIdentity, serializedJwks, serializedKey, clientId, clientSecret, transferRestricted);
            keycloakServer.insert();
            return keycloakServer;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public KeycloakServer(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String serializedJwks, String serializedSignatureKey, String clientId, String clientSecret, boolean transferRestricted) {
        this.identityManagerSession = identityManagerSession;
        this.serverUrl = serverUrl;
        this.ownedIdentity = ownedIdentity;
        this.serializedJwks = serializedJwks;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.keycloakUserId = null;
        this.serializedAuthState = null;
        this.serializedPushTopics = null;
        this.serializedSignatureKey = serializedSignatureKey;
        this.selfRevocationTestNonce = null;
        this.latestRevocationListTimestamp = 0L;
        this.latestGroupUpdateTimestamp = 0L;
        this.ownApiKey = null;
        this.transferRestricted = transferRestricted;
    }

    private KeycloakServer(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.serverUrl = res.getString(SERVER_URL);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.serializedJwks = res.getString(SERIALIZED_JWKS);
        this.clientId = res.getString(CLIENT_ID);
        this.clientSecret = res.getString(CLIENT_SECRET);
        this.keycloakUserId = res.getString(KEYCLOAK_USER_ID);
        this.serializedAuthState = res.getString(SERIALIZED_AUTH_STATE);
        this.serializedPushTopics = res.getBytes(SERIALIZED_PUSH_TOPICS);
        this.serializedSignatureKey = res.getString(SERIALIZED_SIGNATURE_KEY);
        this.selfRevocationTestNonce = res.getString(SELF_REVOCATION_TEST_NONCE);
        this.latestRevocationListTimestamp = res.getLong(LATEST_REVOCATION_LIST_TIMESTAMP);
        this.latestGroupUpdateTimestamp = res.getLong(LATEST_GROUP_UPDATE_TIMESTAMP);
        this.ownApiKey = res.getString(OWN_API_KEY);
        this.transferRestricted = res.getBoolean(TRANSFER_RESTRICTED);
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS keycloak_server (server_url TEXT NOT NULL, owned_identity BLOB NOT NULL, serialized_jwks TEXT NOT NULL, client_id TEXT, client_secret TEXT, keycloak_user_id TEXT, serialized_auth_state TEXT, serialized_push_topics BLOB, serialized_signature_key TEXT, self_revocation_test_nonce TEXT, latest_revocation_list_timestamp BIGINT NOT NULL, latest_group_update_timestamp BIGINT NOT NULL, own_api_key TEXT, transfer_restricted BIT NOT NULL,  CONSTRAINT PK_keycloak_server PRIMARY KEY(server_url, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity (identity) ON DELETE CASCADE);");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 24 && newVersion >= 24) {
            Logger.d("MIGRATING `keycloak_server` DATABASE FROM VERSION " + oldVersion + " TO 24");
            statement = session.createStatement();
            try {
                statement.execute("CREATE TABLE IF NOT EXISTS keycloak_server ( server_url TEXT NOT NULL,  owned_identity BLOB NOT NULL,  serialized_jwks TEXT NOT NULL,  client_id TEXT,  client_secret TEXT,  keycloak_user_id TEXT,  serialized_auth_state TEXT,  CONSTRAINT PK_keycloak_server PRIMARY KEY(server_url, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity (identity) ON DELETE CASCADE);");
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `serialized_push_topics` BLOB DEFAULT NULL;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 24;
        }
        if (oldVersion < 25 && newVersion >= 25) {
            Logger.d("MIGRATING `keycloak_server` DATABASE FROM VERSION " + oldVersion + " TO 25");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `serialized_signature_key` TEXT DEFAULT NULL;");
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `self_revocation_test_nonce` TEXT DEFAULT NULL;");
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `latest_revocation_list_timestamp` BIGINT NOT NULL DEFAULT 0;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 25;
        }
        if (oldVersion < 34 && newVersion >= 34) {
            Logger.d("MIGRATING `keycloak_server` DATABASE FROM VERSION " + oldVersion + " TO 34");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `latest_group_update_timestamp` BIGINT NOT NULL DEFAULT 0;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 34;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            Logger.d("MIGRATING `keycloak_server` DATABASE FROM VERSION " + oldVersion + " TO 35");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `own_api_key` TEXT DEFAULT NULL;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
        if (oldVersion < 42 && newVersion >= 42) {
            Logger.d("MIGRATING `keycloak_server` DATABASE FROM VERSION " + oldVersion + " TO 42");
            statement = session.createStatement();
            try {
                statement.execute("ALTER TABLE keycloak_server ADD COLUMN `transfer_restricted` BIT NOT NULL DEFAULT 0;");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 35;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.insert", "INSERT INTO keycloak_server VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?);");){
            statement.setString(1, this.serverUrl);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setString(3, this.serializedJwks);
            statement.setString(4, this.clientId);
            statement.setString(5, this.clientSecret);
            statement.setString(6, this.keycloakUserId);
            statement.setString(7, this.serializedAuthState);
            statement.setBytes(8, this.serializedPushTopics);
            statement.setString(9, this.serializedSignatureKey);
            statement.setString(10, this.selfRevocationTestNonce);
            statement.setLong(11, this.latestRevocationListTimestamp);
            statement.setLong(12, this.latestGroupUpdateTimestamp);
            statement.setString(13, this.ownApiKey);
            statement.setBoolean(14, this.transferRestricted);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.delete", "DELETE FROM keycloak_server WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, this.serverUrl);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static KeycloakServer get(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.get", "SELECT * FROM keycloak_server WHERE server_url = ? AND owned_identity = ?;");){
            KeycloakServer keycloakServer;
            block16: {
                ResultSet res;
                block14: {
                    KeycloakServer keycloakServer2;
                    block15: {
                        statement.setString(1, serverUrl);
                        statement.setBytes(2, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            keycloakServer2 = new KeycloakServer(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return keycloakServer2;
                }
                keycloakServer = null;
                if (res == null) break block16;
                res.close();
            }
            return keycloakServer;
        }
    }

    public static List<KeycloakServer> getAllWithPushTopic(IdentityManagerSession identityManagerSession, String pushTopic) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.getAllWithPushTopic", "SELECT * FROM keycloak_server WHERE serialized_push_topics LIKE ?;");){
            ArrayList<KeycloakServer> arrayList;
            block13: {
                statement.setBytes(1, ("%" + pushTopic + "%").getBytes(StandardCharsets.UTF_8));
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<KeycloakServer> list = new ArrayList<KeycloakServer>();
                    while (res.next()) {
                        list.add(new KeycloakServer(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void saveAuthState(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String serializedAuthState) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.saveAuthState", "UPDATE keycloak_server SET serialized_auth_state = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, serializedAuthState);
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static void saveJwks(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String serializedJwks) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.saveJwks", "UPDATE keycloak_server SET serialized_jwks = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, serializedJwks);
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static void saveApiKey(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String apiKey) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.saveApiKey", "UPDATE keycloak_server SET own_api_key = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, apiKey);
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static void setKeycloakUserId(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, String userId) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.setKeycloakUserId", "UPDATE keycloak_server SET keycloak_user_id = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, userId);
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void setKeycloakUserId(String userId) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.setKeycloakUserId", "UPDATE keycloak_server SET keycloak_user_id = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, userId);
            statement.setString(2, this.serverUrl);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.keycloakUserId = userId;
        }
    }

    public void setTransferRestricted(boolean transferRestricted) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.setTransferRestricted", "UPDATE keycloak_server SET transfer_restricted = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, transferRestricted);
            statement.setString(2, this.serverUrl);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.transferRestricted = transferRestricted;
        }
    }

    public void setPushTopics(List<String> pushTopics) throws SQLException {
        byte[] serializedPushTopics;
        if (pushTopics == null || pushTopics.isEmpty()) {
            serializedPushTopics = null;
        } else {
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                boolean first = true;
                for (String pushTopic : pushTopics) {
                    if (!first) {
                        baos.write(new byte[]{0});
                    }
                    first = false;
                    baos.write(pushTopic.getBytes(StandardCharsets.UTF_8));
                }
                serializedPushTopics = baos.toByteArray();
            }
            catch (IOException e) {
                serializedPushTopics = null;
            }
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.setPushTopics", "UPDATE keycloak_server SET serialized_push_topics = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setBytes(1, serializedPushTopics);
            statement.setString(2, this.serverUrl);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.serializedPushTopics = serializedPushTopics;
        }
    }

    public void setSelfRevocationTestNonce(String selfRevocationTestNonce) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.setSelfRevocationTestNonce", "UPDATE keycloak_server SET self_revocation_test_nonce = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, selfRevocationTestNonce);
            statement.setString(2, this.serverUrl);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.selfRevocationTestNonce = selfRevocationTestNonce;
        }
    }

    public static void setSignatureKey(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, JsonWebKey signatureKey) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.setSignatureKey", "UPDATE keycloak_server SET serialized_signature_key = ?, latest_group_update_timestamp = 0  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setString(1, signatureKey == null ? null : signatureKey.toJson());
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static void setLatestRevocationListTimestamp(IdentityManagerSession identityManagerSession, String serverUrl, Identity ownedIdentity, long latestRevocationListTimetamp) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("KeycloakServer.setLatestRevocationListTimestamp", "UPDATE keycloak_server SET latest_revocation_list_timestamp = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setLong(1, latestRevocationListTimetamp);
            statement.setString(2, serverUrl);
            statement.setBytes(3, ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void setLatestGroupUpdateTimestamp(long latestGroupUpdateTimestamp) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("KeycloakServer.setLatestGroupUpdateTimestamp", "UPDATE keycloak_server SET latest_group_update_timestamp = ?  WHERE server_url = ?  AND owned_identity = ?;");){
            statement.setLong(1, latestGroupUpdateTimestamp);
            statement.setString(2, this.serverUrl);
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.latestRevocationListTimestamp = latestGroupUpdateTimestamp;
        }
    }

    @Override
    public void wasCommitted() {
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.server_url = this.serverUrl;
        pojo.jwks = this.serializedJwks;
        pojo.client_id = this.clientId;
        pojo.client_secret = this.clientSecret;
        pojo.keycloak_user_id = this.keycloakUserId;
        pojo.serialized_signature_key = this.serializedSignatureKey;
        pojo.self_revocation_test_nonce = this.selfRevocationTestNonce;
        return pojo;
    }

    public static KeycloakServer restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Pojo_0 pojo) throws SQLException {
        if (ownedIdentity == null || pojo.server_url == null || pojo.client_id == null || pojo.jwks == null) {
            return null;
        }
        KeycloakServer keycloakServer = new KeycloakServer(identityManagerSession, pojo.server_url, ownedIdentity, pojo.jwks, pojo.serialized_signature_key, pojo.client_id, pojo.client_secret, false);
        keycloakServer.keycloakUserId = pojo.keycloak_user_id;
        keycloakServer.selfRevocationTestNonce = pojo.self_revocation_test_nonce;
        keycloakServer.insert();
        return keycloakServer;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public String server_url;
        public String jwks;
        public String client_id;
        public String client_secret;
        public String keycloak_user_id;
        public String serialized_signature_key;
        public String self_revocation_test_nonce;
    }
}

