/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;

public class ContactIdentityDetails
implements ObvDatabase {
    static final String TABLE_NAME = "contact_identity_details";
    private final IdentityManagerSession identityManagerSession;
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private int version;
    static final String VERSION = "version";
    private String serializedJsonDetails;
    static final String SERIALIZED_JSON_DETAILS = "serialized_json_details";
    private String photoUrl;
    static final String PHOTO_URL = "photo_url";
    private UID photoServerLabel;
    static final String PHOTO_SERVER_LABEL = "photo_server_label";
    private AuthEncKey photoServerKey;
    static final String PHOTO_SERVER_KEY = "photo_server_key";

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSerializedJsonDetails() {
        return this.serializedJsonDetails;
    }

    public JsonIdentityDetails getJsonIdentityDetails() {
        try {
            return (JsonIdentityDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonIdentityDetails.class);
        }
        catch (Exception e) {
            return null;
        }
    }

    public JsonIdentityDetailsWithVersionAndPhoto getJsonIdentityDetailsWithVersionAndPhoto() {
        try {
            JsonIdentityDetailsWithVersionAndPhoto json = new JsonIdentityDetailsWithVersionAndPhoto();
            json.setIdentityDetails((JsonIdentityDetails)this.identityManagerSession.jsonObjectMapper.readValue(this.serializedJsonDetails, JsonIdentityDetails.class));
            json.setVersion(this.version);
            json.setPhotoUrl(this.photoUrl);
            if (this.photoServerLabel != null && this.photoServerKey != null) {
                json.setPhotoServerLabel(this.photoServerLabel.getBytes());
                json.setPhotoServerKey(Encoded.of(this.photoServerKey).getBytes());
            }
            return json;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public UID getPhotoServerLabel() {
        return this.photoServerLabel;
    }

    public AuthEncKey getPhotoServerKey() {
        return this.photoServerKey;
    }

    public static ContactIdentityDetails create(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto) {
        if (contactIdentity == null || ownedIdentity == null || jsonIdentityDetailsWithVersionAndPhoto == null || jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails() == null) {
            return null;
        }
        try {
            int version = jsonIdentityDetailsWithVersionAndPhoto.getVersion();
            String serializedJsonDetails = identityManagerSession.jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetailsWithVersionAndPhoto.getIdentityDetails());
            UID photoServerLabel = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel() == null ? null : new UID(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerLabel());
            AuthEncKey photoServerKey = jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey() == null ? null : (AuthEncKey)new Encoded(jsonIdentityDetailsWithVersionAndPhoto.getPhotoServerKey()).decodeSymmetricKey();
            ContactIdentityDetails contactIdentityDetails = new ContactIdentityDetails(identityManagerSession, contactIdentity, ownedIdentity, version, serializedJsonDetails, null, photoServerLabel, photoServerKey);
            contactIdentityDetails.insert();
            return contactIdentityDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactIdentityDetails copy(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity, int version, int newVersion) {
        if (ownedIdentity == null) {
            return null;
        }
        try {
            ContactIdentityDetails oldDetails = ContactIdentityDetails.get(identityManagerSession, contactIdentity, ownedIdentity, version);
            if (oldDetails == null) {
                return null;
            }
            ContactIdentityDetails ownedIdentityDetails = new ContactIdentityDetails(identityManagerSession, contactIdentity, ownedIdentity, newVersion, oldDetails.serializedJsonDetails, oldDetails.photoUrl, oldDetails.photoServerLabel, oldDetails.photoServerKey);
            ownedIdentityDetails.insert();
            return ownedIdentityDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactIdentityDetails(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, int version, String serializedJsonDetails, String photoUrl, UID photoServerLabel, AuthEncKey photoServerKey) {
        this.identityManagerSession = identityManagerSession;
        this.contactIdentity = contactIdentity;
        this.ownedIdentity = ownedIdentity;
        this.version = version;
        this.serializedJsonDetails = serializedJsonDetails;
        this.photoUrl = photoUrl;
        this.photoServerLabel = photoServerLabel;
        this.photoServerKey = photoServerKey;
    }

    private ContactIdentityDetails(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.version = res.getInt(VERSION);
        this.serializedJsonDetails = res.getString(SERIALIZED_JSON_DETAILS);
        this.photoUrl = res.getString(PHOTO_URL);
        byte[] bytes = res.getBytes(PHOTO_SERVER_LABEL);
        this.photoServerLabel = bytes == null ? null : new UID(bytes);
        bytes = res.getBytes(PHOTO_SERVER_KEY);
        if (bytes == null) {
            this.photoServerKey = null;
        } else {
            try {
                this.photoServerKey = (AuthEncKey)new Encoded(bytes).decodeSymmetricKey();
            }
            catch (DecodingException e) {
                Logger.x(e);
                this.photoServerKey = null;
            }
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_identity_details (contact_identity BLOB NOT NULL, owned_identity BLOB NOT NULL, version INT NOT NULL, serialized_json_details TEXT NOT NULL, photo_url TEXT, photo_server_label BLOB, photo_server_key BLOB,  CONSTRAINT PK_contact_identity_details PRIMARY KEY(contact_identity, owned_identity, version));");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentityDetails.insert", "INSERT INTO contact_identity_details VALUES (?,?,?,?,?, ?,?);");){
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.setString(4, this.serializedJsonDetails);
            statement.setString(5, this.photoUrl);
            statement.setBytes(6, this.photoServerLabel == null ? null : this.photoServerLabel.getBytes());
            statement.setBytes(7, this.photoServerKey == null ? null : Encoded.of(this.photoServerKey).getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentityDetails.delete", "DELETE FROM contact_identity_details WHERE contact_identity = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, this.contactIdentity.getBytes());
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setInt(3, this.version);
            statement.executeUpdate();
        }
    }

    public static ContactIdentityDetails get(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity, int version) throws SQLException {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentityDetails.get", "SELECT * FROM contact_identity_details WHERE contact_identity = ? AND owned_identity = ? AND version = ?;");){
            ContactIdentityDetails contactIdentityDetails;
            block17: {
                ResultSet res;
                block15: {
                    ContactIdentityDetails contactIdentityDetails2;
                    block16: {
                        statement.setBytes(1, contactIdentity.getBytes());
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setInt(3, version);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactIdentityDetails2 = new ContactIdentityDetails(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactIdentityDetails2;
                }
                contactIdentityDetails = null;
                if (res == null) break block17;
                res.close();
            }
            return contactIdentityDetails;
        }
    }

    public static List<String> getAllPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentityDetails.getAllPhotoUrl", "SELECT photo_url FROM contact_identity_details WHERE photo_url IS NOT NULL;");){
            ArrayList<String> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (res.next()) {
                        list.add(res.getString(PHOTO_URL));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactIdentityDetails> getAllWithMissingPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentityDetails.getAllWithMissingPhotoUrl", "SELECT * FROM contact_identity_details WHERE photo_url IS NULL  AND photo_server_key IS NOT NULL  AND photo_server_label IS NOT NULL;");){
            ArrayList<ContactIdentityDetails> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactIdentityDetails> list = new ArrayList<ContactIdentityDetails>();
                    while (res.next()) {
                        list.add(new ContactIdentityDetails(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public void setPhotoUrl(String photoUrl) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentityDetails.setPhotoUrl", "UPDATE contact_identity_details SET photo_url = ?  WHERE contact_identity = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, photoUrl);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.photoUrl = photoUrl;
        }
    }

    public void setSerializedJsonDetails(String serializedJsonDetails) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactIdentityDetails.setSerializedJsonDetails", "UPDATE contact_identity_details SET serialized_json_details = ?  WHERE contact_identity = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, serializedJsonDetails);
            statement.setBytes(2, this.contactIdentity.getBytes());
            statement.setBytes(3, this.ownedIdentity.getBytes());
            statement.setInt(4, this.version);
            statement.executeUpdate();
            this.serializedJsonDetails = serializedJsonDetails;
        }
    }

    public static void cleanup(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity, int publishedVersion, int trustedVersion) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactIdentityDetails.cleanup", "DELETE FROM contact_identity_details WHERE owned_identity = ?  AND contact_identity = ?  AND version NOT IN (?,?);");){
            statement.setBytes(1, ownedIdentity.getBytes());
            statement.setBytes(2, contactIdentity.getBytes());
            statement.setInt(3, publishedVersion);
            statement.setInt(4, trustedVersion);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.version = this.version;
        pojo.serialized_details = this.serializedJsonDetails;
        if (this.photoServerLabel != null) {
            pojo.photo_server_label = this.photoServerLabel.getBytes();
        }
        if (this.photoServerKey != null) {
            pojo.photo_server_key = Encoded.of(this.photoServerKey).getBytes();
        }
        return pojo;
    }

    public static ContactIdentityDetails restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity, Pojo_0 pojo) throws SQLException {
        UID photoServerLabel = null;
        if (pojo.photo_server_label != null) {
            photoServerLabel = new UID(pojo.photo_server_label);
        }
        AuthEncKey photoServerKey = null;
        try {
            if (pojo.photo_server_key != null) {
                photoServerKey = (AuthEncKey)new Encoded(pojo.photo_server_key).decodeSymmetricKey();
            }
        }
        catch (DecodingException | ClassCastException e) {
            Logger.x(e);
        }
        ContactIdentityDetails contactIdentityDetails = new ContactIdentityDetails(identityManagerSession, contactIdentity, ownedIdentity, pojo.version, pojo.serialized_details, null, photoServerLabel, photoServerKey);
        contactIdentityDetails.insert();
        return contactIdentityDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public int version;
        public String serialized_details;
        public byte[] photo_server_label;
        public byte[] photo_server_key;
    }
}

