/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.nio.charset.StandardCharsets;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.iharder.Base64;

public class ContactGroupV2PendingMember
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group_v2_pending_member";
    private final IdentityManagerSession identityManagerSession;
    private final UID groupUid;
    static final String GROUP_UID = "group_uid";
    private final String serverUrl;
    static final String SERVER_URL = "server_url";
    private final int category;
    static final String CATEGORY = "category";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private String serializedContactDetails;
    static final String SERIALIZED_CONTACT_DETAILS = "serialized_contact_details";
    private byte[] serializedPermissions;
    static final String SERIALIZED_PERMISSIONS = "serialized_permissions";
    private byte[] groupInvitationNonce;
    static final String GROUP_INVITATION_NONCE = "group_invitation_nonce";

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public String getSerializedContactDetails() {
        return this.serializedContactDetails;
    }

    public byte[] getSerializedPermissions() {
        return this.serializedPermissions;
    }

    public byte[] getGroupInvitationNonce() {
        return this.groupInvitationNonce;
    }

    public static ContactGroupV2PendingMember create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity contactIdentity, String serializedContactDetails, Collection<String> permissionStrings, byte[] groupInvitationNonce) {
        if (identityManagerSession == null || ownedIdentity == null || groupIdentifier == null || contactIdentity == null || permissionStrings == null || serializedContactDetails == null || groupInvitationNonce == null) {
            return null;
        }
        try {
            byte[] serializedPermissions = GroupV2.Permission.serializePermissionStrings(permissionStrings);
            ContactGroupV2PendingMember contactGroupPendingMember = new ContactGroupV2PendingMember(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, contactIdentity, serializedContactDetails, serializedPermissions, groupInvitationNonce);
            contactGroupPendingMember.insert();
            return contactGroupPendingMember;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    private ContactGroupV2PendingMember(IdentityManagerSession identityManagerSession, UID groupUid, String serverUrl, int category, Identity ownedIdentity, Identity contactIdentity, String serializedContactDetails, byte[] serializedPermissions, byte[] groupInvitationNonce) {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = groupUid;
        this.serverUrl = serverUrl;
        this.category = category;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
        this.serializedContactDetails = serializedContactDetails;
        this.serializedPermissions = serializedPermissions;
        this.groupInvitationNonce = groupInvitationNonce;
    }

    public ContactGroupV2PendingMember(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = new UID(res.getBytes(GROUP_UID));
        this.serverUrl = res.getString(SERVER_URL);
        this.category = res.getInt(CATEGORY);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        try {
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.serializedContactDetails = res.getString(SERIALIZED_CONTACT_DETAILS);
        this.serializedPermissions = res.getBytes(SERIALIZED_PERMISSIONS);
        this.groupInvitationNonce = res.getBytes(GROUP_INVITATION_NONCE);
    }

    public static ContactGroupV2PendingMember get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity contactIdentity) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.get", "SELECT * FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ? AND contact_identity = ?;");){
            ContactGroupV2PendingMember contactGroupV2PendingMember;
            block17: {
                ResultSet res;
                block15: {
                    ContactGroupV2PendingMember contactGroupV2PendingMember2;
                    block16: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        statement.setBytes(5, contactIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactGroupV2PendingMember2 = new ContactGroupV2PendingMember(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroupV2PendingMember2;
                }
                contactGroupV2PendingMember = null;
                if (res == null) break block17;
                res.close();
            }
            return contactGroupV2PendingMember;
        }
    }

    public static List<ContactGroupV2PendingMember> getAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.getAll", "SELECT * FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            ArrayList<ContactGroupV2PendingMember> arrayList;
            block14: {
                statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                statement.setString(2, groupIdentifier.serverUrl);
                statement.setInt(3, groupIdentifier.category);
                statement.setBytes(4, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2PendingMember> list = new ArrayList<ContactGroupV2PendingMember>();
                    while (res.next()) {
                        list.add(new ContactGroupV2PendingMember(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public void setPermissions(List<String> permissionStrings) throws Exception {
        byte[] serializedPermissions = GroupV2.Permission.serializePermissionStrings(permissionStrings);
        if (serializedPermissions == null) {
            throw new Exception("Unable to serialize permissions");
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.setPermissions", "UPDATE contact_group_v2_pending_member SET serialized_permissions = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ? AND contact_identity = ?;");){
            statement.setBytes(1, serializedPermissions);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setBytes(6, this.contactIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void setGroupInvitationNonce(byte[] groupInvitationNonce) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.setGroupInvitationNonce", "UPDATE contact_group_v2_pending_member SET group_invitation_nonce = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ? AND contact_identity = ?;");){
            statement.setBytes(1, groupInvitationNonce);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setBytes(6, this.contactIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void setSerializedContactDetails(String serializedContactDetails) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.setSerializedContactDetails", "UPDATE contact_group_v2_pending_member SET serialized_contact_details = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ? AND contact_identity = ?;");){
            statement.setString(1, serializedContactDetails);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setBytes(6, this.contactIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public static List<GroupV2.Identifier> getKeycloakGroupV2IdentifiersWhereContactIsPending(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        if (ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.getKeycloakGroupV2IdentifiersWhereContactIsPending", "SELECT group_uid as uid, server_url as url FROM contact_group_v2_pending_member WHERE owned_identity = ?  AND contact_identity = ? AND category = 1;");){
            ArrayList<GroupV2.Identifier> arrayList;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<GroupV2.Identifier> list = new ArrayList<GroupV2.Identifier>();
                    while (res.next()) {
                        try {
                            list.add(new GroupV2.Identifier(new UID(res.getBytes("uid")), res.getString("url"), 1));
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                    }
                    arrayList = list;
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group_v2_pending_member (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, serialized_contact_details TEXT NOT NULL, serialized_permissions BLOB NOT NULL, group_invitation_nonce BLOB NOT NULL,  CONSTRAINT PK_contact_group_v2_pending_member PRIMARY KEY(group_uid, server_url, category, owned_identity, contact_identity),  FOREIGN KEY (group_uid, server_url, category, owned_identity) REFERENCES contact_group_v2(group_uid, server_url, category, owned_identity) ON DELETE CASCADE );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 32 && newVersion >= 32) {
            try (Statement statement = session.createStatement();){
                Logger.d("CREATING contact_group_v2_member DATABASE FOR VERSION 32");
                statement.execute("CREATE TABLE contact_group_v2_pending_member (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL, serialized_contact_details TEXT NOT NULL, serialized_permissions BLOB NOT NULL, group_invitation_nonce BLOB NOT NULL,  CONSTRAINT PK_contact_group_v2_pending_member PRIMARY KEY(group_uid, server_url, category, owned_identity, contact_identity),  FOREIGN KEY (group_uid, server_url, category, owned_identity) REFERENCES contact_group_v2 (group_uid, server_url, category, owned_identity) ON DELETE CASCADE );");
            }
            oldVersion = 32;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.insert", "INSERT INTO contact_group_v2_pending_member VALUES (?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setBytes(5, this.contactIdentity.getBytes());
            statement.setString(6, this.serializedContactDetails);
            statement.setBytes(7, this.serializedPermissions);
            statement.setBytes(8, this.groupInvitationNonce);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2PendingMember.delete", " DELETE FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND contact_identity = ?;");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setBytes(5, this.contactIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }

    static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        List<ContactGroupV2PendingMember> members = ContactGroupV2PendingMember.getAll(identityManagerSession, ownedIdentity, groupIdentifier);
        Pojo_0[] pojos = new Pojo_0[members.size()];
        for (int i = 0; i < pojos.length; ++i) {
            pojos[i] = members.get(i).backup();
        }
        return pojos;
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.contact_identity = this.contactIdentity.getBytes();
        pojo.serialized_details = this.serializedContactDetails;
        pojo.permissions = GroupV2.Permission.deserializePermissions(this.serializedPermissions).toArray(new String[0]);
        pojo.invitation_nonce = this.groupInvitationNonce;
        return pojo;
    }

    static void restoreAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Pojo_0[] pojos) {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            try {
                String sanitizedSerializedDetails = null;
                try {
                    identityManagerSession.jsonObjectMapper.readValue(pojo.serialized_details, JsonIdentityDetails.class);
                    sanitizedSerializedDetails = pojo.serialized_details;
                }
                catch (Exception ignored) {
                    try {
                        String serializedDetailsString = new String(Base64.decode((String)pojo.serialized_details), StandardCharsets.UTF_8);
                        identityManagerSession.jsonObjectMapper.readValue(serializedDetailsString, JsonIdentityDetails.class);
                        sanitizedSerializedDetails = serializedDetailsString;
                    }
                    catch (Exception e) {
                        Logger.i("Could not determine serialized details of GroupV2 pending member.");
                    }
                }
                if (sanitizedSerializedDetails == null) continue;
                ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, Identity.of(pojo.contact_identity), sanitizedSerializedDetails, Arrays.asList(pojo.permissions), pojo.invitation_nonce);
            }
            catch (DecodingException e) {
                Logger.x(e);
            }
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] contact_identity;
        public String serialized_details;
        public String[] permissions;
        public byte[] invitation_nonce;
    }
}

