/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileInputStream;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;

public class ContactGroupV2Details
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group_v2_details";
    private final IdentityManagerSession identityManagerSession;
    private final UID groupUid;
    static final String GROUP_UID = "group_uid";
    private final String serverUrl;
    static final String SERVER_URL = "server_url";
    private final int category;
    static final String CATEGORY = "category";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private final int version;
    static final String VERSION = "version";
    private String serializedJsonDetails;
    static final String SERIALIZED_JSON_DETAILS = "serialized_json_details";
    private String photoUrl;
    static final String PHOTO_URL = "photo_url";
    private Identity photoServerIdentity;
    static final String PHOTO_SERVER_IDENTITY = "photo_server_identity";
    private UID photoServerLabel;
    static final String PHOTO_SERVER_LABEL = "photo_server_label";
    private AuthEncKey photoServerKey;
    static final String PHOTO_SERVER_KEY = "photo_server_key";

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getGroupUid() {
        return this.groupUid;
    }

    public int getVersion() {
        return this.version;
    }

    public String getSerializedJsonDetails() {
        return this.serializedJsonDetails;
    }

    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public GroupV2.ServerPhotoInfo getServerPhotoInfo() {
        if (this.photoServerLabel == null || this.photoServerKey == null) {
            return null;
        }
        return new GroupV2.ServerPhotoInfo(this.photoServerIdentity, this.photoServerLabel, this.photoServerKey);
    }

    public GroupV2.Identifier getGroupIdentifier() {
        return new GroupV2.Identifier(this.groupUid, this.serverUrl, this.category);
    }

    public Identity getPhotoServerIdentity() {
        return this.photoServerIdentity;
    }

    public UID getPhotoServerLabel() {
        return this.photoServerLabel;
    }

    public AuthEncKey getPhotoServerKey() {
        return this.photoServerKey;
    }

    public static ContactGroupV2Details createNew(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedGroupDetails, String absolutePhotoUrl, GroupV2.ServerPhotoInfo serverPhotoInfo) {
        if (groupIdentifier == null || ownedIdentity == null || serializedGroupDetails == null) {
            return null;
        }
        try {
            String photoUrl = null;
            if (absolutePhotoUrl != null) {
                if (serverPhotoInfo == null) {
                    Logger.e("Calling ContactGroupV2Details.createNew with a photoUrl and no label or key");
                    return null;
                }
                try {
                    String randFileName;
                    SecureFile dstPhotoFile;
                    String fileName = "identity_photos" + File.separator + Logger.toHexString(groupIdentifier.groupUid.getBytes());
                    Random random = new Random();
                    while ((dstPhotoFile = new SecureFile(identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
                    }
                    SecureFile srcPhotoFile = new SecureFile(absolutePhotoUrl);
                    try (SecureFileInputStream is = new SecureFileInputStream(srcPhotoFile);
                         SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
                        int length;
                        byte[] buffer = new byte[4096];
                        while ((length = is.read(buffer)) > 0) {
                            ((OutputStream)os).write(buffer, 0, length);
                        }
                    }
                    photoUrl = randFileName;
                }
                catch (IOException e) {
                    Logger.x(e);
                    Logger.w("Error copying the photo for the groupV2 --> creating a group without photo");
                }
            }
            int version = 0;
            ContactGroupV2Details contactGroupDetails = photoUrl == null ? new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, null, null, null, null) : new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, photoUrl, serverPhotoInfo.serverPhotoIdentity, serverPhotoInfo.serverPhotoLabel, serverPhotoInfo.serverPhotoKey);
            contactGroupDetails.insert();
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupV2Details createJoined(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, String serializedGroupDetails, GroupV2.ServerPhotoInfo serverPhotoInfo) {
        try {
            ContactGroupV2Details contactGroupDetails;
            if (serverPhotoInfo == null) {
                contactGroupDetails = new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, null, null, null, null);
            } else {
                String photoUrl = null;
                for (ContactGroupV2Details otherDetails : ContactGroupV2Details.getAll(identityManagerSession, ownedIdentity, groupIdentifier)) {
                    if (otherDetails.photoUrl == null || !Objects.equals(otherDetails.getServerPhotoInfo(), serverPhotoInfo)) continue;
                    photoUrl = otherDetails.photoUrl;
                    break;
                }
                contactGroupDetails = new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, photoUrl, serverPhotoInfo.serverPhotoIdentity, serverPhotoInfo.serverPhotoLabel, serverPhotoInfo.serverPhotoKey);
            }
            contactGroupDetails.insert();
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupV2Details create(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, String serializedGroupDetails, GroupV2.ServerPhotoInfo serverPhotoInfo) {
        if (groupIdentifier == null || ownedIdentity == null || serializedGroupDetails == null) {
            return null;
        }
        try {
            ContactGroupV2Details contactGroupDetails = serverPhotoInfo == null ? new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, null, null, null, null) : new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, serializedGroupDetails, null, serverPhotoInfo.serverPhotoIdentity, serverPhotoInfo.serverPhotoLabel, serverPhotoInfo.serverPhotoKey);
            contactGroupDetails.insert();
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupV2Details createOrUpdateKeycloak(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedGroupDetails, GroupV2.ServerPhotoInfo serverPhotoInfo) {
        try {
            ContactGroupV2Details contactGroupDetails = ContactGroupV2Details.get(identityManagerSession, ownedIdentity, groupIdentifier, 0);
            if (contactGroupDetails == null) {
                contactGroupDetails = serverPhotoInfo == null ? new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, 0, serializedGroupDetails, null, null, null, null) : new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, 0, serializedGroupDetails, null, serverPhotoInfo.serverPhotoIdentity, serverPhotoInfo.serverPhotoLabel, serverPhotoInfo.serverPhotoKey);
                contactGroupDetails.insert();
            } else {
                contactGroupDetails.serializedJsonDetails = serializedGroupDetails;
                if (serverPhotoInfo != null) {
                    GroupV2.ServerPhotoInfo oldServerPhotoInfo;
                    if (contactGroupDetails.photoUrl != null && !Objects.equals(oldServerPhotoInfo = new GroupV2.ServerPhotoInfo(contactGroupDetails.photoServerIdentity, contactGroupDetails.photoServerLabel, contactGroupDetails.photoServerKey), serverPhotoInfo)) {
                        contactGroupDetails.photoUrl = null;
                    }
                    contactGroupDetails.photoServerIdentity = serverPhotoInfo.serverPhotoIdentity;
                    contactGroupDetails.photoServerLabel = serverPhotoInfo.serverPhotoLabel;
                    contactGroupDetails.photoServerKey = serverPhotoInfo.serverPhotoKey;
                } else {
                    contactGroupDetails.photoUrl = null;
                    contactGroupDetails.photoServerIdentity = null;
                    contactGroupDetails.photoServerLabel = null;
                    contactGroupDetails.photoServerKey = null;
                }
                contactGroupDetails.update();
            }
            return contactGroupDetails;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactGroupV2Details(IdentityManagerSession identityManagerSession, UID groupUid, String serverUrl, int category, Identity ownedIdentity, int version, String serializedJsonDetails, String photoUrl, Identity photoServerIdentity, UID photoServerLabel, AuthEncKey photoServerKey) {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = groupUid;
        this.serverUrl = serverUrl;
        this.category = category;
        this.ownedIdentity = ownedIdentity;
        this.version = version;
        this.serializedJsonDetails = serializedJsonDetails;
        this.photoUrl = photoUrl;
        this.photoServerIdentity = photoServerIdentity;
        this.photoServerLabel = photoServerLabel;
        this.photoServerKey = photoServerKey;
    }

    private ContactGroupV2Details(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = new UID(res.getBytes(GROUP_UID));
        this.serverUrl = res.getString(SERVER_URL);
        this.category = res.getInt(CATEGORY);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.version = res.getInt(VERSION);
        this.serializedJsonDetails = res.getString(SERIALIZED_JSON_DETAILS);
        this.photoUrl = res.getString(PHOTO_URL);
        byte[] bytes = res.getBytes(PHOTO_SERVER_IDENTITY);
        if (bytes == null) {
            this.photoServerIdentity = null;
        } else {
            try {
                this.photoServerIdentity = Identity.of(bytes);
            }
            catch (DecodingException e) {
                this.photoServerIdentity = null;
            }
        }
        bytes = res.getBytes(PHOTO_SERVER_LABEL);
        this.photoServerLabel = bytes == null ? null : new UID(bytes);
        bytes = res.getBytes(PHOTO_SERVER_KEY);
        if (bytes == null) {
            this.photoServerKey = null;
        } else {
            try {
                this.photoServerKey = (AuthEncKey)new Encoded(bytes).decodeSymmetricKey();
            }
            catch (DecodingException e) {
                this.photoServerKey = null;
            }
        }
    }

    public static ContactGroupV2Details get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version) throws SQLException {
        if (groupIdentifier == null || ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.get", "SELECT * FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version = ?;");){
            ContactGroupV2Details contactGroupV2Details;
            block17: {
                ResultSet res;
                block15: {
                    ContactGroupV2Details contactGroupV2Details2;
                    block16: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        statement.setInt(5, version);
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactGroupV2Details2 = new ContactGroupV2Details(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroupV2Details2;
                }
                contactGroupV2Details = null;
                if (res == null) break block17;
                res.close();
            }
            return contactGroupV2Details;
        }
    }

    public static List<ContactGroupV2Details> getAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (groupIdentifier == null || ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.getAll", "SELECT * FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            ArrayList<ContactGroupV2Details> arrayList;
            block14: {
                statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                statement.setString(2, groupIdentifier.serverUrl);
                statement.setInt(3, groupIdentifier.category);
                statement.setBytes(4, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2Details> list = new ArrayList<ContactGroupV2Details>();
                    while (res.next()) {
                        list.add(new ContactGroupV2Details(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public void setPhotoUrl(String photoUrl) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2Details.setPhotoUrl", "UPDATE contact_group_v2_details SET photo_url = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, photoUrl);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setInt(6, this.version);
            statement.executeUpdate();
            this.photoUrl = photoUrl;
        }
    }

    public void setAbsolutePhotoUrl(String absolutePhotoUrl) throws Exception {
        String randFileName;
        SecureFile dstPhotoFile;
        String fileName = "identity_photos" + File.separator + Logger.toHexString(this.groupUid.getBytes());
        Random random = new Random();
        while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
        }
        SecureFile srcPhotoFile = new SecureFile(absolutePhotoUrl);
        try (SecureFileInputStream is = new SecureFileInputStream(srcPhotoFile);
             SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
            int length;
            byte[] buffer = new byte[4096];
            while ((length = is.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        this.photoUrl = randFileName;
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2Details.setAbsolutePhotoUrl", "UPDATE contact_group_v2_details SET photo_url = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, this.photoUrl);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.setInt(6, this.version);
            statement.executeUpdate();
        }
    }

    public static void cleanup(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, int trustedVersion) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.cleanup", "DELETE FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version NOT IN (?,?);");){
            statement.setBytes(1, groupIdentifier.groupUid.getBytes());
            statement.setString(2, groupIdentifier.serverUrl);
            statement.setInt(3, groupIdentifier.category);
            statement.setBytes(4, ownedIdentity.getBytes());
            statement.setInt(5, version);
            statement.setInt(6, trustedVersion);
            statement.executeUpdate();
        }
    }

    public static List<ContactGroupV2Details> getByGroupIdentifierAndServerPhotoInfo(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, GroupV2.ServerPhotoInfo serverPhotoInfo) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || serverPhotoInfo == null) {
            return null;
        }
        if (groupIdentifier.category == 1) {
            try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.getByGroupIdentifierAndServerPhotoInfo", "SELECT * FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND photo_server_identity IS NULL  AND photo_server_label = ?;");){
                Object contactGroupV2Details2;
                block28: {
                    statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                    statement.setString(2, groupIdentifier.serverUrl);
                    statement.setInt(3, groupIdentifier.category);
                    statement.setBytes(4, ownedIdentity.getBytes());
                    statement.setBytes(5, serverPhotoInfo.serverPhotoLabel.getBytes());
                    ResultSet res = statement.executeQuery();
                    try {
                        ArrayList<Object> list = new ArrayList<Object>();
                        while (res.next()) {
                            contactGroupV2Details2 = new ContactGroupV2Details(identityManagerSession, res);
                            if (!Objects.equals(((ContactGroupV2Details)contactGroupV2Details2).photoServerKey, serverPhotoInfo.serverPhotoKey)) continue;
                            list.add(contactGroupV2Details2);
                        }
                        contactGroupV2Details2 = list;
                        if (res == null) break block28;
                    }
                    catch (Throwable list) {
                        if (res != null) {
                            try {
                                res.close();
                            }
                            catch (Throwable contactGroupV2Details2) {
                                list.addSuppressed(contactGroupV2Details2);
                            }
                        }
                        throw list;
                    }
                    res.close();
                }
                return contactGroupV2Details2;
            }
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.getByGroupIdentifierAndServerPhotoInfo", "SELECT * FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND photo_server_identity = ?  AND photo_server_label = ?;");){
            ArrayList<ContactGroupV2Details> arrayList;
            block29: {
                statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                statement.setString(2, groupIdentifier.serverUrl);
                statement.setInt(3, groupIdentifier.category);
                statement.setBytes(4, ownedIdentity.getBytes());
                statement.setBytes(5, serverPhotoInfo.serverPhotoIdentity.getBytes());
                statement.setBytes(6, serverPhotoInfo.serverPhotoLabel.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2Details> list = new ArrayList<ContactGroupV2Details>();
                    while (res.next()) {
                        ContactGroupV2Details contactGroupV2Details = new ContactGroupV2Details(identityManagerSession, res);
                        if (!Objects.equals(contactGroupV2Details.photoServerKey, serverPhotoInfo.serverPhotoKey)) continue;
                        list.add(contactGroupV2Details);
                    }
                    arrayList = list;
                    if (res == null) break block29;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<String> getAllPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.getAllPhotoUrl", "SELECT photo_url FROM contact_group_v2_details WHERE photo_url IS NOT NULL;");){
            ArrayList<String> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (res.next()) {
                        list.add(res.getString(PHOTO_URL));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupV2Details> getAllWithMissingPhotoUrl(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2Details.getAllWithMissingPhotoUrl", "SELECT * FROM contact_group_v2_details WHERE photo_url IS NULL  AND (photo_server_identity IS NOT NULL OR category = 1)  AND photo_server_key IS NOT NULL  AND photo_server_label IS NOT NULL;");){
            ArrayList<ContactGroupV2Details> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2Details> list = new ArrayList<ContactGroupV2Details>();
                    while (res.next()) {
                        list.add(new ContactGroupV2Details(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group_v2_details (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, version INT NOT NULL, serialized_json_details TEXT NOT NULL, photo_url TEXT, photo_server_identity BLOB, photo_server_label BLOB, photo_server_key BLOB,  CONSTRAINT PK_contact_group_v2_details PRIMARY KEY(group_uid, server_url, category, owned_identity, version) );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        if (oldVersion < 32 && newVersion >= 32) {
            try (Statement statement = session.createStatement();){
                Logger.d("CREATING contact_group_v2_details DATABASE FOR VERSION 32");
                statement.execute("CREATE TABLE contact_group_v2_details (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, version INT NOT NULL, serialized_json_details TEXT NOT NULL, photo_url TEXT, photo_server_identity BLOB, photo_server_label BLOB, photo_server_key BLOB,  CONSTRAINT PK_contact_group_v2_details PRIMARY KEY(group_uid, server_url, category, owned_identity, version) );");
            }
            oldVersion = 32;
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2Details.insert", "INSERT INTO contact_group_v2_details VALUES (?,?,?,?,?, ?,?,?,?,?);");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setInt(5, this.version);
            statement.setString(6, this.serializedJsonDetails);
            statement.setString(7, this.photoUrl);
            statement.setBytes(8, this.photoServerIdentity == null ? null : this.photoServerIdentity.getBytes());
            statement.setBytes(9, this.photoServerLabel == null ? null : this.photoServerLabel.getBytes());
            statement.setBytes(10, this.photoServerKey == null ? null : Encoded.of(this.photoServerKey).getBytes());
            statement.executeUpdate();
        }
    }

    public void update() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2Details.update", "UPDATE contact_group_v2_details SET serialized_json_details = ?, photo_url = ?, photo_server_identity = ?, photo_server_label = ?, photo_server_key = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setString(1, this.serializedJsonDetails);
            statement.setString(2, this.photoUrl);
            statement.setBytes(3, this.photoServerIdentity == null ? null : this.photoServerIdentity.getBytes());
            statement.setBytes(4, this.photoServerLabel == null ? null : this.photoServerLabel.getBytes());
            statement.setBytes(5, this.photoServerKey == null ? null : Encoded.of(this.photoServerKey).getBytes());
            statement.setBytes(6, this.groupUid.getBytes());
            statement.setString(7, this.serverUrl);
            statement.setInt(8, this.category);
            statement.setBytes(9, this.ownedIdentity.getBytes());
            statement.setInt(10, this.version);
            statement.executeUpdate();
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2Details.delete", "DELETE FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND version = ?;");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setInt(5, this.version);
            statement.executeUpdate();
        }
    }

    @Override
    public void wasCommitted() {
    }

    Pojo_0 backup() {
        Pojo_0 pojo = new Pojo_0();
        pojo.serialized_details = this.serializedJsonDetails;
        if (this.photoServerLabel != null && this.photoServerKey != null) {
            pojo.photo_server_identity = this.photoServerIdentity == null ? null : this.photoServerIdentity.getBytes();
            pojo.photo_server_label = this.photoServerLabel.getBytes();
            pojo.photo_server_key = Encoded.of(this.photoServerKey).getBytes();
        }
        return pojo;
    }

    static void restore(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, Pojo_0 pojo) throws SQLException {
        ContactGroupV2Details contactGroupV2Details = null;
        if (pojo.photo_server_label != null && pojo.photo_server_key != null) {
            try {
                Identity photoServerIdentity = pojo.photo_server_identity == null ? null : Identity.of(pojo.photo_server_identity);
                UID photoServerLabel = new UID(pojo.photo_server_label);
                AuthEncKey photoServerKey = (AuthEncKey)new Encoded(pojo.photo_server_key).decodeSymmetricKey();
                contactGroupV2Details = new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, pojo.serialized_details, null, photoServerIdentity, photoServerLabel, photoServerKey);
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        if (contactGroupV2Details == null) {
            contactGroupV2Details = new ContactGroupV2Details(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, version, pojo.serialized_details, null, null, null, null);
        }
        contactGroupV2Details.insert();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public String serialized_details;
        public byte[] photo_server_identity;
        public byte[] photo_server_label;
        public byte[] photo_server_key;
    }
}

