/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.KeycloakGroupV2UpdateOutput;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.identity.databases.ContactGroupV2Details;
import io.olvid.engine.identity.databases.ContactGroupV2Member;
import io.olvid.engine.identity.databases.ContactGroupV2PendingMember;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.identity.datatypes.KeycloakGroupBlob;
import io.olvid.engine.identity.datatypes.KeycloakGroupMemberAndPermissions;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.SecureFileOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;

public class ContactGroupV2
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group_v2";
    private final IdentityManagerSession identityManagerSession;
    private final UID groupUid;
    static final String GROUP_UID = "group_uid";
    private final String serverUrl;
    static final String SERVER_URL = "server_url";
    private final int category;
    static final String CATEGORY = "category";
    private final Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private byte[] serializedOwnPermissions;
    static final String SERIALIZED_OWN_PERMISSIONS = "serialized_own_permissions";
    private int version;
    static final String VERSION = "version";
    public int trustedDetailsVersion;
    static final String TRUSTED_DETAILS_VERSION = "trusted_details_version";
    private byte[] verifiedAdministratorsChain;
    static final String VERIFIED_ADMINISTRATORS_CHAIN = "verified_administrators_chain";
    private Seed blobMainSeed;
    static final String BLOB_MAIN_SEED = "blob_main_seed";
    private Seed blobVersionSeed;
    static final String BLOB_VERSION_SEED = "blob_version_seed";
    private ServerAuthenticationPrivateKey groupAdminServerAuthenticationPrivateKey;
    static final String GROUP_ADMIN_SERVER_AUTHENTICATION_PRIVATE_KEY = "group_admin_server_authentication_private_key";
    private byte[] ownGroupInvitationNonce;
    static final String OWN_GROUP_INVITATION_NONCE = "own_group_invitation_nonce";
    private boolean frozen;
    static final String FROZEN = "frozen";
    private long lastModificationTimestamp;
    static final String LAST_MODIFICATION_TIMESTAMP = "last_modification_timestamp";
    private String pushTopic;
    static final String PUSH_TOPIC = "push_topic";
    private String serializedSharedSettings;
    static final String SERIALIZED_SHARED_SETTINGS = "serialized_shared_settings";
    private String serializedJsonGroupType;
    static final String SERIALIZED_JSON_GROUP_TYPE = "serialized_json_group_type";
    private Integer alreadyTrustedDetailsVersion;
    static final String ALREADY_TRUSTED_DETAILS_VERSION = "already_trusted_details_version";
    private Identity inviterIdentity;
    private Identity deletedBy;
    private UID labelToDelete;
    private boolean updatedByMe;
    private Identity updatedBy;
    private List<Identity> updatedGroupLeavers;
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_INSERTED_AS_NEW = 2L;
    private static final long HOOK_BIT_DELETED = 4L;
    private static final long HOOK_BIT_FROZEN_CHANGED = 8L;
    private static final long HOOK_BIT_UPDATED = 16L;
    private static final long HOOK_BIT_PHOTO_UPDATED = 32L;
    private static final long HOOK_BIT_SERVER_USER_DATA_CAN_BE_DELETED = 64L;
    private static final long HOOK_BIT_NEW_PUSH_TOPIC = 128L;
    private static final long HOOK_BIT_CREATED_ON_OTHER_DEVICE = 256L;

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public GroupV2.Identifier getGroupIdentifier() {
        return new GroupV2.Identifier(this.groupUid, this.serverUrl, this.category);
    }

    public Integer getVersion() {
        return this.version;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public int getTrustedDetailsVersion() {
        return this.trustedDetailsVersion;
    }

    public List<String> getOwnPermissionStrings() {
        return GroupV2.Permission.deserializePermissions(this.serializedOwnPermissions);
    }

    public Seed getBlobMainSeed() {
        return this.blobMainSeed;
    }

    public Seed getBlobVersionSeed() {
        return this.blobVersionSeed;
    }

    public ServerAuthenticationPrivateKey getGroupAdminServerAuthenticationPrivateKey() {
        return this.groupAdminServerAuthenticationPrivateKey;
    }

    public byte[] getOwnGroupInvitationNonce() {
        return this.ownGroupInvitationNonce;
    }

    public byte[] getVerifiedAdministratorsChain() {
        return this.verifiedAdministratorsChain;
    }

    public long getLastModificationTimestamp() {
        return this.lastModificationTimestamp;
    }

    public String getPushTopic() {
        return this.pushTopic;
    }

    public String getSerializedSharedSettings() {
        return this.serializedSharedSettings;
    }

    public String getSerializedJsonGroupType() {
        return this.serializedJsonGroupType;
    }

    public Integer getAlreadyTrustedDetailsVersion() {
        return this.alreadyTrustedDetailsVersion;
    }

    public void setDeletedBy(Identity deletedBy) {
        this.deletedBy = deletedBy;
    }

    public static ContactGroupV2 createNew(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedGroupDetails, String absolutePhotoUrl, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] verifiedAdministratorsChain, GroupV2.BlobKeys blobKeys, byte[] ownGroupInvitationNonce, List<String> ownPermissionStrings, String serializedGroupType) {
        if (groupIdentifier == null || ownedIdentity == null || serializedGroupDetails == null || verifiedAdministratorsChain == null || blobKeys == null || ownGroupInvitationNonce == null) {
            return null;
        }
        try {
            if (!identityManagerSession.session.isInTransaction()) {
                Logger.e("Calling ContactGroupV2.createNew() outside a transaction");
                return null;
            }
            ContactGroupV2Details contactGroupDetails = ContactGroupV2Details.createNew(identityManagerSession, ownedIdentity, groupIdentifier, serializedGroupDetails, absolutePhotoUrl, serverPhotoInfo);
            if (contactGroupDetails == null) {
                Logger.e("Error create contactGroupDetails in ContactGroupV2.createNew()");
                return null;
            }
            byte[] serializedOwnPermissions = GroupV2.Permission.serializePermissionStrings(ownPermissionStrings);
            ContactGroupV2 contactGroup = new ContactGroupV2(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, serializedOwnPermissions, contactGroupDetails.getVersion(), verifiedAdministratorsChain, blobKeys, ownGroupInvitationNonce, true, System.currentTimeMillis(), null, null, serializedGroupType);
            contactGroup.insert();
            contactGroup.commitHookBits |= 0xAL;
            return contactGroup;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupV2 createJoined(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, String serializedGroupDetails, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] verifiedAdministratorsChain, GroupV2.BlobKeys blobKeys, byte[] ownGroupInvitationNonce, List<String> ownPermissionStrings, String serializedGroupType, boolean createdByMeOnOtherDevice, Identity inviterIdentity) {
        if (ownedIdentity == null || groupIdentifier == null || serializedGroupDetails == null || verifiedAdministratorsChain == null || blobKeys == null || ownGroupInvitationNonce == null || ownPermissionStrings == null) {
            return null;
        }
        try {
            if (!identityManagerSession.session.isInTransaction()) {
                Logger.e("Calling ContactGroupV2.createJoined() outside a transaction");
                return null;
            }
            ContactGroupV2Details contactGroupDetails = ContactGroupV2Details.createJoined(identityManagerSession, ownedIdentity, groupIdentifier, version, serializedGroupDetails, serverPhotoInfo);
            if (contactGroupDetails == null) {
                Logger.e("Error create contactGroupDetails in ContactGroupV2.createJoined()");
                return null;
            }
            ContactGroupV2 contactGroup = new ContactGroupV2(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, GroupV2.Permission.serializePermissionStrings(ownPermissionStrings), contactGroupDetails.getVersion(), verifiedAdministratorsChain, blobKeys, ownGroupInvitationNonce, false, System.currentTimeMillis(), null, null, serializedGroupType);
            contactGroup.inviterIdentity = inviterIdentity;
            contactGroup.insert();
            if (createdByMeOnOtherDevice) {
                contactGroup.commitHookBits |= 0x102L;
            }
            return contactGroup;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ContactGroupV2 createKeycloak(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedGroupDetails, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] ownGroupInvitationNonce, List<String> ownPermissionStrings, String pushTopic, String serializedSharedSettings, long lastModificationTimestamp) {
        if (ownedIdentity == null || groupIdentifier == null || serializedGroupDetails == null || ownGroupInvitationNonce == null || ownPermissionStrings == null) {
            return null;
        }
        try {
            if (!identityManagerSession.session.isInTransaction()) {
                Logger.e("Calling ContactGroupV2.createJoined() outside a transaction");
                return null;
            }
            ContactGroupV2Details contactGroupDetails = ContactGroupV2Details.createOrUpdateKeycloak(identityManagerSession, ownedIdentity, groupIdentifier, serializedGroupDetails, serverPhotoInfo);
            if (contactGroupDetails == null) {
                Logger.e("Error create contactGroupDetails in ContactGroupV2.createJoined()");
                return null;
            }
            ContactGroupV2 contactGroup = new ContactGroupV2(identityManagerSession, groupIdentifier.groupUid, groupIdentifier.serverUrl, groupIdentifier.category, ownedIdentity, GroupV2.Permission.serializePermissionStrings(ownPermissionStrings), contactGroupDetails.getVersion(), null, null, ownGroupInvitationNonce, false, lastModificationTimestamp, pushTopic, serializedSharedSettings, null);
            contactGroup.insert();
            if (pushTopic != null) {
                contactGroup.commitHookBits |= 0x80L;
                identityManagerSession.session.addSessionCommitListener(contactGroup);
            }
            return contactGroup;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public ContactGroupV2(IdentityManagerSession identityManagerSession, UID groupUid, String serverUrl, int category, Identity ownedIdentity, byte[] serializedOwnPermission, int version, byte[] verifiedAdministratorsChain, GroupV2.BlobKeys blobKeys, byte[] ownGroupInvitationNonce, boolean frozen, long lastModificationTimestamp, String pushTopic, String serializedSharedSettings, String serializedJsonGroupType) {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = groupUid;
        this.serverUrl = serverUrl;
        this.category = category;
        this.ownedIdentity = ownedIdentity;
        this.serializedOwnPermissions = serializedOwnPermission;
        this.version = version;
        this.trustedDetailsVersion = version;
        this.verifiedAdministratorsChain = verifiedAdministratorsChain;
        if (blobKeys == null) {
            this.blobMainSeed = null;
            this.blobVersionSeed = null;
            this.groupAdminServerAuthenticationPrivateKey = null;
        } else {
            this.blobMainSeed = blobKeys.blobMainSeed;
            this.blobVersionSeed = blobKeys.blobVersionSeed;
            this.groupAdminServerAuthenticationPrivateKey = blobKeys.groupAdminServerAuthenticationPrivateKey;
        }
        this.ownGroupInvitationNonce = ownGroupInvitationNonce;
        this.frozen = frozen;
        this.lastModificationTimestamp = lastModificationTimestamp;
        this.pushTopic = pushTopic;
        this.serializedSharedSettings = serializedSharedSettings;
        this.serializedJsonGroupType = serializedJsonGroupType;
        this.alreadyTrustedDetailsVersion = null;
    }

    private ContactGroupV2(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupUid = new UID(res.getBytes(GROUP_UID));
        this.serverUrl = res.getString(SERVER_URL);
        this.category = res.getInt(CATEGORY);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
        this.serializedOwnPermissions = res.getBytes(SERIALIZED_OWN_PERMISSIONS);
        this.version = res.getInt(VERSION);
        this.trustedDetailsVersion = res.getInt(TRUSTED_DETAILS_VERSION);
        this.verifiedAdministratorsChain = res.getBytes(VERIFIED_ADMINISTRATORS_CHAIN);
        byte[] bytes = res.getBytes(BLOB_MAIN_SEED);
        this.blobMainSeed = bytes == null ? null : new Seed(bytes);
        bytes = res.getBytes(BLOB_VERSION_SEED);
        this.blobVersionSeed = bytes == null ? null : new Seed(bytes);
        bytes = res.getBytes(GROUP_ADMIN_SERVER_AUTHENTICATION_PRIVATE_KEY);
        if (bytes == null) {
            this.groupAdminServerAuthenticationPrivateKey = null;
        } else {
            try {
                this.groupAdminServerAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(bytes).decodePrivateKey();
            }
            catch (DecodingException e) {
                throw new SQLException();
            }
        }
        this.ownGroupInvitationNonce = res.getBytes(OWN_GROUP_INVITATION_NONCE);
        this.frozen = res.getBoolean(FROZEN);
        this.lastModificationTimestamp = res.getLong(LAST_MODIFICATION_TIMESTAMP);
        this.pushTopic = res.getString(PUSH_TOPIC);
        this.serializedSharedSettings = res.getString(SERIALIZED_SHARED_SETTINGS);
        this.serializedJsonGroupType = res.getString(SERIALIZED_JSON_GROUP_TYPE);
        this.alreadyTrustedDetailsVersion = res.getInt(ALREADY_TRUSTED_DETAILS_VERSION);
        if (res.wasNull()) {
            this.alreadyTrustedDetailsVersion = null;
        }
    }

    public static GroupV2.ServerBlob getServerBlob(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        byte[] groupInvitationNonce;
        String serializedDetails;
        byte[] serializedPermissions;
        Identity contactIdentity2;
        ResultSet res;
        GroupV2.AdministratorsChain administratorsChain;
        if (!identityManagerSession.session.isInTransaction()) {
            throw new SQLException("Called ContactGroupV2.getServerBlob outside of a transaction!");
        }
        ContactGroupV2 group = ContactGroupV2.get(identityManagerSession, ownedIdentity, groupIdentifier);
        if (group == null) {
            return null;
        }
        ContactGroupV2Details groupDetails = ContactGroupV2Details.get(identityManagerSession, ownedIdentity, groupIdentifier, group.version);
        if (groupDetails == null) {
            return null;
        }
        try {
            administratorsChain = GroupV2.AdministratorsChain.of(new Encoded(group.verifiedAdministratorsChain));
        }
        catch (DecodingException e) {
            return null;
        }
        String serializedGroupDetails = groupDetails.getSerializedJsonDetails();
        GroupV2.ServerPhotoInfo serverPhotoInfo = groupDetails.getServerPhotoInfo();
        HashSet<GroupV2.IdentityAndPermissionsAndDetails> groupMemberIdentityAndPermissionsAndDetailsList = new HashSet<GroupV2.IdentityAndPermissionsAndDetails>();
        String serializedDetails2 = OwnedIdentity.getSerializedPublishedDetails(identityManagerSession, ownedIdentity);
        GroupV2.IdentityAndPermissionsAndDetails ownDetails = new GroupV2.IdentityAndPermissionsAndDetails(ownedIdentity, group.getOwnPermissionStrings(), serializedDetails2, group.ownGroupInvitationNonce);
        groupMemberIdentityAndPermissionsAndDetailsList.add(ownDetails);
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getServerBlob_members", "SELECT  gm.contact_identity AS ci,  gm.serialized_permissions AS sp,  details.serialized_json_details AS sd,  gm.group_invitation_nonce AS gin  FROM contact_group_v2_member AS gm  INNER JOIN contact_identity AS contact  ON gm.contact_identity = contact.identity AND gm.owned_identity = contact.owned_identity INNER JOIN contact_identity_details AS details  ON details.contact_identity = contact.identity AND details.owned_identity = contact.owned_identity AND details.version = contact.published_details_version WHERE gm.group_uid = ?  AND gm.server_url = ?  AND gm.category = ?  AND gm.owned_identity = ?;");){
            statement.setBytes(1, groupIdentifier.groupUid.getBytes());
            statement.setString(2, groupIdentifier.serverUrl);
            statement.setInt(3, groupIdentifier.category);
            statement.setBytes(4, ownedIdentity.getBytes());
            try {
                res = statement.executeQuery();
                try {
                    while (res.next()) {
                        contactIdentity2 = Identity.of(res.getBytes("ci"));
                        serializedPermissions = res.getBytes("sp");
                        serializedDetails = res.getString("sd");
                        groupInvitationNonce = res.getBytes("gin");
                        groupMemberIdentityAndPermissionsAndDetailsList.add(new GroupV2.IdentityAndPermissionsAndDetails(contactIdentity2, GroupV2.Permission.deserializePermissions(serializedPermissions), serializedDetails, groupInvitationNonce));
                    }
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            catch (DecodingException e) {
                Logger.x(e);
                GroupV2.ServerBlob contactIdentity2 = null;
                if (statement != null) {
                    statement.close();
                }
                return contactIdentity2;
            }
        }
        statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getServerBlob_pendings", "SELECT * FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");
        try {
            statement.setBytes(1, groupIdentifier.groupUid.getBytes());
            statement.setString(2, groupIdentifier.serverUrl);
            statement.setInt(3, groupIdentifier.category);
            statement.setBytes(4, ownedIdentity.getBytes());
            try {
                res = statement.executeQuery();
                try {
                    while (res.next()) {
                        contactIdentity2 = Identity.of(res.getBytes("contact_identity"));
                        serializedPermissions = res.getBytes("serialized_permissions");
                        serializedDetails = res.getString("serialized_contact_details");
                        groupInvitationNonce = res.getBytes("group_invitation_nonce");
                        groupMemberIdentityAndPermissionsAndDetailsList.add(new GroupV2.IdentityAndPermissionsAndDetails(contactIdentity2, GroupV2.Permission.deserializePermissions(serializedPermissions), serializedDetails, groupInvitationNonce));
                    }
                }
                finally {
                    if (res != null) {
                        res.close();
                    }
                }
            }
            catch (DecodingException e) {
                Logger.x(e);
                GroupV2.ServerBlob serverBlob = null;
                if (statement != null) {
                    statement.close();
                }
                return serverBlob;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return new GroupV2.ServerBlob(administratorsChain, groupMemberIdentityAndPermissionsAndDetailsList, group.version, serializedGroupDetails, serverPhotoInfo, group.serializedJsonGroupType);
    }

    public static String getPhotoUrl(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getPhotoUrl", "SELECT det.photo_url AS photo  FROM contact_group_v2 AS g  INNER JOIN contact_group_v2_details AS det  ON g.group_uid = det.group_uid AND g.server_url = det.server_url AND g.category = det.category AND g.owned_identity = det.owned_identity AND g.version = det.version WHERE g.group_uid = ?  AND g.server_url = ?  AND g.category = ?  AND g.owned_identity = ?;");){
            String string;
            block16: {
                ResultSet res;
                block14: {
                    String string2;
                    block15: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            string2 = res.getString("photo");
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return string2;
                }
                string = null;
                if (res == null) break block16;
                res.close();
            }
            return string;
        }
    }

    public static Long getLastModificationTimestamp(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getLastModificationTimestamp", "SELECT last_modification_timestamp FROM contact_group_v2 WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            Long l;
            block16: {
                ResultSet res;
                block14: {
                    Long l2;
                    block15: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            l2 = res.getLong(LAST_MODIFICATION_TIMESTAMP);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return l2;
                }
                l = null;
                if (res == null) break block16;
                res.close();
            }
            return l;
        }
    }

    public static GroupV2.ServerPhotoInfo getServerPhotoInfo(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getServerPhotoInfo", "SELECT  det.photo_server_identity AS ident,  det.photo_server_label AS label,  det.photo_server_key AS key  FROM contact_group_v2 AS g  INNER JOIN contact_group_v2_details AS det  ON g.group_uid = det.group_uid AND g.server_url = det.server_url AND g.category = det.category AND g.owned_identity = det.owned_identity AND g.version = det.version WHERE g.group_uid = ?  AND g.server_url = ?  AND g.category = ?  AND g.owned_identity = ?;");){
            GroupV2.ServerPhotoInfo serverPhotoInfo;
            block24: {
                ResultSet res;
                block22: {
                    GroupV2.ServerPhotoInfo serverPhotoInfo2;
                    block23: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            AuthEncKey photoServerKey;
                            Identity photoServerIdentity;
                            if (!res.next()) break block22;
                            byte[] bytes = res.getBytes("ident");
                            if (bytes == null) {
                                photoServerIdentity = null;
                            } else {
                                try {
                                    photoServerIdentity = Identity.of(bytes);
                                }
                                catch (DecodingException e) {
                                    photoServerIdentity = null;
                                }
                            }
                            bytes = res.getBytes("label");
                            UID photoServerLabel = bytes == null ? null : new UID(bytes);
                            bytes = res.getBytes("key");
                            if (bytes == null) {
                                photoServerKey = null;
                            } else {
                                try {
                                    photoServerKey = (AuthEncKey)new Encoded(bytes).decodeSymmetricKey();
                                }
                                catch (DecodingException e) {
                                    photoServerKey = null;
                                }
                            }
                            if (photoServerIdentity == null || photoServerLabel == null || photoServerKey == null) break block22;
                            serverPhotoInfo2 = new GroupV2.ServerPhotoInfo(photoServerIdentity, photoServerLabel, photoServerKey);
                            if (res == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return serverPhotoInfo2;
                }
                serverPhotoInfo = null;
                if (res == null) break block24;
                res.close();
            }
            return serverPhotoInfo;
        }
    }

    public void setDownloadedPhotoUrl(Identity ownedIdentity, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] photo) throws Exception {
        String randFileName;
        SecureFile dstPhotoFile;
        List<ContactGroupV2Details> detailsList = ContactGroupV2Details.getByGroupIdentifierAndServerPhotoInfo(this.identityManagerSession, ownedIdentity, this.getGroupIdentifier(), serverPhotoInfo);
        if (detailsList.isEmpty()) {
            return;
        }
        String fileName = "identity_photos" + File.separator + Logger.toHexString(this.groupUid.getBytes());
        Random random = new Random();
        while ((dstPhotoFile = new SecureFile(this.identityManagerSession.engineBaseDirectory, randFileName = fileName + "_" + random.nextInt(65536))).exists()) {
        }
        try (SecureFileOutputStream os = new SecureFileOutputStream(dstPhotoFile);){
            ((OutputStream)os).write(photo, 0, photo.length);
        }
        for (ContactGroupV2Details details : detailsList) {
            details.setPhotoUrl(randFileName);
        }
        this.commitHookBits |= 0x20L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    public static HashSet<GroupV2.IdentityAndPermissions> getGroupV2OtherMembersAndPermissions(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getGroupV2OtherMembersAndPermissions", " SELECT contact_identity AS id,owned_identity AS oid, serialized_permissions AS perm  FROM contact_group_v2_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  UNION SELECT contact_identity AS id, owned_identity AS oid, serialized_permissions AS perm  FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            HashSet<GroupV2.IdentityAndPermissions> hashSet;
            block14: {
                statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                statement.setString(2, groupIdentifier.serverUrl);
                statement.setInt(3, groupIdentifier.category);
                statement.setBytes(4, ownedIdentity.getBytes());
                statement.setBytes(5, groupIdentifier.groupUid.getBytes());
                statement.setString(6, groupIdentifier.serverUrl);
                statement.setInt(7, groupIdentifier.category);
                statement.setBytes(8, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    HashSet<GroupV2.IdentityAndPermissions> set = new HashSet<GroupV2.IdentityAndPermissions>();
                    while (res.next()) {
                        Identity identity = Identity.of(res.getBytes("id"));
                        HashSet<GroupV2.Permission> permissions = GroupV2.Permission.deserializeKnownPermissions(res.getBytes("perm"));
                        set.add(new GroupV2.IdentityAndPermissions(identity, permissions));
                    }
                    hashSet = set;
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return hashSet;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean getGroupV2HasOtherAdminMember(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getAllKeycloakPushTopics(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        if (ownedIdentity == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllKeycloakPushTopics", " SELECT push_topic AS pt  FROM contact_group_v2 WHERE category = 1 AND owned_identity = ?;");){
            ArrayList<String> arrayList;
            block14: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<String> list = new ArrayList<String>();
                    while (res.next()) {
                        list.add(res.getString("pt"));
                    }
                    arrayList = list;
                    if (res == null) break block14;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupV2> getAllWithPushTopic(IdentityManagerSession identityManagerSession, String pushTopic) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllWithPushTopic", "SELECT * FROM contact_group_v2 WHERE push_topic = ?;");){
            ArrayList<ContactGroupV2> arrayList;
            block13: {
                statement.setString(1, pushTopic);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2> list = new ArrayList<ContactGroupV2>();
                    while (res.next()) {
                        list.add(new ContactGroupV2(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static ContactGroupV2 get(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.get", "SELECT * FROM contact_group_v2 WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            ContactGroupV2 contactGroupV2;
            block17: {
                ResultSet res;
                block15: {
                    ContactGroupV2 contactGroupV22;
                    block16: {
                        statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                        statement.setString(2, groupIdentifier.serverUrl);
                        statement.setInt(3, groupIdentifier.category);
                        statement.setBytes(4, ownedIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block15;
                            contactGroupV22 = new ContactGroupV2(identityManagerSession, res);
                            if (res == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroupV22;
                }
                contactGroupV2 = null;
                if (res == null) break block17;
                res.close();
            }
            return contactGroupV2;
        }
    }

    public static List<ContactGroupV2> getAllForIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllForIdentity", "SELECT * FROM contact_group_v2 WHERE owned_identity = ?;");){
            ArrayList<ContactGroupV2> arrayList;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2> list = new ArrayList<ContactGroupV2>();
                    while (res.next()) {
                        list.add(new ContactGroupV2(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupV2> getAllKeycloakForIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllKeycloakForIdentity", "SELECT * FROM contact_group_v2 WHERE owned_identity = ?  AND category = 1;");){
            ArrayList<ContactGroupV2> arrayList;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2> list = new ArrayList<ContactGroupV2>();
                    while (res.next()) {
                        list.add(new ContactGroupV2(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupV2> getAll(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAll", "SELECT * FROM contact_group_v2;");){
            ArrayList<ContactGroupV2> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2> list = new ArrayList<ContactGroupV2>();
                    while (res.next()) {
                        list.add(new ContactGroupV2(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public static List<ContactGroupV2> getAllKeycloak(IdentityManagerSession identityManagerSession) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllKeycloak", "SELECT * FROM contact_group_v2 WHERE category = 1;");){
            ArrayList<ContactGroupV2> arrayList;
            block13: {
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<ContactGroupV2> list = new ArrayList<ContactGroupV2>();
                    while (res.next()) {
                        list.add(new ContactGroupV2(identityManagerSession, res));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public void setFrozen(boolean frozen) throws SQLException {
        if (this.frozen == frozen) {
            return;
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.setFrozen", "UPDATE contact_group_v2 SET frozen = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            statement.setBoolean(1, frozen);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.frozen = frozen;
            this.commitHookBits |= 8L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setTrustedDetailsVersion(int trustedDetailsVersion) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.setTrustedDetailsVersion", "UPDATE contact_group_v2 SET trusted_details_version = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            statement.setInt(1, trustedDetailsVersion);
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.trustedDetailsVersion = trustedDetailsVersion;
            this.updatedByMe = true;
            this.updatedBy = null;
            this.commitHookBits |= 0x10L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public void setAlreadyTrustedDetailsVersion(Integer alreadyTrustedDetailsVersion) throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.setAlreadyTrustedDetailsVersion", "UPDATE contact_group_v2 SET already_trusted_details_version = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            if (alreadyTrustedDetailsVersion == null) {
                statement.setNull(1, 4);
            } else {
                statement.setInt(1, alreadyTrustedDetailsVersion);
            }
            statement.setBytes(2, this.groupUid.getBytes());
            statement.setString(3, this.serverUrl);
            statement.setInt(4, this.category);
            statement.setBytes(5, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.alreadyTrustedDetailsVersion = alreadyTrustedDetailsVersion;
        }
    }

    public List<Identity> updateWithNewBlob(GroupV2.ServerBlob serverBlob, GroupV2.BlobKeys blobKeys, boolean updatedByMe, Identity updatedBy, List<Identity> leavers) throws SQLException {
        if (!this.identityManagerSession.session.isInTransaction()) {
            throw new SQLException("Calling ContactGroupV2.updateGroupV2WithNewBlob outside a transaction!");
        }
        if (!serverBlob.administratorsChain.integrityWasChecked) {
            return null;
        }
        if (this.version > serverBlob.version) {
            return new ArrayList<Identity>();
        }
        HashMap<Identity, GroupV2.IdentityAndPermissionsAndDetails> groupMembersMap = new HashMap<Identity, GroupV2.IdentityAndPermissionsAndDetails>();
        for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
            groupMembersMap.put(identityAndPermissionsAndDetails.identity, identityAndPermissionsAndDetails);
        }
        GroupV2.IdentityAndPermissionsAndDetails ownIdentityAndPermissionsAndDetails = (GroupV2.IdentityAndPermissionsAndDetails)groupMembersMap.remove(this.ownedIdentity);
        if (ownIdentityAndPermissionsAndDetails == null) {
            return null;
        }
        try {
            if (!serverBlob.administratorsChain.isPrefixedBy(GroupV2.AdministratorsChain.of(new Encoded(this.verifiedAdministratorsChain)))) {
                return null;
            }
        }
        catch (DecodingException e) {
            Logger.x(e);
            return null;
        }
        this.serializedOwnPermissions = GroupV2.Permission.serializePermissionStrings(ownIdentityAndPermissionsAndDetails.permissionStrings);
        this.ownGroupInvitationNonce = ownIdentityAndPermissionsAndDetails.groupInvitationNonce;
        this.verifiedAdministratorsChain = serverBlob.administratorsChain.encode().getBytes();
        this.blobMainSeed = blobKeys.blobMainSeed;
        this.blobVersionSeed = blobKeys.blobVersionSeed;
        this.groupAdminServerAuthenticationPrivateKey = blobKeys.groupAdminServerAuthenticationPrivateKey;
        this.lastModificationTimestamp = System.currentTimeMillis();
        this.serializedJsonGroupType = serverBlob.serializedGroupType;
        if (serverBlob.version - this.version == 1) {
            this.updatedBy = updatedBy;
            this.updatedGroupLeavers = leavers;
        }
        GroupV2.Identifier groupIdentifier = this.getGroupIdentifier();
        ContactGroupV2Details publishedDetails = ContactGroupV2Details.get(this.identityManagerSession, this.ownedIdentity, groupIdentifier, this.version);
        if (serverBlob.version != this.version) {
            ContactGroupV2Details newDetails = ContactGroupV2Details.create(this.identityManagerSession, this.ownedIdentity, groupIdentifier, serverBlob.version, serverBlob.serializedGroupDetails, serverBlob.serverPhotoInfo);
            if (newDetails == null) {
                return null;
            }
            if (serverBlob.serverPhotoInfo != null && serverBlob.serverPhotoInfo.equals(publishedDetails.getServerPhotoInfo()) && publishedDetails.getPhotoUrl() != null) {
                newDetails.setPhotoUrl(publishedDetails.getPhotoUrl());
            } else {
                if (Objects.equals(publishedDetails.getPhotoServerIdentity(), this.ownedIdentity)) {
                    this.labelToDelete = publishedDetails.getPhotoServerLabel();
                    this.commitHookBits |= 0x40L;
                }
                if (Objects.equals(newDetails.getPhotoServerIdentity(), this.ownedIdentity)) {
                    ServerUserData.createForGroupV2(this.identityManagerSession, this.ownedIdentity, newDetails.getPhotoServerLabel(), this.getGroupIdentifier().getBytes());
                }
            }
            this.version = newDetails.getVersion();
            if (this.alreadyTrustedDetailsVersion != null) {
                if (this.version == this.alreadyTrustedDetailsVersion) {
                    this.trustedDetailsVersion = this.alreadyTrustedDetailsVersion;
                    this.alreadyTrustedDetailsVersion = null;
                } else if (this.version > this.alreadyTrustedDetailsVersion) {
                    this.alreadyTrustedDetailsVersion = null;
                }
            }
        }
        this.update();
        this.updatedByMe = updatedByMe;
        this.commitHookBits |= 0x10L;
        this.identityManagerSession.session.addSessionCommitListener(this);
        ContactGroupV2Details.cleanup(this.identityManagerSession, this.ownedIdentity, groupIdentifier, this.version, this.trustedDetailsVersion);
        ArrayList<Identity> membersWithNewInvitationNonce = new ArrayList<Identity>();
        try {
            GroupV2.IdentityAndPermissionsAndDetails newPermissionsAndDetails;
            for (ContactGroupV2Member contactGroupV2Member : ContactGroupV2Member.getAll(this.identityManagerSession, this.ownedIdentity, groupIdentifier)) {
                newPermissionsAndDetails = (GroupV2.IdentityAndPermissionsAndDetails)groupMembersMap.get(contactGroupV2Member.getContactIdentity());
                if (newPermissionsAndDetails == null) {
                    contactGroupV2Member.delete();
                    continue;
                }
                if (!Arrays.equals(contactGroupV2Member.getGroupInvitationNonce(), newPermissionsAndDetails.groupInvitationNonce)) {
                    contactGroupV2Member.delete();
                    continue;
                }
                groupMembersMap.remove(contactGroupV2Member.getContactIdentity());
                if (new HashSet<String>(GroupV2.Permission.deserializePermissions(contactGroupV2Member.getSerializedPermissions())).equals(new HashSet<String>(newPermissionsAndDetails.permissionStrings))) continue;
                contactGroupV2Member.setPermissions(newPermissionsAndDetails.permissionStrings);
            }
            for (ContactGroupV2PendingMember contactGroupV2PendingMember : ContactGroupV2PendingMember.getAll(this.identityManagerSession, this.ownedIdentity, groupIdentifier)) {
                newPermissionsAndDetails = (GroupV2.IdentityAndPermissionsAndDetails)groupMembersMap.remove(contactGroupV2PendingMember.getContactIdentity());
                if (newPermissionsAndDetails == null) {
                    contactGroupV2PendingMember.delete();
                    continue;
                }
                if (!new HashSet<String>(GroupV2.Permission.deserializePermissions(contactGroupV2PendingMember.getSerializedPermissions())).equals(new HashSet<String>(newPermissionsAndDetails.permissionStrings))) {
                    contactGroupV2PendingMember.setPermissions(newPermissionsAndDetails.permissionStrings);
                }
                if (!Arrays.equals(contactGroupV2PendingMember.getGroupInvitationNonce(), newPermissionsAndDetails.groupInvitationNonce)) {
                    contactGroupV2PendingMember.setGroupInvitationNonce(newPermissionsAndDetails.groupInvitationNonce);
                    membersWithNewInvitationNonce.add(contactGroupV2PendingMember.getContactIdentity());
                }
                if (contactGroupV2PendingMember.getSerializedContactDetails().equals(newPermissionsAndDetails.serializedIdentityDetails)) continue;
                contactGroupV2PendingMember.setSerializedContactDetails(newPermissionsAndDetails.serializedIdentityDetails);
            }
            for (GroupV2.IdentityAndPermissionsAndDetails pendingGroupMember : groupMembersMap.values()) {
                membersWithNewInvitationNonce.add(pendingGroupMember.identity);
                ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.create(this.identityManagerSession, this.ownedIdentity, groupIdentifier, pendingGroupMember.identity, pendingGroupMember.serializedIdentityDetails, pendingGroupMember.permissionStrings, pendingGroupMember.groupInvitationNonce);
                if (pendingMember != null) continue;
                throw new Exception("Unable to create new ContactGroupV2PendingMember");
            }
        }
        catch (Exception e) {
            Logger.x(e);
            Logger.w("Error while updating group members from new serverBlob");
            return null;
        }
        return membersWithNewInvitationNonce;
    }

    public static List<Identity> getGroupV2MembersAndPendingMembersFromNonce(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, byte[] groupMemberInvitationNonce) throws Exception {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getGroupV2MembersAndPendingMembersFromNonce", " SELECT contact_identity AS id  FROM contact_group_v2_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND group_invitation_nonce = ?  UNION SELECT contact_identity AS id  FROM contact_group_v2_pending_member WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?  AND group_invitation_nonce = ?;");){
            ArrayList<Identity> arrayList;
            block13: {
                statement.setBytes(1, groupIdentifier.groupUid.getBytes());
                statement.setString(2, groupIdentifier.serverUrl);
                statement.setInt(3, groupIdentifier.category);
                statement.setBytes(4, ownedIdentity.getBytes());
                statement.setBytes(5, groupMemberInvitationNonce);
                statement.setBytes(6, groupIdentifier.groupUid.getBytes());
                statement.setString(7, groupIdentifier.serverUrl);
                statement.setInt(8, groupIdentifier.category);
                statement.setBytes(9, ownedIdentity.getBytes());
                statement.setBytes(10, groupMemberInvitationNonce);
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<Identity> list = new ArrayList<Identity>();
                    while (res.next()) {
                        list.add(Identity.of(res.getBytes("id")));
                    }
                    arrayList = list;
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return arrayList;
        }
    }

    public void movePendingMemberToMembers(Identity groupMemberIdentity) throws Exception {
        if (!this.identityManagerSession.session.isInTransaction()) {
            throw new Exception("Called ContactGroupV2.movePendingMemberToMembers outside a transaction");
        }
        ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.get(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier(), groupMemberIdentity);
        if (pendingMember == null) {
            return;
        }
        ContactGroupV2Member member = ContactGroupV2Member.get(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier(), groupMemberIdentity);
        if (member == null) {
            if (this.category != 1) {
                if (!this.identityManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(this.identityManagerSession.session, this.ownedIdentity, groupMemberIdentity)) {
                    this.identityManagerSession.identityDelegate.addContactIdentity(this.identityManagerSession.session, groupMemberIdentity, pendingMember.getSerializedContactDetails(), this.ownedIdentity, TrustOrigin.createServerGroupV2TrustOrigin(System.currentTimeMillis(), this.getGroupIdentifier()), false);
                } else {
                    this.identityManagerSession.identityDelegate.addTrustOriginToContact(this.identityManagerSession.session, groupMemberIdentity, this.ownedIdentity, TrustOrigin.createServerGroupV2TrustOrigin(System.currentTimeMillis(), this.getGroupIdentifier()), false);
                }
            } else if (!this.identityManagerSession.identityDelegate.isIdentityAContactOfOwnedIdentity(this.identityManagerSession.session, this.ownedIdentity, groupMemberIdentity)) {
                this.identityManagerSession.identityDelegate.addContactIdentity(this.identityManagerSession.session, groupMemberIdentity, pendingMember.getSerializedContactDetails(), this.ownedIdentity, TrustOrigin.createKeycloakTrustOrigin(System.currentTimeMillis(), this.serverUrl), false);
            }
            if (this.category != 1 || this.identityManagerSession.identityDelegate.isContactIdentityCertifiedByOwnKeycloak(this.identityManagerSession.session, this.ownedIdentity, groupMemberIdentity)) {
                member = ContactGroupV2Member.create(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier(), groupMemberIdentity, GroupV2.Permission.deserializePermissions(pendingMember.getSerializedPermissions()), pendingMember.getGroupInvitationNonce());
                if (member == null) {
                    throw new Exception("In ContactGroupV2.movePendingMemberToMembers, failed to create ContactGroupV2Member");
                }
                pendingMember.delete();
            }
        } else {
            pendingMember.delete();
        }
        this.updatedByMe = false;
        this.updatedBy = null;
        this.commitHookBits |= 0x10L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    public static GroupV2.IdentifierVersionAndKeys[] getServerGroupsV2IdentifierVersionAndKeysForContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getServerGroupsV2IdentifierVersionAndKeysForContact", "SELECT * FROM (SELECT group_uid AS uid, server_url AS url, serialized_permissions AS perms  FROM contact_group_v2_member WHERE category = 0 AND owned_identity = ?  AND contact_identity = ?  UNION SELECT group_uid AS uid, server_url AS url, serialized_permissions AS perms  FROM contact_group_v2_pending_member WHERE category = 0 AND owned_identity = ?  AND contact_identity = ?) AS gmj  INNER JOIN contact_group_v2 AS gr  ON gmj.uid = gr.group_uid AND gmj.url = gr.server_url AND gr.category = 0 AND gr.owned_identity = ?;");){
            GroupV2.IdentifierVersionAndKeys[] identifierVersionAndKeysArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                statement.setBytes(3, ownedIdentity.getBytes());
                statement.setBytes(4, contactIdentity.getBytes());
                statement.setBytes(5, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<GroupV2.IdentifierVersionAndKeys> list = new ArrayList<GroupV2.IdentifierVersionAndKeys>();
                    while (res.next()) {
                        byte[] bytesGroupAdminKey;
                        byte[] groupUid = res.getBytes("uid");
                        String serverUrl = res.getString("url");
                        byte[] serializedContactPermissions = res.getBytes("perms");
                        int version = res.getInt(VERSION);
                        byte[] bytesMainSeed = res.getBytes(BLOB_MAIN_SEED);
                        byte[] bytesVersionSeed = res.getBytes(BLOB_VERSION_SEED);
                        ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = null;
                        if (GroupV2.Permission.deserializeKnownPermissions(serializedContactPermissions).contains((Object)GroupV2.Permission.GROUP_ADMIN) && (bytesGroupAdminKey = res.getBytes(GROUP_ADMIN_SERVER_AUTHENTICATION_PRIVATE_KEY)) != null) {
                            try {
                                serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(bytesGroupAdminKey).decodePrivateKey();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        GroupV2.BlobKeys blobKeys = new GroupV2.BlobKeys(new Seed(bytesMainSeed), new Seed(bytesVersionSeed), serverAuthenticationPrivateKey);
                        list.add(new GroupV2.IdentifierVersionAndKeys(new GroupV2.Identifier(new UID(groupUid), serverUrl, 0), version, blobKeys));
                    }
                    identifierVersionAndKeysArray = list.toArray(new GroupV2.IdentifierVersionAndKeys[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identifierVersionAndKeysArray;
        }
    }

    public static GroupV2.IdentifierVersionAndKeys[] getAllServerGroupsV2IdentifierVersionAndKeys(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getAllServerGroupsV2IdentifierVersionAndKeys", "SELECT * FROM contact_group_v2 WHERE category = 0 AND owned_identity = ?;");){
            GroupV2.IdentifierVersionAndKeys[] identifierVersionAndKeysArray;
            block16: {
                statement.setBytes(1, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<GroupV2.IdentifierVersionAndKeys> list = new ArrayList<GroupV2.IdentifierVersionAndKeys>();
                    while (res.next()) {
                        byte[] groupUid = res.getBytes(GROUP_UID);
                        String serverUrl = res.getString(SERVER_URL);
                        int version = res.getInt(VERSION);
                        byte[] bytesMainSeed = res.getBytes(BLOB_MAIN_SEED);
                        byte[] bytesVersionSeed = res.getBytes(BLOB_VERSION_SEED);
                        ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = null;
                        byte[] bytesGroupAdminKey = res.getBytes(GROUP_ADMIN_SERVER_AUTHENTICATION_PRIVATE_KEY);
                        if (bytesGroupAdminKey != null) {
                            try {
                                serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(bytesGroupAdminKey).decodePrivateKey();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        GroupV2.BlobKeys blobKeys = new GroupV2.BlobKeys(new Seed(bytesMainSeed), new Seed(bytesVersionSeed), serverAuthenticationPrivateKey);
                        list.add(new GroupV2.IdentifierVersionAndKeys(new GroupV2.Identifier(new UID(groupUid), serverUrl, 0), version, blobKeys));
                    }
                    identifierVersionAndKeysArray = list.toArray(new GroupV2.IdentifierVersionAndKeys[0]);
                    if (res == null) break block16;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identifierVersionAndKeysArray;
        }
    }

    public static GroupV2.IdentifierAndAdminStatus[] getServerGroupsV2IdentifierAndMyAdminStatusForContact(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupV2.getServerGroupsV2IdentifierAndMyAdminStatusForContact", "SELECT * FROM (SELECT group_uid AS uid, server_url AS url  FROM contact_group_v2_member WHERE category = 0 AND owned_identity = ?  AND contact_identity = ?  UNION SELECT group_uid AS uid, server_url AS url  FROM contact_group_v2_pending_member WHERE category = 0 AND owned_identity = ?  AND contact_identity = ?) AS gmj  INNER JOIN contact_group_v2 AS gr  ON gmj.uid = gr.group_uid AND gmj.url = gr.server_url AND gr.category = 0 AND gr.owned_identity = ?;");){
            GroupV2.IdentifierAndAdminStatus[] identifierAndAdminStatusArray;
            block13: {
                statement.setBytes(1, ownedIdentity.getBytes());
                statement.setBytes(2, contactIdentity.getBytes());
                statement.setBytes(3, ownedIdentity.getBytes());
                statement.setBytes(4, contactIdentity.getBytes());
                statement.setBytes(5, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<GroupV2.IdentifierAndAdminStatus> list = new ArrayList<GroupV2.IdentifierAndAdminStatus>();
                    while (res.next()) {
                        byte[] groupUid = res.getBytes("uid");
                        String serverUld = res.getString("url");
                        byte[] serializedOwnPermissions = res.getBytes(SERIALIZED_OWN_PERMISSIONS);
                        list.add(new GroupV2.IdentifierAndAdminStatus(new GroupV2.Identifier(new UID(groupUid), serverUld, 0), GroupV2.Permission.deserializeKnownPermissions(serializedOwnPermissions).contains((Object)GroupV2.Permission.GROUP_ADMIN)));
                    }
                    identifierAndAdminStatusArray = list.toArray(new GroupV2.IdentifierAndAdminStatus[0]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identifierAndAdminStatusArray;
        }
    }

    public KeycloakGroupV2UpdateOutput updateWithNewKeycloakBlob(KeycloakGroupBlob keycloakGroupBlob, ObjectMapper jsonObjectMapper) throws Exception {
        ContactGroupV2Details updatedDetails;
        GroupV2.Identifier groupIdentifier = this.getGroupIdentifier();
        HashMap<Identity, KeycloakGroupMemberAndPermissions> groupMembersMap = new HashMap<Identity, KeycloakGroupMemberAndPermissions>();
        for (KeycloakGroupMemberAndPermissions groupMemberAndPermissions : keycloakGroupBlob.groupMembersAndPermissions) {
            Identity memberIdentity = Identity.of(groupMemberAndPermissions.identity);
            groupMembersMap.put(memberIdentity, groupMemberAndPermissions);
        }
        KeycloakGroupMemberAndPermissions ownKeycloakGroupMemberAndPermissions = (KeycloakGroupMemberAndPermissions)groupMembersMap.remove(this.ownedIdentity);
        if (ownKeycloakGroupMemberAndPermissions == null) {
            return null;
        }
        this.ownGroupInvitationNonce = ownKeycloakGroupMemberAndPermissions.groupInvitationNonce;
        this.serializedOwnPermissions = GroupV2.Permission.serializePermissionStrings(ownKeycloakGroupMemberAndPermissions.permissions);
        this.lastModificationTimestamp = keycloakGroupBlob.timestamp;
        if (!Objects.equals(this.pushTopic, keycloakGroupBlob.pushTopic)) {
            this.pushTopic = keycloakGroupBlob.pushTopic;
            this.commitHookBits |= 0x80L;
        }
        if (!Objects.equals(this.serializedSharedSettings, keycloakGroupBlob.serializedSharedSettings)) {
            this.serializedSharedSettings = keycloakGroupBlob.serializedSharedSettings;
            this.identityManagerSession.session.addSessionCommitListener(() -> {
                HashMap<String, Object> userInfo = new HashMap<String, Object>();
                userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
                userInfo.put("group_identifier", groupIdentifier);
                userInfo.put(SERIALIZED_SHARED_SETTINGS, keycloakGroupBlob.serializedSharedSettings);
                userInfo.put("timestamp", keycloakGroupBlob.timestamp);
                this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_keycloak_group_v_2_shared_settings", userInfo);
            });
        }
        this.update();
        GroupV2.ServerPhotoInfo serverPhotoInfo = null;
        if (keycloakGroupBlob.photoUid != null && keycloakGroupBlob.encodedPhotoKey != null) {
            try {
                UID photoUid = new UID(keycloakGroupBlob.photoUid);
                AuthEncKey photoKey = (AuthEncKey)new Encoded(keycloakGroupBlob.encodedPhotoKey).decodeSymmetricKey();
                serverPhotoInfo = new GroupV2.ServerPhotoInfo(null, photoUid, photoKey);
            }
            catch (Exception photoUid) {
                // empty catch block
            }
        }
        if ((updatedDetails = ContactGroupV2Details.createOrUpdateKeycloak(this.identityManagerSession, this.ownedIdentity, groupIdentifier, jsonObjectMapper.writeValueAsString((Object)keycloakGroupBlob.groupDetails), serverPhotoInfo)) == null) {
            return null;
        }
        boolean photoNeedsToBeDownloaded = serverPhotoInfo != null && updatedDetails.getPhotoUrl() == null;
        ArrayList<Identity> membersWithNewInvitationNonce = new ArrayList<Identity>();
        try {
            for (ContactGroupV2Member contactGroupV2Member : ContactGroupV2Member.getAll(this.identityManagerSession, this.ownedIdentity, groupIdentifier)) {
                KeycloakGroupMemberAndPermissions keycloakGroupMemberAndPermissions = (KeycloakGroupMemberAndPermissions)groupMembersMap.get(contactGroupV2Member.getContactIdentity());
                if (keycloakGroupMemberAndPermissions == null) {
                    contactGroupV2Member.delete();
                    continue;
                }
                if (!Arrays.equals(contactGroupV2Member.getGroupInvitationNonce(), keycloakGroupMemberAndPermissions.groupInvitationNonce)) {
                    contactGroupV2Member.delete();
                    continue;
                }
                groupMembersMap.remove(contactGroupV2Member.getContactIdentity());
                if (Objects.equals(new HashSet<String>(GroupV2.Permission.deserializePermissions(contactGroupV2Member.getSerializedPermissions())), new HashSet<String>(keycloakGroupMemberAndPermissions.permissions))) continue;
                contactGroupV2Member.setPermissions(keycloakGroupMemberAndPermissions.permissions);
            }
            JwtConsumer noVerificationConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
            for (ContactGroupV2PendingMember contactGroupV2PendingMember : ContactGroupV2PendingMember.getAll(this.identityManagerSession, this.ownedIdentity, groupIdentifier)) {
                KeycloakGroupMemberAndPermissions newPermissionsAndDetails = (KeycloakGroupMemberAndPermissions)groupMembersMap.remove(contactGroupV2PendingMember.getContactIdentity());
                if (newPermissionsAndDetails == null) {
                    contactGroupV2PendingMember.delete();
                    continue;
                }
                if (!Objects.equals(new HashSet<String>(GroupV2.Permission.deserializePermissions(contactGroupV2PendingMember.getSerializedPermissions())), new HashSet<String>(newPermissionsAndDetails.permissions))) {
                    contactGroupV2PendingMember.setPermissions(newPermissionsAndDetails.permissions);
                }
                if (!Arrays.equals(contactGroupV2PendingMember.getGroupInvitationNonce(), newPermissionsAndDetails.groupInvitationNonce)) {
                    contactGroupV2PendingMember.setGroupInvitationNonce(newPermissionsAndDetails.groupInvitationNonce);
                    membersWithNewInvitationNonce.add(contactGroupV2PendingMember.getContactIdentity());
                }
                String serializedUnsignedDetails = noVerificationConsumer.processToClaims(newPermissionsAndDetails.signedUserDetails).getRawJson();
                JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)jsonObjectMapper.readValue(serializedUnsignedDetails, JsonKeycloakUserDetails.class);
                JsonIdentityDetails jsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(newPermissionsAndDetails.signedUserDetails);
                String serializedIdentityDetails = jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetails);
                if (contactGroupV2PendingMember.getSerializedContactDetails().equals(serializedIdentityDetails)) continue;
                contactGroupV2PendingMember.setSerializedContactDetails(serializedIdentityDetails);
            }
            for (Map.Entry entry : groupMembersMap.entrySet()) {
                Identity pendingMemberIdentity = (Identity)entry.getKey();
                KeycloakGroupMemberAndPermissions pendingGroupMember = (KeycloakGroupMemberAndPermissions)entry.getValue();
                membersWithNewInvitationNonce.add(pendingMemberIdentity);
                String serializedUnsignedDetails = noVerificationConsumer.processToClaims(pendingGroupMember.signedUserDetails).getRawJson();
                JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)jsonObjectMapper.readValue(serializedUnsignedDetails, JsonKeycloakUserDetails.class);
                JsonIdentityDetails jsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(pendingGroupMember.signedUserDetails);
                String serializedIdentityDetails = jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetails);
                ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.create(this.identityManagerSession, this.ownedIdentity, groupIdentifier, pendingMemberIdentity, serializedIdentityDetails, pendingGroupMember.permissions, pendingGroupMember.groupInvitationNonce);
                if (pendingMember != null) continue;
                throw new Exception("Unable to create new ContactGroupV2PendingMember");
            }
        }
        catch (Exception e) {
            Logger.x(e);
            Logger.w("Error while updating group members from new serverBlob");
            return null;
        }
        this.updatedBy = null;
        this.commitHookBits |= 0x10L;
        this.identityManagerSession.session.addSessionCommitListener(this);
        return new KeycloakGroupV2UpdateOutput(this.ownGroupInvitationNonce, photoNeedsToBeDownloaded, membersWithNewInvitationNonce);
    }

    public static void deleteAllKeycloakGroupsForOwnedIdentity(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        for (ContactGroupV2 contactGroupV2 : ContactGroupV2.getAllKeycloakForIdentity(identityManagerSession, ownedIdentity)) {
            contactGroupV2.delete();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group_v2 (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, serialized_own_permissions BLOB NOT NULL, version INT NOT NULL, trusted_details_version INT NOT NULL, verified_administrators_chain BLOB, blob_main_seed BLOB, blob_version_seed BLOB, group_admin_server_authentication_private_key BLOB, own_group_invitation_nonce BLOB NOT NULL, frozen BIT NOT NULL, last_modification_timestamp INTEGER NOT NULL, push_topic TEXT, serialized_shared_settings TEXT, serialized_json_group_type TEXT, already_trusted_details_version INT,  CONSTRAINT PK_contact_group_v2 PRIMARY KEY(group_uid, server_url, category, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity(identity), FOREIGN KEY (group_uid, server_url, category, owned_identity, version) REFERENCES contact_group_v2_details(group_uid, server_url, category, owned_identity, version), FOREIGN KEY (group_uid, server_url, category, owned_identity, trusted_details_version) REFERENCES contact_group_v2_details(group_uid, server_url, category, owned_identity, version) );");
        }
    }

    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 32 && newVersion >= 32) {
            statement = session.createStatement();
            try {
                Logger.d("CREATING contact_group_v2 DATABASE FOR VERSION 32");
                statement.execute("CREATE TABLE contact_group_v2 (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, serialized_own_permissions BLOB NOT NULL, version INT NOT NULL, trusted_details_version INT NOT NULL, verified_administrators_chain BLOB NOT NULL, blob_main_seed BLOB NOT NULL, blob_version_seed BLOB NOT NULL, group_admin_server_authentication_private_key BLOB, own_group_invitation_nonce BLOB NOT NULL, frozen BIT NOT NULL,  CONSTRAINT PK_contact_group_v2 PRIMARY KEY(group_uid, server_url, category, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity (identity), FOREIGN KEY (group_uid, server_url, category, owned_identity, version) REFERENCES contact_group_v2_details (group_uid, server_url, category, owned_identity, version), FOREIGN KEY (group_uid, server_url, category, owned_identity, trusted_details_version) REFERENCES contact_group_v2_details (group_uid, server_url, category, owned_identity, version) );");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 32;
        }
        if (oldVersion < 34 && newVersion >= 34) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `contact_group_v2` DATABASE FROM VERSION " + oldVersion + " to 34");
                statement.execute("CREATE TABLE contact_group_v2_new (group_uid BLOB NOT NULL, server_url TEXT NOT NULL, category INT NOT NULL, owned_identity BLOB NOT NULL, serialized_own_permissions BLOB NOT NULL, version INT NOT NULL, trusted_details_version INT NOT NULL, verified_administrators_chain BLOB, blob_main_seed BLOB, blob_version_seed BLOB, group_admin_server_authentication_private_key BLOB, own_group_invitation_nonce BLOB NOT NULL, frozen BIT NOT NULL, last_modification_timestamp INTEGER NOT NULL, push_topic TEXT, serialized_shared_settings TEXT,  CONSTRAINT PK_contact_group_v2 PRIMARY KEY(group_uid, server_url, category, owned_identity),  FOREIGN KEY (owned_identity) REFERENCES owned_identity (identity), FOREIGN KEY (group_uid, server_url, category, owned_identity, version) REFERENCES contact_group_v2_details (group_uid, server_url, category, owned_identity, version), FOREIGN KEY (group_uid, server_url, category, owned_identity, trusted_details_version) REFERENCES contact_group_v2_details (group_uid, server_url, category, owned_identity, version) );");
                statement.execute("INSERT INTO contact_group_v2_new  SELECT group_uid, server_url, category, owned_identity, serialized_own_permissions, version, trusted_details_version, verified_administrators_chain, blob_main_seed, blob_version_seed, group_admin_server_authentication_private_key, own_group_invitation_nonce, frozen, 0, NULL, NULL  FROM contact_group_v2");
                statement.execute("DROP TABLE contact_group_v2");
                statement.execute("ALTER TABLE contact_group_v2_new RENAME TO contact_group_v2");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 34;
        }
        if (oldVersion < 35 && newVersion >= 35) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `contact_group_v2` DATABASE FROM VERSION " + oldVersion + " to 35");
                statement.execute("ALTER TABLE contact_group_v2 ADD COLUMN `serialized_json_group_type` TEXT DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (oldVersion < 48 && newVersion >= 48) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING `contact_group_v2` DATABASE FROM VERSION " + oldVersion + " to 48");
                statement.execute("ALTER TABLE contact_group_v2 ADD COLUMN `already_trusted_details_version` INT DEFAULT NULL");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.insert", "INSERT INTO contact_group_v2 VALUES (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?, ?,?,?);");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.setBytes(5, this.serializedOwnPermissions);
            statement.setInt(6, this.version);
            statement.setInt(7, this.trustedDetailsVersion);
            statement.setBytes(8, this.verifiedAdministratorsChain);
            statement.setBytes(9, this.blobMainSeed == null ? null : this.blobMainSeed.getBytes());
            statement.setBytes(10, this.blobVersionSeed == null ? null : this.blobVersionSeed.getBytes());
            statement.setBytes(11, this.groupAdminServerAuthenticationPrivateKey == null ? null : Encoded.of(this.groupAdminServerAuthenticationPrivateKey).getBytes());
            statement.setBytes(12, this.ownGroupInvitationNonce);
            statement.setBoolean(13, this.frozen);
            statement.setLong(14, this.lastModificationTimestamp);
            statement.setString(15, this.pushTopic);
            statement.setString(16, this.serializedSharedSettings);
            statement.setString(17, this.serializedJsonGroupType);
            if (this.alreadyTrustedDetailsVersion == null) {
                statement.setNull(18, 4);
            } else {
                statement.setInt(18, this.alreadyTrustedDetailsVersion);
            }
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        if (!this.identityManagerSession.session.isInTransaction()) {
            Logger.e("Running ContactGroupV2.delete() outside a transaction");
            throw new SQLException();
        }
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.delete", "DELETE FROM contact_group_v2 WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 4L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
        statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.delete", "DELETE FROM contact_group_v2_details WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");
        try {
            statement.setBytes(1, this.groupUid.getBytes());
            statement.setString(2, this.serverUrl);
            statement.setInt(3, this.category);
            statement.setBytes(4, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    private void update() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupV2.update", "UPDATE contact_group_v2 SET serialized_own_permissions = ?, version = ?, trusted_details_version = ?, verified_administrators_chain = ?, blob_main_seed = ?, blob_version_seed = ?, group_admin_server_authentication_private_key = ?, own_group_invitation_nonce = ?, frozen = ?, last_modification_timestamp = ?, push_topic = ?, serialized_shared_settings = ?, serialized_json_group_type = ?, already_trusted_details_version = ?  WHERE group_uid = ?  AND server_url = ?  AND category = ?  AND owned_identity = ?;");){
            statement.setBytes(1, this.serializedOwnPermissions);
            statement.setInt(2, this.version);
            statement.setInt(3, this.trustedDetailsVersion);
            statement.setBytes(4, this.verifiedAdministratorsChain);
            statement.setBytes(5, this.blobVersionSeed == null ? null : this.blobMainSeed.getBytes());
            statement.setBytes(6, this.blobVersionSeed == null ? null : this.blobVersionSeed.getBytes());
            statement.setBytes(7, this.groupAdminServerAuthenticationPrivateKey == null ? null : Encoded.of(this.groupAdminServerAuthenticationPrivateKey).getBytes());
            statement.setBytes(8, this.ownGroupInvitationNonce);
            statement.setBoolean(9, this.frozen);
            statement.setLong(10, this.lastModificationTimestamp);
            statement.setString(11, this.pushTopic);
            statement.setString(12, this.serializedSharedSettings);
            statement.setString(13, this.serializedJsonGroupType);
            if (this.alreadyTrustedDetailsVersion == null) {
                statement.setNull(14, 4);
            } else {
                statement.setInt(14, this.alreadyTrustedDetailsVersion);
            }
            statement.setBytes(15, this.groupUid.getBytes());
            statement.setString(16, this.serverUrl);
            statement.setInt(17, this.category);
            statement.setBytes(18, this.ownedIdentity.getBytes());
            statement.executeUpdate();
        }
    }

    public void triggerUpdateNotification() {
        this.updatedBy = null;
        this.commitHookBits |= 0x10L;
        this.identityManagerSession.session.addSessionCommitListener(this);
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_identifier", this.getGroupIdentifier());
            userInfo.put("created_by_me", (this.commitHookBits & 2L) != 0L);
            userInfo.put("on_other_device", (this.commitHookBits & 0x100L) != 0L);
            if (this.inviterIdentity != null) {
                userInfo.put("created_by", this.inviterIdentity);
            }
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_created", userInfo);
        }
        if ((this.commitHookBits & 4L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_identifier", this.getGroupIdentifier());
            if (this.deletedBy != null) {
                userInfo.put("deleted_by", this.deletedBy);
            }
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_deleted", userInfo);
        }
        if ((this.commitHookBits & 8L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_identifier", this.getGroupIdentifier());
            userInfo.put(FROZEN, this.frozen);
            userInfo.put("new_group", (this.commitHookBits & 2L) != 0L);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_frozen_changed", userInfo);
        }
        if ((this.commitHookBits & 0x10L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_identifier", this.getGroupIdentifier());
            userInfo.put("by_me", this.updatedByMe);
            userInfo.put("by", this.updatedBy);
            userInfo.put("group_leavers", this.updatedGroupLeavers);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_updated", userInfo);
        }
        if ((this.commitHookBits & 0x20L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("group_identifier", this.getGroupIdentifier());
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_photo_updated", userInfo);
        }
        if ((this.commitHookBits & 0x40L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put("label", this.labelToDelete);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_server_user_data_can_be_deleted", userInfo);
        }
        if ((this.commitHookBits & 0x80L) != 0L) {
            userInfo = new HashMap();
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_new_keycloak_group_v2_push_topic", userInfo);
        }
        this.commitHookBits = 0L;
    }

    public static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws SQLException {
        List<ContactGroupV2> groups = ContactGroupV2.getAllForIdentity(identityManagerSession, ownedIdentity);
        Pojo_0[] pojos = new Pojo_0[groups.size()];
        for (int i = 0; i < pojos.length; ++i) {
            pojos[i] = groups.get(i).backup();
        }
        return pojos;
    }

    public static void restoreAll(IdentityManagerSession identityManagerSession, ProtocolStarterDelegate protocolStarterDelegate, Identity ownedIdentity, Pojo_0[] pojos) throws SQLException {
        if (pojos == null) {
            return;
        }
        for (Pojo_0 pojo : pojos) {
            ContactGroupV2.restore(identityManagerSession, protocolStarterDelegate, ownedIdentity, pojo);
        }
    }

    Pojo_0 backup() throws SQLException {
        Pojo_0 pojo = new Pojo_0();
        pojo.group_uid = this.groupUid.getBytes();
        pojo.server_url = this.serverUrl;
        pojo.category = this.category;
        pojo.permissions = GroupV2.Permission.deserializePermissions(this.serializedOwnPermissions).toArray(new String[0]);
        pojo.version = this.version;
        pojo.details = ContactGroupV2Details.get(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier(), this.version).backup();
        if (this.trustedDetailsVersion != this.version) {
            pojo.trusted_details = ContactGroupV2Details.get(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier(), this.trustedDetailsVersion).backup();
        }
        pojo.verified_admin_chain = this.verifiedAdministratorsChain;
        pojo.main_seed = this.blobMainSeed == null ? null : this.blobMainSeed.getBytes();
        byte[] byArray = pojo.version_seed = this.blobVersionSeed == null ? null : this.blobVersionSeed.getBytes();
        if (this.groupAdminServerAuthenticationPrivateKey != null) {
            pojo.encoded_admin_key = Encoded.of(this.groupAdminServerAuthenticationPrivateKey).getBytes();
        }
        pojo.invitation_nonce = this.ownGroupInvitationNonce;
        pojo.last_modification_timestamp = this.lastModificationTimestamp;
        pojo.push_topic = this.pushTopic;
        pojo.serialized_shared_settings = this.serializedSharedSettings;
        pojo.serialized_json_group_type = this.serializedJsonGroupType;
        pojo.members = ContactGroupV2Member.backupAll(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier());
        pojo.pending_members = ContactGroupV2PendingMember.backupAll(this.identityManagerSession, this.ownedIdentity, this.getGroupIdentifier());
        return pojo;
    }

    static void restore(IdentityManagerSession identityManagerSession, ProtocolStarterDelegate protocolStarterDelegate, Identity ownedIdentity, Pojo_0 pojo) throws SQLException {
        GroupV2.Identifier groupIdentifier = new GroupV2.Identifier(new UID(pojo.group_uid), pojo.server_url, pojo.category);
        identityManagerSession.session.startTransaction();
        ContactGroupV2Details.restore(identityManagerSession, ownedIdentity, groupIdentifier, pojo.version, pojo.details);
        if (pojo.trusted_details != null) {
            ContactGroupV2Details.restore(identityManagerSession, ownedIdentity, groupIdentifier, pojo.version - 1, pojo.trusted_details);
        }
        if (Arrays.equals(pojo.details.photo_server_identity, ownedIdentity.getBytes()) && pojo.details.photo_server_label != null) {
            try {
                ServerUserData.createForGroupV2(identityManagerSession, ownedIdentity, new UID(pojo.details.photo_server_label), groupIdentifier.getBytes());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ServerAuthenticationPrivateKey serverAuthenticationPrivateKey = null;
        if (pojo.encoded_admin_key != null) {
            try {
                serverAuthenticationPrivateKey = (ServerAuthenticationPrivateKey)new Encoded(pojo.encoded_admin_key).decodePrivateKey();
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        GroupV2.BlobKeys blobKeys = pojo.main_seed == null || pojo.version_seed == null ? null : new GroupV2.BlobKeys(new Seed(pojo.main_seed), new Seed(pojo.version_seed), serverAuthenticationPrivateKey);
        ContactGroupV2 groupV2 = new ContactGroupV2(identityManagerSession, groupIdentifier.groupUid, pojo.server_url, pojo.category, ownedIdentity, GroupV2.Permission.serializePermissionStrings(Arrays.asList(pojo.permissions)), pojo.version, pojo.verified_admin_chain, blobKeys, pojo.invitation_nonce, false, pojo.last_modification_timestamp, pojo.push_topic, pojo.serialized_shared_settings, pojo.serialized_json_group_type);
        groupV2.insert();
        ContactGroupV2Member.restoreAll(identityManagerSession, ownedIdentity, groupIdentifier, pojo.members);
        ContactGroupV2PendingMember.restoreAll(identityManagerSession, ownedIdentity, groupIdentifier, pojo.pending_members);
        try {
            protocolStarterDelegate.initiateGroupV2ReDownloadWithinTransaction(identityManagerSession.session, ownedIdentity, groupIdentifier);
        }
        catch (Exception e) {
            Logger.x(e);
        }
        identityManagerSession.session.commit();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] group_uid;
        public String server_url;
        public int category;
        public String[] permissions;
        public int version;
        public ContactGroupV2Details.Pojo_0 details;
        public ContactGroupV2Details.Pojo_0 trusted_details;
        public byte[] verified_admin_chain;
        public byte[] main_seed;
        public byte[] version_seed;
        public byte[] encoded_admin_key;
        public byte[] invitation_nonce;
        public long last_modification_timestamp;
        public String push_topic;
        public String serialized_shared_settings;
        public String serialized_json_group_type;
        public ContactGroupV2Member.Pojo_0[] members;
        public ContactGroupV2PendingMember.Pojo_0[] pending_members;
    }
}

