/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity.databases;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class ContactGroupMembersJoin
implements ObvDatabase {
    static final String TABLE_NAME = "contact_group_members_join";
    private final IdentityManagerSession identityManagerSession;
    private byte[] groupOwnerAndUid;
    static final String GROUP_OWNER_AND_UID = "group_owner_and_uid";
    private Identity ownedIdentity;
    static final String OWNED_IDENTITY = "owned_identity";
    private Identity contactIdentity;
    static final String CONTACT_IDENTITY = "contact_identity";
    private long commitHookBits = 0L;
    private static final long HOOK_BIT_INSERTED = 1L;
    private static final long HOOK_BIT_DELETED = 2L;

    public static ContactGroupMembersJoin create(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity) {
        if (groupOwnerAndUid == null || ownedIdentity == null || contactIdentity == null) {
            return null;
        }
        try {
            ContactGroupMembersJoin contactGroupMembersJoin = new ContactGroupMembersJoin(identityManagerSession, groupOwnerAndUid, ownedIdentity, contactIdentity);
            contactGroupMembersJoin.insert();
            return contactGroupMembersJoin;
        }
        catch (SQLException e) {
            return null;
        }
    }

    private ContactGroupMembersJoin(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity) {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.ownedIdentity = ownedIdentity;
        this.contactIdentity = contactIdentity;
    }

    private ContactGroupMembersJoin(IdentityManagerSession identityManagerSession, ResultSet res) throws SQLException {
        this.identityManagerSession = identityManagerSession;
        this.groupOwnerAndUid = res.getBytes(GROUP_OWNER_AND_UID);
        try {
            this.ownedIdentity = Identity.of(res.getBytes(OWNED_IDENTITY));
            this.contactIdentity = Identity.of(res.getBytes(CONTACT_IDENTITY));
        }
        catch (DecodingException e) {
            throw new SQLException();
        }
    }

    public static void createTable(Session session) throws SQLException {
        try (Statement statement = session.createStatement();){
            statement.execute("CREATE TABLE IF NOT EXISTS contact_group_members_join (group_owner_and_uid BLOB NOT NULL, owned_identity BLOB NOT NULL, contact_identity BLOB NOT NULL,  CONSTRAINT PK_contact_group_members_join PRIMARY KEY(group_owner_and_uid, owned_identity, contact_identity),  FOREIGN KEY (group_owner_and_uid,owned_identity) REFERENCES contact_group(group_owner_and_uid,owned_identity) ON DELETE CASCADE,  FOREIGN KEY (contact_identity,owned_identity) REFERENCES contact_identity(identity,owned_identity) ON DELETE CASCADE);");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void upgradeTable(Session session, int oldVersion, int newVersion) throws SQLException {
        Statement statement;
        if (oldVersion < 11 && newVersion >= 11) {
            statement = session.createStatement();
            try {
                Logger.d("MIGRATING contact_group_members_join DATABASE FROM VERSION " + oldVersion + " TO 11");
                statement.execute("ALTER TABLE contact_group_members_join RENAME TO old_contact_group_members_join");
                statement.execute("CREATE TABLE contact_group_members_join ( group_owner_and_uid BLOB NOT NULL,  owned_identity BLOB NOT NULL,  contact_identity BLOB NOT NULL,  CONSTRAINT PK_contact_group_members_join PRIMARY KEY(group_owner_and_uid, owned_identity, contact_identity),  FOREIGN KEY (group_owner_and_uid,owned_identity) REFERENCES contact_group(group_owner_and_uid,owned_identity) ON DELETE CASCADE,  FOREIGN KEY (contact_identity,owned_identity) REFERENCES contact_identity(identity,owned_identity) ON DELETE CASCADE);");
                try (ResultSet res = statement.executeQuery("SELECT * FROM old_contact_group_members_join");){
                    while (res.next()) {
                        PreparedStatement preparedStatement = session.prepareStatement("INSERT INTO contact_group_members_join VALUES (?,?,?)");
                        try {
                            preparedStatement.setBytes(1, res.getBytes(1));
                            preparedStatement.setBytes(2, res.getBytes(2));
                            preparedStatement.setBytes(3, res.getBytes(3));
                            preparedStatement.executeUpdate();
                        }
                        finally {
                            if (preparedStatement == null) continue;
                            preparedStatement.close();
                        }
                    }
                }
                statement.execute("DROP TABLE old_contact_group_members_join");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            oldVersion = 11;
        }
        if (oldVersion >= 12) return;
        if (newVersion < 12) return;
        statement = session.createStatement();
        try {
            statement.execute("DELETE FROM contact_group_members_join AS p  WHERE NOT EXISTS ( SELECT 1 FROM contact_group  WHERE group_owner_and_uid = p.group_owner_and_uid AND owned_identity = p.owned_identity )");
            statement.execute("DELETE FROM contact_group_members_join AS p  WHERE NOT EXISTS ( SELECT 1 FROM contact_identity  WHERE identity = p.contact_identity AND owned_identity = p.owned_identity )");
            return;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    @Override
    public void insert() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupMembersJoin.insert", "INSERT INTO contact_group_members_join VALUES (?,?,?);");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 1L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    @Override
    public void delete() throws SQLException {
        try (PreparedStatement statement = this.identityManagerSession.session.prepareStatement("ContactGroupMembersJoin.delete", "DELETE FROM contact_group_members_join WHERE group_owner_and_uid = ? AND owned_identity = ? AND contact_identity = ?;");){
            statement.setBytes(1, this.groupOwnerAndUid);
            statement.setBytes(2, this.ownedIdentity.getBytes());
            statement.setBytes(3, this.contactIdentity.getBytes());
            statement.executeUpdate();
            this.commitHookBits |= 2L;
            this.identityManagerSession.session.addSessionCommitListener(this);
        }
    }

    public static ContactGroupMembersJoin get(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupMembersJoin.get", "SELECT * FROM contact_group_members_join WHERE group_owner_and_uid = ?  AND owned_identity = ?  AND contact_identity = ?;");){
            ContactGroupMembersJoin contactGroupMembersJoin;
            block16: {
                ResultSet res;
                block14: {
                    ContactGroupMembersJoin contactGroupMembersJoin2;
                    block15: {
                        statement.setBytes(1, groupOwnerAndUid);
                        statement.setBytes(2, ownedIdentity.getBytes());
                        statement.setBytes(3, contactIdentity.getBytes());
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block14;
                            contactGroupMembersJoin2 = new ContactGroupMembersJoin(identityManagerSession, res);
                            if (res == null) break block15;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return contactGroupMembersJoin2;
                }
                contactGroupMembersJoin = null;
                if (res == null) break block16;
                res.close();
            }
            return contactGroupMembersJoin;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Identity[] getContactIdentitiesInGroup(IdentityManagerSession identityManagerSession, byte[] groupOwnerAndUid, Identity ownedIdentity) {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupMembersJoin.getContactIdentitiesInGroup", "SELECT contact.identity FROM contact_group_members_join AS joiin  INNER JOIN contact_identity AS contact  ON contact.identity = joiin.contact_identity AND contact.owned_identity = joiin.owned_identity WHERE joiin.group_owner_and_uid = ? AND joiin.owned_identity = ?;");){
            Identity[] identityArray;
            block17: {
                statement.setBytes(1, groupOwnerAndUid);
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<Identity> list = new ArrayList<Identity>();
                    while (res.next()) {
                        try {
                            list.add(Identity.of(res.getBytes(1)));
                        }
                        catch (DecodingException e) {
                            Logger.x(e);
                        }
                    }
                    identityArray = list.toArray(new Identity[0]);
                    if (res == null) break block17;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return identityArray;
        }
        catch (SQLException e) {
            Logger.x(e);
            return new Identity[0];
        }
    }

    public static byte[][] getGroupOwnerAndUidsOfGroupsContainingContact(IdentityManagerSession identityManagerSession, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        try (PreparedStatement statement = identityManagerSession.session.prepareStatement("ContactGroupMembersJoin.getGroupOwnerAndUidsOfGroupsContainingContact", "SELECT * FROM contact_group_members_join WHERE contact_identity = ? AND owned_identity = ?;");){
            byte[][] byArray;
            block13: {
                statement.setBytes(1, contactIdentity.getBytes());
                statement.setBytes(2, ownedIdentity.getBytes());
                ResultSet res = statement.executeQuery();
                try {
                    ArrayList<byte[]> list = new ArrayList<byte[]>();
                    while (res.next()) {
                        ContactGroupMembersJoin contactGroupMembersJoin = new ContactGroupMembersJoin(identityManagerSession, res);
                        list.add(contactGroupMembersJoin.groupOwnerAndUid);
                    }
                    byArray = (byte[][])list.toArray((T[])new byte[0][]);
                    if (res == null) break block13;
                }
                catch (Throwable throwable) {
                    if (res != null) {
                        try {
                            res.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                res.close();
            }
            return byArray;
        }
    }

    @Override
    public void wasCommitted() {
        HashMap<String, Object> userInfo;
        if ((this.commitHookBits & 1L) != 0L) {
            userInfo = new HashMap<String, Object>();
            userInfo.put(GROUP_OWNER_AND_UID, this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_member_added", userInfo);
        }
        if ((this.commitHookBits & 2L) != 0L) {
            userInfo = new HashMap();
            userInfo.put("group_uid", this.groupOwnerAndUid);
            userInfo.put(OWNED_IDENTITY, this.ownedIdentity);
            userInfo.put(CONTACT_IDENTITY, this.contactIdentity);
            this.identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_member_removed", userInfo);
        }
        this.commitHookBits = 0L;
    }

    static Pojo_0[] backupAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid) {
        Identity[] contactIdentities = ContactGroupMembersJoin.getContactIdentitiesInGroup(identityManagerSession, groupOwnerAndUid, ownedIdentity);
        Pojo_0[] pojos = new Pojo_0[contactIdentities.length];
        for (int i = 0; i < contactIdentities.length; ++i) {
            pojos[i] = new Pojo_0();
            pojos[i].contact_identity = contactIdentities[i].getBytes();
        }
        return pojos;
    }

    static void restoreAll(IdentityManagerSession identityManagerSession, Identity ownedIdentity, byte[] groupOwnerAndUid, Pojo_0[] pojos) {
        if (pojos == null) {
            return;
        }
        try {
            for (Pojo_0 pojo : pojos) {
                ContactGroupMembersJoin.create(identityManagerSession, groupOwnerAndUid, ownedIdentity, Identity.of(pojo.contact_identity));
            }
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Pojo_0 {
        public byte[] contact_identity;
    }
}

