/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.identity;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.PublicKeyEncryption;
import io.olvid.engine.crypto.ServerAuthentication;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.crypto.exceptions.DecryptionException;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.GroupMembersChangedCallback;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.KeyId;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.PreKeyBlobOnServer;
import io.olvid.engine.datatypes.PrivateIdentity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.SessionCommitListener;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.AuthEncKeyAndChannelInfo;
import io.olvid.engine.datatypes.containers.EncodedOwnedPreKey;
import io.olvid.engine.datatypes.containers.Group;
import io.olvid.engine.datatypes.containers.GroupInformation;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.GroupWithDetails;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.datatypes.containers.KeycloakGroupV2UpdateOutput;
import io.olvid.engine.datatypes.containers.OwnedDeviceAndPreKey;
import io.olvid.engine.datatypes.containers.PreKey;
import io.olvid.engine.datatypes.containers.ReceptionChannelInfo;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.datatypes.containers.UidAndPreKey;
import io.olvid.engine.datatypes.containers.UserData;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonKeycloakRevocation;
import io.olvid.engine.engine.types.JsonKeycloakUserDetails;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvContactDeviceCount;
import io.olvid.engine.engine.types.ObvContactInfo;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.databases.ContactDevice;
import io.olvid.engine.identity.databases.ContactGroup;
import io.olvid.engine.identity.databases.ContactGroupDetails;
import io.olvid.engine.identity.databases.ContactGroupMembersJoin;
import io.olvid.engine.identity.databases.ContactGroupV2;
import io.olvid.engine.identity.databases.ContactGroupV2Details;
import io.olvid.engine.identity.databases.ContactGroupV2Member;
import io.olvid.engine.identity.databases.ContactGroupV2PendingMember;
import io.olvid.engine.identity.databases.ContactIdentity;
import io.olvid.engine.identity.databases.ContactIdentityDetails;
import io.olvid.engine.identity.databases.ContactTrustOrigin;
import io.olvid.engine.identity.databases.KeycloakRevokedIdentity;
import io.olvid.engine.identity.databases.KeycloakServer;
import io.olvid.engine.identity.databases.OwnedDevice;
import io.olvid.engine.identity.databases.OwnedIdentity;
import io.olvid.engine.identity.databases.OwnedIdentityDetails;
import io.olvid.engine.identity.databases.OwnedPreKey;
import io.olvid.engine.identity.databases.PendingGroupMember;
import io.olvid.engine.identity.databases.ServerUserData;
import io.olvid.engine.identity.databases.backups.IdentityManagerDeviceSnapshot;
import io.olvid.engine.identity.databases.backups.OwnedIdentityDeviceSnapshot;
import io.olvid.engine.identity.databases.sync.IdentityDetailsSyncSnapshot;
import io.olvid.engine.identity.databases.sync.IdentityManagerSyncSnapshot;
import io.olvid.engine.identity.datatypes.IdentityManagerSession;
import io.olvid.engine.identity.datatypes.IdentityManagerSessionFactory;
import io.olvid.engine.identity.datatypes.KeycloakGroupBlob;
import io.olvid.engine.identity.datatypes.KeycloakGroupDeletionData;
import io.olvid.engine.identity.datatypes.KeycloakGroupMemberAndPermissions;
import io.olvid.engine.identity.datatypes.KeycloakGroupMemberKickedData;
import io.olvid.engine.metamanager.BackupDelegate;
import io.olvid.engine.metamanager.ChannelDelegate;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.EncryptionForIdentityDelegate;
import io.olvid.engine.metamanager.IdentityDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.metamanager.NotificationPostingDelegate;
import io.olvid.engine.metamanager.ObvManager;
import io.olvid.engine.metamanager.PreKeyEncryptionDelegate;
import io.olvid.engine.metamanager.SolveChallengeDelegate;
import io.olvid.engine.protocol.datatypes.ProtocolStarterDelegate;
import io.olvid.engine.secure_io.SecureFile;
import io.olvid.engine.secure_io.datatypes.DirectoryListingResult;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.security.InvalidKeyException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.keys.resolvers.JwksVerificationKeyResolver;
import org.jose4j.keys.resolvers.VerificationKeyResolver;

public class IdentityManager
implements IdentityDelegate,
SolveChallengeDelegate,
EncryptionForIdentityDelegate,
PreKeyEncryptionDelegate,
ObvBackupAndSyncDelegate,
IdentityManagerSessionFactory,
ObvManager {
    private final String engineBaseDirectory;
    private final ObjectMapper jsonObjectMapper;
    private final PRNGService prng;
    private final SessionCommitListener backupNeededSessionCommitListener;
    private CreateSessionDelegate createSessionDelegate;
    private NotificationPostingDelegate notificationPostingDelegate;
    private ProtocolStarterDelegate protocolStarterDelegate;
    private ChannelDelegate channelDelegate;
    private final Timer deviceDiscoveryTimer;
    private final HashMap<Identity, UID> currentDeviceUidCache = new HashMap();
    final Map<Identity, SessionCommitListener> profileBackupListeners = new HashMap<Identity, SessionCommitListener>();
    SessionCommitListener deviceBackupListener = null;

    public IdentityManager(MetaManager metaManager, String engineBaseDirectory, ObjectMapper jsonObjectMapper, PRNGService prng) {
        this.engineBaseDirectory = engineBaseDirectory;
        this.jsonObjectMapper = jsonObjectMapper;
        this.prng = prng;
        this.backupNeededSessionCommitListener = () -> {
            if (this.notificationPostingDelegate != null) {
                this.notificationPostingDelegate.postNotification("identity_manager_notification_database_content_changed", Collections.emptyMap());
            }
        };
        this.deviceDiscoveryTimer = new Timer("Engine-DeviceDiscoveryTimer");
        metaManager.requestDelegate(this, CreateSessionDelegate.class);
        metaManager.requestDelegate(this, NotificationPostingDelegate.class);
        metaManager.requestDelegate(this, ProtocolStarterDelegate.class);
        metaManager.requestDelegate(this, ChannelDelegate.class);
        metaManager.registerImplementedDelegates(this);
    }

    private SessionCommitListener getSessionCommitListenerForProfileBackup(Identity ownedIdentity) {
        SessionCommitListener listener = this.profileBackupListeners.get(ownedIdentity);
        if (listener == null) {
            listener = () -> {
                if (this.notificationPostingDelegate != null) {
                    this.notificationPostingDelegate.postNotification("backup_notification_profile_backup_needed", Map.of("owned_identity", ownedIdentity));
                }
            };
            this.profileBackupListeners.put(ownedIdentity, listener);
        }
        return listener;
    }

    private SessionCommitListener getSessionCommitListenerForDeviceBackup() {
        if (this.deviceBackupListener == null) {
            this.deviceBackupListener = () -> {
                if (this.notificationPostingDelegate != null) {
                    this.notificationPostingDelegate.postNotification("backup_notification_device_backup_needed", Collections.emptyMap());
                }
            };
        }
        return this.deviceBackupListener;
    }

    @Override
    public int initialQueueingPriority() {
        return 20;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void initialisationComplete() {
        int n2;
        ObvDatabase[] obvDatabaseArray;
        IdentityManagerSession identityManagerSession;
        try {
            identityManagerSession = this.getSession();
            try {
                void var5_28;
                OwnedIdentity[] ownedIdentities = OwnedIdentity.getAll(identityManagerSession);
                obvDatabaseArray = ownedIdentities;
                n2 = obvDatabaseArray.length;
                boolean n = false;
                while (var5_28 < n2) {
                    OwnedIdentity ownedIdentity = obvDatabaseArray[var5_28];
                    if (!ownedIdentity.isActive()) {
                        HashMap<String, Object> userInfo = new HashMap<String, Object>();
                        userInfo.put("owned_identity", ownedIdentity.getOwnedIdentity());
                        userInfo.put("active", false);
                        identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_owned_identity_changed_active_status", userInfo);
                    }
                    if (ownedIdentity.getBackupSeed() == null) {
                        BackupSeed backupSeed = ownedIdentity.getPrivateIdentity().getDeterministicBackupSeedForLegacyIdentity();
                        ownedIdentity.setBackupSeed(backupSeed);
                        identityManagerSession.session.commit();
                    }
                    ++var5_28;
                }
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                ContactIdentity[] contactIdentities = ContactIdentity.getAllInactiveWithDevices(identityManagerSession);
                if (contactIdentities.length > 0) {
                    void var5_30;
                    Logger.i("Found " + contactIdentities.length + " inactive contacts with some devices. Cleaning them up!");
                    obvDatabaseArray = contactIdentities;
                    n2 = obvDatabaseArray.length;
                    boolean bl = false;
                    while (var5_30 < n2) {
                        ObvDatabase contactIdentity = obvDatabaseArray[var5_30];
                        this.channelDelegate.deleteObliviousChannelsWithContact(identityManagerSession.session, ((ContactIdentity)contactIdentity).getOwnedIdentity(), ((ContactIdentity)contactIdentity).getContactIdentity());
                        this.removeAllDevicesForContactIdentity(identityManagerSession.session, ((ContactIdentity)contactIdentity).getOwnedIdentity(), ((ContactIdentity)contactIdentity).getContactIdentity());
                        ++var5_30;
                    }
                    identityManagerSession.session.commit();
                }
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (OwnedIdentity ownedIdentity : OwnedIdentity.getAll(identityManagerSession)) {
                    KeycloakServer keycloakServer;
                    if (!ownedIdentity.isKeycloakManaged() || (keycloakServer = ownedIdentity.getKeycloakServer()) == null) continue;
                    long revocationPruneTime = keycloakServer.getLatestRevocationListTimestamp() - 5184000000L;
                    KeycloakRevokedIdentity.prune(identityManagerSession, ownedIdentity.getOwnedIdentity(), ownedIdentity.getKeycloakServerUrl(), revocationPruneTime);
                }
                identityManagerSession.session.commit();
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (ObvDatabase obvDatabase : OwnedIdentity.getAll(identityManagerSession)) {
                    OwnedIdentityDetails.cleanup(identityManagerSession, ((OwnedIdentity)obvDatabase).getOwnedIdentity(), ((OwnedIdentity)obvDatabase).getPublishedDetailsVersion(), ((OwnedIdentity)obvDatabase).getLatestDetailsVersion());
                }
                identityManagerSession.session.commit();
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (ObvDatabase obvDatabase : ContactIdentity.getAllForAllOwnedIdentities(identityManagerSession)) {
                    ContactIdentityDetails.cleanup(identityManagerSession, ((ContactIdentity)obvDatabase).getOwnedIdentity(), ((ContactIdentity)obvDatabase).getContactIdentity(), ((ContactIdentity)obvDatabase).getPublishedDetailsVersion(), ((ContactIdentity)obvDatabase).getTrustedDetailsVersion());
                }
                identityManagerSession.session.commit();
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (ObvDatabase obvDatabase : ContactGroup.getAll(identityManagerSession)) {
                    ContactGroupDetails.cleanup(identityManagerSession, ((ContactGroup)obvDatabase).getOwnedIdentity(), ((ContactGroup)obvDatabase).getGroupOwnerAndUid(), ((ContactGroup)obvDatabase).getPublishedDetailsVersion(), ((ContactGroup)obvDatabase).getLatestOrTrustedDetailsVersion());
                }
                identityManagerSession.session.commit();
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        new Thread(this::synchronizePhotoDirWithDb, "Engine-SynchronizePhotoDirWithDb").start();
    }

    private void synchronizePhotoDirWithDb() {
        IdentityManagerSession identityManagerSession;
        block46: {
            try {
                identityManagerSession = this.getSession();
                try {
                    for (ContactGroupV2 contactGroupV2 : ContactGroupV2.getAll(identityManagerSession)) {
                        ContactGroupV2Details.cleanup(identityManagerSession, contactGroupV2.getOwnedIdentity(), contactGroupV2.getGroupIdentifier(), contactGroupV2.getVersion(), contactGroupV2.getTrustedDetailsVersion());
                    }
                    identityManagerSession.session.commit();
                }
                finally {
                    if (identityManagerSession != null) {
                        identityManagerSession.close();
                    }
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
            try {
                identityManagerSession = this.getSession();
                try {
                    SecureFile photoDir = new SecureFile(this.engineBaseDirectory, "identity_photos");
                    DirectoryListingResult photoUrlsListed = photoDir.listDirectory();
                    if (photoUrlsListed == null) break block46;
                    HashSet<String> photoUrlsToKeep = new HashSet<String>();
                    for (String photoUrl : OwnedIdentityDetails.getAllPhotoUrl(identityManagerSession)) {
                        photoUrlsToKeep.add(new File(photoUrl).getName());
                    }
                    for (String photoUrl : ContactIdentityDetails.getAllPhotoUrl(identityManagerSession)) {
                        photoUrlsToKeep.add(new File(photoUrl).getName());
                    }
                    for (String photoUrl : ContactGroupDetails.getAllPhotoUrl(identityManagerSession)) {
                        photoUrlsToKeep.add(new File(photoUrl).getName());
                    }
                    for (String photoUrl : ContactGroupV2Details.getAllPhotoUrl(identityManagerSession)) {
                        photoUrlsToKeep.add(new File(photoUrl).getName());
                    }
                    for (SecureFile listedPhotoUrl : photoUrlsListed.getSecureFileList()) {
                        if (photoUrlsToKeep.contains(listedPhotoUrl.getPlainNameFile().getName())) continue;
                        try {
                            listedPhotoUrl.delete();
                        }
                        catch (Exception e) {
                            Logger.x(e);
                        }
                    }
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (File file : photoUrlsListed.getFileList()) {
                        SecureFile secureFile = new SecureFile(file.getAbsolutePath());
                        if (!secureFile.canRead() || photoUrlsToKeep.contains(secureFile.getPlainNameFile().getName())) continue;
                        secureFile.delete();
                    }
                }
                finally {
                    if (identityManagerSession != null) {
                        identityManagerSession.close();
                    }
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (OwnedIdentity ownedIdentity : OwnedIdentity.getAll(identityManagerSession)) {
                    HashSet<ObvCapability> publishedCapabilities;
                    OwnedDevice ownedDevice = OwnedDevice.getCurrentDeviceOfOwnedIdentity(identityManagerSession, ownedIdentity.getOwnedIdentity());
                    HashSet<ObvCapability> currentCapabilities = new HashSet<ObvCapability>(ObvCapability.currentCapabilities);
                    List<ObvCapability> publishedCapabilitiesList = ownedDevice.getDeviceCapabilities();
                    HashSet<ObvCapability> hashSet = publishedCapabilities = publishedCapabilitiesList == null ? null : new HashSet<ObvCapability>(publishedCapabilitiesList);
                    if (currentCapabilities.equals(publishedCapabilities)) continue;
                    this.protocolStarterDelegate.updateCurrentDeviceCapabilitiesForOwnedIdentity(identityManagerSession.session, ownedIdentity.getOwnedIdentity(), ObvCapability.currentCapabilities);
                }
                identityManagerSession.session.commit();
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        try {
            identityManagerSession = this.getSession();
            try {
                for (ContactGroupV2 contactGroupV2 : ContactGroupV2.getAllKeycloak(identityManagerSession)) {
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", contactGroupV2.getOwnedIdentity());
                    userInfo.put("group_identifier", contactGroupV2.getGroupIdentifier());
                    userInfo.put("serialized_shared_settings", contactGroupV2.getSerializedSharedSettings());
                    userInfo.put("timestamp", contactGroupV2.getLastModificationTimestamp());
                    this.notificationPostingDelegate.postNotification("identity_manager_notification_keycloak_group_v_2_shared_settings", userInfo);
                }
            }
            finally {
                if (identityManagerSession != null) {
                    identityManagerSession.close();
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        this.deviceDiscoveryTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ContactIdentity[] contactIdentities;
                IdentityManagerSession identityManagerSession;
                try {
                    identityManagerSession = IdentityManager.this.getSession();
                    try {
                        for (OwnedIdentity ownedIdentity : OwnedIdentity.getAll(identityManagerSession)) {
                            if (!ownedIdentity.isActive()) continue;
                            IdentityManager.this.protocolStarterDelegate.startOwnedDeviceDiscoveryProtocolWithinTransaction(identityManagerSession.session, ownedIdentity.getOwnedIdentity());
                        }
                        identityManagerSession.session.commit();
                    }
                    finally {
                        if (identityManagerSession != null) {
                            identityManagerSession.close();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                try {
                    identityManagerSession = IdentityManager.this.getSession();
                    try {
                        contactIdentities = ContactIdentity.getAllActiveWithoutDevices(identityManagerSession, System.currentTimeMillis() - 259200000L);
                        if (contactIdentities.length > 0) {
                            Logger.i("Found " + contactIdentities.length + " contacts with no device. Starting corresponding deviceDiscoveryProtocols.");
                            for (ContactIdentity contactIdentity : contactIdentities) {
                                IdentityManager.this.protocolStarterDelegate.startDeviceDiscoveryProtocolWithinTransaction(identityManagerSession.session, contactIdentity.getOwnedIdentity(), contactIdentity.getContactIdentity());
                                contactIdentity.setLastContactDeviceDiscoveryTimestamp(System.currentTimeMillis());
                            }
                            identityManagerSession.session.commit();
                        }
                    }
                    finally {
                        if (identityManagerSession != null) {
                            identityManagerSession.close();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                try {
                    identityManagerSession = IdentityManager.this.getSession();
                    try {
                        contactIdentities = ContactIdentity.getAllActiveWithDevicesAndOldDiscovery(identityManagerSession, System.currentTimeMillis() - 604800000L);
                        if (contactIdentities.length > 0) {
                            Logger.i("Found " + contactIdentities.length + " contacts with outdated device discovery. Starting corresponding deviceDiscoveryProtocols.");
                            for (ContactIdentity contactIdentity : contactIdentities) {
                                IdentityManager.this.protocolStarterDelegate.startDeviceDiscoveryProtocolWithinTransaction(identityManagerSession.session, contactIdentity.getOwnedIdentity(), contactIdentity.getContactIdentity());
                                contactIdentity.setLastContactDeviceDiscoveryTimestamp(System.currentTimeMillis());
                            }
                            identityManagerSession.session.commit();
                        }
                    }
                    finally {
                        if (identityManagerSession != null) {
                            identityManagerSession.close();
                        }
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
        }, 0L, 86400000L);
    }

    public void setDelegate(CreateSessionDelegate createSessionDelegate) {
        this.createSessionDelegate = createSessionDelegate;
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            OwnedIdentityDetails.createTable(identityManagerSession.session);
            KeycloakServer.createTable(identityManagerSession.session);
            KeycloakRevokedIdentity.createTable(identityManagerSession.session);
            OwnedIdentity.createTable(identityManagerSession.session);
            OwnedDevice.createTable(identityManagerSession.session);
            OwnedPreKey.createTable(identityManagerSession.session);
            ContactIdentityDetails.createTable(identityManagerSession.session);
            ContactIdentity.createTable(identityManagerSession.session);
            ContactTrustOrigin.createTable(identityManagerSession.session);
            ContactDevice.createTable(identityManagerSession.session);
            ContactGroupDetails.createTable(identityManagerSession.session);
            ContactGroup.createTable(identityManagerSession.session);
            ContactGroupMembersJoin.createTable(identityManagerSession.session);
            PendingGroupMember.createTable(identityManagerSession.session);
            ServerUserData.createTable(identityManagerSession.session);
            ContactGroupV2Details.createTable(identityManagerSession.session);
            ContactGroupV2.createTable(identityManagerSession.session);
            ContactGroupV2Member.createTable(identityManagerSession.session);
            ContactGroupV2PendingMember.createTable(identityManagerSession.session);
            identityManagerSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create identity databases");
        }
    }

    public static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        OwnedIdentityDetails.upgradeTable(session, oldVersion, newVersion);
        KeycloakServer.upgradeTable(session, oldVersion, newVersion);
        KeycloakRevokedIdentity.upgradeTable(session, oldVersion, newVersion);
        OwnedIdentity.upgradeTable(session, oldVersion, newVersion);
        OwnedDevice.upgradeTable(session, oldVersion, newVersion);
        if (oldVersion < 14 && newVersion >= 14) {
            try (Statement statement = session.createStatement();){
                statement.execute("DROP TABLE IF EXISTS owned_ephemeral_identity");
            }
        }
        OwnedPreKey.upgradeTable(session, oldVersion, newVersion);
        ContactIdentityDetails.upgradeTable(session, oldVersion, newVersion);
        ContactIdentity.upgradeTable(session, oldVersion, newVersion);
        ContactTrustOrigin.upgradeTable(session, oldVersion, newVersion);
        ContactDevice.upgradeTable(session, oldVersion, newVersion);
        ContactGroupDetails.upgradeTable(session, oldVersion, newVersion);
        ContactGroup.upgradeTable(session, oldVersion, newVersion);
        ContactGroupMembersJoin.upgradeTable(session, oldVersion, newVersion);
        PendingGroupMember.upgradeTable(session, oldVersion, newVersion);
        ServerUserData.upgradeTable(session, oldVersion, newVersion);
        ContactGroupV2Details.upgradeTable(session, oldVersion, newVersion);
        ContactGroupV2.upgradeTable(session, oldVersion, newVersion);
        ContactGroupV2Member.upgradeTable(session, oldVersion, newVersion);
        ContactGroupV2PendingMember.upgradeTable(session, oldVersion, newVersion);
    }

    public void setDelegate(NotificationPostingDelegate notificationPostingDelegate) {
        this.notificationPostingDelegate = notificationPostingDelegate;
    }

    public void setDelegate(ProtocolStarterDelegate protocolStarterDelegate) {
        this.protocolStarterDelegate = protocolStarterDelegate;
    }

    public void setDelegate(ChannelDelegate channelDelegate) {
        this.channelDelegate = channelDelegate;
    }

    @Override
    public IdentityManagerSession getSession() throws SQLException {
        if (this.createSessionDelegate == null) {
            throw new SQLException("No CreateSessionDelegate was set in IdentityManager.");
        }
        return new IdentityManagerSession(this.createSessionDelegate.getSession(), this.notificationPostingDelegate, this, this.engineBaseDirectory, this.jsonObjectMapper, this.prng);
    }

    private IdentityManagerSession wrapSession(Session session) {
        return new IdentityManagerSession(session, this.notificationPostingDelegate, this, this.engineBaseDirectory, this.jsonObjectMapper, this.prng);
    }

    public ObjectMapper getJsonObjectMapper() {
        return this.jsonObjectMapper;
    }

    @Override
    public byte[] solveChallenge(byte[] challenge, Identity identity, PRNGService prng) throws Exception {
        byte[] byArray;
        block9: {
            IdentityManagerSession identityManagerSession = this.getSession();
            try {
                OwnedIdentity ownedIdentity = OwnedIdentity.get(identityManagerSession, identity);
                if (ownedIdentity == null) {
                    throw new Exception("Unknown owned identity");
                }
                PrivateIdentity privateIdentity = ownedIdentity.getPrivateIdentity();
                ServerAuthentication serverAuth = Suite.getServerAuthentication(privateIdentity.getServerAuthenticationPublicKey());
                byArray = serverAuth.solveChallenge(challenge, privateIdentity.getServerAuthenticationPrivateKey(), privateIdentity.getServerAuthenticationPublicKey(), prng);
                if (identityManagerSession == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (identityManagerSession != null) {
                        try {
                            identityManagerSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidKeyException | SQLException e) {
                    Logger.x(e);
                    return null;
                }
            }
            identityManagerSession.close();
        }
        return byArray;
    }

    @Override
    public boolean isOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        return ownedIdentityObject != null;
    }

    @Override
    public boolean isActiveOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        return OwnedIdentity.isActive(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public Identity generateOwnedIdentity(Session session, String server, JsonIdentityDetails jsonIdentityDetails, ObvKeycloakState keycloakState, String deviceDisplayName, PRNGService prng) throws SQLException {
        OwnedIdentity ownedIdentity;
        if (!session.isInTransaction()) {
            session.startTransaction();
        }
        if ((ownedIdentity = OwnedIdentity.create(this.wrapSession(session), server, null, null, jsonIdentityDetails, deviceDisplayName, prng)) == null) {
            return null;
        }
        try {
            this.protocolStarterDelegate.updateCurrentDeviceCapabilitiesForOwnedIdentity(session, ownedIdentity.getOwnedIdentity(), ObvCapability.currentCapabilities);
        }
        catch (Exception e) {
            Logger.w("Failed to update generated identity capabilities");
            Logger.x(e);
        }
        if (keycloakState != null) {
            KeycloakServer keycloakServer = KeycloakServer.create(this.wrapSession(session), keycloakState.keycloakServer, ownedIdentity.getOwnedIdentity(), keycloakState.jwks.toJson(), keycloakState.signatureKey == null ? null : keycloakState.signatureKey.toJson(), keycloakState.clientId, keycloakState.clientSecret, keycloakState.transferRestricted);
            if (keycloakServer == null) {
                return null;
            }
            ownedIdentity.setKeycloakServerUrl(keycloakServer.getServerUrl());
            KeycloakServer.saveAuthState(this.wrapSession(session), keycloakState.keycloakServer, ownedIdentity.getOwnedIdentity(), keycloakState.serializedAuthState);
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
        return ownedIdentity.getOwnedIdentity();
    }

    @Override
    public void deleteOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        this.currentDeviceUidCache.remove(ownedIdentity);
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ContactIdentity[] contactIdentities;
            ContactGroup[] contactGroups;
            for (ContactGroup contactGroup : contactGroups = ContactGroup.getAllForIdentity(this.wrapSession(session), ownedIdentity)) {
                contactGroup.delete();
            }
            List<ContactGroupV2> contactGroupsV2 = ContactGroupV2.getAllForIdentity(this.wrapSession(session), ownedIdentity);
            for (ContactGroupV2 contactGroupV2 : contactGroupsV2) {
                contactGroupV2.delete();
            }
            for (ContactIdentity contactIdentity : contactIdentities = ContactIdentity.getAll(this.wrapSession(session), ownedIdentity)) {
                contactIdentity.delete();
            }
            ServerUserData.deleteAllForOwnedIdentity(this.wrapSession(session), ownedIdentity);
            ownedIdentityObject.delete();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
        }
    }

    @Override
    public Identity[] getOwnedIdentities(Session session) throws SQLException {
        OwnedIdentity[] ownedIdentities = OwnedIdentity.getAll(this.wrapSession(session));
        Identity[] identities = new Identity[ownedIdentities.length];
        for (int i = 0; i < ownedIdentities.length; ++i) {
            identities[i] = ownedIdentities[i].getOwnedIdentity();
        }
        return identities;
    }

    @Override
    public void updateLatestIdentityDetails(Session session, Identity ownedIdentity, JsonIdentityDetails jsonIdentityDetails) throws Exception {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.setLatestDetails(jsonIdentityDetails);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        }
    }

    @Override
    public void updateOwnedIdentityPhoto(Session session, Identity ownedIdentity, String absolutePhotoUrl) throws Exception {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.setPhoto(absolutePhotoUrl);
        }
    }

    @Override
    public void setOwnedDetailsDownloadedPhoto(Session session, Identity ownedIdentity, int version, byte[] photo) throws Exception {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.setDetailsDownloadedPhotoUrl(version, photo);
        }
    }

    @Override
    public void setOwnedIdentityDetailsServerLabelAndKey(Session session, Identity ownedIdentity, int version, UID photoServerLabel, AuthEncKey photoServerKey) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.setPhotoLabelAndKey(version, photoServerLabel, photoServerKey);
            if (ServerUserData.createForOwnedIdentityDetails(this.wrapSession(session), ownedIdentity, photoServerLabel) == null) {
                throw new SQLException();
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void createOwnedIdentityServerUserData(Session session, Identity ownedIdentity, UID photoServerLabel) throws SQLException {
        if (ServerUserData.createForOwnedIdentityDetails(this.wrapSession(session), ownedIdentity, photoServerLabel) == null) {
            throw new SQLException();
        }
    }

    @Override
    public int publishLatestIdentityDetails(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return ownedIdentityObject.publishLatestDetails();
        }
        return -1;
    }

    @Override
    public void discardLatestIdentityDetails(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.discardLatestDetails();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        }
    }

    @Override
    public boolean setOwnedIdentityDetailsFromOtherDevice(Session session, Identity ownedIdentity, JsonIdentityDetailsWithVersionAndPhoto ownDetailsWithVersionAndPhoto) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return ownedIdentityObject.setOwnedIdentityDetailsFromOtherDevice(ownDetailsWithVersionAndPhoto);
        }
        return false;
    }

    @Override
    public String getSerializedPublishedDetailsOfOwnedIdentity(Session session, Identity ownedIdentity) {
        return OwnedIdentity.getSerializedPublishedDetails(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto getOwnedIdentityPublishedDetails(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getPublishedDetails().getJsonIdentityDetailsWithVersionAndPhoto();
        }
        return null;
    }

    @Override
    public boolean isOwnedIdentityKeycloakManaged(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.isKeycloakManaged();
        }
        return false;
    }

    @Override
    public Collection<ObvIdentity> getOwnedIdentitiesWithKeycloakPushTopic(Session session, String pushTopic) throws SQLException {
        List<KeycloakServer> keycloakServers = KeycloakServer.getAllWithPushTopic(this.wrapSession(session), pushTopic);
        List<ContactGroupV2> keycloakGroups = ContactGroupV2.getAllWithPushTopic(this.wrapSession(session), pushTopic);
        HashSet<ObvIdentity> ownedIdentities = new HashSet<ObvIdentity>();
        for (KeycloakServer keycloakServer : keycloakServers) {
            ownedIdentities.add(new ObvIdentity(session, this, keycloakServer.getOwnedIdentity()));
        }
        for (ContactGroupV2 keycloakGroup : keycloakGroups) {
            ownedIdentities.add(new ObvIdentity(session, this, keycloakGroup.getOwnedIdentity()));
        }
        return ownedIdentities;
    }

    @Override
    public ObvKeycloakState getOwnedIdentityKeycloakState(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getKeycloakState();
        }
        return null;
    }

    @Override
    public JsonWebKey getOwnedIdentityKeycloakSignatureKey(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getKeycloakSignatureKey();
        }
        return null;
    }

    @Override
    public void setOwnedIdentityKeycloakSignatureKey(Session session, Identity ownedIdentity, JsonWebKey signatureKey) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.setSignatureKey(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, signatureKey);
            if (signatureKey == null) {
                ContactGroupV2.deleteAllKeycloakGroupsForOwnedIdentity(this.wrapSession(session), ownedIdentity);
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void setKeycloakLatestRevocationListTimestamp(Session session, Identity ownedIdentity, long latestRevocationListTimestamp) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.setLatestRevocationListTimestamp(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, latestRevocationListTimestamp);
            long revocationPruneTime = latestRevocationListTimestamp - 5184000000L;
            KeycloakRevokedIdentity.prune(this.wrapSession(session), ownedIdentity, ownedIdentityObject.getKeycloakServerUrl(), revocationPruneTime);
        }
    }

    @Override
    public void unCertifyExpiredSignedContactDetails(Session session, Identity ownedIdentity, long latestRevocationListTimestamp) {
        for (ContactIdentity contactIdentity : ContactIdentity.getAllCertifiedByKeycloak(this.wrapSession(session), ownedIdentity)) {
            try {
                ContactIdentityDetails publishedDetails;
                JwtConsumer noVerificationConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
                JwtClaims claims = noVerificationConsumer.processToClaims((publishedDetails = contactIdentity.getPublishedDetails()).getJsonIdentityDetails().getSignedUserDetails());
                JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)this.jsonObjectMapper.readValue(claims.getRawJson(), JsonKeycloakUserDetails.class);
                if (jsonKeycloakUserDetails.getTimestamp() == null || jsonKeycloakUserDetails.getTimestamp() >= latestRevocationListTimestamp - 5184000000L) continue;
                contactIdentity.setCertifiedByOwnKeycloak(false, publishedDetails.getSerializedJsonDetails());
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public List<String> getKeycloakPushTopics(Session session, Identity ownedIdentity) throws SQLException {
        List<String> groupPushTopics;
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null || !ownedIdentityObject.isKeycloakManaged()) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> pushTopics = new ArrayList<String>();
        KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity);
        if (keycloakServer != null) {
            pushTopics.addAll(keycloakServer.getPushTopics());
        }
        if ((groupPushTopics = ContactGroupV2.getAllKeycloakPushTopics(this.wrapSession(session), ownedIdentity)) != null) {
            pushTopics.addAll(groupPushTopics);
        }
        return pushTopics;
    }

    @Override
    public void verifyAndAddRevocationList(Session session, Identity ownedIdentity, List<String> signedRevocations) throws Exception {
        KeycloakServer keycloakServer;
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged() && (keycloakServer = ownedIdentityObject.getKeycloakServer()) != null) {
            JwksVerificationKeyResolver jwksResolver;
            JsonWebKey signatureKey = keycloakServer.getSignatureKey();
            if (signatureKey != null) {
                jwksResolver = new JwksVerificationKeyResolver(Collections.singletonList(signatureKey));
            } else {
                JsonWebKeySet jwks = keycloakServer.getJwks();
                jwksResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
            }
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedAudience(false, new String[0]).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).build();
            block5: for (String signedRevocation : signedRevocations) {
                try {
                    JsonKeycloakRevocation jsonKeycloakRevocation;
                    JwtContext context = jwtConsumer.process(signedRevocation);
                    if (context.getJwtClaims() == null || (jsonKeycloakRevocation = (JsonKeycloakRevocation)this.jsonObjectMapper.readValue(context.getJwtClaims().getRawJson(), JsonKeycloakRevocation.class)) == null || jsonKeycloakRevocation.getBytesRevokedIdentity() == null || jsonKeycloakRevocation.getRevocationTimestamp() == 0L) continue;
                    Identity revokedIdentity = Identity.of(jsonKeycloakRevocation.getBytesRevokedIdentity());
                    List<KeycloakRevokedIdentity> keycloakRevokedIdentities = KeycloakRevokedIdentity.get(this.wrapSession(session), ownedIdentity, revokedIdentity);
                    if (keycloakRevokedIdentities != null) {
                        boolean found = false;
                        for (KeycloakRevokedIdentity keycloakRevokedIdentity : keycloakRevokedIdentities) {
                            if (!keycloakServer.getServerUrl().equals(keycloakRevokedIdentity.getKeycloakServerUrl()) || jsonKeycloakRevocation.getRevocationType() != keycloakRevokedIdentity.getRevocationType() || jsonKeycloakRevocation.getRevocationTimestamp() != keycloakRevokedIdentity.getRevocationTimestamp()) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                    }
                    KeycloakRevokedIdentity.create(this.wrapSession(session), ownedIdentity, keycloakServer.getServerUrl(), revokedIdentity, jsonKeycloakRevocation.getRevocationType(), jsonKeycloakRevocation.getRevocationTimestamp());
                    ContactIdentity contactIdentity = ContactIdentity.get(this.wrapSession(session), ownedIdentity, revokedIdentity);
                    if (contactIdentity == null) continue;
                    switch (jsonKeycloakRevocation.getRevocationType()) {
                        case 1: {
                            ContactIdentityDetails publishedDetails;
                            JwtConsumer noVerificationConsumer;
                            JwtClaims claims;
                            JsonKeycloakUserDetails jsonKeycloakUserDetails;
                            if (!contactIdentity.isCertifiedByOwnKeycloak() || (jsonKeycloakUserDetails = (JsonKeycloakUserDetails)this.jsonObjectMapper.readValue((claims = (noVerificationConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build()).processToClaims((publishedDetails = contactIdentity.getPublishedDetails()).getJsonIdentityDetails().getSignedUserDetails())).getRawJson(), JsonKeycloakUserDetails.class)).getTimestamp() != null && jsonKeycloakRevocation.getRevocationTimestamp() <= jsonKeycloakUserDetails.getTimestamp()) continue block5;
                            contactIdentity.setCertifiedByOwnKeycloak(false, publishedDetails.getSerializedJsonDetails());
                            break;
                        }
                        default: {
                            if (!contactIdentity.isForcefullyTrustedByUser()) {
                                this.channelDelegate.deleteObliviousChannelsWithContact(session, ownedIdentity, revokedIdentity);
                                this.removeAllDevicesForContactIdentity(session, ownedIdentity, revokedIdentity);
                            }
                            ContactIdentityDetails publishedDetails = contactIdentity.getPublishedDetails();
                            contactIdentity.setCertifiedByOwnKeycloak(false, publishedDetails.getSerializedJsonDetails());
                            contactIdentity.setRevokedAsCompromised(true);
                        }
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public JsonKeycloakUserDetails verifyKeycloakIdentitySignature(Session session, Identity ownedIdentity, String signature) {
        block14: {
            try {
                JwksVerificationKeyResolver jwksResolver;
                OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
                if (ownedIdentityObject == null || !ownedIdentityObject.isKeycloakManaged()) {
                    return null;
                }
                KeycloakServer keycloakServer = ownedIdentityObject.getKeycloakServer();
                JsonWebKey signatureKey = keycloakServer.getSignatureKey();
                if (signatureKey != null) {
                    jwksResolver = new JwksVerificationKeyResolver(Collections.singletonList(signatureKey));
                } else {
                    JsonWebKeySet jwks = keycloakServer.getJwks();
                    jwksResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
                }
                JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedAudience(false, new String[0]).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).build();
                JwtContext context = jwtConsumer.process(signature);
                if (context.getJwtClaims() == null) break block14;
                JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)this.jsonObjectMapper.readValue(context.getJwtClaims().getRawJson(), JsonKeycloakUserDetails.class);
                if (jsonKeycloakUserDetails.getIdentity() != null) {
                    try {
                        Identity identityToVerify = Identity.of(jsonKeycloakUserDetails.getIdentity());
                        List<KeycloakRevokedIdentity> keycloakRevokedIdentities = KeycloakRevokedIdentity.get(this.wrapSession(session), ownedIdentity, identityToVerify);
                        if (keycloakRevokedIdentities != null) {
                            block7: for (KeycloakRevokedIdentity keycloakRevokedIdentity : keycloakRevokedIdentities) {
                                switch (keycloakRevokedIdentity.getRevocationType()) {
                                    case 1: {
                                        if (jsonKeycloakUserDetails.getTimestamp() != null && keycloakRevokedIdentity.getRevocationTimestamp() <= jsonKeycloakUserDetails.getTimestamp()) continue block7;
                                        return null;
                                    }
                                }
                                return null;
                            }
                        }
                    }
                    catch (DecodingException decodingException) {
                        // empty catch block
                    }
                }
                if (jsonKeycloakUserDetails.getTimestamp() != null && jsonKeycloakUserDetails.getTimestamp() < keycloakServer.getLatestRevocationListTimestamp() - 5184000000L) {
                    return null;
                }
                return jsonKeycloakUserDetails;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String verifyKeycloakSignature(Session session, Identity ownedIdentity, String signature) {
        try {
            JwksVerificationKeyResolver jwksResolver;
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
            if (ownedIdentityObject == null || !ownedIdentityObject.isKeycloakManaged()) {
                return null;
            }
            KeycloakServer keycloakServer = ownedIdentityObject.getKeycloakServer();
            JsonWebKey signatureKey = keycloakServer.getSignatureKey();
            if (signatureKey != null) {
                jwksResolver = new JwksVerificationKeyResolver(Collections.singletonList(signatureKey));
            } else {
                JsonWebKeySet jwks = keycloakServer.getJwks();
                jwksResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
            }
            JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedAudience(false, new String[0]).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).build();
            JwtContext context = jwtConsumer.process(signature);
            if (context.getJwtClaims() != null) {
                return context.getJwtClaims().getRawJson();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public String getOwnedIdentityKeycloakServerUrl(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getKeycloakServerUrl();
        }
        return null;
    }

    @Override
    public void saveKeycloakAuthState(Session session, Identity ownedIdentity, String serializedAuthState) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.saveAuthState(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, serializedAuthState);
        }
    }

    @Override
    public void saveKeycloakJwks(Session session, Identity ownedIdentity, String serializedJwks) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.saveJwks(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, serializedJwks);
        }
    }

    @Override
    public void saveKeycloakApiKey(Session session, Identity ownedIdentity, String apiKey) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.saveApiKey(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, apiKey);
        }
    }

    @Override
    public String getOwnedIdentityKeycloakUserId(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getKeycloakUserId();
        }
        return null;
    }

    @Override
    public void setOwnedIdentityKeycloakUserId(Session session, Identity ownedIdentity, String userId) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer.setKeycloakUserId(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity, userId);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void bindOwnedIdentityToKeycloak(Session session, Identity ownedIdentity, String keycloakUserId, ObvKeycloakState keycloakState) throws Exception {
        KeycloakServer keycloakServer;
        if (ownedIdentity == null || keycloakState == null || keycloakUserId == null) {
            Logger.e("Error in bindOwnedIdentityToKeycloak: bad inputs --> aborting");
            throw new Exception();
        }
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null) {
            Logger.e("Owned identity not found in bindOwnedIdentityToKeycloak");
            throw new Exception();
        }
        if (ownedIdentityObject.isKeycloakManaged()) {
            keycloakServer = KeycloakServer.get(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity);
            ownedIdentityObject.setKeycloakServerUrl(null);
            if (keycloakServer != null) {
                keycloakServer.delete();
            }
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        keycloakServer = KeycloakServer.create(this.wrapSession(session), keycloakState.keycloakServer, ownedIdentity, keycloakState.jwks.toJson(), keycloakState.signatureKey == null ? null : keycloakState.signatureKey.toJson(), keycloakState.clientId, keycloakState.clientSecret, keycloakState.transferRestricted);
        if (keycloakServer == null) {
            Logger.e("Unable to create new KeycloakServer db entry");
            throw new Exception();
        }
        ownedIdentityObject.setKeycloakServerUrl(keycloakServer.getServerUrl());
        keycloakServer.setKeycloakUserId(keycloakUserId);
        KeycloakServer.saveAuthState(this.wrapSession(session), keycloakState.keycloakServer, ownedIdentity, keycloakState.serializedAuthState);
    }

    @Override
    public int unbindOwnedIdentityFromKeycloak(Session session, Identity ownedIdentity) throws Exception {
        if (ownedIdentity == null) {
            Logger.e("Error in unbindOwnedIdentityToKeycloak: bad inputs --> aborting");
            throw new Exception();
        }
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null) {
            Logger.e("Owned identity not found in unbindOwnedIdentityFromKeycloak");
            throw new Exception();
        }
        if (ownedIdentityObject.isKeycloakManaged()) {
            KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), ownedIdentityObject.getKeycloakServerUrl(), ownedIdentity);
            ownedIdentityObject.setKeycloakServerUrl(null);
            if (keycloakServer != null) {
                keycloakServer.delete();
            }
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            JsonIdentityDetails jsonIdentityDetails = ownedIdentityObject.getPublishedDetails().getJsonIdentityDetails();
            jsonIdentityDetails.setSignedUserDetails(null);
            jsonIdentityDetails.setPosition(null);
            jsonIdentityDetails.setCompany(null);
            ownedIdentityObject.discardLatestDetails();
            ownedIdentityObject.setLatestDetails(jsonIdentityDetails);
            return ownedIdentityObject.publishLatestDetails();
        }
        return -2;
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto[] getOwnedIdentityPublishedAndLatestDetails(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            JsonIdentityDetailsWithVersionAndPhoto[] res = ownedIdentityObject.getPublishedDetailsVersion() == ownedIdentityObject.getLatestDetailsVersion() ? new JsonIdentityDetailsWithVersionAndPhoto[]{ownedIdentityObject.getPublishedDetails().getJsonIdentityDetailsWithVersionAndPhoto()} : new JsonIdentityDetailsWithVersionAndPhoto[]{ownedIdentityObject.getPublishedDetails().getJsonIdentityDetailsWithVersionAndPhoto(), ownedIdentityObject.getLatestDetails().getJsonIdentityDetailsWithVersionAndPhoto()};
            return res;
        }
        return null;
    }

    @Override
    public void updateKeycloakTransferRestrictedIfNeeded(Session session, Identity ownedIdentity, String serverUrl, boolean transferRestricted) throws SQLException {
        KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), serverUrl, ownedIdentity);
        if (keycloakServer != null && transferRestricted ^ keycloakServer.isTransferRestricted()) {
            keycloakServer.setTransferRestricted(transferRestricted);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public boolean updateKeycloakPushTopicsIfNeeded(Session session, Identity ownedIdentity, String serverUrl, List<String> pushTopics) throws SQLException {
        KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), serverUrl, ownedIdentity);
        if (keycloakServer != null) {
            HashSet<String> oldSet = new HashSet<String>(keycloakServer.getPushTopics());
            HashSet<String> newSet = new HashSet<String>();
            if (pushTopics != null) {
                newSet.addAll(pushTopics);
            }
            if (!oldSet.equals(newSet)) {
                keycloakServer.setPushTopics(pushTopics);
                return true;
            }
        }
        return false;
    }

    @Override
    public void setOwnedIdentityKeycloakSelfRevocationTestNonce(Session session, Identity ownedIdentity, String serverUrl, String nonce) throws SQLException {
        KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), serverUrl, ownedIdentity);
        if (keycloakServer != null && !Objects.equals(keycloakServer.getSelfRevocationTestNonce(), nonce)) {
            keycloakServer.setSelfRevocationTestNonce(nonce);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public String getOwnedIdentityKeycloakSelfRevocationTestNonce(Session session, Identity ownedIdentity, String serverUrl) throws SQLException {
        KeycloakServer keycloakServer = KeycloakServer.get(this.wrapSession(session), serverUrl, ownedIdentity);
        if (keycloakServer != null) {
            return keycloakServer.getSelfRevocationTestNonce();
        }
        return null;
    }

    @Override
    public void updateKeycloakGroups(Session session, Identity ownedIdentity, List<String> signedGroupBlobs, List<String> signedGroupDeletions, List<String> signedGroupKicks, long keycloakCurrentTimestamp) throws Exception {
        Long groupLastModificationTimestamp;
        GroupV2.Identifier groupIdentifier;
        UID groupUid;
        JwtClaims claims;
        JwksVerificationKeyResolver jwksResolver;
        if (!session.isInTransaction()) {
            Logger.e("Called updateKeycloakGroups outside a transaction");
            throw new Exception();
        }
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null || !ownedIdentityObject.isKeycloakManaged()) {
            Logger.e("Called updateKeycloakGroups for an identity that is not keycloak managed");
            throw new Exception();
        }
        KeycloakServer keycloakServer = ownedIdentityObject.getKeycloakServer();
        JsonWebKey signatureKey = keycloakServer.getSignatureKey();
        if (signatureKey != null) {
            jwksResolver = new JwksVerificationKeyResolver(Collections.singletonList(signatureKey));
        } else {
            JsonWebKeySet jwks = keycloakServer.getJwks();
            jwksResolver = new JwksVerificationKeyResolver(jwks.getJsonWebKeys());
        }
        JwtConsumer jwtConsumer = new JwtConsumerBuilder().setExpectedAudience(false, new String[0]).setVerificationKeyResolver((VerificationKeyResolver)jwksResolver).build();
        if (signedGroupDeletions != null) {
            for (String signedGroupDeletion : signedGroupDeletions) {
                try {
                    claims = jwtConsumer.processToClaims(signedGroupDeletion);
                    if (claims == null) continue;
                    KeycloakGroupDeletionData keycloakGroupDeletionData = (KeycloakGroupDeletionData)this.jsonObjectMapper.readValue(claims.getRawJson(), KeycloakGroupDeletionData.class);
                    groupUid = new UID(keycloakGroupDeletionData.groupUid);
                    groupIdentifier = new GroupV2.Identifier(groupUid, keycloakServer.getServerUrl(), 1);
                    groupLastModificationTimestamp = ContactGroupV2.getLastModificationTimestamp(this.wrapSession(session), ownedIdentity, groupIdentifier);
                    if (groupLastModificationTimestamp == null || groupLastModificationTimestamp > keycloakGroupDeletionData.timestamp) continue;
                    this.deleteGroupV2(session, ownedIdentity, groupIdentifier, null);
                }
                catch (JsonProcessingException | IllegalArgumentException | InvalidJwtException e) {
                    Logger.x(e);
                }
            }
        }
        if (signedGroupKicks != null) {
            for (String signedGroupKick : signedGroupKicks) {
                try {
                    claims = jwtConsumer.processToClaims(signedGroupKick);
                    if (claims == null) continue;
                    KeycloakGroupMemberKickedData keycloakGroupMemberKickedData = (KeycloakGroupMemberKickedData)this.jsonObjectMapper.readValue(claims.getRawJson(), KeycloakGroupMemberKickedData.class);
                    groupUid = new UID(keycloakGroupMemberKickedData.groupUid);
                    if (!Arrays.equals(ownedIdentity.getBytes(), keycloakGroupMemberKickedData.identity)) continue;
                    groupIdentifier = new GroupV2.Identifier(groupUid, keycloakServer.getServerUrl(), 1);
                    groupLastModificationTimestamp = ContactGroupV2.getLastModificationTimestamp(this.wrapSession(session), ownedIdentity, groupIdentifier);
                    if (groupLastModificationTimestamp == null || groupLastModificationTimestamp > keycloakGroupMemberKickedData.timestamp) continue;
                    this.deleteGroupV2(session, ownedIdentity, groupIdentifier, null);
                }
                catch (JsonProcessingException | IllegalArgumentException | InvalidJwtException e) {
                    Logger.x(e);
                }
            }
        }
        if (signedGroupBlobs != null) {
            for (String signedGroupBlob : signedGroupBlobs) {
                try {
                    claims = jwtConsumer.processToClaims(signedGroupBlob);
                    if (claims == null) continue;
                    String serializedKeycloakGroupBlob = claims.getRawJson();
                    KeycloakGroupBlob keycloakGroupBlob = (KeycloakGroupBlob)this.jsonObjectMapper.readValue(serializedKeycloakGroupBlob, KeycloakGroupBlob.class);
                    UID groupUid2 = new UID(keycloakGroupBlob.bytesGroupUid);
                    GroupV2.Identifier groupIdentifier2 = new GroupV2.Identifier(groupUid2, keycloakServer.getServerUrl(), 1);
                    if (keycloakGroupBlob.timestamp < keycloakCurrentTimestamp - 5184000000L) {
                        Logger.w("Received a signed keycloak group blob with an outdated signature");
                        continue;
                    }
                    this.protocolStarterDelegate.createOrUpdateKeycloakGroupV2(session, ownedIdentity, groupIdentifier2, serializedKeycloakGroupBlob);
                }
                catch (JsonProcessingException | IllegalArgumentException | InvalidJwtException e) {
                    Logger.x(e);
                }
            }
        }
        keycloakServer.setLatestGroupUpdateTimestamp(keycloakCurrentTimestamp);
    }

    @Override
    public void reactivateOwnedIdentityIfNeeded(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && !ownedIdentityObject.isActive()) {
            ContactIdentity[] contactIdentities;
            ownedIdentityObject.setActive(true);
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            try {
                for (UID ownedDeviceUid : this.getOtherDeviceUidsOfOwnedIdentity(session, ownedIdentity)) {
                    this.protocolStarterDelegate.startChannelCreationProtocolWithOwnedDevice(session, ownedIdentity, ownedDeviceUid);
                }
            }
            catch (Exception e) {
                Logger.x(e);
            }
            for (ContactIdentity contactIdentity : contactIdentities = ContactIdentity.getAll(this.wrapSession(session), ownedIdentity)) {
                try {
                    this.protocolStarterDelegate.startDeviceDiscoveryProtocolWithinTransaction(session, ownedIdentity, contactIdentity.getContactIdentity());
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            try {
                this.protocolStarterDelegate.startOwnedDeviceDiscoveryProtocolWithinTransaction(session, ownedIdentity);
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }

    @Override
    public void deactivateOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        ownedIdentityObject.setActive(false);
        OwnedDevice ownedDevice = OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ownedDevice.setTimestamps(null, null);
        ContactDevice.deleteAll(this.wrapSession(session), ownedIdentity);
        this.channelDelegate.deleteAllChannelsForOwnedIdentity(session, ownedIdentity);
    }

    @Override
    public void markOwnedIdentityForDeletion(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            ownedIdentityObject.markForDeletion();
            session.addSessionCommitListener(this.getSessionCommitListenerForDeviceBackup());
        }
    }

    @Override
    public UID[] getDeviceUidsOfOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null) {
            return null;
        }
        return ownedIdentityObject.getAllDeviceUids();
    }

    @Override
    public UID[] getOtherDeviceUidsOfOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject == null) {
            return null;
        }
        return ownedIdentityObject.getOtherDeviceUids();
    }

    @Override
    public UID getCurrentDeviceUidOfOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        UID cachedUid = this.currentDeviceUidCache.get(ownedIdentity);
        if (cachedUid != null) {
            return cachedUid;
        }
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            UID deviceUid = ownedIdentityObject.getCurrentDeviceUid();
            this.currentDeviceUidCache.put(ownedIdentity, deviceUid);
            return deviceUid;
        }
        return null;
    }

    @Override
    public Identity getOwnedIdentityForCurrentDeviceUid(Session session, UID currentDeviceUid) throws SQLException {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), currentDeviceUid);
        if (ownedDevice != null && ownedDevice.isCurrentDevice()) {
            return ownedDevice.getOwnedIdentity();
        }
        return null;
    }

    @Override
    public void addDeviceForOwnedIdentity(Session session, Identity ownedIdentity, UID deviceUid, String displayName, Long expirationTimestamp, Long lastRegistrationTimestamp, PreKeyBlobOnServer preKeyBlob, boolean channelCreationAlreadyInProgress) throws SQLException {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), deviceUid);
        if (ownedDevice != null && !Objects.equals(ownedDevice.getOwnedIdentity(), ownedIdentity)) {
            Logger.e("Error: trying to addDeviceForOwnedIdentity for a deviceUid already used by another identity");
            throw new SQLException();
        }
        if (ownedDevice == null && (ownedDevice = OwnedDevice.createOtherDevice(this.wrapSession(session), deviceUid, ownedIdentity, displayName, expirationTimestamp, lastRegistrationTimestamp, preKeyBlob, channelCreationAlreadyInProgress)) == null) {
            throw new SQLException();
        }
    }

    @Override
    public void updateOwnedDevice(Session session, Identity ownedIdentity, UID deviceUid, String displayName, Long expirationTimestamp, Long lastRegistrationTimestamp, PreKeyBlobOnServer preKeyBlob) throws SQLException {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), deviceUid);
        if (ownedDevice != null && Objects.equals(ownedDevice.getOwnedIdentity(), ownedIdentity)) {
            if (!Objects.equals(displayName, ownedDevice.getDisplayName())) {
                ownedDevice.setDisplayName(displayName);
                session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            }
            if (!Objects.equals(expirationTimestamp, ownedDevice.getExpirationTimestamp()) || !Objects.equals(lastRegistrationTimestamp, ownedDevice.getLastRegistrationTimestamp())) {
                ownedDevice.setTimestamps(expirationTimestamp, lastRegistrationTimestamp);
            }
            if (preKeyBlob == null) {
                if (ownedDevice.getPreKey() != null) {
                    ownedDevice.setPreKey(null);
                }
            } else {
                if (!ownedDevice.hasPreKey() || !Objects.equals(ownedDevice.getPreKey().keyId, preKeyBlob.preKey.keyId)) {
                    ownedDevice.setPreKey(preKeyBlob.preKey);
                }
                if (ownedDevice.getDeviceCapabilities() == null) {
                    ownedDevice.setRawDeviceCapabilities(preKeyBlob.rawDeviceCapabilities);
                }
            }
        }
    }

    @Override
    public void removeDeviceForOwnedIdentity(Session session, Identity ownedIdentity, UID deviceUid) throws SQLException {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), deviceUid);
        if (ownedDevice != null && ownedDevice.getOwnedIdentity().equals(ownedIdentity)) {
            ownedDevice.delete();
        }
    }

    @Override
    public List<ObvOwnedDevice> getDevicesOfOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        List<OwnedDevice> ownedDevices = OwnedDevice.getAllDevicesOfIdentity(this.wrapSession(session), ownedIdentity);
        ArrayList<ObvOwnedDevice> obvOwnedDevices = new ArrayList<ObvOwnedDevice>();
        for (OwnedDevice ownedDevice : ownedDevices) {
            obvOwnedDevices.add(new ObvOwnedDevice(ownedDevice.getOwnedIdentity().getBytes(), ownedDevice.getUid().getBytes(), new ObvOwnedDevice.ServerDeviceInfo(ownedDevice.getDisplayName(), ownedDevice.getExpirationTimestamp(), ownedDevice.getLastRegistrationTimestamp()), ownedDevice.isCurrentDevice(), this.channelDelegate.checkIfObliviousChannelIsConfirmed(session, ownedIdentity, ownedDevice.getUid(), ownedIdentity), ownedDevice.hasPreKey()));
        }
        return obvOwnedDevices;
    }

    @Override
    public List<OwnedDeviceAndPreKey> getDevicesAndPreKeysOfOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        List<OwnedDevice> ownedDevices = OwnedDevice.getAllDevicesOfIdentity(this.wrapSession(session), ownedIdentity);
        ArrayList<OwnedDeviceAndPreKey> ownedDeviceAndPreKeys = new ArrayList<OwnedDeviceAndPreKey>();
        for (OwnedDevice ownedDevice : ownedDevices) {
            ownedDeviceAndPreKeys.add(new OwnedDeviceAndPreKey(ownedDevice.getOwnedIdentity(), ownedDevice.getUid(), ownedDevice.isCurrentDevice(), ownedDevice.getPreKey(), new ObvOwnedDevice.ServerDeviceInfo(ownedDevice.getDisplayName(), ownedDevice.getExpirationTimestamp(), ownedDevice.getLastRegistrationTimestamp())));
        }
        return ownedDeviceAndPreKeys;
    }

    @Override
    public String getCurrentDeviceDisplayName(Session session, Identity ownedIdentity) throws SQLException {
        OwnedDevice device = OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.wrapSession(session), ownedIdentity);
        if (device != null) {
            return device.getDisplayName();
        }
        return null;
    }

    @Override
    public EncodedOwnedPreKey getLatestPreKeyForOwnedIdentity(Session session, Identity ownedIdentity) throws SQLException {
        OwnedPreKey ownedPreKey = OwnedPreKey.getLatest(this.wrapSession(session), ownedIdentity);
        if (ownedPreKey != null) {
            return new EncodedOwnedPreKey(ownedPreKey.getKeyId(), ownedPreKey.getExpirationTimestamp(), ownedPreKey.getEncodedSignedPreKey());
        }
        return null;
    }

    @Override
    public Encoded generateNewPreKey(Session session, Identity ownedIdentity, long expirationTimestamp) throws SQLException {
        OwnedPreKey ownedPreKey;
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        OwnedDevice device = OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null && device != null && (ownedPreKey = OwnedPreKey.create(this.wrapSession(session), ownedIdentity, ownedIdentityObject.getPrivateIdentity(), device.getUid(), expirationTimestamp, this.prng)) != null) {
            return ownedPreKey.getEncodedSignedPreKey();
        }
        return null;
    }

    @Override
    public void expireContactAndOwnedPreKeys(Session session, Identity ownedIdentity, String server, long serverTimestamp) throws SQLException {
        if (ownedIdentity.getServer().equals(server)) {
            List<OwnedDevice> ownedDevices = OwnedDevice.getAllWithExpiredPreKey(this.wrapSession(session), ownedIdentity, serverTimestamp);
            for (OwnedDevice ownedDevice : ownedDevices) {
                ownedDevice.setPreKey(null);
            }
        }
        List<ContactDevice> contactDevices = ContactDevice.getAllWithExpiredPreKey(this.wrapSession(session), ownedIdentity, serverTimestamp);
        for (ContactDevice contactDevice : contactDevices) {
            if (!contactDevice.getContactIdentity().getServer().equals(server)) continue;
            contactDevice.setPreKey(null);
        }
    }

    @Override
    public void expireCurrentDeviceOwnedPreKeys(Session session, Identity ownedIdentity, long currentServerTimestamp) throws SQLException {
        OwnedPreKey.deleteExpired(this.wrapSession(session), ownedIdentity, currentServerTimestamp - 5184000000L);
    }

    @Override
    public long getLatestChannelCreationPingTimestampForOwnedDevice(Session session, Identity ownedIdentity, UID ownedDeviceUid) throws SQLException {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), ownedDeviceUid);
        if (ownedDevice != null && ownedDevice.getOwnedIdentity().equals(ownedIdentity)) {
            return ownedDevice.getLatestChannelCreationPingTimestamp();
        }
        return -1L;
    }

    @Override
    public void setLatestChannelCreationPingTimestampForOwnedDevice(Session session, Identity ownedIdentity, UID ownedDeviceUid, long timestamp) throws Exception {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), ownedDeviceUid);
        if (ownedDevice != null && ownedDevice.getOwnedIdentity().equals(ownedIdentity)) {
            ownedDevice.setLatestChannelCreationPingTimestamp(timestamp);
        }
    }

    @Override
    public void addContactIdentity(Session session, Identity contactIdentity, String serializedDetails, Identity ownedIdentity, TrustOrigin trustOrigin, boolean oneToOne) throws Exception {
        try {
            ContactIdentity contactIdentityObject;
            if (contactIdentity.equals(ownedIdentity)) {
                throw new Exception("Error: trying to add your ownedIdentity as a contact");
            }
            JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto = new JsonIdentityDetailsWithVersionAndPhoto();
            jsonIdentityDetailsWithVersionAndPhoto.setVersion(-1);
            JsonIdentityDetails jsonIdentityDetails = (JsonIdentityDetails)this.jsonObjectMapper.readValue(serializedDetails, JsonIdentityDetails.class);
            jsonIdentityDetailsWithVersionAndPhoto.setIdentityDetails(jsonIdentityDetails);
            boolean contactIsRevoked = false;
            List<KeycloakRevokedIdentity> keycloakRevokedIdentities = KeycloakRevokedIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
            if (keycloakRevokedIdentities != null) {
                for (KeycloakRevokedIdentity keycloakRevokedIdentity : keycloakRevokedIdentities) {
                    if (keycloakRevokedIdentity.getRevocationType() != 0) continue;
                    contactIsRevoked = true;
                    break;
                }
            }
            if ((contactIdentityObject = ContactIdentity.create(this.wrapSession(session), contactIdentity, ownedIdentity, jsonIdentityDetailsWithVersionAndPhoto, trustOrigin, contactIsRevoked, oneToOne)) == null) {
                Logger.w("An error occurred while creating a ContactIdentity.");
                throw new SQLException();
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
        catch (Exception e) {
            Logger.x(e);
            throw new Exception();
        }
    }

    @Override
    public void addTrustOriginToContact(Session session, Identity contactIdentity, Identity ownedIdentity, TrustOrigin trustOrigin, boolean markAsOneToOne) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject == null) {
            Logger.e("Error in addTrustOriginToContact: contactIdentity is not a ContactIdentity of ownedIdentity");
            throw new SQLException();
        }
        contactIdentityObject.addTrustOrigin(trustOrigin);
        if (markAsOneToOne && !contactIdentityObject.isOneToOne()) {
            contactIdentityObject.setOneToOne(true);
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public Identity[] getContactsOfOwnedIdentity(Session session, Identity ownedIdentity) {
        try {
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
            if (ownedIdentityObject != null) {
                ContactIdentity[] contactIdentities = ownedIdentityObject.getContactIdentities();
                Identity[] identities = new Identity[contactIdentities.length];
                for (int i = 0; i < contactIdentities.length; ++i) {
                    identities[i] = contactIdentities[i].getContactIdentity();
                }
                return identities;
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
        return null;
    }

    public ObvContactDeviceCount getContactDeviceCounts(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        int count = 0;
        int established = 0;
        int preKey = 0;
        HashSet<UID> confirmedChannelUids = new HashSet<UID>(Arrays.asList(this.channelDelegate.getConfirmedObliviousChannelDeviceUids(session, ownedIdentity, contactIdentity)));
        for (UidAndPreKey uidAndPreKey : this.getDeviceUidsAndPreKeysOfContactIdentity(session, ownedIdentity, contactIdentity)) {
            ++count;
            if (confirmedChannelUids.contains(uidAndPreKey.uid)) {
                ++established;
                continue;
            }
            if (uidAndPreKey.preKey == null) continue;
            ++preKey;
        }
        return new ObvContactDeviceCount(count, established, preKey);
    }

    public List<ObvContactInfo> getContactsInfoOfOwnedIdentity(Session session, Identity ownedIdentity) throws Exception {
        ContactIdentity[] contactIdentities = ContactIdentity.getAll(this.wrapSession(session), ownedIdentity);
        ArrayList<ObvContactInfo> contactInfos = new ArrayList<ObvContactInfo>();
        for (ContactIdentity contactIdentity : contactIdentities) {
            ContactIdentityDetails trustedDetails = contactIdentity.getTrustedDetails();
            contactInfos.add(new ObvContactInfo(contactIdentity.getOwnedIdentity().getBytes(), contactIdentity.getContactIdentity().getBytes(), trustedDetails.getJsonIdentityDetails(), contactIdentity.isCertifiedByOwnKeycloak(), contactIdentity.isOneToOne(), trustedDetails.getPhotoUrl(), contactIdentity.isActive(), contactIdentity.isRecentlyOnline(), contactIdentity.getTrustLevel().major, this.getContactDeviceCounts(session, ownedIdentity, contactIdentity.getContactIdentity())));
        }
        return contactInfos;
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto trustPublishedContactDetails(Session session, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            JsonIdentityDetailsWithVersionAndPhoto details = contactIdentityObject.trustPublishedDetails();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return details;
        }
        return null;
    }

    @Override
    public void setContactPublishedDetails(Session session, Identity contactIdentity, Identity ownedIdentity, JsonIdentityDetailsWithVersionAndPhoto jsonIdentityDetailsWithVersionAndPhoto, boolean allowDowngrade) throws Exception {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            contactIdentityObject.updatePublishedDetails(jsonIdentityDetailsWithVersionAndPhoto, allowDowngrade);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void setContactDetailsDownloadedPhoto(Session session, Identity contactIdentity, Identity ownedIdentity, int version, byte[] photo) throws Exception {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            contactIdentityObject.setDetailsDownloadedPhotoUrl(version, photo);
        }
    }

    @Override
    public String getSerializedPublishedDetailsOfContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) {
        return ContactIdentity.getSerializedPublishedDetails(this.wrapSession(session), ownedIdentity, contactIdentity);
    }

    @Override
    public JsonIdentityDetails getContactIdentityTrustedDetails(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            return contactIdentityObject.getTrustedDetails().getJsonIdentityDetails();
        }
        return null;
    }

    @Override
    public String getContactTrustedDetailsPhotoUrl(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            return contactIdentityObject.getTrustedDetails().getPhotoUrl();
        }
        return null;
    }

    @Override
    public boolean contactHasUntrustedPublishedDetails(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            return contactIdentityObject.getPublishedDetailsVersion() != contactIdentityObject.getTrustedDetailsVersion();
        }
        return false;
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto[] getContactPublishedAndTrustedDetails(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            JsonIdentityDetailsWithVersionAndPhoto[] res = contactIdentityObject.getPublishedDetailsVersion() == contactIdentityObject.getTrustedDetailsVersion() ? new JsonIdentityDetailsWithVersionAndPhoto[]{contactIdentityObject.getPublishedDetails().getJsonIdentityDetailsWithVersionAndPhoto()} : new JsonIdentityDetailsWithVersionAndPhoto[]{contactIdentityObject.getPublishedDetails().getJsonIdentityDetailsWithVersionAndPhoto(), contactIdentityObject.getTrustedDetails().getJsonIdentityDetailsWithVersionAndPhoto()};
            return res;
        }
        return null;
    }

    @Override
    public boolean isContactIdentityCertifiedByOwnKeycloak(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            return contactIdentityObject.isCertifiedByOwnKeycloak();
        }
        return false;
    }

    @Override
    public void unmarkAllCertifiedByOwnKeycloakContacts(Session session, Identity ownedIdentity) throws SQLException {
        ContactIdentity.unmarkAllCertifiedByOwnKeycloakContacts(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public void reCheckAllCertifiedByOwnKeycloakContacts(Session session, Identity ownedIdentity) throws SQLException {
        for (ContactIdentity contactIdentity : ContactIdentity.getAll(this.wrapSession(session), ownedIdentity)) {
            JsonKeycloakUserDetails jsonKeycloakUserDetails;
            JsonIdentityDetails identityDetails;
            ContactIdentityDetails publishedDetails = contactIdentity.getPublishedDetails();
            if (publishedDetails != null && (identityDetails = publishedDetails.getJsonIdentityDetails()) != null && identityDetails.getSignedUserDetails() != null && (jsonKeycloakUserDetails = this.verifyKeycloakIdentitySignature(session, ownedIdentity, identityDetails.getSignedUserDetails())) != null) {
                try {
                    JsonIdentityDetails certifiedJsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(identityDetails.getSignedUserDetails());
                    contactIdentity.markContactAsCertifiedByOwnKeycloak(certifiedJsonIdentityDetails);
                    continue;
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            if (!contactIdentity.isCertifiedByOwnKeycloak()) continue;
            contactIdentity.setCertifiedByOwnKeycloak(false, null);
        }
    }

    @Override
    public TrustOrigin[] getTrustOriginsOfContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) {
        ContactTrustOrigin[] contactTrustOrigins = ContactTrustOrigin.getAll(this.wrapSession(session), contactIdentity, ownedIdentity);
        TrustOrigin[] trustOrigins = new TrustOrigin[contactTrustOrigins.length];
        for (int i = 0; i < contactTrustOrigins.length; ++i) {
            trustOrigins[i] = contactTrustOrigins[i].getTrustOrigin();
        }
        return trustOrigins;
    }

    @Override
    public TrustLevel getContactTrustLevel(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            return contactIdentityObject.getTrustLevel();
        }
        return null;
    }

    @Override
    public void deleteContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity, boolean failIfGroup) throws Exception {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            if (failIfGroup) {
                byte[][] memberGroupUids = ContactGroupMembersJoin.getGroupOwnerAndUidsOfGroupsContainingContact(this.wrapSession(session), contactIdentity, ownedIdentity);
                if (memberGroupUids.length > 0) {
                    Logger.w("Attempted to delete a contact still member of some groups.");
                    throw new Exception();
                }
                if (ContactGroupV2Member.isContactMemberOfAGroupV2(this.wrapSession(session), ownedIdentity, contactIdentity)) {
                    Logger.w("Attempted to delete a contact still member of some groups v2.");
                    throw new Exception();
                }
            }
            contactIdentityObject.delete();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public byte[][] getGroupOwnerAndUidsOfGroupsOwnedByContact(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        return ContactGroup.getGroupOwnerAndUidsOfGroupsOwnedByContact(this.wrapSession(session), ownedIdentity, contactIdentity);
    }

    @Override
    public boolean isIdentityAnActiveContactOfOwnedIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        return contactIdentityObject != null && contactIdentityObject.isActive();
    }

    @Override
    public boolean isIdentityAContactOfOwnedIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        return contactIdentityObject != null;
    }

    @Override
    public boolean isIdentityAOneToOneContactOfOwnedIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        return contactIdentityObject != null && contactIdentityObject.isOneToOne();
    }

    @Override
    public boolean isIdentityANotOneToOneContactOfOwnedIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        return contactIdentityObject != null && contactIdentityObject.isNotOneToOne();
    }

    @Override
    public void setContactOneToOne(Session session, Identity ownedIdentity, Identity contactIdentity, boolean oneToOne) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null && (oneToOne && !contactIdentityObject.isOneToOne() || !oneToOne && !contactIdentityObject.isNotOneToOne())) {
            contactIdentityObject.setOneToOne(oneToOne);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public EnumSet<ObvContactActiveOrInactiveReason> getContactActiveOrInactiveReasons(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject == null) {
            return null;
        }
        EnumSet<ObvContactActiveOrInactiveReason> reasons = EnumSet.noneOf(ObvContactActiveOrInactiveReason.class);
        if (contactIdentityObject.isRevokedAsCompromised()) {
            reasons.add(ObvContactActiveOrInactiveReason.REVOKED);
        }
        if (contactIdentityObject.isForcefullyTrustedByUser()) {
            reasons.add(ObvContactActiveOrInactiveReason.FORCEFULLY_UNBLOCKED);
        }
        return reasons;
    }

    @Override
    public boolean forcefullyUnblockContact(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject == null) {
            return false;
        }
        contactIdentityObject.setForcefullyTrustedByUser(true);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        return true;
    }

    @Override
    public boolean reBlockForcefullyUnblockedContact(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject == null || !contactIdentityObject.isForcefullyTrustedByUser()) {
            return false;
        }
        try {
            if (contactIdentityObject.isRevokedAsCompromised()) {
                this.channelDelegate.deleteObliviousChannelsWithContact(session, ownedIdentity, contactIdentity);
                this.removeAllDevicesForContactIdentity(session, ownedIdentity, contactIdentity);
            }
            contactIdentityObject.setForcefullyTrustedByUser(false);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return true;
        }
        catch (Exception e) {
            Logger.x(e);
            return false;
        }
    }

    @Override
    public void setContactRecentlyOnline(Session session, Identity ownedIdentity, Identity contactIdentity, boolean recentlyOnline) throws SQLException {
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject != null) {
            contactIdentityObject.setRecentlyOnline(recentlyOnline);
        }
    }

    @Override
    public boolean addDeviceForContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity, UID deviceUid, PreKeyBlobOnServer preKeyBlob, boolean channelCreationAlreadyInProgress) throws SQLException {
        ContactDevice contactDevice;
        ContactIdentity contact = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contact != null && contact.isActive() && (contactDevice = ContactDevice.get(this.wrapSession(session), deviceUid, contactIdentity, ownedIdentity)) == null) {
            contactDevice = ContactDevice.create(this.wrapSession(session), deviceUid, contactIdentity, ownedIdentity, preKeyBlob, channelCreationAlreadyInProgress);
            if (contactDevice == null) {
                throw new SQLException();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isContactDeviceKnown(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws SQLException {
        return ContactDevice.exists(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity);
    }

    @Override
    public void updateContactDevicePreKey(Session session, Identity ownedIdentity, Identity contactIdentity, UID deviceUid, PreKeyBlobOnServer preKeyBlob) throws SQLException {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), deviceUid, contactIdentity, ownedIdentity);
        if (contactDevice != null) {
            contactDevice.setPreKey(preKeyBlob);
        }
    }

    @Override
    public void removeDeviceForContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity, UID deviceUid) throws SQLException {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), deviceUid, contactIdentity, ownedIdentity);
        if (contactDevice != null) {
            contactDevice.delete();
        }
    }

    @Override
    public void removeAllDevicesForContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactDevice[] contactDevices;
        for (ContactDevice contactDevice : contactDevices = ContactDevice.getAll(this.wrapSession(session), contactIdentity, ownedIdentity)) {
            contactDevice.delete();
        }
    }

    @Override
    public UID[] getDeviceUidsOfContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) {
        try {
            ContactDevice[] contactDevices = ContactDevice.getAll(this.wrapSession(session), contactIdentity, ownedIdentity);
            UID[] uids = new UID[contactDevices.length];
            for (int i = 0; i < contactDevices.length; ++i) {
                uids[i] = contactDevices[i].getUid();
            }
            return uids;
        }
        catch (SQLException e) {
            Logger.x(e);
            return new UID[0];
        }
    }

    @Override
    public List<UidAndPreKey> getDeviceUidsAndPreKeysOfContactIdentity(Session session, Identity ownedIdentity, Identity contactIdentity) {
        try {
            ContactDevice[] contactDevices;
            ArrayList<UidAndPreKey> uids = new ArrayList<UidAndPreKey>();
            for (ContactDevice contactDevice : contactDevices = ContactDevice.getAll(this.wrapSession(session), contactIdentity, ownedIdentity)) {
                uids.add(new UidAndPreKey(contactDevice.getUid(), contactDevice.getPreKey()));
            }
            return uids;
        }
        catch (SQLException e) {
            Logger.x(e);
            return Collections.emptyList();
        }
    }

    @Override
    public Map<Identity, Map<Identity, Set<UID>>> getAllDeviceUidsOfAllContactsOfAllOwnedIdentities(Session session) throws SQLException {
        ContactDevice[] contactDevices;
        HashMap<Identity, Map<Identity, Set<UID>>> output = new HashMap<Identity, Map<Identity, Set<UID>>>();
        for (ContactDevice contactDevice : contactDevices = ContactDevice.getAll(this.wrapSession(session))) {
            Set<UID> contactDeviceUids;
            Map<Identity, Set<UID>> ownedIdentityMap = output.get(contactDevice.getOwnedIdentity());
            if (ownedIdentityMap == null) {
                ownedIdentityMap = new HashMap<Identity, Set<UID>>();
                output.put(contactDevice.getOwnedIdentity(), ownedIdentityMap);
            }
            if ((contactDeviceUids = ownedIdentityMap.get(contactDevice.getContactIdentity())) == null) {
                contactDeviceUids = new HashSet<UID>();
                ownedIdentityMap.put(contactDevice.getContactIdentity(), contactDeviceUids);
            }
            contactDeviceUids.add(contactDevice.getUid());
        }
        return output;
    }

    @Override
    public long getLatestChannelCreationPingTimestampForContactDevice(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws SQLException {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity);
        if (contactDevice != null) {
            return contactDevice.getLatestChannelCreationPingTimestamp();
        }
        return -1L;
    }

    @Override
    public void setLatestChannelCreationPingTimestampForContactDevice(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid, long timestamp) throws Exception {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity);
        if (contactDevice != null) {
            contactDevice.setLatestChannelCreationPingTimestamp(timestamp);
        }
    }

    @Override
    public List<ObvCapability> getContactCapabilities(Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            List<ObvCapability> list = this.getContactCapabilities(identityManagerSession, ownedIdentity, contactIdentity);
            return list;
        }
    }

    private List<ObvCapability> getContactCapabilities(IdentityManagerSession identityManagerSession, Identity ownedIdentity, Identity contactIdentity) throws SQLException {
        ContactDevice[] contactDevices = ContactDevice.getAll(identityManagerSession, contactIdentity, ownedIdentity);
        HashSet<ObvCapability> contactCapabilities = null;
        for (ContactDevice contactDevice : contactDevices) {
            List<ObvCapability> deviceCapabilities = contactDevice.getDeviceCapabilities();
            if (deviceCapabilities == null) continue;
            if (deviceCapabilities.isEmpty()) {
                return new ArrayList<ObvCapability>();
            }
            if (contactCapabilities == null) {
                contactCapabilities = new HashSet<ObvCapability>(deviceCapabilities);
                continue;
            }
            contactCapabilities.retainAll(deviceCapabilities);
            if (!contactCapabilities.isEmpty()) continue;
            return new ArrayList<ObvCapability>();
        }
        if (contactCapabilities == null) {
            return new ArrayList<ObvCapability>();
        }
        return new ArrayList<ObvCapability>(contactCapabilities);
    }

    @Override
    public String[] getContactDeviceCapabilities(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid) throws SQLException {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity);
        if (contactDevice != null) {
            return contactDevice.getRawDeviceCapabilities();
        }
        return new String[0];
    }

    @Override
    public void setContactDeviceCapabilities(Session session, Identity ownedIdentity, Identity contactIdentity, UID contactDeviceUid, String[] rawDeviceCapabilities) throws Exception {
        ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), contactDeviceUid, contactIdentity, ownedIdentity);
        if (contactDevice == null) {
            throw new Exception();
        }
        contactDevice.setRawDeviceCapabilities(rawDeviceCapabilities);
    }

    @Override
    public List<ObvCapability> getOwnCapabilities(Identity ownedIdentity) throws SQLException {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            OwnedDevice[] ownedDevices;
            HashSet<ObvCapability> ownCapabilities = new HashSet<ObvCapability>(ObvCapability.currentCapabilities);
            for (OwnedDevice ownedDevice : ownedDevices = OwnedDevice.getOtherDevicesOfOwnedIdentity(identityManagerSession, ownedIdentity)) {
                List<ObvCapability> deviceCapabilities = ownedDevice.getDeviceCapabilities();
                if (deviceCapabilities == null) continue;
                if (deviceCapabilities.isEmpty()) {
                    ArrayList<ObvCapability> arrayList = new ArrayList<ObvCapability>();
                    return arrayList;
                }
                ownCapabilities.retainAll(deviceCapabilities);
                if (!ownCapabilities.isEmpty()) continue;
                ArrayList<ObvCapability> arrayList = new ArrayList<ObvCapability>();
                return arrayList;
            }
            ArrayList<ObvCapability> arrayList = new ArrayList<ObvCapability>(ownCapabilities);
            return arrayList;
        }
    }

    @Override
    public List<ObvCapability> getCurrentDevicePublishedCapabilities(Session session, Identity ownedIdentity) throws Exception {
        OwnedDevice ownedDevice = OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ArrayList capabilities = ownedDevice.getDeviceCapabilities();
        return capabilities == null ? new ArrayList() : capabilities;
    }

    @Override
    public void setCurrentDevicePublishedCapabilities(Session session, Identity ownedIdentity, List<ObvCapability> capabilities) throws Exception {
        OwnedDevice ownedDevice = OwnedDevice.getCurrentDeviceOfOwnedIdentity(this.wrapSession(session), ownedIdentity);
        ownedDevice.setRawDeviceCapabilities(ObvCapability.capabilityListToStringArray(capabilities));
    }

    @Override
    public String[] getOtherOwnedDeviceCapabilities(Session session, Identity ownedIdentity, UID otherDeviceUid) throws Exception {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), otherDeviceUid);
        if (ownedDevice == null || !ownedDevice.getOwnedIdentity().equals(ownedIdentity)) {
            throw new Exception();
        }
        return ownedDevice.getRawDeviceCapabilities();
    }

    @Override
    public void setOtherOwnedDeviceCapabilities(Session session, Identity ownedIdentity, UID otherOwnedDeviceUID, String[] rawDeviceCapabilities) throws Exception {
        OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), otherOwnedDeviceUID);
        if (ownedDevice == null || !ownedDevice.getOwnedIdentity().equals(ownedIdentity)) {
            throw new Exception();
        }
        ownedDevice.setRawDeviceCapabilities(rawDeviceCapabilities);
    }

    @Override
    public Seed getDeterministicSeedForOwnedIdentity(Identity ownedIdentity, byte[] diversificationTag) throws Exception {
        if (diversificationTag.length == 0) {
            throw new Exception();
        }
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
            if (ownedIdentity == null) {
                throw new SQLException("OwnedIdentity not found");
            }
            PrivateIdentity privateIdentity = ownedIdentityObject.getPrivateIdentity();
            Seed seed = privateIdentity.getDeterministicSeedForOwnedIdentity(diversificationTag);
            return seed;
        }
    }

    @Override
    public byte[] signIdentities(Session session, Constants.SignatureContext signatureContext, Identity[] identities, Identity ownedIdentity, PRNGService prng) throws Exception {
        try {
            IdentityManagerSession identityManagerSession = this.wrapSession(session);
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
            if (ownedIdentityObject == null) {
                throw new Exception("Unknown owned identity");
            }
            PrivateIdentity privateIdentity = ownedIdentityObject.getPrivateIdentity();
            SignaturePublicKey signaturePublicKey = ownedIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            SignaturePrivateKey signaturePrivateKey = privateIdentity.getServerAuthenticationPrivateKey().getSignaturePrivateKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            for (Identity identity : identities) {
                baos.write(identity.getBytes());
            }
            byte[] padding = prng.bytes(16);
            baos.write(padding);
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signature = Suite.getSignature(signaturePrivateKey);
            byte[] signatureBytes = signature.sign(signaturePrivateKey, signaturePublicKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public byte[] signChannel(Session session, Constants.SignatureContext signatureContext, Identity contactIdentity, UID contactDeviceUid, Identity ownedIdentity, UID ownedDeviceUid, PRNGService prng) throws Exception {
        try {
            IdentityManagerSession identityManagerSession = this.wrapSession(session);
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
            if (ownedIdentityObject == null) {
                throw new Exception("Unknown owned identity");
            }
            PrivateIdentity privateIdentity = ownedIdentityObject.getPrivateIdentity();
            SignaturePublicKey signaturePublicKey = ownedIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            SignaturePrivateKey signaturePrivateKey = privateIdentity.getServerAuthenticationPrivateKey().getSignaturePrivateKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            baos.write(contactDeviceUid.getBytes());
            baos.write(ownedDeviceUid.getBytes());
            baos.write(contactIdentity.getBytes());
            baos.write(ownedIdentity.getBytes());
            byte[] padding = prng.bytes(16);
            baos.write(padding);
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signature = Suite.getSignature(signaturePrivateKey);
            byte[] signatureBytes = signature.sign(signaturePrivateKey, signaturePublicKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public byte[] signBlock(Session session, Constants.SignatureContext signatureContext, byte[] block, Identity ownedIdentity, PRNGService prng) throws Exception {
        try {
            IdentityManagerSession identityManagerSession = this.wrapSession(session);
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
            if (ownedIdentityObject == null) {
                throw new Exception("Unknown owned identity");
            }
            PrivateIdentity privateIdentity = ownedIdentityObject.getPrivateIdentity();
            SignaturePublicKey signaturePublicKey = ownedIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            SignaturePrivateKey signaturePrivateKey = privateIdentity.getServerAuthenticationPrivateKey().getSignaturePrivateKey();
            byte[] prefix = Constants.getSignatureChallengePrefix(signatureContext);
            byte[] padding = prng.bytes(16);
            byte[] challenge = new byte[prefix.length + block.length + 16];
            System.arraycopy(prefix, 0, challenge, 0, prefix.length);
            System.arraycopy(block, 0, challenge, prefix.length, block.length);
            System.arraycopy(padding, 0, challenge, prefix.length + block.length, 16);
            Signature signature = Suite.getSignature(signaturePrivateKey);
            byte[] signatureBytes = signature.sign(signaturePrivateKey, signaturePublicKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public byte[] signGroupInvitationNonce(Session session, Constants.SignatureContext signatureContext, GroupV2.Identifier groupIdentifier, byte[] nonce, Identity contactIdentity, Identity ownedIdentity, PRNGService prng) throws Exception {
        try {
            IdentityManagerSession identityManagerSession = this.wrapSession(session);
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(identityManagerSession, ownedIdentity);
            if (ownedIdentityObject == null) {
                throw new Exception("Unknown owned identity");
            }
            PrivateIdentity privateIdentity = ownedIdentityObject.getPrivateIdentity();
            SignaturePublicKey signaturePublicKey = ownedIdentity.getServerAuthenticationPublicKey().getSignaturePublicKey();
            SignaturePrivateKey signaturePrivateKey = privateIdentity.getServerAuthenticationPrivateKey().getSignaturePrivateKey();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(Constants.getSignatureChallengePrefix(signatureContext));
            baos.write(groupIdentifier.getBytes());
            baos.write(nonce);
            if (contactIdentity != null) {
                baos.write(contactIdentity.getBytes());
            }
            byte[] padding = prng.bytes(16);
            baos.write(padding);
            byte[] challenge = baos.toByteArray();
            baos.close();
            Signature signature = Suite.getSignature(signaturePrivateKey);
            byte[] signatureBytes = signature.sign(signaturePrivateKey, signaturePublicKey, challenge, prng);
            byte[] output = new byte[16 + signatureBytes.length];
            System.arraycopy(padding, 0, output, 0, 16);
            System.arraycopy(signatureBytes, 0, output, 16, signatureBytes.length);
            return output;
        }
        catch (InvalidKeyException e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public void createContactGroup(Session session, Identity ownedIdentity, GroupInformation groupInformation, Identity[] groupMembers, IdentityWithSerializedDetails[] pendingGroupMembers, boolean createdByMeOnOtherDevice) throws Exception {
        for (Identity groupMember : groupMembers) {
            if (this.isIdentityAContactOfOwnedIdentity(session, ownedIdentity, groupMember)) continue;
            Logger.e("Error in createContactGroup: a GroupMember is not a Contact.");
            throw new Exception();
        }
        IdentityManagerSession identityManagerSession = this.wrapSession(session);
        ContactGroup.create(identityManagerSession, groupInformation.getGroupOwnerAndUid(), ownedIdentity, groupInformation.serializedGroupDetailsWithVersionAndPhoto, groupInformation.groupOwnerIdentity.equals(ownedIdentity) ? null : groupInformation.groupOwnerIdentity, createdByMeOnOtherDevice);
        for (Identity identity : groupMembers) {
            ContactGroupMembersJoin.create(identityManagerSession, groupInformation.getGroupOwnerAndUid(), ownedIdentity, identity);
        }
        for (Comparable<Identity> comparable : pendingGroupMembers) {
            PendingGroupMember.create(identityManagerSession, groupInformation.getGroupOwnerAndUid(), ownedIdentity, ((IdentityWithSerializedDetails)comparable).identity, ((IdentityWithSerializedDetails)comparable).serializedDetails);
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void leaveGroup(Session session, byte[] groupOwnerAndUid, Identity ownedIdentity) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in leaveGroup: group not found");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() == null) {
            Logger.e("Error in leaveGroup: you are the group owner");
            throw new Exception();
        }
        contactGroup.delete();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void deleteGroup(Session session, byte[] groupUid, Identity ownedIdentity) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in deleteGroup: group not found");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in deleteGroup: you are not the group owner");
            throw new Exception();
        }
        contactGroup.delete();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void addPendingMembersToGroup(Session session, byte[] groupUid, Identity ownedIdentity, Identity[] contactIdentities, GroupMembersChangedCallback groupMembersChangedCallback) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in addPendingMembersToGroup: ContactGroup not found.");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in addPendingMembersToGroup: you are not the owner of the group.");
            throw new Exception();
        }
        Group group = this.getGroup(session, ownedIdentity, groupUid);
        for (Identity contactIdentity : contactIdentities) {
            if (!this.isIdentityAContactOfOwnedIdentity(session, ownedIdentity, contactIdentity)) {
                Logger.e("Error in addPendingMembersToGroup: contactIdentity is not a Contact.");
                throw new Exception();
            }
            if (!group.isMember(contactIdentity) && !group.isPendingMember(contactIdentity)) continue;
            Logger.e("Error in addPendingMembersToGroup: contactIdentity is already in group.");
            throw new Exception();
        }
        if (!session.isInTransaction()) {
            Logger.e("Called addPendingMembersToGroup outside a transaction");
            throw new Exception();
        }
        for (Identity contactIdentity : contactIdentities) {
            String contactSerializedDetails = this.getSerializedPublishedDetailsOfContactIdentity(session, ownedIdentity, contactIdentity);
            PendingGroupMember.create(this.wrapSession(session), groupUid, ownedIdentity, contactIdentity, contactSerializedDetails);
        }
        contactGroup.incrementGroupMembersVersion();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        if (groupMembersChangedCallback != null) {
            groupMembersChangedCallback.callback();
        }
    }

    @Override
    public void removeMembersAndPendingFromGroup(Session session, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity[] contactIdentities, GroupMembersChangedCallback groupMembersChangedCallback) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in removeMembersAndPendingFromGroup: ContactGroup not found.");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in removeMembersAndPendingFromGroup: you are not the owner of the group.");
            throw new Exception();
        }
        Group group = this.getGroup(session, ownedIdentity, groupOwnerAndUid);
        for (Identity contactIdentity : contactIdentities) {
            if (group.isMember(contactIdentity) || group.isPendingMember(contactIdentity)) continue;
            Logger.e("Error in removeMembersAndPendingFromGroup: contactIdentity is not member or pending.");
            throw new Exception();
        }
        if (!session.isInTransaction()) {
            Logger.e("Called removeMembersAndPendingFromGroup outside a transaction");
            throw new Exception();
        }
        for (Identity contactIdentity : contactIdentities) {
            ContactGroupMembersJoin contactGroupMembersJoin;
            PendingGroupMember pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity);
            if (pendingGroupMember != null) {
                pendingGroupMember.delete();
            }
            if ((contactGroupMembersJoin = ContactGroupMembersJoin.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity)) == null) continue;
            contactGroupMembersJoin.delete();
        }
        contactGroup.incrementGroupMembersVersion();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        if (groupMembersChangedCallback != null) {
            groupMembersChangedCallback.callback();
        }
    }

    @Override
    public void addGroupMemberFromPendingMember(Session session, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity, GroupMembersChangedCallback groupMembersChangedCallback) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in addGroupMemberFromPendingMember: ContactGroup not found.");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in addGroupMemberFromPendingMember: you are not the owner of the group.");
            throw new Exception();
        }
        if (!this.isIdentityAContactOfOwnedIdentity(session, ownedIdentity, contactIdentity)) {
            Logger.e("Error in addGroupMemberFromPendingMember: contactIdentity is not a Contact.");
            throw new Exception();
        }
        if (!session.isInTransaction()) {
            Logger.e("Called addGroupMemberFromPendingMember outside a transaction");
            throw new Exception();
        }
        PendingGroupMember pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity);
        if (pendingGroupMember != null) {
            pendingGroupMember.delete();
        }
        ContactGroupMembersJoin.create(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity);
        contactGroup.incrementGroupMembersVersion();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        if (groupMembersChangedCallback != null) {
            groupMembersChangedCallback.callback();
        }
    }

    @Override
    public void demoteGroupMemberToDeclinedPendingMember(Session session, byte[] groupOwnerAndUid, Identity ownedIdentity, Identity contactIdentity, GroupMembersChangedCallback groupMembersChangedCallback) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in demoteGroupMemberToDeclinedPendingMember: ContactGroup not found.");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in demoteGroupMemberToDeclinedPendingMember: you are not the owner of the group.");
            throw new Exception();
        }
        ContactIdentity contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, contactIdentity);
        if (contactIdentityObject == null) {
            Logger.e("Error in demoteGroupMemberToDeclinedPendingMember: contactIdentity is not a Contact.");
            throw new Exception();
        }
        if (!session.isInTransaction()) {
            Logger.e("Called demoteGroupMemberToDeclinedPendingMember outside a transaction");
            throw new Exception();
        }
        ContactGroupMembersJoin contactGroupMembersJoin = ContactGroupMembersJoin.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity);
        if (contactGroupMembersJoin != null) {
            contactGroupMembersJoin.delete();
        }
        PendingGroupMember pendingGroupMember = PendingGroupMember.create(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity, contactIdentityObject.getPublishedDetails().getSerializedJsonDetails());
        pendingGroupMember.setDeclined(true);
        contactGroup.incrementGroupMembersVersion();
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        if (groupMembersChangedCallback != null) {
            groupMembersChangedCallback.callback();
        }
    }

    @Override
    public void setPendingMemberDeclined(Session session, byte[] groupUid, Identity ownedIdentity, Identity contactIdentity, boolean declined) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupUid, ownedIdentity);
        if (contactGroup == null) {
            Logger.e("Error in setPendingMemberDeclined: ContactGroup not found.");
            throw new Exception();
        }
        if (contactGroup.getGroupOwner() != null) {
            Logger.e("Error in setPendingMemberDeclined: you are not the groupOwner.");
            throw new Exception();
        }
        PendingGroupMember pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupUid, ownedIdentity, contactIdentity);
        if (pendingGroupMember != null) {
            pendingGroupMember.setDeclined(declined);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void updateGroupMembersAndDetails(Session session, Identity ownedIdentity, GroupInformation groupInformation, HashSet<IdentityWithSerializedDetails> groupMembers, HashSet<IdentityWithSerializedDetails> pendingMembers, long membersVersion) throws Exception {
        if (!session.isInTransaction()) {
            Logger.e("Calling updateGroupMembersAndDetails from outside a transaction");
            throw new Exception();
        }
        boolean iAmTheGroupOwner = ownedIdentity.equals(groupInformation.groupOwnerIdentity);
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity);
        if (contactGroup == null) {
            Logger.w("Error: in updateGroupMembersAndDetails, group not found");
            throw new Exception();
        }
        JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.jsonObjectMapper.readValue(groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
        if (contactGroup.updatePublishedDetails(jsonGroupDetailsWithVersionAndPhoto, false)) {
            if (iAmTheGroupOwner) {
                contactGroup.trustPublishedDetails();
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
        if (contactGroup.getGroupMembersVersion() < membersVersion) {
            PendingGroupMember pendingGroupMember;
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            contactGroup.setGroupMembersVersion(membersVersion);
            Group group = this.getGroup(session, ownedIdentity, groupInformation.getGroupOwnerAndUid());
            if (group == null) {
                Logger.e("A ContactGroup exists but getGroup returned null");
                throw new Exception();
            }
            HashSet<Identity> oldMembers = new HashSet<Identity>(Arrays.asList(group.getGroupMembers()));
            HashSet<IdentityWithSerializedDetails> oldPendings = new HashSet<IdentityWithSerializedDetails>(Arrays.asList(group.getPendingGroupMembers()));
            for (IdentityWithSerializedDetails groupMember : groupMembers) {
                ContactIdentity contactIdentityObject;
                if (groupMember.identity.equals(ownedIdentity)) continue;
                if (oldMembers.contains(groupMember.identity)) {
                    oldMembers.remove(groupMember.identity);
                    continue;
                }
                pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity, groupMember.identity);
                if (pendingGroupMember != null) {
                    pendingGroupMember.delete();
                    oldPendings.remove(groupMember);
                }
                if ((contactIdentityObject = ContactIdentity.get(this.wrapSession(session), ownedIdentity, groupMember.identity)) == null) {
                    if (ownedIdentity.equals(groupInformation.groupOwnerIdentity)) {
                        this.addContactIdentity(session, groupMember.identity, groupMember.serializedDetails, ownedIdentity, null, false);
                    } else {
                        this.addContactIdentity(session, groupMember.identity, groupMember.serializedDetails, ownedIdentity, TrustOrigin.createGroupTrustOrigin(System.currentTimeMillis(), groupInformation.groupOwnerIdentity), false);
                    }
                } else if (!ownedIdentity.equals(groupInformation.groupOwnerIdentity)) {
                    this.addTrustOriginToContact(session, groupMember.identity, ownedIdentity, TrustOrigin.createGroupTrustOrigin(System.currentTimeMillis(), groupInformation.groupOwnerIdentity), false);
                }
                ContactGroupMembersJoin.create(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity, groupMember.identity);
            }
            for (Identity oldMember : oldMembers) {
                ContactGroupMembersJoin contactGroupMembersJoin = ContactGroupMembersJoin.get(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity, oldMember);
                if (contactGroupMembersJoin == null) continue;
                contactGroupMembersJoin.delete();
            }
            for (IdentityWithSerializedDetails pendingMember : pendingMembers) {
                if (oldPendings.contains(pendingMember)) {
                    oldPendings.remove(pendingMember);
                    continue;
                }
                PendingGroupMember.create(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity, pendingMember.identity, pendingMember.serializedDetails);
            }
            for (IdentityWithSerializedDetails oldPending : oldPendings) {
                pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity, oldPending.identity);
                if (pendingGroupMember == null) continue;
                pendingGroupMember.delete();
            }
        }
    }

    @Override
    public void resetGroupMembersAndPublishedDetailsVersions(Session session, Identity ownedIdentity, GroupInformation groupInformation) throws Exception {
        if (!session.isInTransaction()) {
            Logger.e("Calling resetGroupMembersAndPublishedDetailsVersions from outside a transaction");
            throw new Exception();
        }
        if (ownedIdentity.equals(groupInformation.groupOwnerIdentity)) {
            Logger.w("Error: in resetGroupMembersAndPublishedDetailsVersions, group is owned");
            throw new Exception();
        }
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupInformation.getGroupOwnerAndUid(), ownedIdentity);
        if (contactGroup == null) {
            Logger.w("Error: in resetGroupMembersAndPublishedDetailsVersions, group not found");
            throw new Exception();
        }
        JsonGroupDetailsWithVersionAndPhoto jsonGroupDetailsWithVersionAndPhoto = (JsonGroupDetailsWithVersionAndPhoto)this.jsonObjectMapper.readValue(groupInformation.serializedGroupDetailsWithVersionAndPhoto, JsonGroupDetailsWithVersionAndPhoto.class);
        contactGroup.updatePublishedDetails(jsonGroupDetailsWithVersionAndPhoto, true);
        contactGroup.setGroupMembersVersion(0L);
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void forcefullyRemoveMemberOrPendingFromJoinedGroup(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, Identity contactIdentity) throws SQLException {
        ContactGroupMembersJoin contactGroupMembersJoin;
        PendingGroupMember pendingGroupMember = PendingGroupMember.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity);
        if (pendingGroupMember != null) {
            pendingGroupMember.delete();
        }
        if ((contactGroupMembersJoin = ContactGroupMembersJoin.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity, contactIdentity)) != null) {
            contactGroupMembersJoin.delete();
        }
    }

    @Override
    public GroupWithDetails[] getGroupsForOwnedIdentity(Session session, Identity ownedIdentity) throws Exception {
        ContactGroup[] contactGroups = ContactGroup.getAllForIdentity(this.wrapSession(session), ownedIdentity);
        GroupWithDetails[] groups = new GroupWithDetails[contactGroups.length];
        for (int i = 0; i < contactGroups.length; ++i) {
            groups[i] = new GroupWithDetails(contactGroups[i].getGroupOwnerAndUid(), ownedIdentity, ContactGroupMembersJoin.getContactIdentitiesInGroup(this.wrapSession(session), contactGroups[i].getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getPendingMembersInGroup(this.wrapSession(session), contactGroups[i].getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getDeclinedPendingMembersInGroup(this.wrapSession(session), contactGroups[i].getGroupOwnerAndUid(), ownedIdentity), contactGroups[i].getGroupOwner(), contactGroups[i].getGroupMembersVersion(), contactGroups[i].getPublishedDetails().getJsonGroupDetails(), contactGroups[i].getLatestOrTrustedDetails().getJsonGroupDetails(), contactGroups[i].getLatestOrTrustedDetails().getVersion() != contactGroups[i].getPublishedDetails().getVersion());
        }
        return groups;
    }

    @Override
    public Group getGroup(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws Exception {
        if (ownedIdentity == null || groupOwnerAndUid == null) {
            return null;
        }
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            return null;
        }
        return new Group(contactGroup.getGroupOwnerAndUid(), ownedIdentity, ContactGroupMembersJoin.getContactIdentitiesInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getPendingMembersInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getDeclinedPendingMembersInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), contactGroup.getGroupOwner(), contactGroup.getGroupMembersVersion());
    }

    @Override
    public GroupWithDetails getGroupWithDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws Exception {
        if (ownedIdentity == null || groupOwnerAndUid == null) {
            return null;
        }
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            return null;
        }
        return new GroupWithDetails(contactGroup.getGroupOwnerAndUid(), ownedIdentity, ContactGroupMembersJoin.getContactIdentitiesInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getPendingMembersInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), PendingGroupMember.getDeclinedPendingMembersInGroup(this.wrapSession(session), contactGroup.getGroupOwnerAndUid(), ownedIdentity), contactGroup.getGroupOwner(), contactGroup.getGroupMembersVersion(), contactGroup.getPublishedDetails().getJsonGroupDetails(), contactGroup.getLatestOrTrustedDetails().getJsonGroupDetails(), contactGroup.getPublishedDetails().getVersion() != contactGroup.getLatestOrTrustedDetails().getVersion());
    }

    @Override
    public GroupInformation getGroupInformation(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws Exception {
        if (ownedIdentity == null || groupOwnerAndUid == null) {
            return null;
        }
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup == null) {
            return null;
        }
        return contactGroup.getGroupInformation();
    }

    @Override
    public JsonGroupDetailsWithVersionAndPhoto[] getGroupPublishedAndLatestOrTrustedDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws SQLException {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            JsonGroupDetailsWithVersionAndPhoto[] res = contactGroup.getPublishedDetailsVersion() == contactGroup.getLatestOrTrustedDetailsVersion() ? new JsonGroupDetailsWithVersionAndPhoto[]{contactGroup.getPublishedDetails().getJsonGroupDetailsWithVersionAndPhoto()} : new JsonGroupDetailsWithVersionAndPhoto[]{contactGroup.getPublishedDetails().getJsonGroupDetailsWithVersionAndPhoto(), contactGroup.getLatestOrTrustedDetails().getJsonGroupDetailsWithVersionAndPhoto()};
            return res;
        }
        return null;
    }

    @Override
    public String getGroupPhotoUrl(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws SQLException {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            if (contactGroup.getGroupOwner() == null) {
                return contactGroup.getPublishedDetails().getPhotoUrl();
            }
            return contactGroup.getLatestOrTrustedDetails().getPhotoUrl();
        }
        return null;
    }

    @Override
    public JsonGroupDetailsWithVersionAndPhoto trustPublishedGroupDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws SQLException {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            JsonGroupDetailsWithVersionAndPhoto details = contactGroup.trustPublishedDetails();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return details;
        }
        return null;
    }

    @Override
    public void updateLatestGroupDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, JsonGroupDetails jsonGroupDetails) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            contactGroup.setLatestDetails(jsonGroupDetails);
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        }
    }

    @Override
    public void setOwnedGroupDetailsServerLabelAndKey(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, int version, UID photoServerLabel, AuthEncKey photoServerKey) throws Exception {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            contactGroup.setPhotoLabelAndKey(version, photoServerLabel, photoServerKey);
            if (ServerUserData.createForOwnedGroupDetails(this.wrapSession(session), ownedIdentity, photoServerLabel, groupOwnerAndUid) == null) {
                throw new SQLException();
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        }
    }

    @Override
    public void createGroupV1ServerUserData(Session session, Identity ownedIdentity, UID photoServerLabel, byte[] groupOwnerAndUid) throws SQLException {
        if (ServerUserData.createForOwnedGroupDetails(this.wrapSession(session), ownedIdentity, photoServerLabel, groupOwnerAndUid) == null) {
            throw new SQLException();
        }
    }

    @Override
    public void updateOwnedGroupPhoto(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, String absolutePhotoUrl, boolean partOfGroupCreation) throws Exception {
        ContactGroup group = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (group != null) {
            group.setOwnedGroupPhoto(absolutePhotoUrl, partOfGroupCreation);
        }
    }

    @Override
    public void setContactGroupDownloadedPhoto(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid, int version, byte[] photo) throws Exception {
        ContactGroup group = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (group != null) {
            group.setDetailsDownloadedPhotoUrl(version, photo);
        }
    }

    @Override
    public int publishLatestGroupDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws SQLException {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return contactGroup.publishLatestDetails();
        }
        return -1;
    }

    @Override
    public void discardLatestGroupDetails(Session session, Identity ownedIdentity, byte[] groupOwnerAndUid) throws SQLException {
        ContactGroup contactGroup = ContactGroup.get(this.wrapSession(session), groupOwnerAndUid, ownedIdentity);
        if (contactGroup != null) {
            contactGroup.discardLatestDetails();
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        }
    }

    @Override
    public byte[][] getGroupOwnerAndUidOfGroupsWhereContactIsPending(Session session, Identity contactIdentity, Identity ownedIdentity) {
        return PendingGroupMember.getGroupOwnerAndUidOfGroupsWhereContactIsPending(this.wrapSession(session), contactIdentity, ownedIdentity, false);
    }

    @Override
    public byte[][] getGroupOwnerAndUidsOfGroupsContainingContact(Session session, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        return ContactGroupMembersJoin.getGroupOwnerAndUidsOfGroupsContainingContact(this.wrapSession(session), contactIdentity, ownedIdentity);
    }

    @Override
    public void refreshMembersOfGroupsOwnedByGroupOwner(UID currentDeviceUid, Identity groupOwner) {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            byte[][] groupOwnerAndUids;
            OwnedDevice ownedDevice = OwnedDevice.get(identityManagerSession, currentDeviceUid);
            if (ownedDevice == null || !ownedDevice.isCurrentDevice()) {
                return;
            }
            Identity ownedIdentity = ownedDevice.getOwnedIdentity();
            for (byte[] groupOwnerAndUid : groupOwnerAndUids = ContactGroup.getGroupOwnerAndUidsOfGroupsOwnedByContact(identityManagerSession, ownedIdentity, groupOwner)) {
                try {
                    this.protocolStarterDelegate.queryGroupMembers(groupOwnerAndUid, ownedIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void pushMembersOfOwnedGroupsToContact(UID currentDeviceUid, Identity contactIdentity) {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            byte[][] groupOwnerAndUids;
            OwnedDevice ownedDevice = OwnedDevice.get(identityManagerSession, currentDeviceUid);
            if (ownedDevice == null || !ownedDevice.isCurrentDevice()) {
                return;
            }
            Identity ownedIdentity = ownedDevice.getOwnedIdentity();
            for (byte[] groupOwnerAndUid : groupOwnerAndUids = ContactGroup.getGroupOwnerAndUidsOfOwnedGroupsWithContact(identityManagerSession, ownedIdentity, contactIdentity)) {
                try {
                    this.protocolStarterDelegate.reinviteAndPushMembersToContact(groupOwnerAndUid, ownedIdentity, contactIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            for (byte[] groupOwnerAndUid : groupOwnerAndUids = PendingGroupMember.getGroupOwnerAndUidOfGroupsWhereContactIsPending(identityManagerSession, contactIdentity, ownedIdentity, true)) {
                try {
                    this.protocolStarterDelegate.reinvitePendingToGroup(groupOwnerAndUid, ownedIdentity, contactIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void createNewGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, String serializedGroupDetails, String absolutePhotoUrl, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] verifiedAdministratorsChain, GroupV2.BlobKeys blobKeys, byte[] ownGroupInvitationNonce, List<String> ownPermissionStrings, HashSet<GroupV2.IdentityAndPermissionsAndDetails> otherGroupMembers, String serializedGroupType) throws Exception {
        if (!ownPermissionStrings.contains(GroupV2.Permission.GROUP_ADMIN.getString())) {
            Logger.e("Error in createNewContactGroupV2: ownPermissions do not contain GROUP_ADMIN.");
            throw new Exception();
        }
        for (GroupV2.IdentityAndPermissionsAndDetails groupMember : otherGroupMembers) {
            if (!this.isIdentityAContactOfOwnedIdentity(session, ownedIdentity, groupMember.identity)) {
                Logger.e("Error in createNewContactGroupV2: a groupMember is not a Contact.");
                throw new Exception();
            }
            if (this.getContactCapabilities(this.wrapSession(session), ownedIdentity, groupMember.identity).contains((Object)ObvCapability.GROUPS_V2)) continue;
            Logger.e("Error in createNewContactGroupV2: a groupMember does not have groupV2 capability.");
            throw new Exception();
        }
        IdentityManagerSession identityManagerSession = this.wrapSession(session);
        ContactGroupV2 group = ContactGroupV2.createNew(identityManagerSession, ownedIdentity, groupIdentifier, serializedGroupDetails, absolutePhotoUrl, serverPhotoInfo, verifiedAdministratorsChain, blobKeys, ownGroupInvitationNonce, ownPermissionStrings, serializedGroupType);
        if (group == null) {
            throw new Exception("Unable to create ContactGroupV2");
        }
        if (serverPhotoInfo != null && ServerUserData.createForGroupV2(identityManagerSession, ownedIdentity, serverPhotoInfo.serverPhotoLabel, groupIdentifier.encode().getBytes()) == null) {
            throw new Exception("Unable to create ServerUserData");
        }
        for (GroupV2.IdentityAndPermissionsAndDetails groupMember : otherGroupMembers) {
            ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, groupMember.identity, groupMember.serializedIdentityDetails, groupMember.permissionStrings, groupMember.groupInvitationNonce);
            if (pendingMember != null) continue;
            throw new Exception("Unable to create ContactGroupV2PendingMember");
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public boolean createJoinedGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, GroupV2.BlobKeys blobKeys, GroupV2.ServerBlob serverBlob, boolean createdByMeOnOtherDevice, Identity inviterIdentity) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1 || serverBlob == null) {
            throw new Exception();
        }
        if (!session.isInTransaction()) {
            throw new SQLException("Called IdentityManager.createJoinedGroupV2 outside of a transaction!");
        }
        IdentityManagerSession identityManagerSession = this.wrapSession(session);
        if (ContactGroupV2.get(identityManagerSession, ownedIdentity, groupIdentifier) != null) {
            Logger.e("Called IdentityManager.createJoinedGroupV2 for an existing group!");
            return false;
        }
        if (!serverBlob.administratorsChain.integrityWasChecked) {
            Logger.e("In IdentityManager.createJoinedGroupV2, serverBlob.administratorsChain has integrityWasChecked false");
            return false;
        }
        GroupV2.IdentityAndPermissionsAndDetails ownIdentityAndPermissionsAndDetails = null;
        for (GroupV2.IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
            if (!identityAndPermissionsAndDetails.identity.equals(ownedIdentity)) continue;
            ownIdentityAndPermissionsAndDetails = identityAndPermissionsAndDetails;
            break;
        }
        if (ownIdentityAndPermissionsAndDetails == null) {
            Logger.e("In IdentityManager.createJoinedGroupV2, ownedIdentity not part of the group");
            return false;
        }
        ContactGroupV2 group = ContactGroupV2.createJoined(identityManagerSession, ownedIdentity, groupIdentifier, serverBlob.version, serverBlob.serializedGroupDetails, serverBlob.serverPhotoInfo, serverBlob.administratorsChain.encode().getBytes(), blobKeys, ownIdentityAndPermissionsAndDetails.groupInvitationNonce, ownIdentityAndPermissionsAndDetails.permissionStrings, serverBlob.serializedGroupType, createdByMeOnOtherDevice, inviterIdentity);
        if (group == null) {
            throw new Exception("Unable to create joined ContactGroupV2");
        }
        for (GroupV2.IdentityAndPermissionsAndDetails groupMember : serverBlob.groupMemberIdentityAndPermissionsAndDetailsList) {
            ContactGroupV2PendingMember pendingMember;
            if (groupMember.identity.equals(ownedIdentity) || (pendingMember = ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, groupMember.identity, groupMember.serializedIdentityDetails, groupMember.permissionStrings, groupMember.groupInvitationNonce)) != null) continue;
            throw new Exception("Unable to create ContactGroupV2PendingMember");
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        return true;
    }

    @Override
    public GroupV2.ServerBlob getGroupV2ServerBlob(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return null;
        }
        return ContactGroupV2.getServerBlob(this.wrapSession(session), ownedIdentity, groupIdentifier);
    }

    @Override
    public String getGroupV2PhotoUrl(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        return ContactGroupV2.getPhotoUrl(this.wrapSession(session), ownedIdentity, groupIdentifier);
    }

    @Override
    public void deleteGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity deletedBy) throws SQLException {
        if (groupIdentifier == null) {
            return;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 != null) {
            groupV2.setDeletedBy(deletedBy);
            groupV2.delete();
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void freezeGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 != null) {
            groupV2.setFrozen(true);
        }
    }

    @Override
    public void unfreezeGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 != null) {
            groupV2.setFrozen(false);
        }
    }

    @Override
    public Integer getGroupV2Version(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        return groupV2.getVersion();
    }

    @Override
    public String getGroupV2JsonGroupType(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        return groupV2.getSerializedJsonGroupType();
    }

    @Override
    public boolean isGroupV2Frozen(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return false;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return false;
        }
        return groupV2.isFrozen();
    }

    @Override
    public GroupV2.BlobKeys getGroupV2BlobKeys(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        return new GroupV2.BlobKeys(groupV2.getBlobMainSeed(), groupV2.getBlobVersionSeed(), groupV2.getGroupAdminServerAuthenticationPrivateKey());
    }

    @Override
    public HashSet<GroupV2.IdentityAndPermissions> getGroupV2OtherMembersAndPermissions(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        return ContactGroupV2.getGroupV2OtherMembersAndPermissions(this.wrapSession(session), ownedIdentity, groupIdentifier);
    }

    @Override
    public boolean getGroupV2HasOtherAdminMember(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            throw new Exception();
        }
        return ContactGroupV2.getGroupV2HasOtherAdminMember(this.wrapSession(session), ownedIdentity, groupIdentifier);
    }

    @Override
    public List<Identity> updateGroupV2WithNewBlob(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, GroupV2.ServerBlob serverBlob, GroupV2.BlobKeys blobKeys, boolean updatedByMe, Identity updatedBy, List<Identity> leavers) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1 || serverBlob == null || blobKeys == null) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        return groupV2.updateWithNewBlob(serverBlob, blobKeys, updatedByMe, updatedBy, leavers);
    }

    @Override
    public List<Identity> getGroupV2MembersAndPendingMembersFromNonce(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, byte[] groupMemberInvitationNonce) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupMemberInvitationNonce == null) {
            return null;
        }
        return ContactGroupV2.getGroupV2MembersAndPendingMembersFromNonce(this.wrapSession(session), ownedIdentity, groupIdentifier, groupMemberInvitationNonce);
    }

    @Override
    public byte[] getGroupV2OwnGroupInvitationNonce(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        return groupV2.getOwnGroupInvitationNonce();
    }

    @Override
    public void moveGroupV2PendingMemberToMembers(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity groupMemberIdentity) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupMemberIdentity == null) {
            return;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return;
        }
        groupV2.movePendingMemberToMembers(groupMemberIdentity);
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
    }

    @Override
    public void setGroupV2DownloadedPhoto(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, GroupV2.ServerPhotoInfo serverPhotoInfo, byte[] photo) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || serverPhotoInfo == null || photo == null) {
            return;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return;
        }
        groupV2.setDownloadedPhotoUrl(ownedIdentity, serverPhotoInfo, photo);
    }

    @Override
    public ObvGroupV2 getObvGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        return IdentityManager.groupV2toObvGroupV2(this.wrapSession(session), ownedIdentity, groupIdentifier, groupV2);
    }

    private static ObvGroupV2 groupV2toObvGroupV2(IdentityManagerSession identityManagerSession, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, ContactGroupV2 groupV2) throws Exception {
        String publishedPhotoUrl;
        String serializedPublishedDetails;
        HashSet<ObvGroupV2.ObvGroupV2Member> otherGroupMembers = new HashSet<ObvGroupV2.ObvGroupV2Member>();
        List<ContactGroupV2Member> members = ContactGroupV2Member.getAll(identityManagerSession, ownedIdentity, groupIdentifier);
        for (ContactGroupV2Member member : members) {
            otherGroupMembers.add(new ObvGroupV2.ObvGroupV2Member(member.getContactIdentity().getBytes(), GroupV2.Permission.deserializeKnownPermissions(member.getSerializedPermissions())));
        }
        HashSet<ObvGroupV2.ObvGroupV2PendingMember> pendingGroupMembers = new HashSet<ObvGroupV2.ObvGroupV2PendingMember>();
        List<ContactGroupV2PendingMember> pendingMembers = ContactGroupV2PendingMember.getAll(identityManagerSession, ownedIdentity, groupIdentifier);
        for (ContactGroupV2PendingMember pendingMember : pendingMembers) {
            pendingGroupMembers.add(new ObvGroupV2.ObvGroupV2PendingMember(pendingMember.getContactIdentity().getBytes(), GroupV2.Permission.deserializeKnownPermissions(pendingMember.getSerializedPermissions()), pendingMember.getSerializedContactDetails()));
        }
        ContactGroupV2Details trustedDetails = ContactGroupV2Details.get(identityManagerSession, ownedIdentity, groupIdentifier, groupV2.getTrustedDetailsVersion());
        if (trustedDetails == null) {
            return null;
        }
        String serializedGroupDetails = trustedDetails.getSerializedJsonDetails();
        String photoUrl = trustedDetails.getPhotoUrl();
        if (photoUrl == null && trustedDetails.getServerPhotoInfo() != null) {
            photoUrl = "";
        }
        if (groupV2.getVersion().intValue() != groupV2.getTrustedDetailsVersion()) {
            ContactGroupV2Details publishedDetails = ContactGroupV2Details.get(identityManagerSession, ownedIdentity, groupIdentifier, groupV2.getVersion());
            if (publishedDetails == null) {
                return null;
            }
            serializedPublishedDetails = publishedDetails.getSerializedJsonDetails();
            publishedPhotoUrl = publishedDetails.getPhotoUrl();
            if (publishedPhotoUrl == null && publishedDetails.getServerPhotoInfo() != null) {
                publishedPhotoUrl = "";
            }
        } else {
            serializedPublishedDetails = null;
            publishedPhotoUrl = null;
        }
        return new ObvGroupV2(ownedIdentity.getBytes(), groupIdentifier, GroupV2.Permission.fromStrings(groupV2.getOwnPermissionStrings()), otherGroupMembers, pendingGroupMembers, serializedGroupDetails, photoUrl, serializedPublishedDetails, publishedPhotoUrl);
    }

    @Override
    public int trustGroupV2PublishedDetails(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return -1;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return -1;
        }
        int trustedVersion = groupV2.getTrustedDetailsVersion();
        if (trustedVersion != groupV2.getVersion()) {
            groupV2.setTrustedDetailsVersion(groupV2.getVersion());
            ContactGroupV2Details.cleanup(this.wrapSession(session), ownedIdentity, groupIdentifier, groupV2.getVersion(), groupV2.getVersion());
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        return groupV2.getVersion();
    }

    @Override
    public GroupV2.ServerPhotoInfo getGroupV2PublishedServerPhotoInfo(Session session, Identity ownedIdentity, byte[] bytesGroupIdentifier) {
        if (ownedIdentity == null || bytesGroupIdentifier == null) {
            return null;
        }
        try {
            GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
            if (groupIdentifier.category == 1) {
                return null;
            }
            return ContactGroupV2.getServerPhotoInfo(this.wrapSession(session), ownedIdentity, groupIdentifier);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public ObvGroupV2.ObvGroupV2DetailsAndPhotos getGroupV2DetailsAndPhotos(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        try {
            String publishedPhotoUrl;
            String serializedPublishedDetails;
            ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
            if (groupV2 == null) {
                return null;
            }
            ContactGroupV2Details trustedDetails = ContactGroupV2Details.get(this.wrapSession(session), ownedIdentity, groupIdentifier, groupV2.getTrustedDetailsVersion());
            if (trustedDetails == null) {
                return null;
            }
            String serializedGroupDetails = trustedDetails.getSerializedJsonDetails();
            String photoUrl = trustedDetails.getPhotoUrl();
            if (photoUrl == null && trustedDetails.getServerPhotoInfo() != null) {
                photoUrl = "";
            }
            if (groupV2.getVersion().intValue() != groupV2.getTrustedDetailsVersion()) {
                ContactGroupV2Details publishedDetails = ContactGroupV2Details.get(this.wrapSession(session), ownedIdentity, groupIdentifier, groupV2.getVersion());
                if (publishedDetails == null) {
                    return null;
                }
                serializedPublishedDetails = publishedDetails.getSerializedJsonDetails();
                publishedPhotoUrl = publishedDetails.getPhotoUrl();
                if (publishedPhotoUrl == null && publishedDetails.getServerPhotoInfo() != null) {
                    publishedPhotoUrl = "";
                }
            } else {
                serializedPublishedDetails = null;
                publishedPhotoUrl = null;
            }
            return new ObvGroupV2.ObvGroupV2DetailsAndPhotos(serializedGroupDetails, photoUrl, serializedPublishedDetails, publishedPhotoUrl);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public void setUpdatedGroupV2PhotoUrl(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, int version, String absolutePhotoUrl) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || absolutePhotoUrl == null) {
            return;
        }
        ContactGroupV2Details details = ContactGroupV2Details.get(this.wrapSession(session), ownedIdentity, groupIdentifier, version);
        if (details == null) {
            return;
        }
        details.setAbsolutePhotoUrl(absolutePhotoUrl);
    }

    @Override
    public GroupV2.AdministratorsChain getGroupV2AdministratorsChain(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return null;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        byte[] serializedAdministratorsChain = groupV2.getVerifiedAdministratorsChain();
        return GroupV2.AdministratorsChain.of(new Encoded(serializedAdministratorsChain));
    }

    @Override
    public boolean getGroupV2AdminStatus(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category == 1) {
            return false;
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return false;
        }
        return groupV2.getOwnPermissionStrings().contains(GroupV2.Permission.GROUP_ADMIN.getString());
    }

    @Override
    public List<ObvGroupV2> getObvGroupsV2ForOwnedIdentity(Session session, Identity ownedIdentity) throws Exception {
        if (ownedIdentity == null) {
            throw new Exception();
        }
        IdentityManagerSession identityManagerSession = this.wrapSession(session);
        List<ContactGroupV2> groupsV2 = ContactGroupV2.getAllForIdentity(identityManagerSession, ownedIdentity);
        ArrayList<ObvGroupV2> obvGroupsV2 = new ArrayList<ObvGroupV2>();
        for (ContactGroupV2 groupV2 : groupsV2) {
            ObvGroupV2 obvGroupV2 = IdentityManager.groupV2toObvGroupV2(identityManagerSession, ownedIdentity, groupV2.getGroupIdentifier(), groupV2);
            if (obvGroupV2 == null) continue;
            obvGroupsV2.add(obvGroupV2);
        }
        return obvGroupsV2;
    }

    @Override
    public GroupV2.IdentifierVersionAndKeys[] getServerGroupsV2IdentifierVersionAndKeysForContact(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (ownedIdentity == null || contactIdentity == null) {
            throw new Exception();
        }
        return ContactGroupV2.getServerGroupsV2IdentifierVersionAndKeysForContact(this.wrapSession(session), ownedIdentity, contactIdentity);
    }

    @Override
    public GroupV2.IdentifierVersionAndKeys[] getAllServerGroupsV2IdentifierVersionAndKeys(Session session, Identity ownedIdentity) throws Exception {
        if (ownedIdentity == null) {
            throw new Exception();
        }
        return ContactGroupV2.getAllServerGroupsV2IdentifierVersionAndKeys(this.wrapSession(session), ownedIdentity);
    }

    @Override
    public GroupV2.IdentifierAndAdminStatus[] getServerGroupsV2IdentifierAndMyAdminStatusForContact(Session session, Identity ownedIdentity, Identity contactIdentity) throws Exception {
        if (ownedIdentity == null || contactIdentity == null) {
            throw new Exception();
        }
        return ContactGroupV2.getServerGroupsV2IdentifierAndMyAdminStatusForContact(this.wrapSession(session), ownedIdentity, contactIdentity);
    }

    @Override
    public void initiateGroupV2BatchKeysResend(UID currentDeviceUid, Identity contactIdentity, UID contactDeviceUid) {
        if (contactIdentity == null || contactDeviceUid == null) {
            return;
        }
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            Identity ownedIdentity = this.getOwnedIdentityForCurrentDeviceUid(identityManagerSession.session, currentDeviceUid);
            if (ownedIdentity == null) {
                return;
            }
            try {
                this.protocolStarterDelegate.initiateGroupV2BatchKeysResend(identityManagerSession.session, ownedIdentity, contactIdentity, contactDeviceUid);
                identityManagerSession.session.commit();
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void forcefullyRemoveMemberOrPendingFromNonAdminGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity contactIdentity) throws SQLException {
        ContactGroupV2 contactGroupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (contactGroupV2 != null) {
            if (groupIdentifier.category == 1) {
                this.moveKeycloakMemberToPendingMember(this.wrapSession(session), groupIdentifier, ownedIdentity, contactIdentity, null);
            } else {
                ContactGroupV2Member member;
                contactGroupV2.triggerUpdateNotification();
                ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.get(this.wrapSession(session), ownedIdentity, groupIdentifier, contactIdentity);
                if (pendingMember != null) {
                    pendingMember.delete();
                }
                if ((member = ContactGroupV2Member.get(this.wrapSession(session), ownedIdentity, groupIdentifier, contactIdentity)) != null) {
                    member.delete();
                }
            }
        }
    }

    @Override
    public Long getGroupV2LastModificationTimestamp(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier) throws SQLException {
        if (ownedIdentity == null || groupIdentifier == null) {
            return null;
        }
        return ContactGroupV2.getLastModificationTimestamp(this.wrapSession(session), ownedIdentity, groupIdentifier);
    }

    @Override
    public byte[] createKeycloakGroupV2(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, KeycloakGroupBlob keycloakGroupBlob) {
        if (ownedIdentity == null || groupIdentifier == null || groupIdentifier.category != 1 || keycloakGroupBlob == null) {
            return null;
        }
        try {
            ContactGroupV2 groupV2;
            IdentityManagerSession identityManagerSession = this.wrapSession(session);
            byte[] ownInvitationNonce = null;
            List<String> ownPermissions = null;
            ArrayList<KeycloakGroupMemberAndPermissions> otherMembers = new ArrayList<KeycloakGroupMemberAndPermissions>();
            for (KeycloakGroupMemberAndPermissions groupMemberAndPermissions : keycloakGroupBlob.groupMembersAndPermissions) {
                if (Arrays.equals(ownedIdentity.getBytes(), groupMemberAndPermissions.identity)) {
                    ownInvitationNonce = groupMemberAndPermissions.groupInvitationNonce;
                    ownPermissions = groupMemberAndPermissions.permissions;
                    continue;
                }
                otherMembers.add(groupMemberAndPermissions);
            }
            GroupV2.ServerPhotoInfo serverPhotoInfo = null;
            if (keycloakGroupBlob.photoUid != null && keycloakGroupBlob.encodedPhotoKey != null) {
                try {
                    UID photoUid = new UID(keycloakGroupBlob.photoUid);
                    AuthEncKey photoKey = (AuthEncKey)new Encoded(keycloakGroupBlob.encodedPhotoKey).decodeSymmetricKey();
                    serverPhotoInfo = new GroupV2.ServerPhotoInfo(null, photoUid, photoKey);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
            }
            if ((groupV2 = ContactGroupV2.createKeycloak(identityManagerSession, ownedIdentity, groupIdentifier, this.jsonObjectMapper.writeValueAsString((Object)keycloakGroupBlob.groupDetails), serverPhotoInfo, ownInvitationNonce, ownPermissions, keycloakGroupBlob.pushTopic, keycloakGroupBlob.serializedSharedSettings, keycloakGroupBlob.timestamp)) == null) {
                throw new Exception("Called createKeycloakGroupV2 and group already exists");
            }
            JwtConsumer noVerificationConsumer = new JwtConsumerBuilder().setSkipSignatureVerification().setSkipAllValidators().build();
            for (KeycloakGroupMemberAndPermissions groupMemberAndPermissions : otherMembers) {
                try {
                    String serializedUnsignedDetails = noVerificationConsumer.processToClaims(groupMemberAndPermissions.signedUserDetails).getRawJson();
                    JsonKeycloakUserDetails jsonKeycloakUserDetails = (JsonKeycloakUserDetails)this.jsonObjectMapper.readValue(serializedUnsignedDetails, JsonKeycloakUserDetails.class);
                    JsonIdentityDetails jsonIdentityDetails = jsonKeycloakUserDetails.getIdentityDetails(groupMemberAndPermissions.signedUserDetails);
                    String serializedIdentityDetails = this.jsonObjectMapper.writeValueAsString((Object)jsonIdentityDetails);
                    Identity groupMemberIdentity = Identity.of(groupMemberAndPermissions.identity);
                    ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, groupMemberIdentity, serializedIdentityDetails, groupMemberAndPermissions.permissions, groupMemberAndPermissions.groupInvitationNonce);
                    if (pendingMember != null) continue;
                    throw new Exception("Unable to create ContactGroupV2PendingMember");
                }
                catch (JsonProcessingException | InvalidJwtException e) {
                    Logger.w("Unable to process one keycloak group member --> skipping them");
                    Logger.x(e);
                }
            }
            if (keycloakGroupBlob.serializedSharedSettings != null) {
                session.addSessionCommitListener(() -> {
                    HashMap<String, Object> userInfo = new HashMap<String, Object>();
                    userInfo.put("owned_identity", ownedIdentity);
                    userInfo.put("group_identifier", groupIdentifier);
                    userInfo.put("serialized_shared_settings", keycloakGroupBlob.serializedSharedSettings);
                    userInfo.put("timestamp", keycloakGroupBlob.timestamp);
                    this.notificationPostingDelegate.postNotification("identity_manager_notification_keycloak_group_v_2_shared_settings", userInfo);
                });
            }
            session.addSessionCommitListener(this.backupNeededSessionCommitListener);
            session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
            return ownInvitationNonce;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public KeycloakGroupV2UpdateOutput updateKeycloakGroupV2WithNewBlob(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, KeycloakGroupBlob keycloakGroupBlob) throws Exception {
        if (session == null || ownedIdentity == null || groupIdentifier == null || groupIdentifier.category != 1 || keycloakGroupBlob == null) {
            return null;
        }
        if (!session.isInTransaction()) {
            throw new SQLException("Calling updateKeycloakGroupV2WithNewBlob outside a transaction!");
        }
        ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
        if (groupV2 == null) {
            return null;
        }
        session.addSessionCommitListener(this.backupNeededSessionCommitListener);
        session.addSessionCommitListener(this.getSessionCommitListenerForProfileBackup(ownedIdentity));
        return groupV2.updateWithNewKeycloakBlob(keycloakGroupBlob, this.jsonObjectMapper);
    }

    @Override
    public void rePingOrDemoteContactFromAllKeycloakGroups(Session session, Identity ownedIdentity, Identity contactIdentity, boolean certifiedByOwnKeycloak, String lastKnownSerializedCertifiedDetails) throws SQLException {
        block9: {
            IdentityManagerSession identityManagerSession;
            block8: {
                if (session == null || ownedIdentity == null || contactIdentity == null) {
                    return;
                }
                identityManagerSession = this.wrapSession(session);
                if (!certifiedByOwnKeycloak) break block8;
                List<GroupV2.Identifier> groupIdentifiers = ContactGroupV2PendingMember.getKeycloakGroupV2IdentifiersWhereContactIsPending(identityManagerSession, ownedIdentity, contactIdentity);
                if (groupIdentifiers == null) break block9;
                for (GroupV2.Identifier groupIdentifier : groupIdentifiers) {
                    try {
                        this.protocolStarterDelegate.initiateKeycloakGroupV2TargetedPing(session, ownedIdentity, groupIdentifier, contactIdentity);
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
                break block9;
            }
            List<GroupV2.Identifier> groupIdentifiers = ContactGroupV2Member.getKeycloakGroupV2IdentifiersWhereContactIsMember(identityManagerSession, ownedIdentity, contactIdentity);
            if (groupIdentifiers != null) {
                for (GroupV2.Identifier groupIdentifier : groupIdentifiers) {
                    try {
                        this.moveKeycloakMemberToPendingMember(identityManagerSession, groupIdentifier, ownedIdentity, contactIdentity, lastKnownSerializedCertifiedDetails);
                    }
                    catch (Exception e) {
                        Logger.x(e);
                    }
                }
            }
        }
    }

    private void moveKeycloakMemberToPendingMember(IdentityManagerSession identityManagerSession, GroupV2.Identifier groupIdentifier, Identity ownedIdentity, Identity groupMemberIdentity, String lastKnownSerializedCertifiedDetails) throws SQLException {
        String serializedPublishedDetails;
        if (groupIdentifier.category != 1) {
            return;
        }
        ContactGroupV2Member member = ContactGroupV2Member.get(identityManagerSession, ownedIdentity, groupIdentifier, groupMemberIdentity);
        String string = serializedPublishedDetails = lastKnownSerializedCertifiedDetails == null ? ContactIdentity.getSerializedPublishedDetails(identityManagerSession, ownedIdentity, groupMemberIdentity) : lastKnownSerializedCertifiedDetails;
        if (member == null || serializedPublishedDetails == null) {
            return;
        }
        ContactGroupV2PendingMember pendingMember = ContactGroupV2PendingMember.get(identityManagerSession, ownedIdentity, groupIdentifier, groupMemberIdentity);
        if (pendingMember == null && (pendingMember = ContactGroupV2PendingMember.create(identityManagerSession, ownedIdentity, groupIdentifier, groupMemberIdentity, serializedPublishedDetails, GroupV2.Permission.deserializePermissions(member.getSerializedPermissions()), member.getGroupInvitationNonce())) == null) {
            throw new SQLException("In IdentityManager.moveKeycloakMemberToPendingMember, failed to create ContactGroupV2PendingMember");
        }
        member.delete();
        identityManagerSession.session.addSessionCommitListener(() -> {
            HashMap<String, Object> userInfo = new HashMap<String, Object>();
            userInfo.put("owned_identity", ownedIdentity);
            userInfo.put("group_identifier", groupIdentifier);
            userInfo.put("by_me", false);
            identityManagerSession.notificationPostingDelegate.postNotification("identity_manager_notification_group_v2_updated", userInfo);
        });
    }

    @Override
    public boolean isIdentityAPendingGroupV2Member(Session session, Identity ownedIdentity, GroupV2.Identifier groupIdentifier, Identity identity) throws SQLException {
        if (session == null || ownedIdentity == null || groupIdentifier == null || identity == null) {
            return false;
        }
        return ContactGroupV2PendingMember.get(this.wrapSession(session), ownedIdentity, groupIdentifier, identity) != null;
    }

    @Override
    public void initiateBackup(BackupDelegate backupDelegate, String tag, UID backupKeyUid, int version) {
        new Thread(() -> {
            try (IdentityManagerSession identityManagerSession = this.getSession();){
                OwnedIdentity.Pojo_0[] ownedIdentityPojos = OwnedIdentity.backupAll(identityManagerSession);
                if (ownedIdentityPojos.length == 0) {
                    backupDelegate.backupFailed(tag, backupKeyUid, version);
                    return;
                }
                String jsonString = this.jsonObjectMapper.writeValueAsString((Object)ownedIdentityPojos);
                backupDelegate.backupSuccess(tag, backupKeyUid, version, jsonString);
            }
            catch (JsonProcessingException | SQLException e) {
                Logger.x(e);
                backupDelegate.backupFailed(tag, backupKeyUid, version);
            }
        }, "Identity Backup").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvIdentity[] restoreOwnedIdentitiesFromBackup(String serializedJsonPojo, String deviceDisplayName, PRNGService prng) {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            OwnedIdentity[] ownedIdentities = OwnedIdentity.getAll(identityManagerSession);
            if (ownedIdentities.length != 0) {
                Logger.e("Trying to restore a backup while an OwnedIdentity already exists. Aborting.");
                ObvIdentity[] obvIdentityArray = new ObvIdentity[]{};
                return obvIdentityArray;
            }
            ArrayList<ObvIdentity> restoredIdentities = new ArrayList<ObvIdentity>();
            OwnedIdentity.Pojo_0[] ownedIdentityPojos = (OwnedIdentity.Pojo_0[])this.jsonObjectMapper.readValue(serializedJsonPojo, (TypeReference)new TypeReference<OwnedIdentity.Pojo_0[]>(){});
            identityManagerSession.session.startTransaction();
            for (OwnedIdentity.Pojo_0 ownedIdentityPojo : ownedIdentityPojos) {
                restoredIdentities.add(OwnedIdentity.restore(identityManagerSession, ownedIdentityPojo, deviceDisplayName, prng));
            }
            identityManagerSession.session.commit();
            Object[] objectArray = restoredIdentities.toArray(new ObvIdentity[0]);
            return objectArray;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public void restoreContactsAndGroupsFromBackup(String serializedJsonPojo, ObvIdentity[] restoredOwnedIdentities, long backupTimestamp) {
        HashSet<Identity> restoredIdentities = new HashSet<Identity>();
        for (ObvIdentity obvOwnedIdentity : restoredOwnedIdentities) {
            restoredIdentities.add(obvOwnedIdentity.getIdentity());
        }
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            OwnedIdentity.Pojo_0[] ownedIdentityPojos = (OwnedIdentity.Pojo_0[])this.jsonObjectMapper.readValue(serializedJsonPojo, (TypeReference)new TypeReference<OwnedIdentity.Pojo_0[]>(){});
            for (OwnedIdentity.Pojo_0 ownedIdentityPojo : ownedIdentityPojos) {
                Identity ownedIdentity = Identity.of(ownedIdentityPojo.owned_identity);
                if (!restoredIdentities.contains(ownedIdentity)) continue;
                ContactIdentity.restoreAll(identityManagerSession, ownedIdentity, ownedIdentityPojo.contact_identities, backupTimestamp);
                ContactGroup.restoreAllForOwner(identityManagerSession, ownedIdentity, ownedIdentity, ownedIdentityPojo.owned_groups, backupTimestamp);
                ContactGroupV2.restoreAll(identityManagerSession, this.protocolStarterDelegate, ownedIdentity, ownedIdentityPojo.groups_v2);
            }
            for (ObvIdentity obvOwnedIdentity : restoredOwnedIdentities) {
                if (!obvOwnedIdentity.isActive()) continue;
                this.reactivateOwnedIdentityIfNeeded(identityManagerSession.session, obvOwnedIdentity.getIdentity());
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public UserData[] getAllUserData(Session session) throws Exception {
        ServerUserData[] serverUserData = ServerUserData.getAll(this.wrapSession(session));
        UserData[] userData = new UserData[serverUserData.length];
        for (int i = 0; i < serverUserData.length; ++i) {
            userData[i] = serverUserData[i].getUserData();
        }
        return userData;
    }

    @Override
    public UserData getUserData(Session session, Identity ownedIdentity, UID label) throws Exception {
        ServerUserData serverUserData = ServerUserData.get(this.wrapSession(session), ownedIdentity, label);
        if (serverUserData != null) {
            return serverUserData.getUserData();
        }
        return null;
    }

    @Override
    public void deleteUserData(Session session, Identity ownedIdentity, UID label) throws Exception {
        ServerUserData serverUserData = ServerUserData.get(this.wrapSession(session), ownedIdentity, label);
        if (serverUserData != null) {
            serverUserData.delete();
        }
    }

    @Override
    public void updateUserDataNextRefreshTimestamp(Session session, Identity ownedIdentity, UID label) throws Exception {
        ServerUserData serverUserData = ServerUserData.get(this.wrapSession(session), ownedIdentity, label);
        if (serverUserData != null) {
            serverUserData.updateNextRefreshTimestamp();
        }
    }

    @Override
    public void processSyncItem(Session session, Identity ownedIdentity, ObvSyncAtom obvSyncAtom) throws Exception {
        switch (obvSyncAtom.syncType) {
            case 12: {
                try {
                    JsonIdentityDetailsWithVersionAndPhoto atomDetails = (JsonIdentityDetailsWithVersionAndPhoto)this.jsonObjectMapper.readValue(obvSyncAtom.getStringValue(), JsonIdentityDetailsWithVersionAndPhoto.class);
                    JsonIdentityDetailsWithVersionAndPhoto[] dbDetails = this.getContactPublishedAndTrustedDetails(session, ownedIdentity, obvSyncAtom.getContactIdentity());
                    if (dbDetails.length != 2 || !Objects.equals(dbDetails[0].getPhotoServerKey() == null ? null : new Encoded(dbDetails[0].getPhotoServerKey()).decodeSymmetricKey(), atomDetails.getPhotoServerKey() == null ? null : new Encoded(atomDetails.getPhotoServerKey()).decodeSymmetricKey()) || !Arrays.equals(dbDetails[0].getPhotoServerLabel(), atomDetails.getPhotoServerLabel()) || !Objects.equals(dbDetails[0].getIdentityDetails(), atomDetails.getIdentityDetails())) break;
                    this.trustPublishedContactDetails(session, obvSyncAtom.getContactIdentity(), ownedIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case 13: {
                try {
                    JsonGroupDetailsWithVersionAndPhoto atomDetails = (JsonGroupDetailsWithVersionAndPhoto)this.jsonObjectMapper.readValue(obvSyncAtom.getStringValue(), JsonGroupDetailsWithVersionAndPhoto.class);
                    JsonGroupDetailsWithVersionAndPhoto[] dbDetails = this.getGroupPublishedAndLatestOrTrustedDetails(session, ownedIdentity, obvSyncAtom.getBytesGroupOwnerAndUid());
                    if (dbDetails.length != 2 || !Objects.equals(dbDetails[0].getPhotoServerKey() == null ? null : new Encoded(dbDetails[0].getPhotoServerKey()).decodeSymmetricKey(), atomDetails.getPhotoServerKey() == null ? null : new Encoded(atomDetails.getPhotoServerKey()).decodeSymmetricKey()) || !Arrays.equals(dbDetails[0].getPhotoServerLabel(), atomDetails.getPhotoServerLabel()) || !Objects.equals(dbDetails[0].getGroupDetails(), atomDetails.getGroupDetails())) break;
                    this.trustPublishedGroupDetails(session, ownedIdentity, obvSyncAtom.getBytesGroupOwnerAndUid());
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case 14: {
                try {
                    int version = obvSyncAtom.getIntegerValue();
                    GroupV2.Identifier groupIdentifier = obvSyncAtom.getGroupIdentifier();
                    ContactGroupV2 groupV2 = ContactGroupV2.get(this.wrapSession(session), ownedIdentity, groupIdentifier);
                    if (groupV2 == null || groupV2.getVersion().intValue() == groupV2.getTrustedDetailsVersion() && groupV2.getVersion() >= version) break;
                    if (groupV2.getVersion() == version) {
                        this.trustGroupV2PublishedDetails(session, ownedIdentity, groupIdentifier);
                        break;
                    }
                    if (groupV2.getVersion() >= version || groupV2.getAlreadyTrustedDetailsVersion() != null && groupV2.getAlreadyTrustedDetailsVersion() >= version) break;
                    groupV2.setAlreadyTrustedDetailsVersion(version);
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            default: {
                throw new Exception("Unknown Identity Manager sync atom type");
            }
        }
    }

    @Override
    public void downloadAllUserData(Session session) throws Exception {
        List<OwnedIdentityDetails> ownedIdentityDetailsList = OwnedIdentityDetails.getAllWithMissingPhotoUrl(this.wrapSession(session));
        for (OwnedIdentityDetails ownedIdentityDetails : ownedIdentityDetailsList) {
            this.protocolStarterDelegate.startDownloadIdentityPhotoProtocolWithinTransaction(session, ownedIdentityDetails.getOwnedIdentity(), ownedIdentityDetails.getOwnedIdentity(), ownedIdentityDetails.getJsonIdentityDetailsWithVersionAndPhoto());
        }
        List<ContactIdentityDetails> contactIdentityDetailsList = ContactIdentityDetails.getAllWithMissingPhotoUrl(this.wrapSession(session));
        for (ContactIdentityDetails contactIdentityDetails : contactIdentityDetailsList) {
            this.protocolStarterDelegate.startDownloadIdentityPhotoProtocolWithinTransaction(session, contactIdentityDetails.getOwnedIdentity(), contactIdentityDetails.getContactIdentity(), contactIdentityDetails.getJsonIdentityDetailsWithVersionAndPhoto());
        }
        List<ContactGroupDetails> list = ContactGroupDetails.getAllWithMissingPhotoUrl(this.wrapSession(session));
        for (ContactGroupDetails contactGroupDetails : list) {
            this.protocolStarterDelegate.startDownloadGroupPhotoProtocolWithinTransaction(session, contactGroupDetails.getOwnedIdentity(), contactGroupDetails.getGroupOwnerAndUid(), contactGroupDetails.getJsonGroupDetailsWithVersionAndPhoto());
        }
        List<ContactGroupV2Details> list2 = ContactGroupV2Details.getAllWithMissingPhotoUrl(this.wrapSession(session));
        for (ContactGroupV2Details contactGroupV2Details : list2) {
            this.protocolStarterDelegate.startDownloadGroupV2PhotoProtocolWithinTransaction(session, contactGroupV2Details.getOwnedIdentity(), contactGroupV2Details.getGroupIdentifier(), contactGroupV2Details.getServerPhotoInfo());
        }
    }

    @Override
    public EncryptedBytes wrap(AuthEncKey messageKey, Identity toIdentity, PRNGService prng) {
        try {
            PublicKeyEncryption pubEnc = Suite.getPublicKeyEncryption(toIdentity.getEncryptionPublicKey());
            return pubEnc.encrypt(toIdentity.getEncryptionPublicKey(), Encoded.of(messageKey).getBytes(), prng);
        }
        catch (InvalidKeyException e) {
            return null;
        }
    }

    @Override
    public AuthEncKey unwrap(Session session, EncryptedBytes wrappedKey, Identity toIdentity) throws SQLException {
        try {
            OwnedIdentity ownedIdentity = OwnedIdentity.get(this.wrapSession(session), toIdentity);
            if (ownedIdentity == null) {
                return null;
            }
            PrivateIdentity privateIdentity = ownedIdentity.getPrivateIdentity();
            PublicKeyEncryption pubEnc = Suite.getPublicKeyEncryption(privateIdentity.getEncryptionPublicKey());
            byte[] unwrappedBytes = pubEnc.decrypt(privateIdentity.getEncryptionPrivateKey(), wrappedKey);
            return (AuthEncKey)new Encoded(unwrappedBytes).decodeSymmetricKey();
        }
        catch (DecryptionException | DecodingException | InvalidKeyException e) {
            return null;
        }
    }

    @Override
    public byte[] decrypt(Session session, EncryptedBytes ciphertext, Identity toIdentity) throws SQLException {
        try {
            OwnedIdentity ownedIdentity = OwnedIdentity.get(this.wrapSession(session), toIdentity);
            if (ownedIdentity == null) {
                return null;
            }
            PrivateIdentity privateIdentity = ownedIdentity.getPrivateIdentity();
            PublicKeyEncryption pubEnc = Suite.getPublicKeyEncryption(privateIdentity.getEncryptionPublicKey());
            return pubEnc.decrypt(privateIdentity.getEncryptionPrivateKey(), ciphertext);
        }
        catch (DecryptionException | InvalidKeyException e) {
            return null;
        }
    }

    public EncryptionPrivateKey getOwnedIdentityEncryptionPrivateKey(Session session, Identity toIdentity) throws SQLException {
        OwnedIdentity ownedIdentity = OwnedIdentity.get(this.wrapSession(session), toIdentity);
        if (ownedIdentity == null) {
            return null;
        }
        PrivateIdentity privateIdentity = ownedIdentity.getPrivateIdentity();
        return privateIdentity.getEncryptionPrivateKey();
    }

    @Override
    public EncryptedBytes wrapWithPreKey(Session session, AuthEncKey messageKey, Identity ownedIdentity, Identity remoteIdentity, UID remoteDeviceUid, PRNGService prng) {
        try {
            PreKey preKey;
            OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
            if (ownedIdentityObject == null) {
                Logger.w("In wrapWithPreKey(), unknown OwnedIdentity");
                return null;
            }
            if (ownedIdentity.equals(remoteIdentity)) {
                OwnedDevice ownedDevice = OwnedDevice.get(this.wrapSession(session), remoteDeviceUid);
                if (ownedDevice == null || !Objects.equals(ownedDevice.getOwnedIdentity(), ownedIdentity)) {
                    Logger.w("In wrapWithPreKey(), unable to find the correct ownedDevice");
                    return null;
                }
                preKey = ownedDevice.getPreKey();
            } else {
                ContactDevice contactDevice = ContactDevice.get(this.wrapSession(session), remoteDeviceUid, remoteIdentity, ownedIdentity);
                if (contactDevice == null) {
                    Logger.w("In wrapWithPreKey(), unable to find the correct contactDevice");
                    return null;
                }
                preKey = contactDevice.getPreKey();
            }
            if (preKey == null) {
                Logger.w("In wrapWithPreKey(), remote device does not have a preKey");
                return null;
            }
            UID currentDeviceUid = this.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
            Encoded encodedPayload = Encoded.of(new Encoded[]{Encoded.of(messageKey), Encoded.of(currentDeviceUid), Encoded.of(ownedIdentity)});
            Encoded signaturePayload = Encoded.of(new Encoded[]{encodedPayload, Encoded.of(remoteIdentity), Encoded.of(remoteDeviceUid), Encoded.of(preKey.keyId.getBytes())});
            byte[] signature = Signature.sign(Constants.SignatureContext.ENCRYPTION_WITH_PRE_KEY, signaturePayload.getBytes(), ownedIdentityObject.getPrivateIdentity().getServerAuthenticationPrivateKey().getSignaturePrivateKey(), prng);
            if (signature == null) {
                Logger.w("In wrapWithPreKey(), unable to compute signature?!");
                return null;
            }
            Encoded encodedPlaintext = Encoded.of(new Encoded[]{encodedPayload, Encoded.of(signature)});
            EncryptedBytes encryptedBytes = Suite.getPublicKeyEncryption(preKey.encryptionPublicKey).encrypt(preKey.encryptionPublicKey, encodedPlaintext.getBytes(), prng);
            byte[] outputBytes = new byte[32 + encryptedBytes.length];
            System.arraycopy(preKey.keyId.getBytes(), 0, outputBytes, 0, 32);
            System.arraycopy(encryptedBytes.getBytes(), 0, outputBytes, 32, encryptedBytes.length);
            return new EncryptedBytes(outputBytes);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public AuthEncKeyAndChannelInfo unwrapWithPreKey(Session session, EncryptedBytes wrappedKey, Identity ownedIdentity) {
        try {
            byte[] plaintextBytes;
            if (wrappedKey.length < 32) {
                return null;
            }
            KeyId keyId = new KeyId(Arrays.copyOfRange(wrappedKey.getBytes(), 0, 32));
            OwnedPreKey ownedPreKey = OwnedPreKey.get(this.wrapSession(session), ownedIdentity, keyId);
            if (ownedPreKey == null) {
                return null;
            }
            try {
                plaintextBytes = Suite.getPublicKeyEncryption(ownedPreKey.getEncryptionPrivateKey()).decrypt(ownedPreKey.getEncryptionPrivateKey(), new EncryptedBytes(Arrays.copyOfRange(wrappedKey.getBytes(), 32, wrappedKey.length)));
            }
            catch (DecryptionException | InvalidKeyException ignored) {
                return null;
            }
            Encoded[] encodeds = new Encoded(plaintextBytes).decodeList();
            Encoded[] payloadEncodeds = encodeds[0].decodeList();
            byte[] signature = encodeds[1].decodeBytes();
            AuthEncKey messageKey = (AuthEncKey)payloadEncodeds[0].decodeSymmetricKey();
            UID remoteDeviceUid = payloadEncodeds[1].decodeUid();
            Identity remoteIdentity = payloadEncodeds[2].decodeIdentity();
            UID currentDeviceUid = this.getCurrentDeviceUidOfOwnedIdentity(session, ownedIdentity);
            Encoded signatureEncoded = Encoded.of(new Encoded[]{encodeds[0], Encoded.of(ownedIdentity), Encoded.of(currentDeviceUid), Encoded.of(keyId.getBytes())});
            if (!Signature.verify(Constants.SignatureContext.ENCRYPTION_WITH_PRE_KEY, signatureEncoded.getBytes(), remoteIdentity, signature)) {
                Logger.w("PreKey wrapped messageKey signature verification failed!");
                return null;
            }
            return new AuthEncKeyAndChannelInfo(messageKey, ReceptionChannelInfo.createPreKeyChannelInfo(remoteDeviceUid, remoteIdentity));
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public String getTag() {
        return "identity";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvSyncSnapshotNode getSyncSnapshot(Identity ownedIdentity) {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            ObvSyncSnapshotNode obvSyncSnapshotNode;
            try {
                identityManagerSession.session.startTransaction();
                obvSyncSnapshotNode = this.getSyncSnapshotWithinTransaction(identityManagerSession, ownedIdentity);
            }
            catch (Exception e) {
                ObvSyncSnapshotNode obvSyncSnapshotNode2;
                block14: {
                    Logger.x(e);
                    obvSyncSnapshotNode2 = null;
                    identityManagerSession.session.rollback();
                    if (identityManagerSession == null) break block14;
                    identityManagerSession.close();
                }
                return obvSyncSnapshotNode2;
                {
                    catch (Throwable throwable) {
                        identityManagerSession.session.rollback();
                        throw throwable;
                    }
                }
            }
            identityManagerSession.session.rollback();
            return obvSyncSnapshotNode;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private ObvSyncSnapshotNode getSyncSnapshotWithinTransaction(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws Exception {
        if (!identityManagerSession.session.isInTransaction()) {
            Logger.e("ERROR: called IdentityManager.getSyncSnapshot outside a transaction!");
            throw new Exception();
        }
        return IdentityManagerSyncSnapshot.of(identityManagerSession, ownedIdentity);
    }

    @Override
    public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreOwnedIdentity(ObvIdentity ownedIdentity, ObvSyncSnapshotNode node) throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreSyncSnapshot(ObvSyncSnapshotNode node) {
        block16: {
            try (IdentityManagerSession identityManagerSession = this.getSession();){
                boolean transactionSuccessful = false;
                try {
                    identityManagerSession.session.startTransaction();
                    ObvBackupAndSyncDelegate.RestoreFinishedCallback callback = this.restoreSyncSnapshotWithinTransaction(identityManagerSession, node);
                    transactionSuccessful = true;
                    ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreFinishedCallback = callback;
                    return restoreFinishedCallback;
                }
                catch (Exception e) {
                    Logger.x(e);
                    break block16;
                }
                finally {
                    if (transactionSuccessful) {
                        identityManagerSession.session.commit();
                    } else {
                        identityManagerSession.session.rollback();
                    }
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            catch (SQLException e) {
                Logger.x(e);
            }
        }
        return null;
    }

    private ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreSyncSnapshotWithinTransaction(IdentityManagerSession identityManagerSession, ObvSyncSnapshotNode node) throws Exception {
        if (!(node instanceof IdentityManagerSyncSnapshot)) {
            throw new Exception();
        }
        ((IdentityManagerSyncSnapshot)node).restore(identityManagerSession, this.protocolStarterDelegate);
        return null;
    }

    @Override
    public byte[] serialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, ObvSyncSnapshotNode snapshotNode) throws Exception {
        switch (serializationContext) {
            case DEVICE: {
                if (snapshotNode instanceof IdentityManagerDeviceSnapshot) break;
                throw new Exception("IdentityBackupDelegate can only serialize IdentityManagerDeviceSnapshot");
            }
            case PROFILE: {
                if (snapshotNode instanceof IdentityManagerSyncSnapshot) break;
                throw new Exception("IdentityBackupDelegate can only serialize IdentityManagerSyncSnapshot");
            }
        }
        return this.jsonObjectMapper.writeValueAsBytes((Object)snapshotNode);
    }

    @Override
    public ObvSyncSnapshotNode deserialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, byte[] serializedSnapshotNode) throws Exception {
        switch (serializationContext) {
            case DEVICE: {
                return (ObvSyncSnapshotNode)this.jsonObjectMapper.readValue(serializedSnapshotNode, IdentityManagerDeviceSnapshot.class);
            }
        }
        return (ObvSyncSnapshotNode)this.jsonObjectMapper.readValue(serializedSnapshotNode, IdentityManagerSyncSnapshot.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvSyncSnapshotNode getDeviceSnapshot() {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            ObvSyncSnapshotNode obvSyncSnapshotNode;
            try {
                identityManagerSession.session.startTransaction();
                obvSyncSnapshotNode = this.getDeviceSnapshotWithinTransaction(identityManagerSession);
            }
            catch (Exception e) {
                ObvSyncSnapshotNode obvSyncSnapshotNode2;
                block14: {
                    Logger.x(e);
                    obvSyncSnapshotNode2 = null;
                    identityManagerSession.session.rollback();
                    if (identityManagerSession == null) break block14;
                    identityManagerSession.close();
                }
                return obvSyncSnapshotNode2;
                {
                    catch (Throwable throwable) {
                        identityManagerSession.session.rollback();
                        throw throwable;
                    }
                }
            }
            identityManagerSession.session.rollback();
            return obvSyncSnapshotNode;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    public ObvSyncSnapshotNode getDeviceSnapshotWithinTransaction(IdentityManagerSession identityManagerSession) throws Exception {
        if (!identityManagerSession.session.isInTransaction()) {
            Logger.e("ERROR: called IdentityManager.getDeviceSnapshotWithinTransaction outside a transaction!");
            throw new Exception();
        }
        return IdentityManagerDeviceSnapshot.of(identityManagerSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, String> getAdditionalProfileInfo(Identity ownedIdentity) {
        try (IdentityManagerSession identityManagerSession = this.getSession();){
            Map<String, String> map;
            try {
                identityManagerSession.session.startTransaction();
                map = this.getAdditionalProfileInfoWithinTransaction(identityManagerSession, ownedIdentity);
            }
            catch (Exception e) {
                Map<String, String> map2;
                block14: {
                    Logger.x(e);
                    map2 = null;
                    identityManagerSession.session.rollback();
                    if (identityManagerSession == null) break block14;
                    identityManagerSession.close();
                }
                return map2;
                {
                    catch (Throwable throwable) {
                        identityManagerSession.session.rollback();
                        throw throwable;
                    }
                }
            }
            identityManagerSession.session.rollback();
            return map;
        }
        catch (SQLException e) {
            Logger.x(e);
            return null;
        }
    }

    private Map<String, String> getAdditionalProfileInfoWithinTransaction(IdentityManagerSession identityManagerSession, Identity ownedIdentity) throws Exception {
        if (!identityManagerSession.session.isInTransaction()) {
            Logger.e("ERROR: called IdentityManager.getAdditionalProfileInfoWithinTransaction outside a transaction!");
            throw new Exception();
        }
        String displayName = this.getCurrentDeviceDisplayName(identityManagerSession.session, ownedIdentity);
        if (displayName != null) {
            return Map.of("device_name", displayName);
        }
        return Collections.emptyMap();
    }

    @Override
    public ObvBackupAndSyncDelegate getSyncDelegate() {
        return this;
    }

    @Override
    public ObvBackupAndSyncDelegate getSyncDelegateWithinTransaction(final Session session) {
        return new ObvBackupAndSyncDelegate(){
            private final IdentityManagerSession identityManagerSession;
            {
                this.identityManagerSession = IdentityManager.this.wrapSession(session);
            }

            @Override
            public String getTag() {
                return IdentityManager.this.getTag();
            }

            @Override
            public ObvSyncSnapshotNode getSyncSnapshot(Identity ownedIdentity) {
                try {
                    return IdentityManager.this.getSyncSnapshotWithinTransaction(this.identityManagerSession, ownedIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }

            @Override
            public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreOwnedIdentity(ObvIdentity ownedIdentity, ObvSyncSnapshotNode node) throws Exception {
                return IdentityManager.this.restoreOwnedIdentity(ownedIdentity, node);
            }

            @Override
            public ObvBackupAndSyncDelegate.RestoreFinishedCallback restoreSyncSnapshot(ObvSyncSnapshotNode node) throws Exception {
                return IdentityManager.this.restoreSyncSnapshotWithinTransaction(this.identityManagerSession, node);
            }

            @Override
            public byte[] serialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, ObvSyncSnapshotNode snapshotNode) throws Exception {
                return IdentityManager.this.serialize(serializationContext, snapshotNode);
            }

            @Override
            public ObvSyncSnapshotNode deserialize(ObvBackupAndSyncDelegate.SerializationContext serializationContext, byte[] serializedSnapshotNode) throws Exception {
                return IdentityManager.this.deserialize(serializationContext, serializedSnapshotNode);
            }

            @Override
            public ObvSyncSnapshotNode getDeviceSnapshot() {
                try {
                    return IdentityManager.this.getDeviceSnapshotWithinTransaction(this.identityManagerSession);
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }

            @Override
            public Map<String, String> getAdditionalProfileInfo(Identity ownedIdentity) {
                try {
                    return IdentityManager.this.getAdditionalProfileInfoWithinTransaction(this.identityManagerSession, ownedIdentity);
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
        };
    }

    @Override
    public ObvIdentity restoreTransferredOwnedIdentity(Session session, String deviceName, IdentityManagerSyncSnapshot node) throws Exception {
        Identity ownedIdentity = Identity.of(node.owned_identity);
        return node.owned_identity_node.restoreOwnedIdentity(this.wrapSession(session), deviceName, ownedIdentity);
    }

    @Override
    public BackupSeed getOwnedIdentityBackupSeed(Session session, Identity ownedIdentity) throws SQLException {
        OwnedIdentity ownedIdentityObject = OwnedIdentity.get(this.wrapSession(session), ownedIdentity);
        if (ownedIdentityObject != null) {
            return ownedIdentityObject.getBackupSeed();
        }
        return null;
    }

    @Override
    public List<ObvDeviceBackupForRestore.ObvDeviceBackupProfile> getDeviceBackupProfileListFromDeviceBackup(Session session, ObvSyncSnapshotNode snapshotNode) throws Exception {
        if (!(snapshotNode instanceof IdentityManagerDeviceSnapshot)) {
            throw new Exception("Bad snapshot type");
        }
        ArrayList<ObvDeviceBackupForRestore.ObvDeviceBackupProfile> list = new ArrayList<ObvDeviceBackupForRestore.ObvDeviceBackupProfile>();
        IdentityManagerDeviceSnapshot identityManagerDeviceSnapshot = (IdentityManagerDeviceSnapshot)snapshotNode;
        if (!identityManagerDeviceSnapshot.validate()) {
            throw new Exception("Invalid IdentityManagerDeviceSnapshot");
        }
        IdentityManagerSession identityManagerSession = this.wrapSession(session);
        for (Map.Entry<ObvBytesKey, OwnedIdentityDeviceSnapshot> owned_identity : identityManagerDeviceSnapshot.owned_identities.entrySet()) {
            if (!owned_identity.getValue().validate()) continue;
            ObvDeviceBackupForRestore.ObvDeviceBackupProfile profile = new ObvDeviceBackupForRestore.ObvDeviceBackupProfile();
            profile.bytesProfileIdentity = owned_identity.getKey().getBytes();
            IdentityDetailsSyncSnapshot published_details = owned_identity.getValue().published_details;
            JsonIdentityDetailsWithVersionAndPhoto detailsAndPhoto = new JsonIdentityDetailsWithVersionAndPhoto();
            detailsAndPhoto.setVersion(published_details.version);
            detailsAndPhoto.setIdentityDetails((JsonIdentityDetails)this.jsonObjectMapper.readValue(published_details.serialized_details, JsonIdentityDetails.class));
            if (published_details.photo_server_label != null && published_details.photo_server_key != null) {
                detailsAndPhoto.setPhotoServerLabel(published_details.photo_server_label);
                detailsAndPhoto.setPhotoServerKey(published_details.photo_server_key);
                try {
                    UID label = new UID(published_details.photo_server_label);
                    AuthEncKey key = (AuthEncKey)new Encoded(published_details.photo_server_key).decodeSymmetricKey();
                    List<OwnedIdentityDetails> ownedIdentityDetailsList = OwnedIdentityDetails.getAllForOwnedIdentity(identityManagerSession, Identity.of(profile.bytesProfileIdentity));
                    for (OwnedIdentityDetails ownedIdentityDetails : ownedIdentityDetailsList) {
                        if (!label.equals(ownedIdentityDetails.getPhotoServerLabel()) || !key.equals(ownedIdentityDetails.getPhotoServerKey())) continue;
                        detailsAndPhoto.setPhotoUrl(ownedIdentityDetails.getPhotoUrl());
                        break;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            profile.identityDetails = detailsAndPhoto;
            profile.keycloakManaged = owned_identity.getValue().keycloak_managed;
            profile.profileBackupSeed = new BackupSeed(owned_identity.getValue().backup_seed).toString();
            list.add(profile);
        }
        return list;
    }
}

