/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.sync;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;

public class ObvSyncAtom {
    public static final int TYPE_CONTACT_NICKNAME_CHANGE = 0;
    public static final int TYPE_GROUP_V1_NICKNAME_CHANGE = 1;
    public static final int TYPE_GROUP_V2_NICKNAME_CHANGE = 2;
    public static final int TYPE_CONTACT_PERSONAL_NOTE_CHANGE = 3;
    public static final int TYPE_GROUP_V1_PERSONAL_NOTE_CHANGE = 4;
    public static final int TYPE_GROUP_V2_PERSONAL_NOTE_CHANGE = 5;
    public static final int TYPE_OWN_PROFILE_NICKNAME_CHANGE = 6;
    public static final int TYPE_CONTACT_CUSTOM_HUE_CHANGE = 7;
    public static final int TYPE_CONTACT_SEND_READ_RECEIPT_CHANGE = 8;
    public static final int TYPE_GROUP_V1_SEND_READ_RECEIPT_CHANGE = 9;
    public static final int TYPE_GROUP_V2_SEND_READ_RECEIPT_CHANGE = 10;
    public static final int TYPE_PINNED_DISCUSSIONS_CHANGE = 11;
    public static final int TYPE_TRUST_CONTACT_DETAILS = 12;
    public static final int TYPE_TRUST_GROUP_V1_DETAILS = 13;
    public static final int TYPE_TRUST_GROUP_V2_DETAILS = 14;
    public static final int TYPE_SETTING_DEFAULT_SEND_READ_RECEIPTS = 15;
    public static final int TYPE_SETTING_AUTO_JOIN_GROUPS = 16;
    public static final int TYPE_BOOKMARKED_MESSAGE_CHANGE = 17;
    public static final int TYPE_ARCHIVED_DISCUSSIONS_CHANGE = 18;
    public static final int TYPE_DISCUSSIONS_MUTE_CHANGE = 19;
    public static final int TYPE_SETTING_UNARCHIVE_ON_NOTIFICATION = 20;
    public static final int TYPE_SETTING_LAST_RATING = 21;
    public final int syncType;
    private final Identity contactIdentity;
    private final byte[] groupOwnerAndUid;
    private final byte[] bytesGroupIdentifier;
    private final String stringValue;
    private final Integer integerValue;
    private final Boolean booleanValue;
    private final List<DiscussionIdentifier> discussionIdentifiers;
    private final MessageIdentifier messageIdentifier;
    private final MuteNotification muteNotification;

    private ObvSyncAtom(int syncType, Identity contactIdentity, byte[] groupOwnerAndUid, byte[] bytesGroupIdentifier, String stringValue, Integer integerValue, Boolean booleanValue, List<DiscussionIdentifier> discussionIdentifiers, MessageIdentifier messageIdentifier, MuteNotification muteNotification) {
        this.syncType = syncType;
        this.contactIdentity = contactIdentity;
        this.groupOwnerAndUid = groupOwnerAndUid;
        this.bytesGroupIdentifier = bytesGroupIdentifier;
        this.stringValue = stringValue;
        this.integerValue = integerValue;
        this.booleanValue = booleanValue;
        this.discussionIdentifiers = discussionIdentifiers;
        this.messageIdentifier = messageIdentifier;
        this.muteNotification = muteNotification;
    }

    public static ObvSyncAtom createContactNicknameChange(byte[] bytesContactIdentity, String nickname) throws DecodingException {
        return new ObvSyncAtom(0, Identity.of(bytesContactIdentity), null, null, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createGroupV1NicknameChange(byte[] bytesGroupOwnerAndUid, String nickname) {
        return new ObvSyncAtom(1, null, bytesGroupOwnerAndUid, null, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createGroupV2NicknameChange(byte[] bytesGroupV2Identifier, String nickname) {
        return new ObvSyncAtom(2, null, null, bytesGroupV2Identifier, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createContactPersonalNoteChange(byte[] bytesContactIdentity, String personalNote) throws DecodingException {
        return new ObvSyncAtom(3, Identity.of(bytesContactIdentity), null, null, personalNote, null, null, null, null, null);
    }

    public static ObvSyncAtom createGroupV1PersonalNoteChange(byte[] bytesGroupOwnerAndUid, String nickname) {
        return new ObvSyncAtom(4, null, bytesGroupOwnerAndUid, null, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createGroupV2PersonalNoteChange(byte[] bytesGroupV2Identifier, String nickname) {
        return new ObvSyncAtom(5, null, null, bytesGroupV2Identifier, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createOwnProfileNicknameChange(String nickname) {
        return new ObvSyncAtom(6, null, null, null, nickname, null, null, null, null, null);
    }

    public static ObvSyncAtom createContactCustomHueChange(byte[] bytesContactIdentity, Integer customHue) throws DecodingException {
        return new ObvSyncAtom(7, Identity.of(bytesContactIdentity), null, null, null, customHue, null, null, null, null);
    }

    public static ObvSyncAtom createContactSendReadReceiptChange(byte[] bytesContactIdentity, Boolean sendReadReceipt) throws DecodingException {
        return new ObvSyncAtom(8, Identity.of(bytesContactIdentity), null, null, null, null, sendReadReceipt, null, null, null);
    }

    public static ObvSyncAtom createGroupV1SendReadReceiptChange(byte[] bytesGroupOwnerAndUid, Boolean sendReadReceipt) {
        return new ObvSyncAtom(9, null, bytesGroupOwnerAndUid, null, null, null, sendReadReceipt, null, null, null);
    }

    public static ObvSyncAtom createGroupV2SendReadReceiptChange(byte[] bytesGroupV2Identifier, Boolean sendReadReceipt) {
        return new ObvSyncAtom(10, null, null, bytesGroupV2Identifier, null, null, sendReadReceipt, null, null, null);
    }

    public static ObvSyncAtom createPinnedDiscussionsChange(List<DiscussionIdentifier> discussionIdentifiers, boolean ordered) {
        return new ObvSyncAtom(11, null, null, null, null, null, ordered, discussionIdentifiers, null, null);
    }

    public static ObvSyncAtom createTrustContactDetails(Identity contactIdentity, String serializedIdentityDetailsWithVersionAndPhoto) {
        return new ObvSyncAtom(12, contactIdentity, null, null, serializedIdentityDetailsWithVersionAndPhoto, null, null, null, null, null);
    }

    public static ObvSyncAtom createTrustGroupV1Details(byte[] bytesGroupOwnerAndUid, String serializedGroupDetailsWithVersionAndPhoto) {
        return new ObvSyncAtom(13, null, bytesGroupOwnerAndUid, null, serializedGroupDetailsWithVersionAndPhoto, null, null, null, null, null);
    }

    public static ObvSyncAtom createTrustGroupV2Details(GroupV2.Identifier groupIdentifier, int version) {
        return new ObvSyncAtom(14, null, null, groupIdentifier.encode().getBytes(), null, version, null, null, null, null);
    }

    public static ObvSyncAtom createSettingDefaultSendReadReceipts(boolean sendReadReceipt) {
        return new ObvSyncAtom(15, null, null, null, null, null, sendReadReceipt, null, null, null);
    }

    public static ObvSyncAtom createSettingAutoJoinGroups(String autoJoinGroupsType) {
        return new ObvSyncAtom(16, null, null, null, autoJoinGroupsType, null, null, null, null, null);
    }

    public static ObvSyncAtom createBookmarkedMessageChange(MessageIdentifier messageIdentifier, boolean bookmarked) {
        return new ObvSyncAtom(17, null, null, null, null, null, bookmarked, null, messageIdentifier, null);
    }

    public static ObvSyncAtom createArchivedDiscussionsChange(List<DiscussionIdentifier> discussionIdentifiers, boolean archived) {
        return new ObvSyncAtom(18, null, null, null, null, null, archived, discussionIdentifiers, null, null);
    }

    public static ObvSyncAtom createDiscussionsMuteChange(List<DiscussionIdentifier> discussionIdentifiers, MuteNotification muteNotification) {
        return new ObvSyncAtom(19, null, null, null, null, null, null, discussionIdentifiers, null, muteNotification);
    }

    public static ObvSyncAtom createSettingUnarchiveOnNotification(Boolean unarchiveOnNotification) {
        return new ObvSyncAtom(20, null, null, null, null, null, unarchiveOnNotification, null, null, null);
    }

    public static ObvSyncAtom createSettingLastRating(int lastRating, long lastRatingTimestamp) {
        return new ObvSyncAtom(21, null, null, null, Long.toString(lastRatingTimestamp), lastRating, null, null, null, null);
    }

    public boolean isAppSyncItem() {
        switch (this.syncType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                return true;
            }
        }
        return false;
    }

    public byte[] getBytesContactIdentity() {
        return this.contactIdentity.getBytes();
    }

    public Identity getContactIdentity() {
        return this.contactIdentity;
    }

    public byte[] getBytesGroupOwnerAndUid() {
        return this.groupOwnerAndUid;
    }

    public byte[] getBytesGroupIdentifier() {
        return this.bytesGroupIdentifier;
    }

    public GroupV2.Identifier getGroupIdentifier() throws DecodingException {
        return GroupV2.Identifier.of(this.bytesGroupIdentifier);
    }

    public String getStringValue() {
        if (this.stringValue == null) {
            return null;
        }
        String out = this.stringValue.trim();
        if (out.isEmpty()) {
            return null;
        }
        return out;
    }

    public Integer getIntegerValue() {
        return this.integerValue;
    }

    public Boolean getBooleanValue() {
        return this.booleanValue;
    }

    public List<DiscussionIdentifier> getDiscussionIdentifiers() {
        return this.discussionIdentifiers;
    }

    public MessageIdentifier getMessageIdentifier() {
        return this.messageIdentifier;
    }

    public MuteNotification getMuteNotification() {
        return this.muteNotification;
    }

    public Encoded encode() {
        ArrayList<Encoded> encodeds = new ArrayList<Encoded>();
        encodeds.add(Encoded.of(this.syncType));
        switch (this.syncType) {
            case 0: 
            case 3: {
                encodeds.add(Encoded.of(this.contactIdentity));
                if (this.stringValue == null) break;
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 1: 
            case 4: {
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, 0, this.groupOwnerAndUid.length - 32)));
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length)));
                if (this.stringValue == null) break;
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 2: 
            case 5: {
                encodeds.add(Encoded.of(this.bytesGroupIdentifier));
                if (this.stringValue == null) break;
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 6: {
                if (this.stringValue == null) break;
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 7: {
                encodeds.add(Encoded.of(this.contactIdentity));
                if (this.integerValue == null) break;
                encodeds.add(Encoded.of(this.integerValue.intValue()));
                break;
            }
            case 8: {
                encodeds.add(Encoded.of(this.contactIdentity));
                if (this.booleanValue == null) break;
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 9: {
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, 0, this.groupOwnerAndUid.length - 32)));
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length)));
                if (this.booleanValue == null) break;
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 10: {
                encodeds.add(Encoded.of(this.bytesGroupIdentifier));
                if (this.booleanValue == null) break;
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 11: 
            case 18: {
                ArrayList<Encoded> encodedDiscussionIdentifiers = new ArrayList<Encoded>();
                for (DiscussionIdentifier discussionIdentifier : this.discussionIdentifiers) {
                    encodedDiscussionIdentifiers.add(discussionIdentifier.encode());
                }
                encodeds.add(Encoded.of(encodedDiscussionIdentifiers.toArray(new Encoded[0])));
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 12: {
                encodeds.add(Encoded.of(this.contactIdentity));
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 13: {
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, 0, this.groupOwnerAndUid.length - 32)));
                encodeds.add(Encoded.of(Arrays.copyOfRange(this.groupOwnerAndUid, this.groupOwnerAndUid.length - 32, this.groupOwnerAndUid.length)));
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 14: {
                encodeds.add(Encoded.of(this.bytesGroupIdentifier));
                encodeds.add(Encoded.of(this.integerValue.intValue()));
                break;
            }
            case 15: 
            case 20: {
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 16: {
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            case 17: {
                encodeds.add(this.messageIdentifier.encode());
                encodeds.add(Encoded.of(this.booleanValue));
                break;
            }
            case 19: {
                ArrayList<Encoded> encodedDiscussionIdentifiers = new ArrayList<Encoded>();
                for (DiscussionIdentifier discussionIdentifier : this.discussionIdentifiers) {
                    encodedDiscussionIdentifiers.add(discussionIdentifier.encode());
                }
                encodeds.add(Encoded.of(encodedDiscussionIdentifiers.toArray(new Encoded[0])));
                encodeds.add(this.muteNotification.encode());
                break;
            }
            case 21: {
                encodeds.add(Encoded.of(this.integerValue.intValue()));
                encodeds.add(Encoded.of(this.stringValue));
                break;
            }
            default: {
                return null;
            }
        }
        return Encoded.of(encodeds.toArray(new Encoded[0]));
    }

    public static ObvSyncAtom of(Encoded encoded) throws DecodingException {
        Encoded[] encodeds = encoded.decodeList();
        if (encodeds.length == 0) {
            throw new DecodingException();
        }
        int syncType = (int)encodeds[0].decodeLong();
        switch (syncType) {
            case 0: 
            case 3: {
                if (encodeds.length == 2) {
                    return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, null, null, null, null, null, null);
                }
                if (encodeds.length != 3) break;
                return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, encodeds[2].decodeString(), null, null, null, null, null);
            }
            case 1: 
            case 4: {
                if (encodeds.length == 3) {
                    return new ObvSyncAtom(syncType, null, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()), null, null, null, null, null, null, null);
                }
                if (encodeds.length != 4) break;
                return new ObvSyncAtom(syncType, null, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()), null, encodeds[3].decodeString(), null, null, null, null, null);
            }
            case 2: 
            case 5: {
                if (encodeds.length == 2) {
                    return new ObvSyncAtom(syncType, null, null, encodeds[1].decodeBytes(), null, null, null, null, null, null);
                }
                if (encodeds.length != 3) break;
                return new ObvSyncAtom(syncType, null, null, encodeds[1].decodeBytes(), encodeds[2].decodeString(), null, null, null, null, null);
            }
            case 6: {
                if (encodeds.length == 1) {
                    return new ObvSyncAtom(syncType, null, null, null, null, null, null, null, null, null);
                }
                if (encodeds.length != 2) break;
                return new ObvSyncAtom(syncType, null, null, null, encodeds[1].decodeString(), null, null, null, null, null);
            }
            case 7: {
                if (encodeds.length == 2) {
                    return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, null, null, null, null, null, null);
                }
                if (encodeds.length != 3) break;
                return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, null, (int)encodeds[2].decodeLong(), null, null, null, null);
            }
            case 8: {
                if (encodeds.length == 2) {
                    return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, null, null, null, null, null, null);
                }
                if (encodeds.length != 3) break;
                return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, null, null, encodeds[2].decodeBoolean(), null, null, null);
            }
            case 9: {
                if (encodeds.length == 3) {
                    return new ObvSyncAtom(syncType, null, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()), null, null, null, null, null, null, null);
                }
                if (encodeds.length != 4) break;
                return new ObvSyncAtom(syncType, null, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()), null, null, null, encodeds[3].decodeBoolean(), null, null, null);
            }
            case 10: {
                if (encodeds.length == 2) {
                    return new ObvSyncAtom(syncType, null, null, encodeds[1].decodeBytes(), null, null, null, null, null, null);
                }
                if (encodeds.length != 3) break;
                return new ObvSyncAtom(syncType, null, null, encodeds[1].decodeBytes(), null, null, encodeds[2].decodeBoolean(), null, null, null);
            }
            case 11: 
            case 18: {
                ArrayList<DiscussionIdentifier> discussionIdentifiers = new ArrayList<DiscussionIdentifier>();
                for (Encoded encodedDiscussionIdentifier : encodeds[1].decodeList()) {
                    discussionIdentifiers.add(DiscussionIdentifier.of(encodedDiscussionIdentifier));
                }
                return new ObvSyncAtom(syncType, null, null, null, null, null, encodeds[2].decodeBoolean(), discussionIdentifiers, null, null);
            }
            case 12: {
                return new ObvSyncAtom(syncType, encodeds[1].decodeIdentity(), null, null, encodeds[2].decodeString(), null, null, null, null, null);
            }
            case 13: {
                return new ObvSyncAtom(syncType, null, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()), null, encodeds[3].decodeString(), null, null, null, null, null);
            }
            case 14: {
                return new ObvSyncAtom(syncType, null, null, encodeds[1].decodeBytes(), null, (int)encodeds[2].decodeLong(), null, null, null, null);
            }
            case 15: 
            case 20: {
                return new ObvSyncAtom(syncType, null, null, null, null, null, encodeds[1].decodeBoolean(), null, null, null);
            }
            case 16: {
                return new ObvSyncAtom(syncType, null, null, null, encodeds[1].decodeString(), null, null, null, null, null);
            }
            case 17: {
                return new ObvSyncAtom(syncType, null, null, null, null, null, encodeds[2].decodeBoolean(), null, MessageIdentifier.of(encodeds[1]), null);
            }
            case 19: {
                ArrayList<DiscussionIdentifier> discussionIdentifiers = new ArrayList<DiscussionIdentifier>();
                for (Encoded encodedDiscussionIdentifier : encodeds[1].decodeList()) {
                    discussionIdentifiers.add(DiscussionIdentifier.of(encodedDiscussionIdentifier));
                }
                return new ObvSyncAtom(syncType, null, null, null, null, null, null, discussionIdentifiers, null, MuteNotification.of(encodeds[2]));
            }
            case 21: {
                return new ObvSyncAtom(syncType, null, null, null, encodeds[2].decodeString(), (int)encodeds[1].decodeLong(), null, null, null, null);
            }
        }
        throw new DecodingException();
    }

    private static byte[] joinArrays(byte[] a, byte[] b) {
        byte[] out = new byte[a.length + b.length];
        System.arraycopy(a, 0, out, 0, a.length);
        System.arraycopy(b, 0, out, a.length, b.length);
        return out;
    }

    public static class MessageIdentifier {
        public final DiscussionIdentifier discussionIdentifier;
        public final byte[] senderIdentifier;
        public final UUID senderThreadIdentifier;
        public final long senderSequenceNumber;

        public MessageIdentifier(DiscussionIdentifier discussionIdentifier, byte[] senderIdentifier, UUID senderThreadIdentifier, long senderSequenceNumber) {
            this.discussionIdentifier = discussionIdentifier;
            this.senderIdentifier = senderIdentifier;
            this.senderThreadIdentifier = senderThreadIdentifier;
            this.senderSequenceNumber = senderSequenceNumber;
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.discussionIdentifier.encode(), Encoded.of(this.senderIdentifier), Encoded.of(this.senderThreadIdentifier), Encoded.of(this.senderSequenceNumber)});
        }

        public static MessageIdentifier of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length != 4) {
                throw new DecodingException();
            }
            return new MessageIdentifier(DiscussionIdentifier.of(encodeds[0]), encodeds[1].decodeBytes(), encodeds[2].decodeUuid(), encodeds[3].decodeLong());
        }
    }

    public static class MuteNotification {
        public static final String MUTED = "m";
        public static final String MUTE_TIMESTAMP = "t";
        public static final String EXCEPT_MENTIONED = "e";
        public final boolean muted;
        public final Long muteTimestamp;
        public final boolean exceptMentioned;

        public MuteNotification(boolean muted, Long muteTimestamp, boolean exceptMentioned) {
            this.muted = muted;
            this.muteTimestamp = muteTimestamp;
            this.exceptMentioned = exceptMentioned;
        }

        public Encoded encode() {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            map.put(new DictionaryKey(MUTED), Encoded.of(this.muted));
            if (this.muteTimestamp != null) {
                map.put(new DictionaryKey(MUTE_TIMESTAMP), Encoded.of(this.muteTimestamp));
            }
            map.put(new DictionaryKey(EXCEPT_MENTIONED), Encoded.of(this.exceptMentioned));
            return Encoded.of(map);
        }

        public static MuteNotification of(Encoded encoded) throws DecodingException {
            HashMap<DictionaryKey, Encoded> map = encoded.decodeDictionary();
            boolean muted = map.get(new DictionaryKey(MUTED)).decodeBoolean();
            Encoded encodedTimestamp = map.get(new DictionaryKey(MUTE_TIMESTAMP));
            Long muteTimestamp = encodedTimestamp == null ? null : Long.valueOf(encodedTimestamp.decodeLong());
            Encoded encodedMentions = map.get(new DictionaryKey(EXCEPT_MENTIONED));
            boolean exceptMentioned = encodedMentions == null || encodedMentions.decodeBoolean();
            return new MuteNotification(muted, muteTimestamp, exceptMentioned);
        }
    }

    public static class DiscussionIdentifier {
        public static final int CONTACT = 0;
        public static final int GROUP_V1 = 1;
        public static final int GROUP_V2 = 2;
        public final int type;
        public final byte[] bytesDiscussionIdentifier;

        public DiscussionIdentifier(int type, byte[] bytesDiscussionIdentifier) {
            this.type = type;
            this.bytesDiscussionIdentifier = bytesDiscussionIdentifier;
        }

        public Encoded encode() {
            ArrayList<Encoded> encodeds = new ArrayList<Encoded>();
            encodeds.add(Encoded.of(this.type));
            switch (this.type) {
                case 0: 
                case 2: {
                    encodeds.add(Encoded.of(this.bytesDiscussionIdentifier));
                    break;
                }
                case 1: {
                    encodeds.add(Encoded.of(Arrays.copyOfRange(this.bytesDiscussionIdentifier, 0, this.bytesDiscussionIdentifier.length - 32)));
                    encodeds.add(Encoded.of(Arrays.copyOfRange(this.bytesDiscussionIdentifier, this.bytesDiscussionIdentifier.length - 32, this.bytesDiscussionIdentifier.length)));
                    break;
                }
                default: {
                    return null;
                }
            }
            return Encoded.of(encodeds.toArray(new Encoded[0]));
        }

        public static DiscussionIdentifier of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length == 0) {
                throw new DecodingException();
            }
            int type = (int)encodeds[0].decodeLong();
            switch (type) {
                case 0: 
                case 2: {
                    return new DiscussionIdentifier(type, encodeds[1].decodeBytes());
                }
                case 1: {
                    return new DiscussionIdentifier(type, ObvSyncAtom.joinArrays(encodeds[1].decodeBytes(), encodeds[2].decodeBytes()));
                }
            }
            throw new DecodingException();
        }
    }
}

