/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.sync;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import java.util.HashMap;
import java.util.Map;

public class ObvProfileBackupSnapshot {
    public static final String SNAPSHOT = "snapshot";
    public static final String ADDITIONAL_INFO = "additional_info";
    public static final String TIMESTAMP = "timestamp";
    public static final String INFO_PLATFORM = "platform";
    public static final String INFO_DEVICE_NAME = "device_name";
    private final ObvSyncSnapshot snapshot;
    private final Map<String, String> additional_info;
    private final long timestamp;

    private ObvProfileBackupSnapshot(ObvSyncSnapshot snapshot, long timestamp, Map<String, String> additional_info) {
        this.snapshot = snapshot;
        this.timestamp = timestamp;
        this.additional_info = additional_info;
    }

    public Map<String, String> getAdditionalInfo() {
        return this.additional_info;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ObvSyncSnapshot getSnapshot() {
        return this.snapshot;
    }

    public static ObvProfileBackupSnapshot get(Identity ownedIdentity, ObvBackupAndSyncDelegate ... delegates) {
        ObvSyncSnapshot obvSyncSnapshot = ObvSyncSnapshot.get(ownedIdentity, delegates);
        HashMap<String, String> additionalProfileInfo = new HashMap<String, String>();
        for (ObvBackupAndSyncDelegate delegate : delegates) {
            additionalProfileInfo.putAll(delegate.getAdditionalProfileInfo(ownedIdentity));
        }
        return new ObvProfileBackupSnapshot(obvSyncSnapshot, System.currentTimeMillis(), additionalProfileInfo);
    }

    public HashMap<DictionaryKey, Encoded> toEncodedDictionary(ObvBackupAndSyncDelegate ... delegates) {
        try {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            map.put(new DictionaryKey(SNAPSHOT), Encoded.of(this.snapshot.toEncodedDictionary(delegates)));
            map.put(new DictionaryKey(ADDITIONAL_INFO), Encoded.of(this.additional_info));
            map.put(new DictionaryKey(TIMESTAMP), Encoded.of(this.timestamp));
            return map;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ObvProfileBackupSnapshot fromEncodedDictionary(HashMap<DictionaryKey, Encoded> map, ObvBackupAndSyncDelegate ... delegates) {
        try {
            Encoded encodedSnapshot = map.get(new DictionaryKey(SNAPSHOT));
            Encoded encodedTimestamp = map.get(new DictionaryKey(TIMESTAMP));
            Encoded encodedAdditionalInfo = map.get(new DictionaryKey(ADDITIONAL_INFO));
            if (encodedSnapshot == null || encodedTimestamp == null) {
                return null;
            }
            return new ObvProfileBackupSnapshot(ObvSyncSnapshot.fromEncodedDictionary(encodedSnapshot.decodeDictionary(), delegates), encodedTimestamp.decodeLong(), encodedAdditionalInfo == null ? new HashMap() : encodedAdditionalInfo.decodeStringMap());
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }
}

