/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.sync;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import java.util.HashMap;

public class ObvDeviceBackupSnapshot {
    private final HashMap<String, ObvSyncSnapshotNode> snapshotMap;

    private ObvDeviceBackupSnapshot(HashMap<String, ObvSyncSnapshotNode> snapshotMap) {
        this.snapshotMap = snapshotMap;
    }

    public static ObvDeviceBackupSnapshot get(ObvBackupAndSyncDelegate ... delegates) {
        HashMap<String, ObvSyncSnapshotNode> snapshotMap = new HashMap<String, ObvSyncSnapshotNode>();
        for (ObvBackupAndSyncDelegate delegate : delegates) {
            snapshotMap.put(delegate.getTag(), delegate.getDeviceSnapshot());
        }
        return new ObvDeviceBackupSnapshot(snapshotMap);
    }

    public HashMap<DictionaryKey, Encoded> toEncodedDictionary(ObvBackupAndSyncDelegate ... delegates) {
        try {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                ObvSyncSnapshotNode node = this.snapshotMap.get(delegate.getTag());
                if (node == null) {
                    return null;
                }
                map.put(new DictionaryKey(delegate.getTag()), Encoded.of(delegate.serialize(ObvBackupAndSyncDelegate.SerializationContext.DEVICE, node)));
            }
            return map;
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public static ObvDeviceBackupSnapshot fromEncodedDictionary(HashMap<DictionaryKey, Encoded> map, ObvBackupAndSyncDelegate ... delegates) {
        try {
            HashMap<String, ObvSyncSnapshotNode> snapshotMap = new HashMap<String, ObvSyncSnapshotNode>();
            for (ObvBackupAndSyncDelegate delegate : delegates) {
                Encoded encodedNode = map.get(new DictionaryKey(delegate.getTag()));
                if (encodedNode == null) {
                    return null;
                }
                snapshotMap.put(delegate.getTag(), delegate.deserialize(ObvBackupAndSyncDelegate.SerializationContext.DEVICE, encodedNode.decodeBytes()));
            }
            return new ObvDeviceBackupSnapshot(snapshotMap);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    public ObvSyncSnapshotNode getSnapshotNode(String tag) {
        return this.snapshotMap.get(tag);
    }
}

