/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.metamanager.IdentityDelegate;

public class ObvTrustOrigin {
    private final TYPE type;
    private final long timestamp;
    private final ObvIdentity mediatorOrGroupOwner;
    private final String keycloakServer;
    private final byte[] bytesGroupIdentifier;

    public TYPE getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public ObvIdentity getMediatorOrGroupOwner() {
        return this.mediatorOrGroupOwner;
    }

    public String getKeycloakServer() {
        return this.keycloakServer;
    }

    public byte[] getBytesGroupIdentifier() {
        return this.bytesGroupIdentifier;
    }

    public ObvTrustOrigin(Session session, IdentityDelegate identityDelegate, TrustOrigin trustOrigin, Identity ownedIdentity) throws Exception {
        switch (trustOrigin.getType()) {
            case DIRECT: {
                this.type = TYPE.DIRECT;
                break;
            }
            case INTRODUCTION: {
                this.type = TYPE.INTRODUCTION;
                break;
            }
            case GROUP: {
                this.type = TYPE.GROUP;
                break;
            }
            case KEYCLOAK: {
                this.type = TYPE.KEYCLOAK;
                break;
            }
            case SERVER_GROUP_V2: {
                this.type = TYPE.SERVER_GROUP_V2;
                break;
            }
            default: {
                throw new Exception("Unknown TrustOrigin type " + String.valueOf((Object)trustOrigin.getType()));
            }
        }
        this.timestamp = trustOrigin.getTimestamp();
        ObvIdentity mediatorOrGroupOwner = null;
        if (trustOrigin.getMediatorOrGroupOwnerIdentity() != null) {
            try {
                mediatorOrGroupOwner = new ObvIdentity(session, identityDelegate, trustOrigin.getMediatorOrGroupOwnerIdentity(), ownedIdentity);
            }
            catch (Exception e) {
                mediatorOrGroupOwner = new ObvIdentity(trustOrigin.getMediatorOrGroupOwnerIdentity(), new JsonIdentityDetails(), false, true);
            }
        }
        this.mediatorOrGroupOwner = mediatorOrGroupOwner;
        this.keycloakServer = trustOrigin.getKeycloakServer();
        this.bytesGroupIdentifier = trustOrigin.getGroupIdentifier() == null ? null : trustOrigin.getGroupIdentifier().getBytes();
    }

    public static enum TYPE {
        DIRECT,
        INTRODUCTION,
        GROUP,
        KEYCLOAK,
        SERVER_GROUP_V2;

    }
}

