/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.ObvBase64;
import io.olvid.engine.encoder.Encoded;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObvMutualScanUrl {
    public static final String URL_PROTOCOL = "https";
    public static final String URL_PROTOCOL_OLVID = "olvid";
    public static final String URL_INVITATION_HOST = "invitation.olvid.io";
    public static final Pattern MUTUAL_SCAN_PATTERN = Pattern.compile("(https|olvid)" + Pattern.quote("://invitation.olvid.io") + "/2#([-_a-zA-Z0-9]+)");
    public final Identity identity;
    public final String displayName;
    public final byte[] signature;

    public ObvMutualScanUrl(Identity identity, String displayName, byte[] signature) {
        this.identity = identity;
        this.displayName = displayName;
        this.signature = signature;
    }

    public byte[] getBytesIdentity() {
        return this.identity.getBytes();
    }

    public String getUrlRepresentation() {
        return "https://invitation.olvid.io/2#" + ObvBase64.encode(Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(this.displayName), Encoded.of(this.signature)}).getBytes());
    }

    public static ObvMutualScanUrl fromUrlRepresentation(String urlRepresentation) {
        Matcher matcher = MUTUAL_SCAN_PATTERN.matcher(urlRepresentation);
        if (matcher.find()) {
            try {
                Encoded[] list = new Encoded(ObvBase64.decode(matcher.group(2))).decodeList();
                Identity identity = list[0].decodeIdentity();
                String displayName = list[1].decodeString();
                byte[] signature = list[2].decodeBytes();
                return new ObvMutualScanUrl(identity, displayName, signature);
            }
            catch (Exception e) {
                Logger.x(e);
                return null;
            }
        }
        return null;
    }
}

