/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types.identities;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.metamanager.IdentityDelegate;
import java.sql.SQLException;
import java.util.Arrays;

public class ObvIdentity
implements Comparable<ObvIdentity> {
    protected final Identity identity;
    protected final JsonIdentityDetails identityDetails;
    protected final boolean keycloakManaged;
    protected final boolean active;

    public ObvIdentity(Identity identity, JsonIdentityDetails identityDetails, boolean keycloakManaged, boolean active) {
        this.identity = identity;
        this.identityDetails = identityDetails;
        this.keycloakManaged = keycloakManaged;
        this.active = active;
    }

    public ObvIdentity(Session session, IdentityDelegate identityDelegate, Identity ownedIdentity) throws SQLException {
        this.identity = ownedIdentity;
        this.identityDetails = identityDelegate.getOwnedIdentityPublishedDetails(session, ownedIdentity).getIdentityDetails();
        this.keycloakManaged = identityDelegate.isOwnedIdentityKeycloakManaged(session, ownedIdentity);
        this.active = identityDelegate.isActiveOwnedIdentity(session, ownedIdentity);
    }

    public ObvIdentity(Session session, IdentityDelegate identityDelegate, Identity contactIdentity, Identity ownedIdentity) throws SQLException {
        this.identity = contactIdentity;
        this.identityDetails = identityDelegate.getContactIdentityTrustedDetails(session, ownedIdentity, contactIdentity);
        this.keycloakManaged = identityDelegate.isContactIdentityCertifiedByOwnKeycloak(session, ownedIdentity, contactIdentity);
        this.active = identityDelegate.isIdentityAnActiveContactOfOwnedIdentity(session, ownedIdentity, contactIdentity);
    }

    public byte[] getBytesIdentity() {
        return this.identity.getBytes();
    }

    public String getServer() {
        return this.identity.getServer();
    }

    public JsonIdentityDetails getIdentityDetails() {
        return this.identityDetails;
    }

    public boolean isKeycloakManaged() {
        return this.keycloakManaged;
    }

    public boolean isActive() {
        return this.active;
    }

    public static ObvIdentity of(Encoded encoded, ObjectMapper jsonObjectMapper) throws Exception {
        Encoded[] list = encoded.decodeList();
        if (list.length != 2) {
            throw new DecodingException();
        }
        return new ObvIdentity(list[0].decodeIdentity(), (JsonIdentityDetails)jsonObjectMapper.readValue(list[1].decodeString(), JsonIdentityDetails.class), false, true);
    }

    public Encoded encode(ObjectMapper jsonObjectMapper) throws Exception {
        return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(jsonObjectMapper.writeValueAsString((Object)this.identityDetails))});
    }

    public int hashCode() {
        return Arrays.hashCode(this.identity.getBytes());
    }

    public boolean equals(Object other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        return this.identity.equals(((ObvIdentity)other).identity);
    }

    @Override
    public int compareTo(ObvIdentity o) {
        return this.identity.computeUniqueUid().compareTo(o.identity.computeUniqueUid());
    }

    public Identity getIdentity() {
        return this.identity;
    }
}

