/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.types.ObvTransferStep;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import java.util.UUID;

public class ObvDialog {
    private final UUID uuid;
    private final Encoded encodedElements;
    private final byte[] bytesOwnedIdentity;
    private final Category category;
    private Encoded encodedResponse;

    public UUID getUuid() {
        return this.uuid;
    }

    public Encoded getEncodedElements() {
        return this.encodedElements;
    }

    public byte[] getBytesOwnedIdentity() {
        return this.bytesOwnedIdentity;
    }

    public Encoded getEncodedResponse() {
        return this.encodedResponse;
    }

    public Category getCategory() {
        return this.category;
    }

    public ObvDialog(UUID uuid, Encoded encodedElements, byte[] bytesOwnedIdentity, Category category) {
        this.uuid = uuid;
        this.encodedElements = encodedElements;
        this.bytesOwnedIdentity = bytesOwnedIdentity;
        this.category = category;
        this.encodedResponse = null;
    }

    public static ObvDialog of(Encoded encoded, ObjectMapper jsonObjectMapper) throws Exception {
        Encoded[] list = encoded.decodeList();
        if (list.length != 4) {
            throw new DecodingException();
        }
        return new ObvDialog(list[0].decodeUuid(), list[1], list[2].decodeBytes(), Category.of(list[3], jsonObjectMapper));
    }

    public Encoded encode(ObjectMapper jsonObjectMapper) {
        return Encoded.of(new Encoded[]{Encoded.of(this.uuid), this.encodedElements, Encoded.of(this.bytesOwnedIdentity), this.category.encode(jsonObjectMapper)});
    }

    public void setResponseToAcceptInvite(boolean acceptInvite) throws Exception {
        if (this.category.id != 1) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(acceptInvite);
    }

    public void setResponseToSasExchange(byte[] otherSas) throws Exception {
        if (this.category.id != 2) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(otherSas);
    }

    public void setResponseToAcceptMediatorInvite(boolean acceptInvite) throws Exception {
        if (this.category.id != 6) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(acceptInvite);
    }

    public void setResponseToAcceptGroupInvite(boolean acceptInvite) throws Exception {
        if (this.category.id != 8 && this.category.id != 15 && (this.category.id != 16 || acceptInvite)) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(acceptInvite);
    }

    public void setAbortOneToOneInvitationSent(boolean abort) throws Exception {
        if (this.category.id != 13) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(abort);
    }

    public void setResponseToAcceptOneToOneInvitation(boolean acceptInvitation) throws Exception {
        if (this.category.id != 14) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(acceptInvitation);
    }

    public void setAbortTransfer() throws Exception {
        if (this.category.id != 18) {
            throw new Exception();
        }
        this.encodedResponse = null;
    }

    public void setTransferSessionNumber(long sessionNumber) throws Exception {
        if (this.category.id != 18 || this.category.obvTransferStep.getStep() != ObvTransferStep.Step.TARGET_SESSION_NUMBER_INPUT) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(sessionNumber);
    }

    public void setTransferSasAndDeviceUid(String sas, byte[] deviceUidToKeepActive) throws Exception {
        if (this.category.id == 18 && this.category.obvTransferStep.getStep() == ObvTransferStep.Step.SOURCE_SAS_INPUT) {
            this.encodedResponse = deviceUidToKeepActive == null ? Encoded.of(new Encoded[]{Encoded.of(sas)}) : Encoded.of(new Encoded[]{Encoded.of(sas), Encoded.of(deviceUidToKeepActive)});
        } else {
            throw new Exception();
        }
    }

    public void setTransferAuthenticationProof(String signature, String serializedAuthState) throws Exception {
        if (this.category.id != 18 || this.category.obvTransferStep.getStep() != ObvTransferStep.Step.TARGET_REQUESTS_KEYCLOAK_AUTHENTICATION_PROOF) {
            throw new Exception();
        }
        this.encodedResponse = Encoded.of(new Encoded[]{Encoded.of(signature), Encoded.of(serializedAuthState)});
    }

    public static class Category {
        public static final int UNKNOWN_DIALOG_CATEGORY = -1;
        public static final int INVITE_SENT_DIALOG_CATEGORY = 0;
        public static final int ACCEPT_INVITE_DIALOG_CATEGORY = 1;
        public static final int SAS_EXCHANGE_DIALOG_CATEGORY = 2;
        public static final int SAS_CONFIRMED_DIALOG_CATEGORY = 3;
        public static final int INVITE_ACCEPTED_DIALOG_CATEGORY = 5;
        public static final int ACCEPT_MEDIATOR_INVITE_DIALOG_CATEGORY = 6;
        public static final int MEDIATOR_INVITE_ACCEPTED_DIALOG_CATEGORY = 7;
        public static final int ACCEPT_GROUP_INVITE_DIALOG_CATEGORY = 8;
        public static final int ONE_TO_ONE_INVITATION_SENT_DIALOG_CATEGORY = 13;
        public static final int ACCEPT_ONE_TO_ONE_INVITATION_DIALOG_CATEGORY = 14;
        public static final int GROUP_V2_INVITATION_DIALOG_CATEGORY = 15;
        public static final int GROUP_V2_FROZEN_INVITATION_DIALOG_CATEGORY = 16;
        public static final int SYNC_ITEM_TO_APPLY_DIALOG_CATEGORY = 17;
        public static final int TRANSFER_DIALOG_CATEGORY = 18;
        private final int id;
        private final byte[] bytesContactIdentity;
        private final String contactDisplayNameOrSerializedDetails;
        private final byte[] sasToDisplay;
        private final byte[] sasEntered;
        private final byte[] bytesMediatorOrGroupOwnerIdentity;
        private final String serializedGroupDetails;
        private final byte[] bytesGroupUid;
        private final ObvIdentity[] pendingGroupMemberIdentities;
        public final Long serverTimestamp;
        private final ObvGroupV2 obvGroupV2;
        private final ObvSyncAtom obvSyncAtom;
        public final ObvTransferStep obvTransferStep;

        public Category(int id, byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, byte[] sasToDisplay, byte[] sasEntered, byte[] bytesMediatorOrGroupOwnerIdentity, String serializedGroupDetails, byte[] bytesGroupUid, ObvIdentity[] pendingGroupMemberIdentities, Long serverTimestamp, ObvGroupV2 obvGroupV2, ObvSyncAtom obvSyncAtom, ObvTransferStep obvTransferStep) {
            this.id = id;
            this.bytesContactIdentity = bytesContactIdentity;
            this.contactDisplayNameOrSerializedDetails = contactDisplayNameOrSerializedDetails;
            this.sasToDisplay = sasToDisplay;
            this.sasEntered = sasEntered;
            this.bytesMediatorOrGroupOwnerIdentity = bytesMediatorOrGroupOwnerIdentity;
            this.serializedGroupDetails = serializedGroupDetails;
            this.bytesGroupUid = bytesGroupUid;
            this.pendingGroupMemberIdentities = pendingGroupMemberIdentities;
            this.serverTimestamp = serverTimestamp;
            this.obvGroupV2 = obvGroupV2;
            this.obvSyncAtom = obvSyncAtom;
            this.obvTransferStep = obvTransferStep;
        }

        public int getId() {
            return this.id;
        }

        public byte[] getSasToDisplay() {
            return this.sasToDisplay;
        }

        public String getSerializedGroupDetails() {
            return this.serializedGroupDetails;
        }

        public byte[] getBytesGroupUid() {
            return this.bytesGroupUid;
        }

        public byte[] getBytesGroupOwnerAndUid() {
            byte[] out = new byte[this.bytesMediatorOrGroupOwnerIdentity.length + this.bytesGroupUid.length];
            System.arraycopy(this.bytesMediatorOrGroupOwnerIdentity, 0, out, 0, this.bytesMediatorOrGroupOwnerIdentity.length);
            System.arraycopy(this.bytesGroupUid, 0, out, this.bytesMediatorOrGroupOwnerIdentity.length, this.bytesGroupUid.length);
            return out;
        }

        public String getContactDisplayNameOrSerializedDetails() {
            return this.contactDisplayNameOrSerializedDetails;
        }

        public byte[] getBytesMediatorOrGroupOwnerIdentity() {
            return this.bytesMediatorOrGroupOwnerIdentity;
        }

        public byte[] getBytesContactIdentity() {
            return this.bytesContactIdentity;
        }

        public ObvIdentity[] getPendingGroupMemberIdentities() {
            return this.pendingGroupMemberIdentities;
        }

        public ObvGroupV2 getObvGroupV2() {
            return this.obvGroupV2;
        }

        public ObvSyncAtom getObvSyncItem() {
            return this.obvSyncAtom;
        }

        public ObvTransferStep getObvTransferStep() {
            return this.obvTransferStep;
        }

        private static Category of(Encoded encoded, ObjectMapper jsonObjectMapper) throws Exception {
            Encoded[] list = encoded.decodeList();
            if (list.length != 2) {
                throw new DecodingException();
            }
            int id = (int)list[0].decodeLong();
            byte[] bytesContactIdentity = null;
            String contactDisplayNameOrSerializedDetails = null;
            byte[] sasToDisplay = null;
            byte[] sasEntered = null;
            byte[] bytesMediatorOrGroupOwnerIdentity = null;
            String serializedGroupDetails = null;
            byte[] bytesGroupUid = null;
            ObvIdentity[] pendingGroupMemberIdentities = null;
            Long serverTimestamp = null;
            ObvGroupV2 obvGroupV2 = null;
            ObvSyncAtom obvSyncAtom = null;
            ObvTransferStep obvTransferStep = null;
            Encoded[] vars = list[1].decodeList();
            switch (id) {
                case 1: {
                    if (vars.length != 3) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    serverTimestamp = vars[2].decodeLong();
                    break;
                }
                case 2: {
                    if (vars.length != 4) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    sasToDisplay = vars[2].decodeBytes();
                    serverTimestamp = vars[3].decodeLong();
                    break;
                }
                case 3: {
                    if (vars.length != 4) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    sasToDisplay = vars[2].decodeBytes();
                    sasEntered = vars[3].decodeBytes();
                    break;
                }
                case 6: {
                    if (vars.length != 4) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    bytesMediatorOrGroupOwnerIdentity = vars[2].decodeBytes();
                    serverTimestamp = vars[3].decodeLong();
                    break;
                }
                case 7: {
                    if (vars.length != 3) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    bytesMediatorOrGroupOwnerIdentity = vars[2].decodeBytes();
                    break;
                }
                case 8: {
                    if (vars.length != 5) {
                        throw new DecodingException();
                    }
                    serializedGroupDetails = vars[0].decodeString();
                    bytesGroupUid = vars[1].decodeBytes();
                    bytesMediatorOrGroupOwnerIdentity = vars[2].decodeBytes();
                    Encoded[] pendingEncodeds = vars[3].decodeList();
                    pendingGroupMemberIdentities = new ObvIdentity[pendingEncodeds.length];
                    for (int i = 0; i < pendingEncodeds.length; ++i) {
                        pendingGroupMemberIdentities[i] = ObvIdentity.of(pendingEncodeds[i], jsonObjectMapper);
                    }
                    serverTimestamp = vars[4].decodeLong();
                    break;
                }
                case 13: {
                    if (vars.length != 1) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    break;
                }
                case 14: {
                    if (vars.length != 2) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    serverTimestamp = vars[1].decodeLong();
                    break;
                }
                case 15: 
                case 16: {
                    if (vars.length != 2) {
                        throw new DecodingException();
                    }
                    bytesMediatorOrGroupOwnerIdentity = vars[0].decodeBytes();
                    obvGroupV2 = ObvGroupV2.of(vars[1]);
                    break;
                }
                case 17: {
                    if (vars.length != 1) {
                        throw new DecodingException();
                    }
                    obvSyncAtom = ObvSyncAtom.of(vars[0]);
                    break;
                }
                case 18: {
                    if (vars.length != 1) {
                        throw new DecodingException();
                    }
                    obvTransferStep = ObvTransferStep.of(vars[0]);
                    break;
                }
                case 0: 
                case 5: {
                    if (vars.length != 2) {
                        throw new DecodingException();
                    }
                    bytesContactIdentity = vars[0].decodeBytes();
                    contactDisplayNameOrSerializedDetails = vars[1].decodeString();
                    break;
                }
                default: {
                    Logger.e("Found an UI dialog with unknown category " + id);
                    id = -1;
                }
            }
            return new Category(id, bytesContactIdentity, contactDisplayNameOrSerializedDetails, sasToDisplay, sasEntered, bytesMediatorOrGroupOwnerIdentity, serializedGroupDetails, bytesGroupUid, pendingGroupMemberIdentities, serverTimestamp, obvGroupV2, obvSyncAtom, obvTransferStep);
        }

        private Encoded encode(ObjectMapper jsonObjectMapper) {
            Encoded encodedVars = null;
            switch (this.id) {
                case 0: 
                case 5: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails)});
                    break;
                }
                case 1: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails), Encoded.of(this.serverTimestamp)});
                    break;
                }
                case 2: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails), Encoded.of(this.sasToDisplay), Encoded.of(this.serverTimestamp)});
                    break;
                }
                case 3: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails), Encoded.of(this.sasToDisplay), Encoded.of(this.sasEntered)});
                    break;
                }
                case 6: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails), Encoded.of(this.bytesMediatorOrGroupOwnerIdentity), Encoded.of(this.serverTimestamp)});
                    break;
                }
                case 7: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.contactDisplayNameOrSerializedDetails), Encoded.of(this.bytesMediatorOrGroupOwnerIdentity)});
                    break;
                }
                case 8: {
                    Encoded[] pendingEncodeds = new Encoded[this.pendingGroupMemberIdentities.length];
                    for (int i = 0; i < this.pendingGroupMemberIdentities.length; ++i) {
                        try {
                            pendingEncodeds[i] = this.pendingGroupMemberIdentities[i].encode(jsonObjectMapper);
                            continue;
                        }
                        catch (Exception e) {
                            Logger.x(e);
                            break;
                        }
                    }
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.serializedGroupDetails), Encoded.of(this.bytesGroupUid), Encoded.of(this.bytesMediatorOrGroupOwnerIdentity), Encoded.of(pendingEncodeds), Encoded.of(this.serverTimestamp)});
                    break;
                }
                case 13: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity)});
                    break;
                }
                case 14: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesContactIdentity), Encoded.of(this.serverTimestamp)});
                    break;
                }
                case 15: 
                case 16: {
                    encodedVars = Encoded.of(new Encoded[]{Encoded.of(this.bytesMediatorOrGroupOwnerIdentity), this.obvGroupV2.encode()});
                    break;
                }
                case 17: {
                    encodedVars = Encoded.of(new Encoded[]{this.obvSyncAtom.encode()});
                    break;
                }
                case 18: {
                    encodedVars = Encoded.of(new Encoded[]{this.obvTransferStep.encode()});
                }
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.id), encodedVars});
        }

        public static Category createInviteSent(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails) {
            return new Category(0, bytesContactIdentity, contactDisplayNameOrSerializedDetails, null, null, null, null, null, null, null, null, null, null);
        }

        public static Category createAcceptInvite(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, long serverTimestamp) {
            return new Category(1, bytesContactIdentity, contactDisplayNameOrSerializedDetails, null, null, null, null, null, null, serverTimestamp, null, null, null);
        }

        public static Category createSasExchange(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, byte[] sasToDisplay, long serverTimestamp) {
            return new Category(2, bytesContactIdentity, contactDisplayNameOrSerializedDetails, sasToDisplay, null, null, null, null, null, serverTimestamp, null, null, null);
        }

        public static Category createSasConfirmed(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, byte[] sasToDisplay, byte[] sasEntered) {
            return new Category(3, bytesContactIdentity, contactDisplayNameOrSerializedDetails, sasToDisplay, sasEntered, null, null, null, null, null, null, null, null);
        }

        public static Category createInviteAccepted(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails) {
            return new Category(5, bytesContactIdentity, contactDisplayNameOrSerializedDetails, null, null, null, null, null, null, null, null, null, null);
        }

        public static Category createAcceptMediatorInvite(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, byte[] bytesMediatorIdentity, long serverTimestamp) {
            return new Category(6, bytesContactIdentity, contactDisplayNameOrSerializedDetails, null, null, bytesMediatorIdentity, null, null, null, serverTimestamp, null, null, null);
        }

        public static Category createMediatorInviteAccepted(byte[] bytesContactIdentity, String contactDisplayNameOrSerializedDetails, byte[] bytesMediatorIdentity) {
            return new Category(7, bytesContactIdentity, contactDisplayNameOrSerializedDetails, null, null, bytesMediatorIdentity, null, null, null, null, null, null, null);
        }

        public static Category createAcceptGroupInvite(String serializedGroupDetails, byte[] groupId, byte[] bytesGroupOwnerIdentity, ObvIdentity[] pendingGroupMemberIdentities, long serverTimestamp) {
            return new Category(8, null, null, null, null, bytesGroupOwnerIdentity, serializedGroupDetails, groupId, pendingGroupMemberIdentities, serverTimestamp, null, null, null);
        }

        public static Category createOneToOneInvitationSent(byte[] bytesContactIdentity) {
            return new Category(13, bytesContactIdentity, null, null, null, null, null, null, null, null, null, null, null);
        }

        public static Category createAcceptOneToOneInvitation(byte[] bytesContactIdentity, Long serverTimestamp) {
            return new Category(14, bytesContactIdentity, null, null, null, null, null, null, null, serverTimestamp, null, null, null);
        }

        public static Category createGroupV2Invitation(byte[] bytesInviterIdentity, ObvGroupV2 obvGroupV2) {
            return new Category(15, null, null, null, null, bytesInviterIdentity, null, null, null, null, obvGroupV2, null, null);
        }

        public static Category createGroupV2FrozenInvitation(byte[] bytesInviterIdentity, ObvGroupV2 obvGroupV2) {
            return new Category(16, null, null, null, null, bytesInviterIdentity, null, null, null, null, obvGroupV2, null, null);
        }

        public static Category createSyncItemToApply(ObvSyncAtom obvSyncAtom) {
            return new Category(17, null, null, null, null, null, null, null, null, null, null, obvSyncAtom, null);
        }

        public static Category createTransferDialog(ObvTransferStep obvTransferStep) {
            return new Category(18, null, null, null, null, null, null, null, null, null, null, null, obvTransferStep);
        }
    }
}

