/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Arrays;

public class ObvBytesKey
implements Comparable<ObvBytesKey> {
    final byte[] bytes;

    public ObvBytesKey(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ObvBytesKey)) {
            return false;
        }
        return Arrays.equals(this.bytes, ((ObvBytesKey)other).bytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public int compareTo(ObvBytesKey other) {
        if (this.bytes.length != other.bytes.length) {
            return this.bytes.length - other.bytes.length;
        }
        for (int i = 0; i < this.bytes.length; ++i) {
            if (this.bytes[i] == other.bytes[i]) continue;
            return (this.bytes[i] & 0xFF) - (other.bytes[i] & 0xFF);
        }
        return 0;
    }

    public static class Deserializer
    extends JsonDeserializer<ObvBytesKey> {
        public ObvBytesKey deserialize(JsonParser p, DeserializationContext context) throws IOException {
            return new ObvBytesKey(context.getConfig().getBase64Variant().decode(p.getValueAsString()));
        }
    }

    public static class Serializer
    extends JsonSerializer<ObvBytesKey> {
        public void serialize(ObvBytesKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(serializers.getConfig().getBase64Variant().encode(value.bytes));
        }
    }

    public static class KeyDeserializer
    extends com.fasterxml.jackson.databind.KeyDeserializer {
        public Object deserializeKey(String key, DeserializationContext ctxt) throws IOException {
            return new ObvBytesKey(ctxt.getConfig().getBase64Variant().decode(key));
        }
    }

    public static class KeySerializer
    extends JsonSerializer<ObvBytesKey> {
        public void serialize(ObvBytesKey value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeFieldName(serializers.getConfig().getBase64Variant().encode(value.bytes));
        }
    }
}

