/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.DecryptedApplicationMessage;
import io.olvid.engine.datatypes.containers.ReceivedAttachment;
import io.olvid.engine.metamanager.NetworkFetchDelegate;

public class ObvAttachment {
    private final byte[] metadata;
    private final String url;
    private final boolean downloadRequested;
    private final Identity ownedIdentity;
    private final UID messageUid;
    private final long messageServerTimestamp;
    private final int number;
    private final long expectedLength;
    private final long receivedLength;

    public byte[] getMetadata() {
        return this.metadata;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isDownloadRequested() {
        return this.downloadRequested;
    }

    public long getMessageServerTimestamp() {
        return this.messageServerTimestamp;
    }

    public byte[] getBytesOwnedIdentity() {
        return this.ownedIdentity.getBytes();
    }

    public Identity getOwnedIdentity() {
        return this.ownedIdentity;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public byte[] getMessageIdentifier() {
        return this.messageUid.getBytes();
    }

    public int getNumber() {
        return this.number;
    }

    public long getExpectedLength() {
        return this.expectedLength;
    }

    public long getReceivedLength() {
        return this.receivedLength;
    }

    ObvAttachment(byte[] metadata, String url, boolean downloadRequested, Identity ownedIdentity, UID messageUid, long messageServerTimestamp, int number, long expectedLength, long receivedLength) {
        this.metadata = metadata;
        this.url = url;
        this.downloadRequested = downloadRequested;
        this.ownedIdentity = ownedIdentity;
        this.messageUid = messageUid;
        this.messageServerTimestamp = messageServerTimestamp;
        this.number = number;
        this.expectedLength = expectedLength;
        this.receivedLength = receivedLength;
    }

    public static ObvAttachment create(NetworkFetchDelegate networkFetchDelegate, Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        ReceivedAttachment receivedAttachment = networkFetchDelegate.getAttachment(ownedIdentity, messageUid, attachmentNumber);
        if (receivedAttachment == null) {
            return null;
        }
        DecryptedApplicationMessage receivedMessage = networkFetchDelegate.getMessage(ownedIdentity, receivedAttachment.getMessageUid());
        if (receivedMessage == null) {
            return null;
        }
        Identity ownIdentity = receivedMessage.getToIdentity();
        if (ownIdentity == null) {
            return null;
        }
        return new ObvAttachment(receivedAttachment.getMetadata(), receivedAttachment.getUrl(), receivedAttachment.isDownloadRequested(), receivedAttachment.getOwnedIdentity(), receivedAttachment.getMessageUid(), receivedMessage.getServerTimestamp(), receivedAttachment.getAttachmentNumber(), receivedAttachment.getExpectedLength(), receivedAttachment.getReceivedLength());
    }
}

