/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.datatypes.ObvBase64;
import java.util.HashMap;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonIdentityDetails {
    public static final String FORMAT_STRING_FIRST_LAST = "%f %l";
    public static final String FORMAT_STRING_FIRST_LAST_COMPANY = "%f %l (%c)";
    public static final String FORMAT_STRING_FIRST_LAST_POSITION_COMPANY = "%f %l (%p @ %c)";
    public static final String FORMAT_STRING_LAST_FIRST = "%l %f";
    public static final String FORMAT_STRING_LAST_FIRST_COMPANY = "%l %f (%c)";
    public static final String FORMAT_STRING_LAST_FIRST_POSITION_COMPANY = "%l %f (%p @ %c)";
    public static final String FORMAT_STRING_FOR_SEARCH = "%f %l %p %c";
    String firstName;
    String lastName;
    String company;
    String position;
    String signedUserDetails;
    HashMap<String, String> customFields;

    public JsonIdentityDetails() {
    }

    public JsonIdentityDetails(String firstName, String lastName, String company, String position) {
        this.firstName = JsonIdentityDetails.nullOrTrim(firstName);
        this.lastName = JsonIdentityDetails.nullOrTrim(lastName);
        this.company = JsonIdentityDetails.nullOrTrim(company);
        this.position = JsonIdentityDetails.nullOrTrim(position);
    }

    @JsonProperty(value="first_name")
    public String getFirstName() {
        return this.firstName;
    }

    @JsonProperty(value="first_name")
    public void setFirstName(String firstName) {
        this.firstName = JsonIdentityDetails.nullOrTrim(firstName);
    }

    @JsonProperty(value="last_name")
    public String getLastName() {
        return this.lastName;
    }

    @JsonProperty(value="last_name")
    public void setLastName(String lastName) {
        this.lastName = JsonIdentityDetails.nullOrTrim(lastName);
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = JsonIdentityDetails.nullOrTrim(company);
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String position) {
        this.position = JsonIdentityDetails.nullOrTrim(position);
    }

    @JsonProperty(value="custom_fields")
    public HashMap<String, String> getCustomFields() {
        return this.customFields;
    }

    @JsonProperty(value="custom_fields")
    public void setCustomFields(HashMap<String, String> customFields) {
        this.customFields = customFields;
    }

    @JsonProperty(value="signed_user_details")
    public String getSignedUserDetails() {
        return this.signedUserDetails;
    }

    @JsonProperty(value="signed_user_details")
    public void setSignedUserDetails(String signedUserDetails) {
        this.signedUserDetails = signedUserDetails;
    }

    private static String nullOrTrim(String in) {
        if (in == null) {
            return null;
        }
        String out = in.trim();
        if (out.isEmpty()) {
            return null;
        }
        return out;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.firstName == null && this.lastName == null;
    }

    @JsonIgnore
    public String formatDisplayName(String contactDisplayNameFormat, boolean uppercaseLastName) {
        Object displayName;
        switch (contactDisplayNameFormat) {
            case "%f %l (%c)": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, false, uppercaseLastName);
                if (this.company == null) break;
                displayName = (String)displayName + " (" + this.company + ")";
                break;
            }
            case "%f %l (%p @ %c)": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, false, uppercaseLastName);
                String posComp = JsonIdentityDetails.joinCompany(this.position, this.company);
                if (posComp == null) break;
                displayName = (String)displayName + " (" + posComp + ")";
                break;
            }
            case "%l %f": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, true, uppercaseLastName);
                break;
            }
            case "%l %f (%c)": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, true, uppercaseLastName);
                if (this.company == null) break;
                displayName = (String)displayName + " (" + this.company + ")";
                break;
            }
            case "%l %f (%p @ %c)": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, true, uppercaseLastName);
                String posComp = JsonIdentityDetails.joinCompany(this.position, this.company);
                if (posComp == null) break;
                displayName = (String)displayName + " (" + posComp + ")";
                break;
            }
            case "%f %l %p %c": {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, false, false);
                String posComp = JsonIdentityDetails.joinCompany(this.position, this.company);
                if (posComp == null) break;
                displayName = (String)displayName + " " + posComp;
                break;
            }
            default: {
                displayName = JsonIdentityDetails.joinNames(this.firstName, this.lastName, false, uppercaseLastName);
            }
        }
        return displayName;
    }

    @JsonIgnore
    public String formatFirstAndLastName(String format, boolean uppercaseLastName) {
        switch (format) {
            case "%l %f": 
            case "%l %f (%c)": 
            case "%l %f (%p @ %c)": {
                return JsonIdentityDetails.joinNames(this.firstName, this.lastName, true, uppercaseLastName);
            }
        }
        return JsonIdentityDetails.joinNames(this.firstName, this.lastName, false, uppercaseLastName);
    }

    @JsonIgnore
    @Nullable
    public String formatPositionAndCompany(String format) {
        return JsonIdentityDetails.joinCompany(this.position, this.company);
    }

    public static String joinNames(String firstName, String lastName, boolean lastFirst, boolean uppercaseLast) {
        if (lastName == null) {
            if (firstName == null) {
                return "";
            }
            return firstName;
        }
        if (uppercaseLast) {
            lastName = lastName.toUpperCase();
        }
        if (firstName == null) {
            return lastName;
        }
        if (lastFirst) {
            return lastName + " " + firstName;
        }
        return firstName + " " + lastName;
    }

    private static String joinCompany(String position, String company) {
        if (position == null) {
            return company;
        }
        if (company == null) {
            return position;
        }
        return position + " @ " + company;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonIdentityDetails)) {
            return false;
        }
        JsonIdentityDetails other = (JsonIdentityDetails)obj;
        if (!Objects.equals(this.firstName, other.firstName)) {
            return false;
        }
        if (!Objects.equals(this.lastName, other.lastName)) {
            return false;
        }
        if (!Objects.equals(this.company, other.company)) {
            return false;
        }
        if (!Objects.equals(this.position, other.position)) {
            return false;
        }
        if (this.signedUserDetails == null && other.signedUserDetails != null || this.signedUserDetails != null && other.signedUserDetails == null) {
            return false;
        }
        ObjectMapper objectMapper = new ObjectMapper();
        if (!Objects.equals(JsonIdentityDetails.getSignatureKid(objectMapper, this.signedUserDetails), JsonIdentityDetails.getSignatureKid(objectMapper, other.signedUserDetails))) {
            return false;
        }
        return Objects.equals(this.customFields, other.customFields);
    }

    @JsonIgnore
    public boolean fieldsAreTheSame(JsonIdentityDetails other) {
        if (!Objects.equals(this.firstName, other.firstName)) {
            return false;
        }
        if (!Objects.equals(this.lastName, other.lastName)) {
            return false;
        }
        if (!Objects.equals(this.company, other.company)) {
            return false;
        }
        if (!Objects.equals(this.position, other.position)) {
            return false;
        }
        return Objects.equals(this.customFields, other.customFields);
    }

    @JsonIgnore
    public boolean firstAndLastNamesAreTheSame(JsonIdentityDetails other) {
        return Objects.equals(this.firstName, other.firstName) && Objects.equals(this.lastName, other.lastName);
    }

    private static String getSignatureKid(ObjectMapper objectMapper, String signature) {
        int pos;
        if (signature != null && (pos = signature.indexOf(46)) > 0) {
            String headerString = signature.substring(0, pos);
            try {
                HashMap header = (HashMap)objectMapper.readValue(ObvBase64.decode(headerString), (TypeReference)new TypeReference<HashMap<String, String>>(){});
                return (String)header.get("kid");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

