/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class JsonGroupType {
    public static final String TYPE_SIMPLE = "simple";
    public static final String TYPE_PRIVATE = "private";
    public static final String TYPE_READ_ONLY = "read_only";
    public static final String TYPE_CUSTOM = "custom";
    public static final String REMOTE_DELETE_NOBODY = "nobody";
    public static final String REMOTE_DELETE_ADMINS = "admins";
    public static final String REMOTE_DELETE_EVERYONE = "everyone";
    String type;
    Boolean readOnly;
    String remoteDelete;

    public JsonGroupType() {
    }

    @JsonIgnore
    public static JsonGroupType createSimple() {
        return new JsonGroupType(TYPE_SIMPLE, null, null);
    }

    @JsonIgnore
    public static JsonGroupType createPrivate() {
        return new JsonGroupType(TYPE_PRIVATE, null, null);
    }

    @JsonIgnore
    public static JsonGroupType createReadOnly() {
        return new JsonGroupType(TYPE_READ_ONLY, null, null);
    }

    @JsonIgnore
    public static JsonGroupType createCustom(boolean readOnly, String remoteDelete) {
        if (remoteDelete == null || !remoteDelete.equals(REMOTE_DELETE_NOBODY) && !remoteDelete.equals(REMOTE_DELETE_ADMINS) && !remoteDelete.equals(REMOTE_DELETE_EVERYONE)) {
            remoteDelete = REMOTE_DELETE_NOBODY;
        }
        return new JsonGroupType(TYPE_CUSTOM, readOnly, remoteDelete);
    }

    private JsonGroupType(String type, Boolean readOnly, String remoteDelete) {
        this.type = type;
        this.readOnly = readOnly;
        this.remoteDelete = remoteDelete;
    }

    @JsonProperty(value="type")
    public String getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="ro")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @JsonProperty(value="ro")
    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @JsonProperty(value="del")
    public String getRemoteDelete() {
        return this.remoteDelete;
    }

    @JsonProperty(value="del")
    public void setRemoteDelete(String remoteDelete) {
        this.remoteDelete = remoteDelete;
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.type == null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonGroupType)) {
            return false;
        }
        JsonGroupType other = (JsonGroupType)obj;
        return Objects.equals(this.type, other.type) && Objects.equals(this.readOnly, other.readOnly) && Objects.equals(this.remoteDelete, other.remoteDelete);
    }
}

