/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.types;

import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.types.EngineDbQueryStatisticsEntry;
import io.olvid.engine.engine.types.EngineNotificationListener;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonOsmStyle;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.engine.engine.types.ObvBackupKeyInformation;
import io.olvid.engine.engine.types.ObvBackupKeyVerificationOutput;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvContactDeviceCount;
import io.olvid.engine.engine.types.ObvContactInfo;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.ObvDeviceList;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.ObvPushNotificationType;
import io.olvid.engine.engine.types.ObvReturnReceipt;
import io.olvid.engine.engine.types.RegisterApiKeyResult;
import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import io.olvid.engine.engine.types.identities.ObvGroup;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.identities.ObvMutualScanUrl;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.engine.types.identities.ObvTrustOrigin;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jose4j.jwk.JsonWebKey;

public interface EngineAPI {
    public void startProcessing();

    public void addNotificationListener(String var1, EngineNotificationListener var2);

    public void addNotificationListener(String var1, EngineNotificationListener var2, ListenerPriority var3);

    public void removeNotificationListener(String var1, EngineNotificationListener var2);

    public void startSendingNotifications();

    public void stopSendingNotifications();

    public void runTaskOnEngineNotificationQueue(Runnable var1);

    public Map<String, EngineDbQueryStatisticsEntry> getEngineDbQueryStatistics();

    public String getServerOfIdentity(byte[] var1);

    public ObvIdentity[] getOwnedIdentities() throws Exception;

    public ObvIdentity getOwnedIdentity(byte[] var1) throws Exception;

    public ObvIdentity generateOwnedIdentity(String var1, JsonIdentityDetails var2, ObvKeycloakState var3, String var4);

    public RegisterApiKeyResult registerOwnedIdentityApiKeyOnServer(byte[] var1, UUID var2);

    public void recreateServerSession(byte[] var1);

    public void deleteOwnedIdentity(byte[] var1) throws Exception;

    public JsonIdentityDetailsWithVersionAndPhoto[] getOwnedIdentityPublishedAndLatestDetails(byte[] var1) throws Exception;

    public ObvKeycloakState getOwnedIdentityKeycloakState(byte[] var1) throws Exception;

    public void saveKeycloakAuthState(byte[] var1, String var2) throws Exception;

    public void saveKeycloakJwks(byte[] var1, String var2) throws Exception;

    public void saveKeycloakApiKey(byte[] var1, String var2) throws Exception;

    public Collection<ObvIdentity> getOwnedIdentitiesWithKeycloakPushTopic(String var1) throws Exception;

    public String getOwnedIdentityKeycloakUserId(byte[] var1) throws Exception;

    public void setOwnedIdentityKeycloakUserId(byte[] var1, String var2) throws Exception;

    public JsonWebKey getOwnedIdentityKeycloakSignatureKey(byte[] var1) throws Exception;

    public void setOwnedIdentityKeycloakSignatureKey(byte[] var1, JsonWebKey var2) throws Exception;

    public ObvIdentity bindOwnedIdentityToKeycloak(byte[] var1, ObvKeycloakState var2, String var3);

    public void unbindOwnedIdentityFromKeycloak(byte[] var1);

    public void updateKeycloakTransferRestrictedIfNeeded(byte[] var1, String var2, boolean var3);

    public void updateKeycloakPushTopicsIfNeeded(byte[] var1, String var2, List<String> var3);

    public void updateKeycloakRevocationList(byte[] var1, long var2, List<String> var4);

    public void setOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] var1, String var2, String var3);

    public String getOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] var1, String var2);

    public boolean updateKeycloakGroups(byte[] var1, List<String> var2, List<String> var3, List<String> var4, long var5);

    public void registerToPushNotification(byte[] var1, ObvPushNotificationType var2, boolean var3, byte[] var4) throws Exception;

    public void processAndroidPushNotification(String var1);

    public byte[] getOwnedIdentityFromMaskingUid(String var1);

    public void processDeviceManagementRequest(byte[] var1, ObvDeviceManagementRequest var2) throws Exception;

    public void updateLatestIdentityDetails(byte[] var1, JsonIdentityDetails var2) throws Exception;

    public void discardLatestIdentityDetails(byte[] var1);

    public void publishLatestIdentityDetails(byte[] var1);

    public void updateOwnedIdentityPhoto(byte[] var1, String var2) throws Exception;

    public byte[] getServerAuthenticationToken(byte[] var1);

    public List<ObvCapability> getOwnCapabilities(byte[] var1);

    public List<ObvOwnedDevice> getOwnedDevices(byte[] var1);

    public ObvDeviceList queryRegisteredOwnedDevicesFromServer(byte[] var1);

    public void refreshOwnedDeviceList(byte[] var1);

    public void recreateOwnedDeviceChannel(byte[] var1, byte[] var2);

    public ObvIdentity[] getContactsOfOwnedIdentity(byte[] var1) throws Exception;

    public List<ObvContactInfo> getContactsInfoOfOwnedIdentity(byte[] var1) throws Exception;

    public EnumSet<ObvContactActiveOrInactiveReason> getContactActiveOrInactiveReasons(byte[] var1, byte[] var2);

    public boolean forcefullyUnblockContact(byte[] var1, byte[] var2);

    public boolean reBlockForcefullyUnblockedContact(byte[] var1, byte[] var2);

    public boolean isContactOneToOne(byte[] var1, byte[] var2) throws Exception;

    public ObvContactDeviceCount getContactDeviceCounts(byte[] var1, byte[] var2) throws Exception;

    public void forceContactDeviceDiscovery(byte[] var1, byte[] var2);

    public String getContactTrustedDetailsPhotoUrl(byte[] var1, byte[] var2) throws Exception;

    public JsonIdentityDetailsWithVersionAndPhoto[] getContactPublishedAndTrustedDetails(byte[] var1, byte[] var2) throws Exception;

    public void trustPublishedContactDetails(byte[] var1, byte[] var2);

    public ObvTrustOrigin[] getContactTrustOrigins(byte[] var1, byte[] var2) throws Exception;

    public int getContactTrustLevel(byte[] var1, byte[] var2) throws Exception;

    public List<ObvCapability> getContactCapabilities(byte[] var1, byte[] var2);

    public ObvGroup[] getGroupsOfOwnedIdentity(byte[] var1) throws Exception;

    public JsonGroupDetailsWithVersionAndPhoto[] getGroupPublishedAndLatestOrTrustedDetails(byte[] var1, byte[] var2) throws Exception;

    public String getGroupTrustedDetailsPhotoUrl(byte[] var1, byte[] var2) throws Exception;

    public void trustPublishedGroupDetails(byte[] var1, byte[] var2);

    public void updateLatestGroupDetails(byte[] var1, byte[] var2, JsonGroupDetails var3) throws Exception;

    public void discardLatestGroupDetails(byte[] var1, byte[] var2);

    public void publishLatestGroupDetails(byte[] var1, byte[] var2);

    public void updateOwnedGroupPhoto(byte[] var1, byte[] var2, String var3) throws Exception;

    public List<ObvGroupV2> getGroupsV2OfOwnedIdentity(byte[] var1) throws Exception;

    public void trustGroupV2PublishedDetails(byte[] var1, byte[] var2) throws Exception;

    public ObvGroupV2.ObvGroupV2DetailsAndPhotos getGroupV2DetailsAndPhotos(byte[] var1, byte[] var2);

    public String getGroupV2JsonType(byte[] var1, byte[] var2);

    public void initiateGroupV2Update(byte[] var1, byte[] var2, ObvGroupV2.ObvGroupV2ChangeSet var3) throws Exception;

    public void leaveGroupV2(byte[] var1, byte[] var2) throws Exception;

    public void disbandGroupV2(byte[] var1, byte[] var2) throws Exception;

    public void reDownloadGroupV2(byte[] var1, byte[] var2) throws Exception;

    public Integer getGroupV2Version(byte[] var1, byte[] var2) throws Exception;

    public boolean isGroupV2UpdateInProgress(byte[] var1, GroupV2.Identifier var2) throws Exception;

    public void deletePersistedDialog(UUID var1) throws Exception;

    public Set<UUID> getAllPersistedDialogUuids() throws Exception;

    public void resendAllPersistedDialogs() throws Exception;

    public void respondToDialog(ObvDialog var1) throws Exception;

    public void abortProtocol(ObvDialog var1) throws Exception;

    public void startTrustEstablishmentProtocol(byte[] var1, String var2, byte[] var3) throws Exception;

    public ObvMutualScanUrl computeMutualScanSignedNonceUrl(byte[] var1, byte[] var2, String var3) throws Exception;

    public boolean verifyMutualScanSignedNonceUrl(byte[] var1, ObvMutualScanUrl var2);

    public void startMutualScanTrustEstablishmentProtocol(byte[] var1, byte[] var2, byte[] var3) throws Exception;

    public void startContactMutualIntroductionProtocol(byte[] var1, byte[] var2, byte[][] var3) throws Exception;

    public void startGroupCreationProtocol(String var1, String var2, byte[] var3, byte[][] var4) throws Exception;

    public void startGroupV2CreationProtocol(String var1, String var2, byte[] var3, HashSet<GroupV2.Permission> var4, HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> var5, String var6) throws Exception;

    public void restartAllOngoingChannelEstablishmentProtocols(byte[] var1, byte[] var2) throws Exception;

    public void recreateAllChannels(byte[] var1, byte[] var2) throws Exception;

    public void inviteContactsToGroup(byte[] var1, byte[] var2, byte[][] var3) throws Exception;

    public void removeContactsFromGroup(byte[] var1, byte[] var2, byte[][] var3) throws Exception;

    public void reinvitePendingToGroup(byte[] var1, byte[] var2, byte[] var3) throws Exception;

    public void leaveGroup(byte[] var1, byte[] var2) throws Exception;

    public void disbandGroup(byte[] var1, byte[] var2) throws Exception;

    public void deleteContact(byte[] var1, byte[] var2) throws Exception;

    public void downgradeOneToOneContact(byte[] var1, byte[] var2) throws Exception;

    public void startOneToOneInvitationProtocol(byte[] var1, byte[] var2) throws Exception;

    public void deleteOwnedIdentityAndNotifyContacts(byte[] var1, boolean var2) throws Exception;

    public void queryGroupOwnerForLatestGroupMembers(byte[] var1, byte[] var2) throws Exception;

    public void addKeycloakContact(byte[] var1, byte[] var2, String var3) throws Exception;

    public void initiateOwnedIdentityTransferProtocolOnSourceDevice(byte[] var1) throws Exception;

    public void initiateOwnedIdentityTransferProtocolOnTargetDevice(String var1) throws Exception;

    public byte[] getReturnReceiptNonce();

    public byte[] getReturnReceiptKey();

    public void deleteReturnReceipt(byte[] var1, byte[] var2);

    public ObvReturnReceipt decryptReturnReceipt(byte[] var1, byte[] var2);

    public ObvPostMessageOutput post(byte[] var1, byte[] var2, ObvOutboundAttachment[] var3, List<byte[]> var4, byte[] var5, boolean var6, boolean var7);

    public ObvPostMessageOutput postToSpecificDevices(byte[] var1, List<byte[]> var2, List<byte[]> var3, byte[] var4, boolean var5, boolean var6);

    public void sendReturnReceipt(byte[] var1, byte[] var2, int var3, byte[] var4, byte[] var5, Integer var6);

    public boolean isOutboxAttachmentSent(byte[] var1, byte[] var2, int var3);

    public boolean isOutboxMessageSent(byte[] var1, byte[] var2);

    public void cancelMessageSending(byte[] var1, byte[] var2);

    public boolean isInboxAttachmentReceived(byte[] var1, byte[] var2, int var3);

    public void downloadMessages(byte[] var1);

    public void downloadSmallAttachment(byte[] var1, byte[] var2, int var3);

    public void downloadLargeAttachment(byte[] var1, byte[] var2, int var3);

    public void pauseAttachmentDownload(byte[] var1, byte[] var2, int var3);

    public void markAttachmentForDeletion(ObvAttachment var1);

    public void markAttachmentForDeletion(byte[] var1, byte[] var2, int var3);

    public void deleteMessageAndAttachments(byte[] var1, byte[] var2);

    public void markMessageForDeletion(byte[] var1, byte[] var2);

    public void markMessageAsOnHold(byte[] var1, byte[] var2);

    public void cancelAttachmentUpload(byte[] var1, byte[] var2, int var3);

    public void resendAllAttachmentNotifications() throws Exception;

    public void connectWebsocket(boolean var1, String var2, String var3, int var4, String var5);

    public void disconnectWebsocket();

    public void pingWebsocket(byte[] var1);

    public void retryScheduledNetworkTasks();

    public ObvMessage getOnHoldMessage(byte[] var1, byte[] var2) throws Exception;

    public void initiateBackup(boolean var1);

    public String generateDeviceBackupSeed(String var1);

    public String getDeviceBackupSeed() throws Exception;

    public void deleteDeviceBackupSeed(String var1);

    public boolean backupDeviceAndProfilesNow();

    public void deviceBackupNeeded();

    public void profileBackupNeeded(byte[] var1);

    public ObvDeviceBackupForRestore fetchDeviceBackup(String var1, String var2);

    public ObvProfileBackupsForRestore fetchProfileBackups(byte[] var1, String var2);

    public boolean deleteProfileBackupSnapshot(byte[] var1, String var2, byte[] var3, long var4);

    public byte[] downloadProfilePicture(byte[] var1, byte[] var2, byte[] var3) throws Exception;

    public boolean restoreProfile(ObvSyncSnapshot var1, String var2, String var3);

    public ObvBackupKeyInformation getBackupKeyInformation() throws Exception;

    public void stopLegacyBackups();

    public void setAutoBackupEnabled(boolean var1, boolean var2);

    public void markBackupExported(byte[] var1, int var2);

    public void markBackupUploaded(byte[] var1, int var2);

    public void discardBackup(byte[] var1, int var2);

    public ObvBackupKeyVerificationOutput validateBackupSeed(String var1, byte[] var2);

    public ObvIdentity[] restoreOwnedIdentitiesFromBackup(String var1, byte[] var2, String var3);

    public void restoreContactsAndGroupsFromBackup(String var1, byte[] var2, ObvIdentity[] var3);

    public String decryptAppDataBackup(String var1, byte[] var2);

    public void appBackupSuccess(byte[] var1, int var2, String var3);

    public void appBackupFailed(byte[] var1, int var2);

    public void getTurnCredentials(byte[] var1, UUID var2, String var3, String var4);

    public void queryApiKeyStatus(byte[] var1, UUID var2);

    public void queryApiKeyStatus(String var1, UUID var2);

    public void queryFreeTrial(byte[] var1);

    public void startFreeTrial(byte[] var1);

    public void verifyReceipt(byte[] var1, String var2);

    public void queryServerWellKnown(String var1);

    public List<JsonOsmStyle> getOsmStyles(byte[] var1);

    public String getAddressServerUrl(byte[] var1);

    public void propagateAppSyncAtomToAllOwnedIdentitiesOtherDevicesIfNeeded(ObvSyncAtom var1) throws Exception;

    public void propagateAppSyncAtomToOtherDevicesIfNeeded(byte[] var1, ObvSyncAtom var2) throws Exception;

    public void downloadAllUserData() throws Exception;

    public void setAllOwnedDeviceNames(String var1);

    public void vacuumDatabase() throws Exception;

    public static enum ListenerPriority {
        LOW,
        NORMAL,
        HIGH;

    }

    public static enum ApiKeyStatus {
        UNKNOWN,
        VALID,
        LICENSES_EXHAUSTED,
        EXPIRED,
        OPEN_BETA_KEY,
        FREE_TRIAL_KEY,
        AWAITING_PAYMENT_GRACE_PERIOD,
        AWAITING_PAYMENT_ON_HOLD,
        FREE_TRIAL_KEY_EXPIRED;

    }

    public static enum ApiKeyPermission {
        CALL,
        WEB_CLIENT,
        MULTI_DEVICE;

    }
}

