/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine.databases;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.ObvDatabase;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.engine.datatypes.EngineSession;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class EngineDbSchemaVersion
implements ObvDatabase {
    static final String TABLE_NAME = "engine_db_schema_version";
    private final EngineSession engineSession;
    private int version;
    static final String VERSION = "version";

    public int getVersion() {
        return this.version;
    }

    private EngineDbSchemaVersion(EngineSession engineSession, ResultSet res) throws SQLException {
        this.engineSession = engineSession;
        this.version = res.getInt(VERSION);
    }

    public static void createTable(Session session) throws SQLException {
        block24: {
            try (PreparedStatement statement = session.prepareStatement("SELECT name FROM sqlite_master WHERE type=? AND name = ?");){
                statement.setString(1, "table");
                statement.setString(2, TABLE_NAME);
                try (ResultSet res = statement.executeQuery();){
                    if (res.next()) break block24;
                    try (Statement createStatement = session.createStatement();){
                        createStatement.execute("CREATE TABLE engine_db_schema_version (version INT NOT NULL);");
                    }
                    try (PreparedStatement insertStatement = session.prepareStatement("INSERT INTO engine_db_schema_version VALUES (?)");){
                        insertStatement.setInt(1, 48);
                        insertStatement.executeUpdate();
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static EngineDbSchemaVersion get(EngineSession engineSession) {
        try (PreparedStatement statement = engineSession.session.prepareStatement("EngineDbSchemaVersion.get", "SELECT * FROM engine_db_schema_version;");){
            EngineDbSchemaVersion engineDbSchemaVersion;
            block18: {
                ResultSet res;
                block16: {
                    EngineDbSchemaVersion engineDbSchemaVersion2;
                    block17: {
                        res = statement.executeQuery();
                        try {
                            if (!res.next()) break block16;
                            engineDbSchemaVersion2 = new EngineDbSchemaVersion(engineSession, res);
                            if (res == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (res != null) {
                                try {
                                    res.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        res.close();
                    }
                    return engineDbSchemaVersion2;
                }
                engineDbSchemaVersion = null;
                if (res == null) break block18;
                res.close();
            }
            return engineDbSchemaVersion;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void update(int version) throws SQLException {
        try (PreparedStatement statement = this.engineSession.session.prepareStatement("EngineDbSchemaVersion.update", "UPDATE engine_db_schema_version SET version = ?;");){
            statement.setInt(1, version);
            statement.executeUpdate();
            this.version = version;
        }
    }

    @Override
    public void delete() throws SQLException {
        Logger.e("Deletion in table engine_db_schema_version Is Prohibited");
        throw new SQLException();
    }

    @Override
    public void insert() throws SQLException {
        Logger.e("Insertion in table engine_db_schema_version Is Prohibited");
        throw new SQLException();
    }

    @Override
    public void wasCommitted() {
    }
}

