/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.notification.NotificationManager;
import java.util.HashMap;
import java.util.Map;

public class NotificationListenerUploads
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerUploads(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"network_send_notification_attachment_upload_progress", "network_send_notification_attachment_upload_finished", "network_send_notification_attachment_upload_cancelled", "network_send_notification_message_uploaded", "network_send_notification_message_upload_failed"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "network_send_notification_attachment_upload_progress": {
                Identity ownedIdentity = (Identity)userInfo.get("ownedIdentity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                float progress = ((Float)userInfo.get("progress")).floatValue();
                Float speed = (Float)userInfo.get("speed");
                Integer eta = (Integer)userInfo.get("eta");
                if (ownedIdentity == null || messageUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("attachment_number", attachmentNumber);
                engineInfo.put("progress", Float.valueOf(progress));
                if (speed != null && eta != null) {
                    engineInfo.put("speed", speed);
                    engineInfo.put("eta", eta);
                }
                this.engine.postEngineNotification("engine_notification_upload_attachment_progress", engineInfo);
                break;
            }
            case "network_send_notification_attachment_upload_finished": {
                Identity ownedIdentity = (Identity)userInfo.get("ownedIdentity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                if (ownedIdentity == null || messageUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("attachment_number", attachmentNumber);
                this.engine.postEngineNotification("engine_notification_attachment_uploaded", engineInfo);
                break;
            }
            case "network_send_notification_attachment_upload_cancelled": {
                Identity ownedIdentity = (Identity)userInfo.get("ownedIdentity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                if (ownedIdentity == null || messageUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("attachment_number", attachmentNumber);
                this.engine.postEngineNotification("engine_notification_attachment_upload_cancelled", engineInfo);
                break;
            }
            case "network_send_notification_message_uploaded": {
                Identity ownedIdentity = (Identity)userInfo.get("ownedIdentity");
                UID messageUid = (UID)userInfo.get("uid");
                Long timestampFromServer = (Long)userInfo.get("timestamp_from_server");
                if (ownedIdentity == null || messageUid == null || timestampFromServer == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("identifier", messageUid.getBytes());
                engineInfo.put("timestamp_from_server", timestampFromServer);
                this.engine.postEngineNotification("engine_notification_message_uploaded", engineInfo);
                break;
            }
            case "network_send_notification_message_upload_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("ownedIdentity");
                UID messageUid = (UID)userInfo.get("uid");
                if (ownedIdentity == null || messageUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("identifier", messageUid.getBytes());
                this.engine.postEngineNotification("engine_notification_message_upload_failed", engineInfo);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

