/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.notification.NotificationManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NotificationListenerGroupsV2
implements NotificationListener {
    private final Engine engine;

    public NotificationListenerGroupsV2(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"identity_manager_notification_group_v2_created", "identity_manager_notification_group_v2_updated", "identity_manager_notification_group_v2_photo_updated", "identity_manager_notification_group_v2_frozen_changed", "identity_manager_notification_group_v2_deleted", "identity_manager_notification_keycloak_group_v_2_shared_settings", "identity_manager_notification_new_keycloak_group_v2_push_topic"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "identity_manager_notification_group_v2_created": {
                try (EngineSession engineSession = this.engine.getSession();){
                    ObvGroupV2 obvGroupV2;
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    Identity createdBy = (Identity)userInfo.get("created_by");
                    GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                    Boolean createdByMe = (Boolean)userInfo.get("created_by_me");
                    Boolean createdOnOtherDevice = (Boolean)userInfo.get("on_other_device");
                    if (ownedIdentity != null && groupIdentifier != null && createdByMe != null && createdOnOtherDevice != null && (obvGroupV2 = this.engine.identityManager.getObvGroupV2(engineSession.session, ownedIdentity, groupIdentifier)) != null) {
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        engineInfo.put("group", obvGroupV2);
                        engineInfo.put("new_group", createdByMe);
                        engineInfo.put("by_me", createdByMe);
                        engineInfo.put("created_on_other_device", createdOnOtherDevice);
                        if (createdBy != null) {
                            engineInfo.put("by", createdBy.getBytes());
                        }
                        this.engine.postEngineNotification("engine_notification_group_v2_created_or_updated", engineInfo);
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_group_v2_updated": {
                try (EngineSession engineSession = this.engine.getSession();){
                    ObvGroupV2 obvGroupV2;
                    Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                    GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                    Boolean updatedByMe = (Boolean)userInfo.get("by_me");
                    Identity updatedBy = (Identity)userInfo.get("by");
                    List groupLeavers = (List)userInfo.get("group_leavers");
                    if (ownedIdentity != null && groupIdentifier != null && updatedByMe != null && (obvGroupV2 = this.engine.identityManager.getObvGroupV2(engineSession.session, ownedIdentity, groupIdentifier)) != null) {
                        HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                        engineInfo.put("group", obvGroupV2);
                        engineInfo.put("new_group", false);
                        engineInfo.put("by_me", updatedByMe);
                        engineInfo.put("by", updatedBy == null ? null : updatedBy.getBytes());
                        if (groupLeavers != null) {
                            byte[][] leavers = new byte[groupLeavers.size()][];
                            for (int i = 0; i < groupLeavers.size(); ++i) {
                                leavers[i] = ((Identity)groupLeavers.get(i)).getBytes();
                            }
                            engineInfo.put("group_leavers", leavers);
                        }
                        engineInfo.put("created_on_other_device", false);
                        this.engine.postEngineNotification("engine_notification_group_v2_created_or_updated", engineInfo);
                    }
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                break;
            }
            case "identity_manager_notification_group_v2_photo_updated": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                if (ownedIdentity == null || groupIdentifier == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_identifier", groupIdentifier.getBytes());
                this.engine.postEngineNotification("engine_notification_group_v2_photo_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_group_v2_frozen_changed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                Boolean frozen = (Boolean)userInfo.get("frozen");
                Boolean newGroup = (Boolean)userInfo.get("new_group");
                if (ownedIdentity == null || groupIdentifier == null || frozen == null || newGroup == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_identifier", groupIdentifier.getBytes());
                engineInfo.put("updating", frozen);
                engineInfo.put("creating", newGroup);
                this.engine.postEngineNotification("engine_notification_group_v2_update_in_progress_changed", engineInfo);
                break;
            }
            case "identity_manager_notification_group_v2_deleted": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                Identity deletedBy = (Identity)userInfo.get("deleted_by");
                if (ownedIdentity == null || groupIdentifier == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_identifier", groupIdentifier.getBytes());
                if (deletedBy != null) {
                    engineInfo.put("deleted_by", deletedBy.getBytes());
                }
                this.engine.postEngineNotification("engine_notification_group_v2_deleted", engineInfo);
                break;
            }
            case "identity_manager_notification_keycloak_group_v_2_shared_settings": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                GroupV2.Identifier groupIdentifier = (GroupV2.Identifier)userInfo.get("group_identifier");
                String serializedSharedSettings = (String)userInfo.get("serialized_shared_settings");
                Long latestModificationTimestamp = (Long)userInfo.get("timestamp");
                if (ownedIdentity == null || groupIdentifier == null || latestModificationTimestamp == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("bytes_group_identifier", groupIdentifier.getBytes());
                engineInfo.put("shared_settings", serializedSharedSettings);
                engineInfo.put("timestamp", latestModificationTimestamp);
                this.engine.postEngineNotification("engine_notification_keycloak_group_v2_shared_settings", engineInfo);
                break;
            }
            case "identity_manager_notification_new_keycloak_group_v2_push_topic": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                this.engine.fetchManager.forceRegisterPushNotification(ownedIdentity, false);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

