/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import io.olvid.engine.Logger;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.NotificationListener;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.DecryptedApplicationMessage;
import io.olvid.engine.datatypes.containers.OwnedIdentitySynchronizationStatus;
import io.olvid.engine.datatypes.containers.ReceivedAttachment;
import io.olvid.engine.datatypes.notifications.DownloadNotifications;
import io.olvid.engine.engine.Engine;
import io.olvid.engine.engine.types.EngineAPI;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.engine.engine.types.ObvTurnCredentialsFailedReason;
import io.olvid.engine.networkfetch.databases.ServerSession;
import io.olvid.engine.notification.NotificationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class NotificationListenerDownloads
implements NotificationListener {
    private final Engine engine;
    private long latestNetworkRestart = System.currentTimeMillis();

    public NotificationListenerDownloads(Engine engine) {
        this.engine = engine;
    }

    void registerToNotifications(NotificationManager notificationManager) {
        for (String notificationName : new String[]{"network_fetch_notification_message_payload_set", "network_fetch_notification_message_extended_payload_downloaded", "network_fetch_notification_attachment_download_failed", "network_fetch_notification_attachment_download_finished", "network_fetch_notification_attachment_download_progress", "network_fetch_notification_attachment_download_was_paused", "network_fetch_notification_server_session_exists", "network_fetch_notification_server_session_created", "network_fetch_notification_server_poll_requested", "network_fetch_notification_server_polled", "network_fetch_notification_return_receipt_received", "network_fetch_notification_turn_credentials_recieved", "network_fetch_notification_turn_credentials_failed", "network_fetch_notification_api_key_status_query_success", "network_fetch_notification_api_key_status_query_failed", "network_fetch_notification_free_trial_query_success", "network_fetch_notification_free_trial_query_failed", "network_fetch_notification_free_trial_retrieve_success", "network_fetch_notification_free_trial_retrieve_failed", "network_fetch_notification_verify_receipt_success", "network_fetch_notification_well_known_updated", "network_fetch_notification_well_known_download_success", "network_fetch_notification_well_known_download_failed", "network_fetch_notification_ping_lost", "network_fetch_notification_ping_received", "network_fetch_notification_websocket_connection_state_changed", "network_fetch_notification_websocket_detected_some_network", "network_fetch_notification_push_topic_notified", "network_fetch_notification_keycloak_update_required", "network_fetch_notification_push_register_failed_bad_device_uid_to_replace", "network_fetch_notification_owned_identity_synchronizing_with_server"}) {
            notificationManager.addListener(notificationName, this);
        }
    }

    @Override
    public void callback(String notificationName, Map<String, Object> userInfo) {
        switch (notificationName) {
            case "network_fetch_notification_message_payload_set": {
                DecryptedApplicationMessage decryptedMessage = (DecryptedApplicationMessage)userInfo.get("message");
                ReceivedAttachment[] receivedAttachments = (ReceivedAttachment[])userInfo.get("attachments");
                if (decryptedMessage == null || receivedAttachments == null) break;
                ObvMessage message = new ObvMessage(decryptedMessage, receivedAttachments);
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("message", message);
                this.engine.postEngineNotification("engine_notification_new_message_received", engineInfo);
                break;
            }
            case "network_fetch_notification_message_extended_payload_downloaded": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UID messageUid = (UID)userInfo.get("message_uid");
                byte[] extendedPayload = (byte[])userInfo.get("extended_payload");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("extended_payload", extendedPayload);
                this.engine.postEngineNotification("engine_notification_message_extended_payload_downloaded", engineInfo);
                break;
            }
            case "network_fetch_notification_attachment_download_was_paused": {
                break;
            }
            case "network_fetch_notification_attachment_download_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("attachment_number", attachmentNumber);
                this.engine.postEngineNotification("engine_notification_attachment_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_attachment_download_finished": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                ObvAttachment attachment = ObvAttachment.create(this.engine.fetchManager, ownedIdentity, messageUid, attachmentNumber);
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("attachment", attachment);
                this.engine.postEngineNotification("engine_notification_attachment_downloaded", engineInfo);
                break;
            }
            case "network_fetch_notification_attachment_download_progress": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UID messageUid = (UID)userInfo.get("messageUid");
                int attachmentNumber = (Integer)userInfo.get("attachmentNumber");
                float progress = ((Float)userInfo.get("progress")).floatValue();
                Float speed = (Float)userInfo.get("speed");
                Integer eta = (Integer)userInfo.get("eta");
                if (messageUid == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("message_identifier", messageUid.getBytes());
                engineInfo.put("attachment_number", attachmentNumber);
                engineInfo.put("progress", Float.valueOf(progress));
                if (speed != null && eta != null) {
                    engineInfo.put("speed", speed);
                    engineInfo.put("eta", eta);
                }
                this.engine.postEngineNotification("engine_notification_download_attachment_progress", engineInfo);
                break;
            }
            case "network_fetch_notification_server_session_exists": 
            case "network_fetch_notification_server_session_created": {
                Identity ownedIdentity = (Identity)userInfo.get("identity");
                ServerSession.ApiKeyStatus apiKeyStatus = (ServerSession.ApiKeyStatus)((Object)userInfo.get("api_key_status"));
                List permissions = (List)userInfo.get("permissions");
                long apiKeyExpirationTimestamp = (Long)userInfo.get("api_key_expiration_timestamp");
                if (ownedIdentity == null || apiKeyStatus == null || permissions == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                switch (apiKeyStatus) {
                    case VALID: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.VALID);
                        break;
                    }
                    case UNKNOWN: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.UNKNOWN);
                        break;
                    }
                    case LICENSES_EXHAUSTED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.LICENSES_EXHAUSTED);
                        break;
                    }
                    case EXPIRED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.EXPIRED);
                        break;
                    }
                    case OPEN_BETA_KEY: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.OPEN_BETA_KEY);
                        break;
                    }
                    case FREE_TRIAL_KEY: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.FREE_TRIAL_KEY);
                        break;
                    }
                    case AWAITING_PAYMENT_GRACE_PERIOD: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.AWAITING_PAYMENT_GRACE_PERIOD);
                        break;
                    }
                    case AWAITING_PAYMENT_ON_HOLD: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.AWAITING_PAYMENT_ON_HOLD);
                        break;
                    }
                    case FREE_TRIAL_KEY_EXPIRED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.FREE_TRIAL_KEY_EXPIRED);
                    }
                }
                ArrayList<EngineAPI.ApiKeyPermission> enginePermissions = new ArrayList<EngineAPI.ApiKeyPermission>();
                for (ServerSession.Permission permission : permissions) {
                    switch (permission) {
                        case CALL: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.CALL);
                            break;
                        }
                        case WEB_CLIENT: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.WEB_CLIENT);
                            break;
                        }
                        case MULTI_DEVICE: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.MULTI_DEVICE);
                        }
                    }
                }
                engineInfo.put("permissions", enginePermissions);
                if (apiKeyExpirationTimestamp != 0L) {
                    engineInfo.put("api_key_expiration_timestamp", apiKeyExpirationTimestamp);
                }
                this.engine.postEngineNotification("engine_notification_api_key_accepted", engineInfo);
                break;
            }
            case "network_fetch_notification_server_poll_requested": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                boolean user_initiated = (Boolean)userInfo.get("user_initiated");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("user_initiated", user_initiated);
                this.engine.postEngineNotification("engine_notification_server_poll_requested", engineInfo);
                break;
            }
            case "network_fetch_notification_server_polled": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                boolean success = (Boolean)userInfo.get("success");
                boolean truncated = (Boolean)userInfo.get("truncated");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("success", success);
                engineInfo.put("truncated", truncated);
                this.engine.postEngineNotification("engine_notification_server_polled", engineInfo);
                break;
            }
            case "network_fetch_notification_return_receipt_received": {
                Identity ownedIdentity = (Identity)userInfo.get("bytes_owned_identity");
                byte[] serverUid = (byte[])userInfo.get("server_uid");
                byte[] nonce = (byte[])userInfo.get("nonce");
                byte[] encryptedPayload = (byte[])userInfo.get("encrypted_payload");
                long timestamp = (Long)userInfo.get("timestamp");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("server_uid", serverUid);
                engineInfo.put("nonce", nonce);
                engineInfo.put("encrypted_payload", encryptedPayload);
                engineInfo.put("timestamp", timestamp);
                this.engine.postEngineNotification("engine_notification_return_receipt_received", engineInfo);
                break;
            }
            case "network_fetch_notification_turn_credentials_recieved": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UUID callUuid = (UUID)userInfo.get("call_uuid");
                String username1 = (String)userInfo.get("username1");
                String password1 = (String)userInfo.get("username2");
                String username2 = (String)userInfo.get("password1");
                String password2 = (String)userInfo.get("password2");
                List turnServers = (List)userInfo.get("servers");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("call_uuid", callUuid);
                engineInfo.put("username1", username1);
                engineInfo.put("username2", password1);
                engineInfo.put("password1", username2);
                engineInfo.put("password2", password2);
                engineInfo.put("servers", turnServers);
                this.engine.postEngineNotification("engine_notification_turn_credentials_received", engineInfo);
                break;
            }
            case "network_fetch_notification_turn_credentials_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UUID callUuid = (UUID)userInfo.get("call_uuid");
                DownloadNotifications.TurnCredentialsFailedReason rfc = (DownloadNotifications.TurnCredentialsFailedReason)((Object)userInfo.get("reason"));
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("owned_identity", ownedIdentity.getBytes());
                engineInfo.put("call_uuid", callUuid);
                switch (rfc) {
                    case PERMISSION_DENIED: {
                        engineInfo.put("reason", (Object)ObvTurnCredentialsFailedReason.PERMISSION_DENIED);
                        break;
                    }
                    case BAD_SERVER_SESSION: {
                        engineInfo.put("reason", (Object)ObvTurnCredentialsFailedReason.BAD_SERVER_SESSION);
                        break;
                    }
                    case UNABLE_TO_CONTACT_SERVER: {
                        engineInfo.put("reason", (Object)ObvTurnCredentialsFailedReason.UNABLE_TO_CONTACT_SERVER);
                        break;
                    }
                    case CALLS_NOT_SUPPORTED_ON_SERVER: {
                        engineInfo.put("reason", (Object)ObvTurnCredentialsFailedReason.CALLS_NOT_SUPPORTED_ON_SERVER);
                    }
                }
                this.engine.postEngineNotification("engine_notification_turn_credentials_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_api_key_status_query_success": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UUID apiKey = (UUID)userInfo.get("api_key");
                ServerSession.ApiKeyStatus apiKeyStatus = (ServerSession.ApiKeyStatus)((Object)userInfo.get("api_key_status"));
                List permissions = (List)userInfo.get("permissions");
                long apiKeyExpirationTimestamp = (Long)userInfo.get("api_key_expiration_timestamp");
                if (ownedIdentity == null || apiKey == null || apiKeyStatus == null || permissions == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("api_key", apiKey);
                switch (apiKeyStatus) {
                    case VALID: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.VALID);
                        break;
                    }
                    case UNKNOWN: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.UNKNOWN);
                        break;
                    }
                    case LICENSES_EXHAUSTED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.LICENSES_EXHAUSTED);
                        break;
                    }
                    case EXPIRED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.EXPIRED);
                        break;
                    }
                    case OPEN_BETA_KEY: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.OPEN_BETA_KEY);
                        break;
                    }
                    case FREE_TRIAL_KEY: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.FREE_TRIAL_KEY);
                        break;
                    }
                    case AWAITING_PAYMENT_GRACE_PERIOD: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.AWAITING_PAYMENT_GRACE_PERIOD);
                        break;
                    }
                    case AWAITING_PAYMENT_ON_HOLD: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.AWAITING_PAYMENT_ON_HOLD);
                        break;
                    }
                    case FREE_TRIAL_KEY_EXPIRED: {
                        engineInfo.put("api_key_status", (Object)EngineAPI.ApiKeyStatus.FREE_TRIAL_KEY_EXPIRED);
                    }
                }
                ArrayList<EngineAPI.ApiKeyPermission> enginePermissions = new ArrayList<EngineAPI.ApiKeyPermission>();
                for (ServerSession.Permission permission : permissions) {
                    switch (permission) {
                        case CALL: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.CALL);
                            break;
                        }
                        case WEB_CLIENT: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.WEB_CLIENT);
                            break;
                        }
                        case MULTI_DEVICE: {
                            enginePermissions.add(EngineAPI.ApiKeyPermission.MULTI_DEVICE);
                        }
                    }
                }
                engineInfo.put("permissions", enginePermissions);
                if (apiKeyExpirationTimestamp != 0L) {
                    engineInfo.put("api_key_expiration_timestamp", apiKeyExpirationTimestamp);
                }
                this.engine.postEngineNotification("engine_notification_api_key_status_query_success", engineInfo);
                break;
            }
            case "network_fetch_notification_api_key_status_query_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                UUID apiKey = (UUID)userInfo.get("api_key");
                if (ownedIdentity == null || apiKey == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("api_key", apiKey);
                this.engine.postEngineNotification("engine_notification_api_key_status_query_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_free_trial_query_success": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                boolean available = (Boolean)userInfo.get("available");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("available", available);
                this.engine.postEngineNotification("engine_notification_free_trial_query_success", engineInfo);
                break;
            }
            case "network_fetch_notification_free_trial_query_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_free_trial_query_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_free_trial_retrieve_success": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_retrieve_query_success", engineInfo);
                break;
            }
            case "network_fetch_notification_free_trial_retrieve_failed": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_retrieve_query_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_verify_receipt_success": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                String storeToken = (String)userInfo.get("store_token");
                if (ownedIdentity == null || storeToken == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("store_token", storeToken);
                this.engine.postEngineNotification("engine_notification_verify_receipt_success", engineInfo);
                break;
            }
            case "network_fetch_notification_well_known_updated": {
                String server = (String)userInfo.get("server");
                Map appInfo = (Map)userInfo.get("app_info");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("server", server);
                engineInfo.put("app_info", appInfo);
                engineInfo.put("updated", true);
                this.engine.postEngineNotification("engine_notification_well_known_download_success", engineInfo);
                break;
            }
            case "network_fetch_notification_well_known_download_success": {
                String server = (String)userInfo.get("server");
                Map appInfo = (Map)userInfo.get("app_info");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("server", server);
                engineInfo.put("app_info", appInfo);
                engineInfo.put("updated", false);
                this.engine.postEngineNotification("engine_notification_well_known_download_success", engineInfo);
                break;
            }
            case "network_fetch_notification_well_known_download_failed": {
                String server = (String)userInfo.get("server");
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("server", server);
                this.engine.postEngineNotification("engine_notification_well_known_download_failed", engineInfo);
                break;
            }
            case "network_fetch_notification_ping_lost": {
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                this.engine.postEngineNotification("engine_notification_ping_lost", engineInfo);
                break;
            }
            case "network_fetch_notification_ping_received": {
                Long delay = (Long)userInfo.get("delay");
                if (delay == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("delay", delay);
                this.engine.postEngineNotification("engine_notification_ping_received", engineInfo);
                break;
            }
            case "network_fetch_notification_websocket_connection_state_changed": {
                Integer state = (Integer)userInfo.get("state");
                if (state == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("state", state);
                this.engine.postEngineNotification("engine_notification_websocket_connection_state_changed", engineInfo);
                break;
            }
            case "network_fetch_notification_websocket_detected_some_network": {
                if (this.latestNetworkRestart + 5000L < System.currentTimeMillis()) {
                    this.latestNetworkRestart = System.currentTimeMillis();
                    Logger.i("Network detected (WebSocket connected), retrying all scheduled network jobs");
                    this.engine.retryScheduledNetworkTasks();
                }
                this.engine.postEngineNotification("engine_notification_websocket_detected_some_network", new HashMap<String, Object>());
                break;
            }
            case "network_fetch_notification_push_topic_notified": {
                String topic = (String)userInfo.get("topic");
                if (topic == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("topic", topic);
                this.engine.postEngineNotification("engine_notification_push_topic_notified", engineInfo);
                break;
            }
            case "network_fetch_notification_keycloak_update_required": {
                Identity ownedIdentity = (Identity)userInfo.get("identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_keycloak_update_required", engineInfo);
                break;
            }
            case "network_fetch_notification_push_register_failed_bad_device_uid_to_replace": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                if (ownedIdentity == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                this.engine.postEngineNotification("engine_notification_push_register_failed_bad_device_uid_to_replace", engineInfo);
                break;
            }
            case "network_fetch_notification_owned_identity_synchronizing_with_server": {
                Identity ownedIdentity = (Identity)userInfo.get("owned_identity");
                OwnedIdentitySynchronizationStatus status = (OwnedIdentitySynchronizationStatus)((Object)userInfo.get("status"));
                if (ownedIdentity == null || status == null) break;
                HashMap<String, Object> engineInfo = new HashMap<String, Object>();
                engineInfo.put("bytes_owned_identity", ownedIdentity.getBytes());
                engineInfo.put("status", (Object)status);
                this.engine.postEngineNotification("engine_notification_owned_identity_synchronizing_with_server", engineInfo);
                break;
            }
            default: {
                Logger.w("Received notification " + notificationName + " but no handler is set.");
            }
        }
    }
}

