/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.engine;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.olvid.engine.Logger;
import io.olvid.engine.backup.BackupManager;
import io.olvid.engine.channel.ChannelManager;
import io.olvid.engine.crypto.AuthEnc;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.BackupSeed;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.OperationQueue;
import io.olvid.engine.datatypes.PushNotificationTypeAndParameters;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.TrustLevel;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.containers.ChannelApplicationMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelDialogMessageToSend;
import io.olvid.engine.datatypes.containers.ChannelDialogResponseMessageToSend;
import io.olvid.engine.datatypes.containers.DialogType;
import io.olvid.engine.datatypes.containers.GroupV2;
import io.olvid.engine.datatypes.containers.GroupWithDetails;
import io.olvid.engine.datatypes.containers.IdentityWithSerializedDetails;
import io.olvid.engine.datatypes.containers.ServerQuery;
import io.olvid.engine.datatypes.containers.TrustOrigin;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesMDCKeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCKeyPair;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.engine.NotificationListenerBackups;
import io.olvid.engine.engine.NotificationListenerChannelsAndProtocols;
import io.olvid.engine.engine.NotificationListenerDownloads;
import io.olvid.engine.engine.NotificationListenerGroups;
import io.olvid.engine.engine.NotificationListenerGroupsV2;
import io.olvid.engine.engine.NotificationListenerIdentity;
import io.olvid.engine.engine.NotificationListenerUploads;
import io.olvid.engine.engine.databases.EngineDbSchemaVersion;
import io.olvid.engine.engine.databases.UserInterfaceDialog;
import io.olvid.engine.engine.datatypes.EngineSession;
import io.olvid.engine.engine.datatypes.EngineSessionFactory;
import io.olvid.engine.engine.datatypes.UserInterfaceDialogListener;
import io.olvid.engine.engine.types.EngineAPI;
import io.olvid.engine.engine.types.EngineDbQueryStatisticsEntry;
import io.olvid.engine.engine.types.EngineNotificationListener;
import io.olvid.engine.engine.types.JsonGroupDetails;
import io.olvid.engine.engine.types.JsonGroupDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonIdentityDetails;
import io.olvid.engine.engine.types.JsonIdentityDetailsWithVersionAndPhoto;
import io.olvid.engine.engine.types.JsonOsmStyle;
import io.olvid.engine.engine.types.ObvAttachment;
import io.olvid.engine.engine.types.ObvBackupKeyInformation;
import io.olvid.engine.engine.types.ObvBackupKeyVerificationOutput;
import io.olvid.engine.engine.types.ObvBytesKey;
import io.olvid.engine.engine.types.ObvCapability;
import io.olvid.engine.engine.types.ObvContactDeviceCount;
import io.olvid.engine.engine.types.ObvContactInfo;
import io.olvid.engine.engine.types.ObvDeviceBackupForRestore;
import io.olvid.engine.engine.types.ObvDeviceList;
import io.olvid.engine.engine.types.ObvDeviceManagementRequest;
import io.olvid.engine.engine.types.ObvDialog;
import io.olvid.engine.engine.types.ObvMessage;
import io.olvid.engine.engine.types.ObvOutboundAttachment;
import io.olvid.engine.engine.types.ObvPostMessageOutput;
import io.olvid.engine.engine.types.ObvProfileBackupsForRestore;
import io.olvid.engine.engine.types.ObvPushNotificationType;
import io.olvid.engine.engine.types.ObvReturnReceipt;
import io.olvid.engine.engine.types.RegisterApiKeyResult;
import io.olvid.engine.engine.types.identities.ObvContactActiveOrInactiveReason;
import io.olvid.engine.engine.types.identities.ObvGroup;
import io.olvid.engine.engine.types.identities.ObvGroupV2;
import io.olvid.engine.engine.types.identities.ObvIdentity;
import io.olvid.engine.engine.types.identities.ObvKeycloakState;
import io.olvid.engine.engine.types.identities.ObvMutualScanUrl;
import io.olvid.engine.engine.types.identities.ObvOwnedDevice;
import io.olvid.engine.engine.types.identities.ObvTrustOrigin;
import io.olvid.engine.engine.types.sync.ObvBackupAndSyncDelegate;
import io.olvid.engine.engine.types.sync.ObvSyncAtom;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshot;
import io.olvid.engine.engine.types.sync.ObvSyncSnapshotNode;
import io.olvid.engine.identity.IdentityManager;
import io.olvid.engine.identity.databases.sync.IdentityManagerSyncSnapshot;
import io.olvid.engine.metamanager.CreateSessionDelegate;
import io.olvid.engine.metamanager.EngineOwnedIdentityCleanupDelegate;
import io.olvid.engine.metamanager.MetaManager;
import io.olvid.engine.networkfetch.FetchManager;
import io.olvid.engine.networkfetch.operations.StandaloneServerQueryOperation;
import io.olvid.engine.networksend.SendManager;
import io.olvid.engine.notification.NotificationManager;
import io.olvid.engine.protocol.ProtocolManager;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLSocketFactory;
import org.jose4j.jwk.JsonWebKey;

public class Engine
implements UserInterfaceDialogListener,
EngineSessionFactory,
EngineAPI,
EngineOwnedIdentityCleanupDelegate {
    private long instanceCounter;
    private final HashMap<String, HashMap<Long, ListenerAndPriority>> listeners;
    private final ReentrantLock listenersLock;
    private final BlockingQueue<EngineNotification> notificationQueue;
    private final PRNGService prng;
    final ObjectMapper jsonObjectMapper;
    private final String dbPath;
    private final String dbKey;
    private final SSLSocketFactory sslSocketFactory;
    private final CreateSessionDelegate createSessionDelegate;
    private final ObvBackupAndSyncDelegate appBackupAndSyncDelegate;
    final ChannelManager channelManager;
    final IdentityManager identityManager;
    final FetchManager fetchManager;
    final SendManager sendManager;
    final NotificationManager notificationManager;
    final ProtocolManager protocolManager;
    final BackupManager backupManager;
    final NotificationWorker notificationWorker;
    private NotificationListenerChannelsAndProtocols notificationListenerChannelsAndProtocols;
    private NotificationListenerDownloads notificationListenerDownloads;
    private NotificationListenerIdentity notificationListenerIdentity;
    private NotificationListenerGroups notificationListenerGroups;
    private NotificationListenerGroupsV2 notificationListenerGroupsV2;
    private NotificationListenerUploads notificationListenerUploads;
    private NotificationListenerBackups notificationListenerBackups;

    public Engine(File baseDirectory, ObvBackupAndSyncDelegate appBackupAndSyncDelegate, String dbKey, SSLSocketFactory sslSocketFactory, Logger.LogOutputter logOutputter, int logLevel) throws Exception {
        this(baseDirectory, appBackupAndSyncDelegate, dbKey, sslSocketFactory, logOutputter, logLevel, 1, 1);
    }

    public Engine(File baseDirectory, ObvBackupAndSyncDelegate appBackupAndSyncDelegate, String dbKey, SSLSocketFactory sslSocketFactory, Logger.LogOutputter logOutputter, int logLevel, int sendMessageThreadCount, int sendReturnReceiptThreadCount) throws Exception {
        File inboundAttachmentDirectory;
        String baseDirectoryPath;
        block41: {
            this.instanceCounter = 0L;
            this.listeners = new HashMap();
            this.listenersLock = new ReentrantLock();
            this.notificationQueue = new ArrayBlockingQueue<EngineNotification>(5000);
            this.notificationWorker = new NotificationWorker();
            Logger.setOutputter(logOutputter);
            Logger.setOutputLogLevel(logLevel);
            this.prng = Suite.getDefaultPRNGService(0);
            this.jsonObjectMapper = new ObjectMapper();
            this.jsonObjectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
            if (baseDirectory == null) {
                baseDirectory = new File(System.getProperty("java.io.tmpdir"));
            }
            baseDirectoryPath = baseDirectory.getPath();
            this.dbPath = new File(baseDirectory, "engine_db.sqlite").getPath();
            this.dbKey = dbKey;
            this.sslSocketFactory = sslSocketFactory;
            this.appBackupAndSyncDelegate = appBackupAndSyncDelegate;
            inboundAttachmentDirectory = new File(baseDirectory, "inbound_attachments");
            inboundAttachmentDirectory.mkdir();
            File identityPhotosDirectory = new File(baseDirectory, "identity_photos");
            identityPhotosDirectory.mkdir();
            File userDataDirectory = new File(baseDirectory, "downloaded_user_data");
            userDataDirectory.mkdir();
            if (dbKey != null && !Session.databaseIsReadable(this.dbPath, dbKey)) {
                try {
                    Logger.i("Engine database may need to be encrypted");
                    long startTime = System.currentTimeMillis();
                    File dbFile = new File(baseDirectory, "engine_db.sqlite");
                    File tmpEncryptedDbFile = new File(baseDirectory, "engine_encrypted_db.sqlite");
                    if (tmpEncryptedDbFile.exists()) {
                        tmpEncryptedDbFile.delete();
                    }
                    try (Session session = Session.getUpgradeTablesSession(this.dbPath, null);
                         Statement statement = session.createStatement();){
                        statement.execute("ATTACH DATABASE '" + tmpEncryptedDbFile.getPath() + "' AS encrypted KEY \"" + dbKey + "\";");
                        statement.execute("SELECT sqlcipher_export('encrypted');");
                        statement.execute("DETACH DATABASE encrypted;");
                    }
                    boolean deleted = dbFile.delete();
                    if (deleted) {
                        boolean renamed = tmpEncryptedDbFile.renameTo(dbFile);
                        if (renamed) {
                            Logger.i("Engine database encryption successful (took " + (System.currentTimeMillis() - startTime) + "ms)");
                        } else {
                            Logger.e("Engine database encryption error: Unable to rename encrypted database!");
                        }
                        break block41;
                    }
                    throw new RuntimeException("Engine database encryption error: unable to delete unencrypted database!");
                }
                catch (Exception fatal) {
                    Logger.e("Engine database encryption failed, falling back to un-encrypted database");
                    dbKey = null;
                }
            }
        }
        try (Session session = Session.getUpgradeTablesSession(this.dbPath, dbKey);){
            session.startTransaction();
            EngineDbSchemaVersion.createTable(session);
            session.commit();
            EngineDbSchemaVersion engineDbSchemaVersion = EngineDbSchemaVersion.get(this.wrapSession(session));
            if (engineDbSchemaVersion == null) {
                throw new SQLException();
            }
            if (engineDbSchemaVersion.getVersion() != 48) {
                Logger.w("WARNING ENGINE DB SCHEMA VERSION CHANGED FROM " + engineDbSchemaVersion.getVersion() + " TO 48");
                for (int version = engineDbSchemaVersion.getVersion(); version < 48; ++version) {
                    if (version == 15) {
                        this.deleteRecursive(inboundAttachmentDirectory);
                        inboundAttachmentDirectory.mkdir();
                    }
                    session.startTransaction();
                    Logger.w("WARNING    -  STEP VERSION " + version + " TO " + (version + 1));
                    Engine.upgradeTables(session, version, version + 1);
                    ChannelManager.upgradeTables(session, version, version + 1);
                    IdentityManager.upgradeTables(session, version, version + 1);
                    FetchManager.upgradeTables(session, version, version + 1);
                    SendManager.upgradeTables(session, version, version + 1);
                    ProtocolManager.upgradeTables(session, version, version + 1);
                    BackupManager.upgradeTables(session, version, version + 1);
                    engineDbSchemaVersion.update(version + 1);
                    session.commit();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to check for tables upgrade", e);
        }
        MetaManager metaManager = new MetaManager();
        String finalDbKey = dbKey;
        this.createSessionDelegate = () -> Session.getSession(this.dbPath, finalDbKey);
        metaManager.registerImplementedDelegates(this.createSessionDelegate);
        metaManager.registerImplementedDelegates(this);
        try (EngineSession engineSession = this.getSession();){
            UserInterfaceDialog.createTable(engineSession.session);
            engineSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
            throw new RuntimeException("Unable to create engine databases");
        }
        this.channelManager = new ChannelManager(metaManager);
        this.identityManager = new IdentityManager(metaManager, baseDirectoryPath, this.jsonObjectMapper, this.prng);
        this.fetchManager = new FetchManager(metaManager, sslSocketFactory, baseDirectoryPath, this.prng, this.jsonObjectMapper);
        this.sendManager = new SendManager(metaManager, sslSocketFactory, baseDirectoryPath, this.prng, sendMessageThreadCount, sendReturnReceiptThreadCount);
        this.notificationManager = new NotificationManager(metaManager);
        this.protocolManager = new ProtocolManager(metaManager, appBackupAndSyncDelegate, baseDirectoryPath, this.prng, this.jsonObjectMapper);
        this.backupManager = new BackupManager(metaManager, appBackupAndSyncDelegate, sslSocketFactory, this.prng, this.jsonObjectMapper);
        this.registerToInternalNotifications();
        this.initializationComplete();
        metaManager.initializationComplete();
    }

    @Override
    public void startProcessing() {
        this.fetchManager.startProcessing();
        this.sendManager.startProcessing();
        this.protocolManager.startProcessing();
    }

    private static void upgradeTables(Session session, int oldVersion, int newVersion) throws SQLException {
        UserInterfaceDialog.upgradeTable(session, oldVersion, newVersion);
    }

    private void initializationComplete() {
        try (EngineSession engineSession = this.getSession();){
            for (UserInterfaceDialog userInterfaceDialog : UserInterfaceDialog.getAll(engineSession)) {
                try {
                    if (userInterfaceDialog.getObvDialog().getCategory().getId() != 18) continue;
                    userInterfaceDialog.delete();
                }
                catch (Exception e) {
                    Logger.x(e);
                    try {
                        userInterfaceDialog.delete();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    private void deleteRecursive(File fileOrDirectory) {
        File[] children;
        if (fileOrDirectory == null) {
            return;
        }
        if (fileOrDirectory.isDirectory() && (children = fileOrDirectory.listFiles()) != null) {
            for (File child : children) {
                this.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    @Override
    public void addNotificationListener(String notificationName, EngineNotificationListener engineNotificationListener) {
        this.addNotificationListener(notificationName, engineNotificationListener, EngineAPI.ListenerPriority.NORMAL);
    }

    @Override
    public void addNotificationListener(String notificationName, EngineNotificationListener engineNotificationListener, EngineAPI.ListenerPriority priority) {
        long listenerNumber;
        this.listenersLock.lock();
        if (engineNotificationListener.hasEngineNotificationListenerRegistrationNumber()) {
            listenerNumber = engineNotificationListener.getEngineNotificationListenerRegistrationNumber();
        } else {
            listenerNumber = this.instanceCounter++;
            engineNotificationListener.setEngineNotificationListenerRegistrationNumber(listenerNumber);
        }
        HashMap<Long, ListenerAndPriority> notificationObservers = this.listeners.get(notificationName);
        if (notificationObservers == null) {
            notificationObservers = new HashMap();
            this.listeners.put(notificationName, notificationObservers);
        }
        WeakReference<EngineNotificationListener> weakReference = new WeakReference<EngineNotificationListener>(engineNotificationListener);
        notificationObservers.put(listenerNumber, new ListenerAndPriority(weakReference, priority));
        this.listenersLock.unlock();
    }

    @Override
    public void removeNotificationListener(String notificationName, EngineNotificationListener engineNotificationListener) {
        if (engineNotificationListener != null && engineNotificationListener.hasEngineNotificationListenerRegistrationNumber()) {
            this.removeNotificationListener(notificationName, engineNotificationListener.getEngineNotificationListenerRegistrationNumber());
        }
    }

    @Override
    public void startSendingNotifications() {
        this.notificationWorker.start();
    }

    @Override
    public void stopSendingNotifications() {
        this.notificationWorker.stop();
    }

    @Override
    public void runTaskOnEngineNotificationQueue(Runnable runnable) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("synchronized_task", runnable);
        this.postEngineNotification("synchronized_task", userInfo);
    }

    private void removeNotificationListener(String notificationName, long notificationListenerRegistrationNumber) {
        this.listenersLock.lock();
        HashMap<Long, ListenerAndPriority> notificationObservers = this.listeners.get(notificationName);
        if (notificationObservers != null) {
            notificationObservers.remove(notificationListenerRegistrationNumber);
        }
        this.listenersLock.unlock();
    }

    void postEngineNotification(String notificationName, HashMap<String, Object> userInfo) {
        Logger.d("Posting engine notification with name " + notificationName);
        try {
            this.notificationQueue.put(new EngineNotification(notificationName, userInfo));
        }
        catch (InterruptedException e) {
            Logger.x(e);
        }
    }

    private void registerToInternalNotifications() {
        this.notificationListenerChannelsAndProtocols = new NotificationListenerChannelsAndProtocols(this);
        this.notificationListenerChannelsAndProtocols.registerToNotifications(this.notificationManager);
        this.notificationListenerDownloads = new NotificationListenerDownloads(this);
        this.notificationListenerDownloads.registerToNotifications(this.notificationManager);
        this.notificationListenerIdentity = new NotificationListenerIdentity(this);
        this.notificationListenerIdentity.registerToNotifications(this.notificationManager);
        this.notificationListenerIdentity = new NotificationListenerIdentity(this);
        this.notificationListenerIdentity.registerToNotifications(this.notificationManager);
        this.notificationListenerGroups = new NotificationListenerGroups(this);
        this.notificationListenerGroups.registerToNotifications(this.notificationManager);
        this.notificationListenerGroupsV2 = new NotificationListenerGroupsV2(this);
        this.notificationListenerGroupsV2.registerToNotifications(this.notificationManager);
        this.notificationListenerUploads = new NotificationListenerUploads(this);
        this.notificationListenerUploads.registerToNotifications(this.notificationManager);
        this.notificationListenerBackups = new NotificationListenerBackups(this);
        this.notificationListenerBackups.registerToNotifications(this.notificationManager);
    }

    @Override
    public EngineSession getSession() throws SQLException {
        return new EngineSession(this.createSessionDelegate.getSession(), this, this.jsonObjectMapper);
    }

    EngineSession wrapSession(Session session) {
        return new EngineSession(session, this, this.jsonObjectMapper);
    }

    @Override
    public void sendUserInterfaceDialogNotification(UUID uuid, ObvDialog dialog, long creationTimestamp) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("uuid", uuid);
        userInfo.put("dialog", dialog);
        userInfo.put("creation_timestamp", creationTimestamp);
        this.postEngineNotification("engine_notification_ui_dialog", userInfo);
    }

    @Override
    public void sendUserInterfaceDialogDeletionNotification(UUID uuid) {
        HashMap<String, Object> userInfo = new HashMap<String, Object>();
        userInfo.put("uuid", uuid);
        this.postEngineNotification("engine_notification_ui_dialog_deleted", userInfo);
    }

    ObvDialog createDialog(ChannelDialogMessageToSend channelDialogMessageToSend) {
        ObvDialog.Category category;
        Identity ownedIdentity = channelDialogMessageToSend.getSendChannelInfo().getToIdentity();
        DialogType dialogType = channelDialogMessageToSend.getSendChannelInfo().getDialogType();
        switch (dialogType.id) {
            case 0: {
                category = ObvDialog.Category.createInviteSent(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails);
                break;
            }
            case 1: {
                category = ObvDialog.Category.createAcceptInvite(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails, dialogType.serverTimestamp);
                break;
            }
            case 2: {
                category = ObvDialog.Category.createSasExchange(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails, dialogType.sasToDisplay, dialogType.serverTimestamp);
                break;
            }
            case 3: {
                category = ObvDialog.Category.createSasConfirmed(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails, dialogType.sasToDisplay, dialogType.sasEntered);
                break;
            }
            case 5: {
                category = ObvDialog.Category.createInviteAccepted(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails);
                break;
            }
            case 6: {
                byte[] bytesMediatorIdentity = null;
                if (dialogType.mediatorOrGroupOwnerIdentity != null) {
                    bytesMediatorIdentity = dialogType.mediatorOrGroupOwnerIdentity.getBytes();
                }
                category = ObvDialog.Category.createAcceptMediatorInvite(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails, bytesMediatorIdentity, dialogType.serverTimestamp);
                break;
            }
            case 7: {
                byte[] bytesMediatorIdentity = null;
                if (dialogType.mediatorOrGroupOwnerIdentity != null) {
                    bytesMediatorIdentity = dialogType.mediatorOrGroupOwnerIdentity.getBytes();
                }
                category = ObvDialog.Category.createMediatorInviteAccepted(dialogType.contactIdentity.getBytes(), dialogType.contactDisplayNameOrSerializedDetails, bytesMediatorIdentity);
                break;
            }
            case 8: {
                byte[] bytesGroupOwnedIdentity = null;
                if (dialogType.mediatorOrGroupOwnerIdentity != null) {
                    bytesGroupOwnedIdentity = dialogType.mediatorOrGroupOwnerIdentity.getBytes();
                }
                ObvIdentity[] pendingGroupMemberIdentities = new ObvIdentity[dialogType.pendingGroupMemberIdentities.length];
                for (int i = 0; i < pendingGroupMemberIdentities.length; ++i) {
                    try {
                        JsonIdentityDetails identityDetails = (JsonIdentityDetails)this.jsonObjectMapper.readValue(dialogType.pendingGroupMemberSerializedDetails[i], JsonIdentityDetails.class);
                        pendingGroupMemberIdentities[i] = new ObvIdentity(dialogType.pendingGroupMemberIdentities[i], identityDetails, false, true);
                        continue;
                    }
                    catch (Exception e) {
                        break;
                    }
                }
                category = ObvDialog.Category.createAcceptGroupInvite(dialogType.serializedGroupDetails, dialogType.groupUid.getBytes(), bytesGroupOwnedIdentity, pendingGroupMemberIdentities, dialogType.serverTimestamp);
                break;
            }
            case 13: {
                category = ObvDialog.Category.createOneToOneInvitationSent(dialogType.contactIdentity.getBytes());
                break;
            }
            case 14: {
                category = ObvDialog.Category.createAcceptOneToOneInvitation(dialogType.contactIdentity.getBytes(), dialogType.serverTimestamp);
                break;
            }
            case 15: {
                category = ObvDialog.Category.createGroupV2Invitation(dialogType.mediatorOrGroupOwnerIdentity.getBytes(), dialogType.obvGroupV2);
                break;
            }
            case 16: {
                category = ObvDialog.Category.createGroupV2FrozenInvitation(dialogType.mediatorOrGroupOwnerIdentity.getBytes(), dialogType.obvGroupV2);
                break;
            }
            case 17: {
                category = ObvDialog.Category.createSyncItemToApply(dialogType.obvSyncAtom);
                break;
            }
            case 18: {
                category = ObvDialog.Category.createTransferDialog(dialogType.obvTransferStep);
                break;
            }
            default: {
                Logger.w("Unknown DialogType " + dialogType.id);
                return null;
            }
        }
        return new ObvDialog(channelDialogMessageToSend.getUuid(), channelDialogMessageToSend.getEncodedElements(), ownedIdentity.getBytes(), category);
    }

    @Override
    public void deleteOwnedIdentityFromInboxOutboxProtocolsAndDialogs(Session session, Identity ownedIdentity, UID excludedProtocolInstanceUid) throws Exception {
        this.protocolManager.deleteOwnedIdentity(session, ownedIdentity, excludedProtocolInstanceUid);
        this.sendManager.deleteOwnedIdentity(session, ownedIdentity);
        this.fetchManager.deleteOwnedIdentity(session, ownedIdentity, excludedProtocolInstanceUid != null);
        for (UserInterfaceDialog userInterfaceDialog : UserInterfaceDialog.getAll(this.wrapSession(session))) {
            try {
                ObvDialog obvDialog = userInterfaceDialog.getObvDialog();
                if (!Arrays.equals(obvDialog.getBytesOwnedIdentity(), ownedIdentity.getBytes())) continue;
                userInterfaceDialog.delete();
            }
            catch (Exception e) {
                Logger.x(e);
            }
        }
    }

    @Override
    public void deleteOwnedIdentityServerSession(Session session, Identity ownedIdentity) {
        this.fetchManager.deleteExistingServerSession(session, ownedIdentity, false);
    }

    @Override
    public Map<String, EngineDbQueryStatisticsEntry> getEngineDbQueryStatistics() {
        return Session.queryStatistics;
    }

    @Override
    public String getServerOfIdentity(byte[] bytesIdentity) {
        try {
            Identity identity = Identity.of(bytesIdentity);
            return identity.getServer();
        }
        catch (DecodingException decodingException) {
            return null;
        }
    }

    @Override
    public ObvIdentity[] getOwnedIdentities() throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity[] identities = this.identityManager.getOwnedIdentities(engineSession.session);
            ObvIdentity[] ownedIdentities = new ObvIdentity[identities.length];
            for (int i = 0; i < identities.length; ++i) {
                ownedIdentities[i] = new ObvIdentity(engineSession.session, this.identityManager, identities[i]);
            }
            ObvIdentity[] obvIdentityArray = ownedIdentities;
            return obvIdentityArray;
        }
    }

    @Override
    public ObvIdentity getOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            ObvIdentity obvOwnedIdentity = new ObvIdentity(engineSession.session, this.identityManager, ownedIdentity);
            if (obvOwnedIdentity.getIdentityDetails() != null) {
                ObvIdentity obvIdentity = obvOwnedIdentity;
                return obvIdentity;
            }
            ObvIdentity obvIdentity = null;
            return obvIdentity;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvIdentity generateOwnedIdentity(String server, JsonIdentityDetails identityDetails, ObvKeycloakState keycloakState, String deviceDisplayName) {
        try (EngineSession engineSession = this.getSession();){
            Identity identity;
            if (server == null) {
                server = "";
            }
            if ((identity = this.identityManager.generateOwnedIdentity(engineSession.session, server, identityDetails, keycloakState, deviceDisplayName, this.prng)) == null) {
                ObvIdentity obvIdentity2 = null;
                return obvIdentity2;
            }
            ObvIdentity ownedIdentity = new ObvIdentity(identity, identityDetails, keycloakState != null, true);
            engineSession.session.commit();
            ObvIdentity obvIdentity = ownedIdentity;
            return obvIdentity;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public RegisterApiKeyResult registerOwnedIdentityApiKeyOnServer(byte[] bytesOwnedIdentity, UUID apiKey) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            byte[] serverSessionToken = this.fetchManager.getServerAuthenticationToken(ownedIdentity);
            if (serverSessionToken == null) {
                this.fetchManager.createServerSession(ownedIdentity);
                return RegisterApiKeyResult.WAIT_FOR_SERVER_SESSION;
            }
            StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, ownedIdentity, new ServerQuery.RegisterApiKeyQuery(ownedIdentity, serverSessionToken, Logger.getUuidString(apiKey))), this.sslSocketFactory);
            OperationQueue queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-registerOwnedIdentityApiKeyOnServer");
            queue.join();
            if (standaloneServerQueryOperation.isFinished()) {
                this.recreateServerSession(bytesOwnedIdentity);
                return RegisterApiKeyResult.SUCCESS;
            }
            if (standaloneServerQueryOperation.getReasonForCancel() != null) {
                switch (standaloneServerQueryOperation.getReasonForCancel()) {
                    case 4: {
                        return RegisterApiKeyResult.INVALID_KEY;
                    }
                    case 3: {
                        this.recreateServerSession(bytesOwnedIdentity);
                        return RegisterApiKeyResult.WAIT_FOR_SERVER_SESSION;
                    }
                }
            }
            return RegisterApiKeyResult.FAILED;
        }
        catch (Exception e) {
            Logger.x(e);
            return RegisterApiKeyResult.FAILED;
        }
    }

    @Override
    public void updateKeycloakTransferRestrictedIfNeeded(byte[] bytesOwnedIdentity, String serverUrl, boolean transferRestricted) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.updateKeycloakTransferRestrictedIfNeeded(engineSession.session, ownedIdentity, serverUrl, transferRestricted);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void updateKeycloakPushTopicsIfNeeded(byte[] bytesOwnedIdentity, String serverUrl, List<String> pushTopics) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            boolean updated = this.identityManager.updateKeycloakPushTopicsIfNeeded(engineSession.session, ownedIdentity, serverUrl, pushTopics);
            engineSession.session.commit();
            if (updated) {
                this.fetchManager.forceRegisterPushNotification(ownedIdentity, false);
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void updateKeycloakRevocationList(byte[] bytesOwnedIdentity, long latestRevocationListTimestamp, List<String> signedRevocations) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            engineSession.session.startTransaction();
            this.identityManager.verifyAndAddRevocationList(engineSession.session, ownedIdentity, signedRevocations);
            this.identityManager.setKeycloakLatestRevocationListTimestamp(engineSession.session, ownedIdentity, latestRevocationListTimestamp);
            engineSession.session.commit();
            this.identityManager.unCertifyExpiredSignedContactDetails(engineSession.session, ownedIdentity, latestRevocationListTimestamp);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void setOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] bytesOwnedIdentity, String serverUrl, String nonce) {
        if (nonce == null) {
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.setOwnedIdentityKeycloakSelfRevocationTestNonce(engineSession.session, ownedIdentity, serverUrl, nonce);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public String getOwnedIdentityKeycloakSelfRevocationTestNonce(byte[] bytesOwnedIdentity, String serverUrl) {
        String string;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                string = this.identityManager.getOwnedIdentityKeycloakSelfRevocationTestNonce(engineSession.session, ownedIdentity, serverUrl);
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateKeycloakGroups(byte[] bytesOwnedIdentity, List<String> signedGroupBlobs, List<String> signedGroupDeletions, List<String> signedGroupKicks, long keycloakCurrentTimestamp) {
        boolean bl;
        block16: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                boolean success = false;
                try {
                    engineSession.session.startTransaction();
                    this.identityManager.updateKeycloakGroups(engineSession.session, ownedIdentity, signedGroupBlobs, signedGroupDeletions, signedGroupKicks, keycloakCurrentTimestamp);
                    success = true;
                }
                catch (Exception e) {
                    Logger.x(e);
                }
                finally {
                    if (success) {
                        engineSession.session.commit();
                    } else {
                        engineSession.session.rollback();
                    }
                }
                bl = success;
                if (engineSession == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public void recreateServerSession(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.deleteExistingServerSession(engineSession.session, ownedIdentity, true);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void deleteOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            engineSession.session.startTransaction();
            this.channelManager.deleteAllChannelsForOwnedIdentity(engineSession.session, ownedIdentity);
            this.identityManager.deleteOwnedIdentity(engineSession.session, ownedIdentity);
            this.deleteOwnedIdentityFromInboxOutboxProtocolsAndDialogs(engineSession.session, ownedIdentity, null);
            engineSession.session.commit();
        }
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto[] getOwnedIdentityPublishedAndLatestDetails(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonIdentityDetailsWithVersionAndPhoto[] jsonIdentityDetailsWithVersionAndPhotoArray = this.identityManager.getOwnedIdentityPublishedAndLatestDetails(engineSession.session, ownedIdentity);
            return jsonIdentityDetailsWithVersionAndPhotoArray;
        }
    }

    @Override
    public ObvKeycloakState getOwnedIdentityKeycloakState(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            ObvKeycloakState obvKeycloakState = this.identityManager.getOwnedIdentityKeycloakState(engineSession.session, ownedIdentity);
            return obvKeycloakState;
        }
    }

    @Override
    public void saveKeycloakAuthState(byte[] bytesOwnedIdentity, String serializedAuthState) throws Exception {
        Logger.d("Saving keycloak authState in Engine");
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.saveKeycloakAuthState(engineSession.session, ownedIdentity, serializedAuthState);
            engineSession.session.commit();
        }
    }

    @Override
    public void saveKeycloakJwks(byte[] bytesOwnedIdentity, String serializedJwks) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.saveKeycloakJwks(engineSession.session, ownedIdentity, serializedJwks);
            engineSession.session.commit();
        }
    }

    @Override
    public void saveKeycloakApiKey(byte[] bytesOwnedIdentity, String apiKey) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.saveKeycloakApiKey(engineSession.session, ownedIdentity, apiKey);
            engineSession.session.commit();
        }
    }

    @Override
    public Collection<ObvIdentity> getOwnedIdentitiesWithKeycloakPushTopic(String pushTopic) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Collection<ObvIdentity> collection = this.identityManager.getOwnedIdentitiesWithKeycloakPushTopic(engineSession.session, pushTopic);
            return collection;
        }
    }

    @Override
    public String getOwnedIdentityKeycloakUserId(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            String string = this.identityManager.getOwnedIdentityKeycloakUserId(engineSession.session, ownedIdentity);
            return string;
        }
    }

    @Override
    public void setOwnedIdentityKeycloakUserId(byte[] bytesOwnedIdentity, String userId) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.setOwnedIdentityKeycloakUserId(engineSession.session, ownedIdentity, userId);
            engineSession.session.commit();
        }
    }

    @Override
    public JsonWebKey getOwnedIdentityKeycloakSignatureKey(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonWebKey jsonWebKey = this.identityManager.getOwnedIdentityKeycloakSignatureKey(engineSession.session, ownedIdentity);
            return jsonWebKey;
        }
    }

    @Override
    public void setOwnedIdentityKeycloakSignatureKey(byte[] bytesOwnedIdentity, JsonWebKey signatureKey) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.setOwnedIdentityKeycloakSignatureKey(engineSession.session, ownedIdentity, signatureKey);
            this.identityManager.reCheckAllCertifiedByOwnKeycloakContacts(engineSession.session, ownedIdentity);
            engineSession.session.commit();
        }
    }

    @Override
    public ObvIdentity bindOwnedIdentityToKeycloak(byte[] bytesOwnedIdentity, ObvKeycloakState keycloakState, String keycloakUserId) {
        ObvIdentity obvIdentity;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                engineSession.session.startTransaction();
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                this.protocolManager.startProtocolForBindingOwnedIdentityToKeycloakWithinTransaction(engineSession.session, ownedIdentity, keycloakState, keycloakUserId);
                ObvIdentity obvIdentity2 = new ObvIdentity(engineSession.session, this.identityManager, ownedIdentity);
                engineSession.session.commit();
                obvIdentity = obvIdentity2;
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return obvIdentity;
    }

    @Override
    public void unbindOwnedIdentityFromKeycloak(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.protocolManager.startProtocolForUnbindingOwnedIdentityFromKeycloak(ownedIdentity);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void registerToPushNotification(byte[] bytesOwnedIdentity, ObvPushNotificationType pushNotificationType, boolean reactivateCurrentDevice, byte[] bytesDeviceUidToReplace) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            UID currentDeviceUid = this.identityManager.getCurrentDeviceUidOfOwnedIdentity(engineSession.session, ownedIdentity);
            UID deviceUidToReplace = bytesDeviceUidToReplace == null ? null : new UID(bytesDeviceUidToReplace);
            PushNotificationTypeAndParameters pushNotificationTypeAndParameters = switch (pushNotificationType.platform) {
                case ObvPushNotificationType.Platform.ANDROID -> {
                    if (pushNotificationType.firebaseToken == null) {
                        yield PushNotificationTypeAndParameters.createWebsocketOnlyAndroid(reactivateCurrentDevice, deviceUidToReplace);
                    }
                    UID identityMaskingUid = new UID(this.prng);
                    byte[] firebaseTokenBytes = pushNotificationType.firebaseToken.getBytes(StandardCharsets.UTF_8);
                    yield PushNotificationTypeAndParameters.createFirebaseAndroid(firebaseTokenBytes, identityMaskingUid, reactivateCurrentDevice, deviceUidToReplace);
                }
                case ObvPushNotificationType.Platform.WINDOWS -> PushNotificationTypeAndParameters.createWindows(reactivateCurrentDevice, deviceUidToReplace);
                case ObvPushNotificationType.Platform.LINUX -> PushNotificationTypeAndParameters.createLinux(reactivateCurrentDevice, deviceUidToReplace);
                case ObvPushNotificationType.Platform.DAEMON -> PushNotificationTypeAndParameters.createDaemon(reactivateCurrentDevice, deviceUidToReplace);
                default -> {
                    Logger.e("Engine.registerToPushNotification: unknown pushNotificationType.platform");
                    throw new Exception();
                }
            };
            engineSession.session.startTransaction();
            this.fetchManager.registerPushNotificationIfConfigurationChanged(engineSession.session, ownedIdentity, currentDeviceUid, pushNotificationTypeAndParameters);
            engineSession.session.commit();
        }
    }

    @Override
    public void processAndroidPushNotification(String maskingUidString) {
        this.fetchManager.processAndroidPushNotification(maskingUidString);
    }

    @Override
    public byte[] getOwnedIdentityFromMaskingUid(String maskingUidString) {
        Identity ownedIdentity = this.fetchManager.getOwnedIdentityFromMaskingUid(maskingUidString);
        if (ownedIdentity != null) {
            return ownedIdentity.getBytes();
        }
        return null;
    }

    @Override
    public void processDeviceManagementRequest(byte[] bytesOwnedIdentity, ObvDeviceManagementRequest deviceManagementRequest) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            this.protocolManager.processDeviceManagementRequest(engineSession.session, ownedIdentity, deviceManagementRequest);
            engineSession.session.commit();
        }
    }

    @Override
    public void updateLatestIdentityDetails(byte[] bytesOwnedIdentity, JsonIdentityDetails jsonIdentityDetails) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.identityManager.updateLatestIdentityDetails(engineSession.session, ownedIdentity, jsonIdentityDetails);
            engineSession.session.commit();
        }
    }

    @Override
    public void discardLatestIdentityDetails(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.discardLatestIdentityDetails(engineSession.session, ownedIdentity);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void publishLatestIdentityDetails(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            int version = this.identityManager.publishLatestIdentityDetails(engineSession.session, ownedIdentity);
            if (version != -1) {
                this.protocolManager.startIdentityDetailsPublicationProtocol(engineSession.session, ownedIdentity, version);
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void updateOwnedIdentityPhoto(byte[] bytesOwnedIdentity, String absolutePhotoUrl) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.identityManager.updateOwnedIdentityPhoto(engineSession.session, ownedIdentity, absolutePhotoUrl);
            engineSession.session.commit();
        }
    }

    @Override
    public byte[] getServerAuthenticationToken(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            return this.fetchManager.getServerAuthenticationToken(ownedIdentity);
        }
        catch (DecodingException e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public List<ObvCapability> getOwnCapabilities(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            return this.identityManager.getOwnCapabilities(ownedIdentity);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public List<ObvOwnedDevice> getOwnedDevices(byte[] bytesOwnedIdentity) {
        List<ObvOwnedDevice> list;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                list = this.identityManager.getDevicesOfOwnedIdentity(engineSession.session, ownedIdentity);
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return list;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ObvDeviceList queryRegisteredOwnedDevicesFromServer(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, ownedIdentity, new ServerQuery.OwnedDeviceDiscoveryQuery(ownedIdentity)), this.sslSocketFactory);
            OperationQueue queue = new OperationQueue();
            queue.queue(standaloneServerQueryOperation);
            queue.execute(1, "Engine-queryRegisterOwnedDevicesFromServer");
            queue.join();
            if (!standaloneServerQueryOperation.isFinished()) return null;
            if (standaloneServerQueryOperation.getServerResponse() == null) return null;
            ObvDeviceList obvDeviceList = ObvDeviceList.of(standaloneServerQueryOperation.getServerResponse().decodeEncryptedData(), this.identityManager.getOwnedIdentityEncryptionPrivateKey(engineSession.session, ownedIdentity));
            return obvDeviceList;
        }
        catch (Exception e) {
            Logger.x(e);
        }
        return null;
    }

    @Override
    public void refreshOwnedDeviceList(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.protocolManager.startOwnedDeviceDiscoveryProtocol(ownedIdentity);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void recreateOwnedDeviceChannel(byte[] bytesOwnedIdentity, byte[] bytesDeviceUid) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            UID deviceUid = new UID(bytesDeviceUid);
            this.protocolManager.startChannelCreationWithOwnedDeviceProtocol(ownedIdentity, deviceUid);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public ObvIdentity[] getContactsOfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            Identity[] identities = this.identityManager.getContactsOfOwnedIdentity(engineSession.session, ownedIdentity);
            ObvIdentity[] contactIdentities = new ObvIdentity[identities.length];
            for (int i = 0; i < identities.length; ++i) {
                contactIdentities[i] = new ObvIdentity(engineSession.session, this.identityManager, identities[i], ownedIdentity);
            }
            ObvIdentity[] obvIdentityArray = contactIdentities;
            return obvIdentityArray;
        }
    }

    @Override
    public List<ObvContactInfo> getContactsInfoOfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            List<ObvContactInfo> list = this.identityManager.getContactsInfoOfOwnedIdentity(engineSession.session, ownedIdentity);
            return list;
        }
    }

    @Override
    public EnumSet<ObvContactActiveOrInactiveReason> getContactActiveOrInactiveReasons(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        EnumSet<ObvContactActiveOrInactiveReason> enumSet;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                Identity contactIdentity = Identity.of(bytesContactIdentity);
                enumSet = this.identityManager.getContactActiveOrInactiveReasons(engineSession.session, ownedIdentity, contactIdentity);
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return enumSet;
    }

    @Override
    public boolean forcefullyUnblockContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        boolean bl;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                Identity contactIdentity = Identity.of(bytesContactIdentity);
                boolean success = this.identityManager.forcefullyUnblockContact(engineSession.session, ownedIdentity, contactIdentity);
                engineSession.session.commit();
                bl = success;
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public boolean reBlockForcefullyUnblockedContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        boolean bl;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                Identity contactIdentity = Identity.of(bytesContactIdentity);
                boolean success = this.identityManager.reBlockForcefullyUnblockedContact(engineSession.session, ownedIdentity, contactIdentity);
                engineSession.session.commit();
                bl = success;
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public boolean isContactOneToOne(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            boolean bl = this.identityManager.isIdentityAOneToOneContactOfOwnedIdentity(engineSession.session, ownedIdentity, contactIdentity);
            return bl;
        }
    }

    @Override
    public ObvContactDeviceCount getContactDeviceCounts(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            ObvContactDeviceCount obvContactDeviceCount = this.identityManager.getContactDeviceCounts(engineSession.session, Identity.of(bytesOwnedIdentity), Identity.of(bytesContactIdentity));
            return obvContactDeviceCount;
        }
    }

    @Override
    public void forceContactDeviceDiscovery(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        try {
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.protocolManager.startDeviceDiscoveryProtocol(ownedIdentity, contactIdentity);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public String getContactTrustedDetailsPhotoUrl(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            String string = this.identityManager.getContactTrustedDetailsPhotoUrl(engineSession.session, ownedIdentity, contactIdentity);
            return string;
        }
    }

    @Override
    public JsonIdentityDetailsWithVersionAndPhoto[] getContactPublishedAndTrustedDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonIdentityDetailsWithVersionAndPhoto[] jsonIdentityDetailsWithVersionAndPhotoArray = this.identityManager.getContactPublishedAndTrustedDetails(engineSession.session, ownedIdentity, contactIdentity);
            return jsonIdentityDetailsWithVersionAndPhotoArray;
        }
    }

    @Override
    public void trustPublishedContactDetails(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        try (EngineSession engineSession = this.getSession();){
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonIdentityDetailsWithVersionAndPhoto details = this.identityManager.trustPublishedContactDetails(engineSession.session, contactIdentity, ownedIdentity);
            if (details != null) {
                this.propagateEngineSyncAtomToOtherDevicesIfNeeded(engineSession.session, ownedIdentity, ObvSyncAtom.createTrustContactDetails(contactIdentity, this.jsonObjectMapper.writeValueAsString((Object)details)));
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public ObvTrustOrigin[] getContactTrustOrigins(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        ObvTrustOrigin[] obvTrustOrigins;
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        try (EngineSession engineSession = this.getSession();){
            TrustOrigin[] trustOrigins = this.identityManager.getTrustOriginsOfContactIdentity(engineSession.session, ownedIdentity, contactIdentity);
            obvTrustOrigins = new ObvTrustOrigin[trustOrigins.length];
            for (int i = 0; i < trustOrigins.length; ++i) {
                obvTrustOrigins[i] = new ObvTrustOrigin(engineSession.session, this.identityManager, trustOrigins[i], ownedIdentity);
            }
        }
        return obvTrustOrigins;
    }

    @Override
    public int getContactTrustLevel(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        try (EngineSession engineSession = this.getSession();){
            TrustLevel contactTrustLevel = this.identityManager.getContactTrustLevel(engineSession.session, ownedIdentity, contactIdentity);
            if (contactTrustLevel != null) {
                int n = contactTrustLevel.major;
                return n;
            }
            int n = 0;
            return n;
        }
    }

    @Override
    public List<ObvCapability> getContactCapabilities(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            return this.identityManager.getContactCapabilities(ownedIdentity, contactIdentity);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public ObvGroup[] getGroupsOfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            GroupWithDetails[] groups = this.identityManager.getGroupsForOwnedIdentity(engineSession.session, ownedIdentity);
            ObvGroup[] obvGroups = new ObvGroup[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                byte[][] byteContactIdentities = new byte[groups[i].getGroupMembers().length][];
                for (int j = 0; j < byteContactIdentities.length; ++j) {
                    byteContactIdentities[j] = groups[i].getGroupMembers()[j].getBytes();
                }
                ObvIdentity[] pendingMembers = new ObvIdentity[groups[i].getPendingGroupMembers().length];
                for (int j = 0; j < pendingMembers.length; ++j) {
                    try {
                        JsonIdentityDetails identityDetails = (JsonIdentityDetails)this.identityManager.getJsonObjectMapper().readValue(groups[i].getPendingGroupMembers()[j].serializedDetails, JsonIdentityDetails.class);
                        pendingMembers[j] = new ObvIdentity(groups[i].getPendingGroupMembers()[j].identity, identityDetails, false, true);
                        continue;
                    }
                    catch (IOException e) {
                        pendingMembers[j] = new ObvIdentity(groups[i].getPendingGroupMembers()[j].identity, null, false, true);
                    }
                }
                byte[][] bytesDeclinesPendingMembers = new byte[groups[i].getDeclinedPendingMembers().length][];
                for (int j = 0; j < bytesDeclinesPendingMembers.length; ++j) {
                    bytesDeclinesPendingMembers[j] = groups[i].getDeclinedPendingMembers()[j].getBytes();
                }
                obvGroups[i] = groups[i].getGroupOwner() == null ? new ObvGroup(groups[i].getGroupOwnerAndUid(), groups[i].getPublishedGroupDetails(), ownedIdentity.getBytes(), byteContactIdentities, pendingMembers, bytesDeclinesPendingMembers, null) : new ObvGroup(groups[i].getGroupOwnerAndUid(), groups[i].getLatestOrTrustedGroupDetails(), ownedIdentity.getBytes(), byteContactIdentities, pendingMembers, bytesDeclinesPendingMembers, groups[i].getGroupOwner().getBytes());
            }
            ObvGroup[] obvGroupArray = obvGroups;
            return obvGroupArray;
        }
    }

    @Override
    public JsonGroupDetailsWithVersionAndPhoto[] getGroupPublishedAndLatestOrTrustedDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonGroupDetailsWithVersionAndPhoto[] jsonGroupDetailsWithVersionAndPhotoArray = this.identityManager.getGroupPublishedAndLatestOrTrustedDetails(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            return jsonGroupDetailsWithVersionAndPhotoArray;
        }
    }

    @Override
    public String getGroupTrustedDetailsPhotoUrl(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            String string = this.identityManager.getGroupPhotoUrl(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            return string;
        }
    }

    @Override
    public void trustPublishedGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            JsonGroupDetailsWithVersionAndPhoto details = this.identityManager.trustPublishedGroupDetails(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            if (details != null) {
                this.propagateEngineSyncAtomToOtherDevicesIfNeeded(engineSession.session, ownedIdentity, ObvSyncAtom.createTrustGroupV1Details(bytesGroupOwnerAndUid, this.jsonObjectMapper.writeValueAsString((Object)details)));
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void updateLatestGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, JsonGroupDetails jsonGroupDetails) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.identityManager.updateLatestGroupDetails(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid, jsonGroupDetails);
            engineSession.session.commit();
        }
    }

    @Override
    public void discardLatestGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.identityManager.discardLatestGroupDetails(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void publishLatestGroupDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            int version = this.identityManager.publishLatestGroupDetails(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            if (version != -1) {
                this.protocolManager.startGroupDetailsPublicationProtocol(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid);
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void updateOwnedGroupPhoto(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, String absolutePhotoUrl) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.identityManager.updateOwnedGroupPhoto(engineSession.session, ownedIdentity, bytesGroupOwnerAndUid, absolutePhotoUrl, false);
            engineSession.session.commit();
        }
    }

    @Override
    public List<ObvGroupV2> getGroupsV2OfOwnedIdentity(byte[] bytesOwnedIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            List<ObvGroupV2> list = this.identityManager.getObvGroupsV2ForOwnedIdentity(engineSession.session, ownedIdentity);
            return list;
        }
    }

    @Override
    public void trustGroupV2PublishedDetails(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        try (EngineSession engineSession = this.getSession();){
            int version = this.identityManager.trustGroupV2PublishedDetails(engineSession.session, ownedIdentity, groupIdentifier);
            if (version != -1) {
                this.propagateEngineSyncAtomToOtherDevicesIfNeeded(engineSession.session, ownedIdentity, ObvSyncAtom.createTrustGroupV2Details(groupIdentifier, version));
            }
            engineSession.session.commit();
        }
    }

    @Override
    public String getGroupV2JsonType(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        String string;
        block9: {
            if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
                return null;
            }
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
            EngineSession engineSession = this.getSession();
            try {
                string = this.identityManager.getGroupV2JsonGroupType(engineSession.session, ownedIdentity, groupIdentifier);
                if (engineSession == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return string;
    }

    @Override
    public ObvGroupV2.ObvGroupV2DetailsAndPhotos getGroupV2DetailsAndPhotos(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) {
        ObvGroupV2.ObvGroupV2DetailsAndPhotos obvGroupV2DetailsAndPhotos;
        block9: {
            if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
                return null;
            }
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
            EngineSession engineSession = this.getSession();
            try {
                obvGroupV2DetailsAndPhotos = this.identityManager.getGroupV2DetailsAndPhotos(engineSession.session, ownedIdentity, groupIdentifier);
                if (engineSession == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return null;
                }
            }
            engineSession.close();
        }
        return obvGroupV2DetailsAndPhotos;
    }

    @Override
    public void initiateGroupV2Update(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier, ObvGroupV2.ObvGroupV2ChangeSet changeSet) throws Exception {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        this.protocolManager.initiateGroupV2Update(ownedIdentity, groupIdentifier, changeSet);
    }

    @Override
    public void leaveGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        if (groupIdentifier.category == 1) {
            return;
        }
        this.protocolManager.initiateGroupV2Leave(ownedIdentity, groupIdentifier);
    }

    @Override
    public void disbandGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        if (groupIdentifier.category == 1) {
            return;
        }
        this.protocolManager.initiateGroupV2Disband(ownedIdentity, groupIdentifier);
    }

    @Override
    public void reDownloadGroupV2(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        this.protocolManager.initiateGroupV2ReDownload(ownedIdentity, groupIdentifier);
    }

    @Override
    public Integer getGroupV2Version(byte[] bytesOwnedIdentity, byte[] bytesGroupIdentifier) throws Exception {
        if (bytesOwnedIdentity == null || bytesGroupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        GroupV2.Identifier groupIdentifier = GroupV2.Identifier.of(bytesGroupIdentifier);
        try (EngineSession engineSession = this.getSession();){
            Integer n = this.identityManager.getGroupV2Version(engineSession.session, ownedIdentity, groupIdentifier);
            return n;
        }
    }

    @Override
    public boolean isGroupV2UpdateInProgress(byte[] bytesOwnedIdentity, GroupV2.Identifier groupIdentifier) throws Exception {
        if (bytesOwnedIdentity == null || groupIdentifier == null) {
            throw new Exception();
        }
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            boolean bl = this.identityManager.isGroupV2Frozen(engineSession.session, ownedIdentity, groupIdentifier);
            return bl;
        }
    }

    @Override
    public void deletePersistedDialog(UUID uuid) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            UserInterfaceDialog dialog = UserInterfaceDialog.get(engineSession, uuid);
            if (dialog != null) {
                dialog.delete();
                engineSession.session.commit();
            }
        }
    }

    @Override
    public Set<UUID> getAllPersistedDialogUuids() throws Exception {
        try (EngineSession engineSession = this.getSession();){
            UserInterfaceDialog[] dialogs = UserInterfaceDialog.getAll(engineSession);
            HashSet<UUID> obvDialogUuids = new HashSet<UUID>();
            for (UserInterfaceDialog dialog : dialogs) {
                obvDialogUuids.add(dialog.getUuid());
            }
            HashSet<UUID> hashSet = obvDialogUuids;
            return hashSet;
        }
    }

    @Override
    public void resendAllPersistedDialogs() throws Exception {
        try (EngineSession engineSession = this.getSession();){
            UserInterfaceDialog[] dialogs;
            for (UserInterfaceDialog dialog : dialogs = UserInterfaceDialog.getAll(engineSession)) {
                dialog.resend();
            }
        }
    }

    @Override
    public void respondToDialog(ObvDialog dialog) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(dialog.getBytesOwnedIdentity());
            ChannelDialogResponseMessageToSend responseMessageToSend = new ChannelDialogResponseMessageToSend(dialog.getUuid(), ownedIdentity, dialog.getEncodedResponse(), dialog.getEncodedElements());
            engineSession.session.startTransaction();
            this.channelManager.post(engineSession.session, responseMessageToSend, this.prng);
            engineSession.session.commit();
        }
    }

    @Override
    public void abortProtocol(ObvDialog dialog) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            UserInterfaceDialog userInterfaceDialog = UserInterfaceDialog.get(engineSession, dialog.getUuid());
            UID protocolInstanceUid = dialog.getEncodedElements().decodeList()[1].decodeUid();
            Identity ownedIdentity = Identity.of(dialog.getBytesOwnedIdentity());
            engineSession.session.startTransaction();
            userInterfaceDialog.delete();
            this.protocolManager.abortProtocol(engineSession.session, protocolInstanceUid, ownedIdentity);
            engineSession.session.commit();
        }
    }

    @Override
    public void startTrustEstablishmentProtocol(byte[] bytesRemoteIdentity, String contactDisplayName, byte[] bytesOwnedIdentity) throws Exception {
        Identity remoteIdentity = Identity.of(bytesRemoteIdentity);
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.startTrustEstablishmentProtocol(ownedIdentity, remoteIdentity, contactDisplayName);
    }

    @Override
    public ObvMutualScanUrl computeMutualScanSignedNonceUrl(byte[] bytesRemoteIdentity, byte[] bytesOwnedIdentity, String ownDisplayName) throws Exception {
        Identity contactIdentity = Identity.of(bytesRemoteIdentity);
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            byte[] signature = this.identityManager.signIdentities(engineSession.session, Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{contactIdentity, ownedIdentity}, ownedIdentity, this.prng);
            ObvMutualScanUrl obvMutualScanUrl = new ObvMutualScanUrl(ownedIdentity, ownDisplayName, signature);
            return obvMutualScanUrl;
        }
    }

    @Override
    public boolean verifyMutualScanSignedNonceUrl(byte[] bytesOwnedIdentity, ObvMutualScanUrl mutualScanUrl) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            return Signature.verify(Constants.SignatureContext.MUTUAL_SCAN, new Identity[]{ownedIdentity, mutualScanUrl.identity}, mutualScanUrl.identity, mutualScanUrl.signature);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void startMutualScanTrustEstablishmentProtocol(byte[] bytesOwnedIdentity, byte[] bytesRemoteIdentity, byte[] signature) throws Exception {
        Identity contactIdentity = Identity.of(bytesRemoteIdentity);
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.startMutualScanTrustEstablishmentProtocol(ownedIdentity, contactIdentity, signature);
    }

    @Override
    public void startContactMutualIntroductionProtocol(byte[] bytesOwnedIdentity, byte[] bytesContactIdentityA, byte[][] bytesContactIdentities) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentityA = Identity.of(bytesContactIdentityA);
        Identity[] contactIdentities = new Identity[bytesContactIdentities.length];
        for (int i = 0; i < bytesContactIdentities.length; ++i) {
            contactIdentities[i] = Identity.of(bytesContactIdentities[i]);
            if (!contactIdentityA.equals(contactIdentities[i])) continue;
            throw new Exception();
        }
        this.protocolManager.startContactMutualIntroductionProtocol(ownedIdentity, contactIdentityA, contactIdentities);
    }

    @Override
    public void startGroupCreationProtocol(String serializedGroupDetailsWithVersionAndPhoto, String absolutePhotoUrl, byte[] bytesOwnedIdentity, byte[][] bytesRemoteIdentities) throws Exception {
        if (bytesOwnedIdentity == null || bytesRemoteIdentities == null) {
            throw new Exception();
        }
        HashSet<IdentityWithSerializedDetails> groupMemberIdentitiesAndDisplayNames = new HashSet<IdentityWithSerializedDetails>();
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            for (byte[] bytesRemoteIdentity : bytesRemoteIdentities) {
                Identity remoteIdentity = Identity.of(bytesRemoteIdentity);
                String serializedDetails = this.identityManager.getSerializedPublishedDetailsOfContactIdentity(engineSession.session, ownedIdentity, remoteIdentity);
                groupMemberIdentitiesAndDisplayNames.add(new IdentityWithSerializedDetails(remoteIdentity, serializedDetails));
            }
        }
        this.protocolManager.startGroupCreationProtocol(ownedIdentity, serializedGroupDetailsWithVersionAndPhoto, absolutePhotoUrl, groupMemberIdentitiesAndDisplayNames);
    }

    @Override
    public void startGroupV2CreationProtocol(String serializedGroupDetails, String absolutePhotoUrl, byte[] bytesOwnedIdentity, HashSet<GroupV2.Permission> ownPermissions, HashMap<ObvBytesKey, HashSet<GroupV2.Permission>> otherGroupMembers, String serializedGroupType) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        HashSet<GroupV2.IdentityAndPermissions> otherGroupMembersSet = new HashSet<GroupV2.IdentityAndPermissions>();
        for (Map.Entry<ObvBytesKey, HashSet<GroupV2.Permission>> entry : otherGroupMembers.entrySet()) {
            Identity remoteIdentity = Identity.of(entry.getKey().getBytes());
            otherGroupMembersSet.add(new GroupV2.IdentityAndPermissions(remoteIdentity, entry.getValue()));
        }
        this.protocolManager.startGroupV2CreationProtocol(ownedIdentity, serializedGroupDetails, absolutePhotoUrl, ownPermissions, otherGroupMembersSet, serializedGroupType);
    }

    @Override
    public void restartAllOngoingChannelEstablishmentProtocols(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            UID[] deviceUids = this.identityManager.getDeviceUidsOfContactIdentity(engineSession.session, ownedIdentity, contactIdentity);
            HashSet<UID> confirmedDeviceUids = new HashSet<UID>(Arrays.asList(this.channelManager.getConfirmedObliviousChannelDeviceUids(engineSession.session, ownedIdentity, contactIdentity)));
            for (UID deviceUid : deviceUids) {
                if (confirmedDeviceUids.contains(deviceUid)) continue;
                this.identityManager.removeDeviceForContactIdentity(engineSession.session, ownedIdentity, contactIdentity, deviceUid);
            }
            this.protocolManager.startDeviceDiscoveryProtocolWithinTransaction(engineSession.session, ownedIdentity, contactIdentity);
            engineSession.session.commit();
        }
    }

    @Override
    public void recreateAllChannels(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.channelManager.deleteObliviousChannelsWithContact(engineSession.session, ownedIdentity, contactIdentity);
            this.identityManager.removeAllDevicesForContactIdentity(engineSession.session, ownedIdentity, contactIdentity);
            this.protocolManager.startDeviceDiscoveryProtocolWithinTransaction(engineSession.session, ownedIdentity, contactIdentity);
            engineSession.session.commit();
        }
    }

    @Override
    public void inviteContactsToGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, byte[][] bytesNewMemberIdentities) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        HashSet<Identity> newMembersIdentity = new HashSet<Identity>();
        for (byte[] bytesNewMemberIdentity : bytesNewMemberIdentities) {
            newMembersIdentity.add(Identity.of(bytesNewMemberIdentity));
        }
        this.protocolManager.inviteContactsToGroup(bytesGroupOwnerAndUid, ownedIdentity, newMembersIdentity);
    }

    @Override
    public void removeContactsFromGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, byte[][] bytesRemovedMemberIdentities) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        HashSet<Identity> removedMemberIdentities = new HashSet<Identity>();
        for (byte[] bytesNewMemberIdentity : bytesRemovedMemberIdentities) {
            removedMemberIdentities.add(Identity.of(bytesNewMemberIdentity));
        }
        this.protocolManager.removeContactsFromGroup(bytesGroupOwnerAndUid, ownedIdentity, removedMemberIdentities);
    }

    @Override
    public void reinvitePendingToGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid, byte[] bytesPendingMemberIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity pendingMemberIdentity = Identity.of(bytesPendingMemberIdentity);
        this.protocolManager.reinvitePendingToGroup(bytesGroupOwnerAndUid, ownedIdentity, pendingMemberIdentity);
    }

    @Override
    public void leaveGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.leaveGroup(bytesGroupOwnerAndUid, ownedIdentity);
    }

    @Override
    public void disbandGroup(byte[] bytesOwnedIdentity, byte[] bytesGroupOwnerAndUid) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.disbandGroup(bytesGroupOwnerAndUid, ownedIdentity);
    }

    @Override
    public void deleteContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        this.protocolManager.deleteContact(ownedIdentity, contactIdentity);
    }

    @Override
    public void downgradeOneToOneContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        this.protocolManager.downgradeOneToOneContact(ownedIdentity, contactIdentity);
    }

    @Override
    public void startOneToOneInvitationProtocol(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        this.protocolManager.startOneToOneInvitationProtocol(ownedIdentity, contactIdentity);
    }

    @Override
    public void deleteOwnedIdentityAndNotifyContacts(byte[] bytesOwnedIdentity, boolean deleteEverywhere) throws Exception {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.protocolManager.startOwnedIdentityDeletionProtocol(engineSession.session, ownedIdentity, deleteEverywhere);
            engineSession.session.commit();
        }
    }

    @Override
    public void queryGroupOwnerForLatestGroupMembers(byte[] bytesGroupOwnerAndUid, byte[] bytesOwnedIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.queryGroupMembers(bytesGroupOwnerAndUid, ownedIdentity);
    }

    @Override
    public void addKeycloakContact(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity, String signedContactDetails) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        Identity contactIdentity = Identity.of(bytesContactIdentity);
        this.protocolManager.addKeycloakContact(ownedIdentity, contactIdentity, signedContactDetails);
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnSourceDevice(byte[] bytesOwnedIdentity) throws Exception {
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        this.protocolManager.initiateOwnedIdentityTransferProtocolOnSourceDevice(ownedIdentity);
    }

    @Override
    public void initiateOwnedIdentityTransferProtocolOnTargetDevice(String deviceName) throws Exception {
        this.protocolManager.initiateOwnedIdentityTransferProtocolOnTargetDevice(deviceName);
    }

    @Override
    public byte[] getReturnReceiptNonce() {
        return this.prng.bytes(16);
    }

    @Override
    public byte[] getReturnReceiptKey() {
        AuthEncKey authEncKey = Suite.getDefaultAuthEnc(0).generateKey(this.prng);
        return Encoded.of(authEncKey).getBytes();
    }

    @Override
    public void deleteReturnReceipt(byte[] bytesOwnedIdentity, byte[] serverUid) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.deleteReturnReceipt(ownedIdentity, serverUid);
        }
        catch (DecodingException e) {
            Logger.w("DecodingException while reconstructing the ownedIdentity in deleteReturnReceipt");
            Logger.x(e);
        }
    }

    @Override
    public ObvReturnReceipt decryptReturnReceipt(byte[] returnReceiptKey, byte[] encryptedPayload) {
        try {
            byte[] decryptedPayload;
            AuthEncKey authEncKey = (AuthEncKey)new Encoded(returnReceiptKey).decodeSymmetricKey();
            AuthEnc authEnc = Suite.getAuthEnc(authEncKey);
            if (authEnc != null && (decryptedPayload = authEnc.decrypt(authEncKey, new EncryptedBytes(encryptedPayload))) != null) {
                Encoded[] list = new Encoded(decryptedPayload).decodeList();
                if (list.length == 2) {
                    return new ObvReturnReceipt(list[0].decodeBytes(), (int)list[1].decodeLong());
                }
                if (list.length == 3) {
                    return new ObvReturnReceipt(list[0].decodeBytes(), (int)list[1].decodeLong(), (int)list[2].decodeLong());
                }
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
        return null;
    }

    @Override
    public ObvPostMessageOutput post(byte[] messagePayload, byte[] extendedMessagePayload, ObvOutboundAttachment[] outboundAttachments, List<byte[]> bytesContactIdentities, byte[] bytesOwnedIdentity, boolean hasUserContent, boolean isVoipMessage) {
        HashMap<String, HashSet<Identity>> contactServersHashMap = new HashMap<String, HashSet<Identity>>();
        for (byte[] bytesContactIdentity : bytesContactIdentities) {
            try {
                Identity contactIdentity = Identity.of(bytesContactIdentity);
                HashSet<Identity> list = (HashSet<Identity>)contactServersHashMap.get(contactIdentity.getServer());
                if (list == null) {
                    list = new HashSet<Identity>();
                    contactServersHashMap.put(contactIdentity.getServer(), list);
                }
                list.add(contactIdentity);
            }
            catch (DecodingException e) {
                Logger.x(e);
                Logger.w("Error decoding a bytesContactIdentity while posting a message!");
            }
        }
        HashMap<ObvBytesKey, byte[]> messageIdentifierByContactIdentity = new HashMap<ObvBytesKey, byte[]>();
        boolean messageSent = false;
        for (String server : contactServersHashMap.keySet()) {
            HashSet contactIdentities = (HashSet)contactServersHashMap.get(server);
            if (contactIdentities == null) continue;
            try {
                ChannelApplicationMessageToSend.Attachment[] attachments = new ChannelApplicationMessageToSend.Attachment[outboundAttachments.length];
                for (int i = 0; i < outboundAttachments.length; ++i) {
                    attachments[i] = new ChannelApplicationMessageToSend.Attachment(outboundAttachments[i].getPath(), false, outboundAttachments[i].getAttachmentLength(), outboundAttachments[i].getMetadata());
                }
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                ChannelApplicationMessageToSend message = new ChannelApplicationMessageToSend(contactIdentities.toArray(new Identity[0]), ownedIdentity, messagePayload, extendedMessagePayload, attachments, hasUserContent, isVoipMessage);
                UID messageUid = null;
                try (EngineSession engineSession = this.getSession();){
                    try {
                        engineSession.session.startTransaction();
                        messageUid = this.channelManager.post(engineSession.session, message, this.prng);
                        engineSession.session.commit();
                    }
                    catch (Exception e) {
                        engineSession.session.rollback();
                    }
                }
                if (messageUid != null) {
                    for (Identity contactIdentity : contactIdentities) {
                        messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), messageUid.getBytes());
                    }
                } else {
                    for (Identity contactIdentity : contactIdentities) {
                        messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), null);
                    }
                    continue;
                }
                messageSent = true;
            }
            catch (Exception e) {
                for (Identity contactIdentity : contactIdentities) {
                    messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), null);
                }
                Logger.x(e);
            }
        }
        return new ObvPostMessageOutput(messageSent, messageIdentifierByContactIdentity);
    }

    @Override
    public ObvPostMessageOutput postToSpecificDevices(byte[] messagePayload, List<byte[]> bytesContactIdentities, List<byte[]> bytesContactDeviceUids, byte[] bytesOwnedIdentity, boolean hasUserContent, boolean isVoipMessage) {
        if (bytesContactIdentities.size() != bytesContactDeviceUids.size()) {
            return new ObvPostMessageOutput(false, new HashMap<ObvBytesKey, byte[]>());
        }
        HashMap<String, HashSet<Identity>> contactServersHashMap = new HashMap<String, HashSet<Identity>>();
        HashMap<Identity, UID> contactDeviceUids = new HashMap<Identity, UID>();
        for (int i = 0; i < bytesContactIdentities.size(); ++i) {
            try {
                Identity contactIdentity = Identity.of(bytesContactIdentities.get(i));
                HashSet<Identity> list = (HashSet<Identity>)contactServersHashMap.get(contactIdentity.getServer());
                if (list == null) {
                    list = new HashSet<Identity>();
                    contactServersHashMap.put(contactIdentity.getServer(), list);
                }
                list.add(contactIdentity);
                byte[] bytesContactDeviceUid = bytesContactDeviceUids.get(i);
                if (bytesContactDeviceUid == null) continue;
                contactDeviceUids.put(contactIdentity, new UID(bytesContactDeviceUid));
                continue;
            }
            catch (DecodingException e) {
                Logger.x(e);
                Logger.w("Error decoding a bytesContactIdentity while postingToSpecificDevices a message!");
            }
        }
        HashMap<ObvBytesKey, byte[]> messageIdentifierByContactIdentity = new HashMap<ObvBytesKey, byte[]>();
        boolean messageSent = false;
        for (String server : contactServersHashMap.keySet()) {
            HashSet contactIdentities = (HashSet)contactServersHashMap.get(server);
            if (contactIdentities == null) continue;
            try {
                Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
                Identity[] contactIdentityArray = new Identity[contactIdentities.size()];
                UID[] contactDeviceUidArray = new UID[contactIdentities.size()];
                int i = 0;
                Iterator iterator = contactIdentities.iterator();
                while (iterator.hasNext()) {
                    Identity contactIdentity;
                    contactIdentityArray[i] = contactIdentity = (Identity)iterator.next();
                    contactDeviceUidArray[i] = (UID)contactDeviceUids.get(contactIdentity);
                    ++i;
                }
                ChannelApplicationMessageToSend message = new ChannelApplicationMessageToSend(contactIdentityArray, contactDeviceUidArray, ownedIdentity, messagePayload, null, new ChannelApplicationMessageToSend.Attachment[0], hasUserContent, isVoipMessage);
                UID messageUid = null;
                try (EngineSession engineSession = this.getSession();){
                    try {
                        engineSession.session.startTransaction();
                        messageUid = this.channelManager.post(engineSession.session, message, this.prng);
                        engineSession.session.commit();
                    }
                    catch (Exception e) {
                        engineSession.session.rollback();
                    }
                }
                if (messageUid != null) {
                    for (Identity contactIdentity : contactIdentities) {
                        messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), messageUid.getBytes());
                    }
                } else {
                    for (Identity contactIdentity : contactIdentities) {
                        messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), null);
                    }
                    continue;
                }
                messageSent = true;
            }
            catch (Exception e) {
                for (Identity contactIdentity : contactIdentities) {
                    messageIdentifierByContactIdentity.put(new ObvBytesKey(contactIdentity.getBytes()), null);
                }
                Logger.x(e);
            }
        }
        return new ObvPostMessageOutput(messageSent, messageIdentifierByContactIdentity);
    }

    @Override
    public void sendReturnReceipt(byte[] bytesOwnedIdentity, byte[] bytesContactIdentity, int status, byte[] returnReceiptNonce, byte[] returnReceiptKeyBytes, Integer attachmentNumber) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            Identity contactIdentity = Identity.of(bytesContactIdentity);
            AuthEncKey returnReceiptKey = (AuthEncKey)new Encoded(returnReceiptKeyBytes).decodeSymmetricKey();
            UID[] deviceUids = Arrays.equals(bytesOwnedIdentity, bytesContactIdentity) ? this.identityManager.getOtherDeviceUidsOfOwnedIdentity(engineSession.session, ownedIdentity) : this.identityManager.getDeviceUidsOfContactIdentity(engineSession.session, ownedIdentity, contactIdentity);
            if (deviceUids.length != 0) {
                this.sendManager.sendReturnReceipt(engineSession.session, ownedIdentity, contactIdentity, deviceUids, status, returnReceiptNonce, returnReceiptKey, attachmentNumber);
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public boolean isOutboxAttachmentSent(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier, int engineNumber) {
        boolean bl;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                bl = this.sendManager.isOutboxAttachmentSent(engineSession.session, Identity.of(bytesOwnedIdentity), new UID(engineMessageIdentifier), engineNumber);
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public boolean isOutboxMessageSent(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier) {
        boolean bl;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                bl = this.sendManager.isOutboxMessageSent(engineSession.session, Identity.of(bytesOwnedIdentity), new UID(engineMessageIdentifier));
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public void cancelMessageSending(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier) {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.sendManager.cancelMessageSending(engineSession.session, Identity.of(bytesOwnedIdentity), new UID(engineMessageIdentifier));
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public boolean isInboxAttachmentReceived(byte[] bytesOwnedIdentity, byte[] engineMessageIdentifier, int attachmentNumber) {
        boolean bl;
        block8: {
            EngineSession engineSession = this.getSession();
            try {
                bl = this.fetchManager.isInboxAttachmentReceived(engineSession.session, Identity.of(bytesOwnedIdentity), new UID(engineMessageIdentifier), attachmentNumber);
                if (engineSession == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (engineSession != null) {
                        try {
                            engineSession.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Logger.x(e);
                    return false;
                }
            }
            engineSession.close();
        }
        return bl;
    }

    @Override
    public void downloadMessages(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            UID currentDeviceUid = this.identityManager.getCurrentDeviceUidOfOwnedIdentity(engineSession.session, ownedIdentity);
            this.fetchManager.downloadMessages(ownedIdentity, currentDeviceUid);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void downloadSmallAttachment(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        try {
            this.fetchManager.downloadAttachment(Identity.of(bytesOwnedIdentity), new UID(messageIdentifier), attachmentNumber, 0);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.downloadSmallAttachment");
            Logger.x(e);
        }
    }

    @Override
    public void downloadLargeAttachment(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        try {
            this.fetchManager.downloadAttachment(Identity.of(bytesOwnedIdentity), new UID(messageIdentifier), attachmentNumber, 1);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.downloadLargeAttachment");
            Logger.x(e);
        }
    }

    @Override
    public void pauseAttachmentDownload(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        try {
            this.fetchManager.pauseDownloadAttachment(Identity.of(bytesOwnedIdentity), new UID(messageIdentifier), attachmentNumber);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.pauseAttachmentDownload");
            Logger.x(e);
        }
    }

    @Override
    public void markAttachmentForDeletion(ObvAttachment attachment) {
        this.markAttachmentForDeletion(attachment.getOwnedIdentity(), attachment.getMessageUid(), attachment.getNumber());
    }

    @Override
    public void markAttachmentForDeletion(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        try {
            this.markAttachmentForDeletion(Identity.of(bytesOwnedIdentity), new UID(messageIdentifier), attachmentNumber);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.deleteAttachment");
            Logger.x(e);
        }
    }

    @Override
    public void deleteMessageAndAttachments(byte[] bytesOwnedIdentity, byte[] messageIdentifier) {
        Identity ownedIdentity;
        UID messageUid = new UID(messageIdentifier);
        try {
            ownedIdentity = Identity.of(bytesOwnedIdentity);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.deleteMessage");
            Logger.x(e);
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            this.fetchManager.deleteMessageAndAttachments(engineSession.session, ownedIdentity, messageUid);
            engineSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void markMessageForDeletion(byte[] bytesOwnedIdentity, byte[] messageIdentifier) {
        Identity ownedIdentity;
        UID messageUid = new UID(messageIdentifier);
        try {
            ownedIdentity = Identity.of(bytesOwnedIdentity);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.deleteMessage");
            Logger.x(e);
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            this.fetchManager.deleteMessage(engineSession.session, ownedIdentity, messageUid);
            engineSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void markMessageAsOnHold(byte[] bytesOwnedIdentity, byte[] messageIdentifier) {
        Identity ownedIdentity;
        UID messageUid = new UID(messageIdentifier);
        try {
            ownedIdentity = Identity.of(bytesOwnedIdentity);
        }
        catch (DecodingException e) {
            Logger.e("Error parsing bytesOwnedIdentity in Engine.markMessageAsOnHold");
            Logger.x(e);
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            this.fetchManager.markMessageAsOnHold(engineSession.session, ownedIdentity, messageUid);
            engineSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    private void markAttachmentForDeletion(Identity ownedIdentity, UID messageUid, int attachmentNumber) {
        if (ownedIdentity == null || messageUid == null) {
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            this.fetchManager.deleteAttachment(engineSession.session, ownedIdentity, messageUid, attachmentNumber);
            engineSession.session.commit();
        }
        catch (SQLException e) {
            Logger.x(e);
        }
    }

    @Override
    public void cancelAttachmentUpload(byte[] bytesOwnedIdentity, byte[] messageIdentifier, int attachmentNumber) {
        if (bytesOwnedIdentity == null || messageIdentifier == null) {
            return;
        }
        try (EngineSession engineSession = this.getSession();){
            this.sendManager.cancelAttachmentUpload(engineSession.session, Identity.of(bytesOwnedIdentity), new UID(messageIdentifier), attachmentNumber);
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void resendAllAttachmentNotifications() throws Exception {
        this.fetchManager.resendAllDownloadedAttachmentNotifications();
    }

    @Override
    public void connectWebsocket(boolean relyOnWebsocketForNetworkDetection, String os, String osVersion, int appBuild, String appVersion) {
        this.fetchManager.connectWebsockets(relyOnWebsocketForNetworkDetection, os, osVersion, appBuild, appVersion);
    }

    @Override
    public void disconnectWebsocket() {
        this.fetchManager.disconnectWebsockets();
    }

    @Override
    public void pingWebsocket(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.pingWebsocket(ownedIdentity);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void retryScheduledNetworkTasks() {
        this.fetchManager.retryScheduledNetworkTasks();
        this.sendManager.retryScheduledNetworkTasks();
        this.backupManager.retryScheduledNetworkTasks();
    }

    @Override
    public ObvMessage getOnHoldMessage(byte[] bytesOwnedIdentity, byte[] messageIdentifier) throws Exception {
        UID messageUid = new UID(messageIdentifier);
        Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
        try (EngineSession engineSession = this.getSession();){
            ObvMessage obvMessage = this.fetchManager.getOnHoldMessage(engineSession.session, ownedIdentity, messageUid);
            return obvMessage;
        }
    }

    @Override
    public void initiateBackup(boolean forExport) {
        this.backupManager.initiateBackup(forExport);
    }

    @Override
    public String generateDeviceBackupSeed(String server) {
        try {
            return this.backupManager.generateDeviceBackupSeed(server);
        }
        catch (Exception e) {
            Logger.x(e);
            return null;
        }
    }

    @Override
    public String getDeviceBackupSeed() throws Exception {
        return this.backupManager.getCurrentDeviceBackupSeed();
    }

    @Override
    public void deleteDeviceBackupSeed(String deviceBackupSeed) {
        try {
            BackupSeed backupSeed = new BackupSeed(deviceBackupSeed);
            this.backupManager.deleteDeviceBackupSeed(backupSeed);
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public boolean backupDeviceAndProfilesNow() {
        try {
            return this.backupManager.backupDeviceAndProfilesNow();
        }
        catch (Exception e) {
            Logger.x(e);
            return false;
        }
    }

    @Override
    public void deviceBackupNeeded() {
        this.notificationManager.postNotification("backup_notification_device_backup_needed", Collections.emptyMap());
    }

    @Override
    public void profileBackupNeeded(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.notificationManager.postNotification("backup_notification_profile_backup_needed", Map.of("owned_identity", ownedIdentity));
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public ObvDeviceBackupForRestore fetchDeviceBackup(String server, String deviceBackupSeed) {
        try {
            BackupSeed backupSeed = new BackupSeed(deviceBackupSeed);
            return this.backupManager.fetchDeviceBackup(server, backupSeed);
        }
        catch (Exception e) {
            Logger.x(e);
            return new ObvDeviceBackupForRestore(ObvDeviceBackupForRestore.Status.PERMANENT_ERROR, null, null);
        }
    }

    @Override
    public ObvProfileBackupsForRestore fetchProfileBackups(byte[] bytesIdentity, String profileBackupSeed) {
        try {
            BackupSeed backupSeed = new BackupSeed(profileBackupSeed);
            Identity identity = Identity.of(bytesIdentity);
            return this.backupManager.fetchProfileBackups(identity.getServer(), backupSeed);
        }
        catch (Exception e) {
            Logger.x(e);
            return new ObvProfileBackupsForRestore(ObvProfileBackupsForRestore.Status.PERMANENT_ERROR, null, null);
        }
    }

    @Override
    public boolean deleteProfileBackupSnapshot(byte[] bytesIdentity, String profileBackupSeed, byte[] threadId, long version) {
        try {
            BackupSeed backupSeed = new BackupSeed(profileBackupSeed);
            Identity identity = Identity.of(bytesIdentity);
            UID backupThreadId = new UID(threadId);
            return this.backupManager.deleteProfileBackupSnapshot(identity.getServer(), backupSeed, backupThreadId, version);
        }
        catch (Exception e) {
            Logger.x(e);
            return false;
        }
    }

    @Override
    public byte[] downloadProfilePicture(byte[] bytesIdentity, byte[] photoLabel, byte[] photoKey) throws Exception {
        Identity identity = Identity.of(bytesIdentity);
        UID label = new UID(photoLabel);
        AuthEncKey authEncKey = (AuthEncKey)new Encoded(photoKey).decodeSymmetricKey();
        StandaloneServerQueryOperation standaloneServerQueryOperation = new StandaloneServerQueryOperation(new ServerQuery(null, null, new ServerQuery.BackupsV2DownloadProfilePictureQuery(identity, label, authEncKey)), this.sslSocketFactory);
        OperationQueue queue = new OperationQueue();
        queue.queue(standaloneServerQueryOperation);
        queue.execute(1, "Engine-downloadProfilePicture");
        queue.join();
        if (standaloneServerQueryOperation.isFinished()) {
            return standaloneServerQueryOperation.getServerResponse().decodeBytes();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean restoreProfile(ObvSyncSnapshot snapshot, String deviceName, String serializedKeycloakAuthState) {
        boolean success = false;
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            try {
                ObvBackupAndSyncDelegate wrappedIdentityDelegate = this.identityManager.getSyncDelegateWithinTransaction(engineSession.session);
                ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback> commitCallbackList = new ArrayList<ObvBackupAndSyncDelegate.RestoreFinishedCallback>();
                engineSession.session.addSessionCommitListener(() -> {
                    for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : commitCallbackList) {
                        callback.onRestoreSuccess();
                    }
                });
                try {
                    List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacks;
                    ObvIdentity obvOwnedIdentity;
                    ObvSyncSnapshotNode node = snapshot.getSnapshotNode(wrappedIdentityDelegate.getTag());
                    if (node instanceof IdentityManagerSyncSnapshot) {
                        obvOwnedIdentity = this.identityManager.restoreTransferredOwnedIdentity(engineSession.session, deviceName, (IdentityManagerSyncSnapshot)node);
                        if (serializedKeycloakAuthState != null) {
                            this.identityManager.saveKeycloakAuthState(engineSession.session, obvOwnedIdentity.getIdentity(), serializedKeycloakAuthState);
                        }
                    } else {
                        throw new Exception();
                    }
                    List<ObvBackupAndSyncDelegate.RestoreFinishedCallback> callbacksOwnedIdentity = snapshot.restoreOwnedIdentity(obvOwnedIdentity, wrappedIdentityDelegate, this.appBackupAndSyncDelegate);
                    if (callbacksOwnedIdentity != null && !callbacksOwnedIdentity.isEmpty()) {
                        commitCallbackList.addAll(callbacksOwnedIdentity);
                    }
                    if ((callbacks = snapshot.restore(wrappedIdentityDelegate, this.appBackupAndSyncDelegate)) != null && !callbacks.isEmpty()) {
                        commitCallbackList.addAll(callbacks);
                    }
                }
                catch (Exception e) {
                    for (ObvBackupAndSyncDelegate.RestoreFinishedCallback callback : commitCallbackList) {
                        callback.onRestoreFailure();
                    }
                    throw e;
                }
                try {
                    this.identityManager.downloadAllUserData(engineSession.session);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                engineSession.session.addSessionCommitListener(() -> this.notificationManager.postNotification("protocol_manager_notification_snapshot_restoration_finished", Collections.emptyMap()));
                success = true;
            }
            catch (Exception e) {
                Logger.x(e);
            }
            finally {
                if (success) {
                    engineSession.session.commit();
                } else {
                    engineSession.session.rollback();
                }
            }
        }
        catch (SQLException e) {
            Logger.x(e);
        }
        return success;
    }

    @Override
    public ObvBackupKeyInformation getBackupKeyInformation() throws Exception {
        return this.backupManager.getBackupKeyInformation();
    }

    @Override
    public void stopLegacyBackups() {
        this.backupManager.stopLegacyBackups();
    }

    @Override
    public void setAutoBackupEnabled(boolean enabled, boolean initiateBackupNowIfNeeded) {
        this.backupManager.setAutoBackupEnabled(enabled, initiateBackupNowIfNeeded);
    }

    @Override
    public void markBackupExported(byte[] backupKeyUid, int version) {
        this.backupManager.markBackupExported(new UID(backupKeyUid), version);
    }

    @Override
    public void markBackupUploaded(byte[] backupKeyUid, int version) {
        this.backupManager.markBackupUploaded(new UID(backupKeyUid), version);
    }

    @Override
    public void discardBackup(byte[] backupKeyUid, int version) {
        this.backupManager.discardBackup(new UID(backupKeyUid), version);
    }

    @Override
    public ObvBackupKeyVerificationOutput validateBackupSeed(String backupSeedString, byte[] backupContent) {
        int status = this.backupManager.validateBackupSeed(backupSeedString, backupContent);
        switch (status) {
            case 0: {
                return new ObvBackupKeyVerificationOutput(0);
            }
            case 1: {
                return new ObvBackupKeyVerificationOutput(1);
            }
            case 2: {
                return new ObvBackupKeyVerificationOutput(2);
            }
        }
        return new ObvBackupKeyVerificationOutput(3);
    }

    @Override
    public ObvIdentity[] restoreOwnedIdentitiesFromBackup(String backupSeed, byte[] backupContent, String deviceDisplayName) {
        return this.backupManager.restoreOwnedIdentitiesFromBackup(backupSeed, backupContent, deviceDisplayName);
    }

    @Override
    public void restoreContactsAndGroupsFromBackup(String backupSeed, byte[] backupContent, ObvIdentity[] restoredOwnedIdentities) {
        this.backupManager.restoreContactsAndGroupsFromBackup(backupSeed, backupContent, restoredOwnedIdentities);
    }

    @Override
    public String decryptAppDataBackup(String backupSeed, byte[] backupContent) {
        return this.backupManager.decryptAppDataBackup(backupSeed, backupContent);
    }

    @Override
    public void appBackupSuccess(byte[] bytesBackupKeyUid, int version, String appBackupContent) {
        this.backupManager.backupSuccess("app", new UID(bytesBackupKeyUid), version, appBackupContent);
    }

    @Override
    public void appBackupFailed(byte[] bytesBackupKeyUid, int version) {
        this.backupManager.backupFailed("app", new UID(bytesBackupKeyUid), version);
    }

    @Override
    public void getTurnCredentials(byte[] bytesOwnedIdentity, UUID callUuid, String callerUsername, String recipientUsername) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.getTurnCredentials(ownedIdentity, callUuid, callerUsername, recipientUsername);
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
    }

    @Override
    public void queryApiKeyStatus(byte[] bytesOwnedIdentity, UUID apiKey) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.queryApiKeyStatus(ownedIdentity, apiKey);
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
    }

    @Override
    public void queryApiKeyStatus(String server, UUID apiKey) {
        EncryptionEciesMDCKeyPair anonAuthKeyPair = EncryptionEciesMDCKeyPair.generate(this.prng);
        ServerAuthenticationECSdsaMDCKeyPair serverAuthKeyPair = ServerAuthenticationECSdsaMDCKeyPair.generate(this.prng);
        if (anonAuthKeyPair != null && serverAuthKeyPair != null) {
            Identity dummyIdentity = new Identity(server, serverAuthKeyPair.getPublicKey(), anonAuthKeyPair.getPublicKey());
            this.fetchManager.queryApiKeyStatus(dummyIdentity, apiKey);
        }
    }

    @Override
    public void queryFreeTrial(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            this.fetchManager.queryFreeTrial(ownedIdentity);
        }
        catch (DecodingException e) {
            Logger.x(e);
        }
    }

    @Override
    public void startFreeTrial(byte[] bytesOwnedIdentity) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            if (!this.identityManager.isOwnedIdentityKeycloakManaged(engineSession.session, ownedIdentity)) {
                this.fetchManager.startFreeTrial(ownedIdentity);
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void verifyReceipt(byte[] bytesOwnedIdentity, String storeToken) {
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            if (!this.identityManager.isOwnedIdentityKeycloakManaged(engineSession.session, ownedIdentity)) {
                this.fetchManager.verifyReceipt(ownedIdentity, storeToken);
            }
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void queryServerWellKnown(String server) {
        this.fetchManager.queryServerWellKnown(server);
    }

    @Override
    public List<JsonOsmStyle> getOsmStyles(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            return this.fetchManager.getOsmStyles(ownedIdentity.getServer());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public String getAddressServerUrl(byte[] bytesOwnedIdentity) {
        try {
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            return this.fetchManager.getAddressServerUrl(ownedIdentity.getServer());
        }
        catch (Exception ignored) {
            return null;
        }
    }

    @Override
    public void propagateAppSyncAtomToAllOwnedIdentitiesOtherDevicesIfNeeded(ObvSyncAtom obvSyncAtom) throws Exception {
        if (!obvSyncAtom.isAppSyncItem()) {
            throw new Exception();
        }
        try (EngineSession engineSession = this.getSession();){
            for (Identity ownedIdentity : this.identityManager.getOwnedIdentities(engineSession.session)) {
                if (this.identityManager.getOtherDeviceUidsOfOwnedIdentity(engineSession.session, ownedIdentity).length <= 0) continue;
                this.protocolManager.initiateSingleItemSync(engineSession.session, ownedIdentity, obvSyncAtom);
            }
            engineSession.session.commit();
        }
    }

    @Override
    public void propagateAppSyncAtomToOtherDevicesIfNeeded(byte[] bytesOwnedIdentity, ObvSyncAtom obvSyncAtom) throws Exception {
        if (!obvSyncAtom.isAppSyncItem()) {
            throw new Exception();
        }
        try (EngineSession engineSession = this.getSession();){
            Identity ownedIdentity = Identity.of(bytesOwnedIdentity);
            if (this.identityManager.getOtherDeviceUidsOfOwnedIdentity(engineSession.session, ownedIdentity).length > 0) {
                this.protocolManager.initiateSingleItemSync(engineSession.session, ownedIdentity, obvSyncAtom);
                engineSession.session.commit();
            }
        }
    }

    private boolean propagateEngineSyncAtomToOtherDevicesIfNeeded(Session session, Identity ownedIdentity, ObvSyncAtom obvSyncAtom) throws Exception {
        if (obvSyncAtom.isAppSyncItem()) {
            throw new Exception();
        }
        if (this.identityManager.getOtherDeviceUidsOfOwnedIdentity(session, ownedIdentity).length > 0) {
            this.protocolManager.initiateSingleItemSync(session, ownedIdentity, obvSyncAtom);
            return true;
        }
        return false;
    }

    @Override
    public void downloadAllUserData() throws Exception {
        try (EngineSession engineSession = this.getSession();){
            engineSession.session.startTransaction();
            this.identityManager.downloadAllUserData(engineSession.session);
            engineSession.session.commit();
        }
    }

    @Override
    public void setAllOwnedDeviceNames(String deviceName) {
        try (EngineSession engineSession = this.getSession();){
            for (Identity ownedIdentity : this.identityManager.getOwnedIdentities(engineSession.session)) {
                UID currentDeviceUid = this.identityManager.getCurrentDeviceUidOfOwnedIdentity(engineSession.session, ownedIdentity);
                this.protocolManager.processDeviceManagementRequest(engineSession.session, ownedIdentity, ObvDeviceManagementRequest.createSetNicknameRequest(currentDeviceUid.getBytes(), deviceName));
            }
            engineSession.session.commit();
        }
        catch (Exception e) {
            Logger.x(e);
        }
    }

    @Override
    public void vacuumDatabase() throws Exception {
        try (EngineSession engineSession = this.getSession();
             Statement statement = engineSession.session.createStatement("Engine.vacuumDatabase");){
            statement.execute("VACUUM");
            statement.execute("PRAGMA wal_checkpoint(TRUNCATE)");
            engineSession.session.commit();
        }
    }

    private class NotificationWorker {
        public static final String SYNCHRONIZED_TASK = "synchronized_task";
        private boolean started = false;
        private Thread thread = null;

        private NotificationWorker() {
        }

        public synchronized void start() {
            if (this.started) {
                return;
            }
            this.started = true;
            this.thread = new Thread(() -> {
                while (this.started) {
                    EngineNotification engineNotification = null;
                    try {
                        engineNotification = Engine.this.notificationQueue.take();
                    }
                    catch (InterruptedException e) {
                        Logger.x(e);
                    }
                    if (engineNotification == null) continue;
                    Logger.d("Queue Size ---> " + Engine.this.notificationQueue.size());
                    if (engineNotification.notificationName.equals(SYNCHRONIZED_TASK)) {
                        try {
                            Object task = engineNotification.userInfo.get(SYNCHRONIZED_TASK);
                            if (!(task instanceof Runnable)) continue;
                            ((Runnable)task).run();
                        }
                        catch (Exception e) {
                            Logger.e("Exception while running App task on engine notification queue");
                            Logger.x(e);
                        }
                        continue;
                    }
                    Engine.this.listenersLock.lock();
                    HashMap<Long, ListenerAndPriority> notificationObservers = Engine.this.listeners.get(engineNotification.notificationName);
                    if (notificationObservers != null) {
                        notificationObservers = new HashMap<Long, ListenerAndPriority>(notificationObservers);
                        Engine.this.listenersLock.unlock();
                        if (notificationObservers.size() < 2) {
                            for (Map.Entry<Long, ListenerAndPriority> entry : notificationObservers.entrySet()) {
                                EngineNotificationListener listener = (EngineNotificationListener)entry.getValue().listener.get();
                                if (listener == null) {
                                    Engine.this.removeNotificationListener(engineNotification.notificationName, entry.getKey());
                                    continue;
                                }
                                try {
                                    listener.callback(engineNotification.notificationName, engineNotification.userInfo);
                                }
                                catch (Exception e) {
                                    Logger.x(e);
                                }
                            }
                            continue;
                        }
                        for (EngineAPI.ListenerPriority priority : new EngineAPI.ListenerPriority[]{EngineAPI.ListenerPriority.HIGH, EngineAPI.ListenerPriority.NORMAL, EngineAPI.ListenerPriority.LOW}) {
                            for (Map.Entry<Long, ListenerAndPriority> entry : notificationObservers.entrySet()) {
                                if (entry.getValue().priority != priority) continue;
                                EngineNotificationListener listener = (EngineNotificationListener)entry.getValue().listener.get();
                                if (listener == null) {
                                    Engine.this.removeNotificationListener(engineNotification.notificationName, entry.getKey());
                                    continue;
                                }
                                try {
                                    listener.callback(engineNotification.notificationName, engineNotification.userInfo);
                                }
                                catch (Exception e) {
                                    Logger.x(e);
                                }
                            }
                        }
                        continue;
                    }
                    Engine.this.listenersLock.unlock();
                }
            });
            this.thread.setName("Engine-EngineNotificationPosting");
            this.thread.start();
        }

        public synchronized void stop() {
            if (!this.started) {
                return;
            }
            this.started = false;
            if (this.thread != null) {
                this.thread.interrupt();
                this.thread = null;
            }
        }
    }

    private static class ListenerAndPriority {
        public final WeakReference<EngineNotificationListener> listener;
        public final EngineAPI.ListenerPriority priority;

        public ListenerAndPriority(WeakReference<EngineNotificationListener> listener, EngineAPI.ListenerPriority priority) {
            this.listener = listener;
            this.priority = priority;
        }
    }

    private static class EngineNotification {
        public final String notificationName;
        public final HashMap<String, Object> userInfo;

        EngineNotification(String notificationName, HashMap<String, Object> userInfo) {
            this.notificationName = notificationName;
            this.userInfo = userInfo;
        }
    }
}

