/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.symmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.CryptographicKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.datatypes.key.symmetric.MACKey;
import io.olvid.engine.datatypes.key.symmetric.SymEncKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class SymmetricKey
extends CryptographicKey {
    public SymmetricKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static SymmetricKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 2: {
                return AuthEncKey.of(algorithmImplementation, key);
            }
            case 1: {
                return MACKey.of(algorithmImplementation, key);
            }
            case 0: {
                return SymEncKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

