/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.symmetric;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.datatypes.key.symmetric.MACHmacSha256Key;
import io.olvid.engine.datatypes.key.symmetric.SymEncCTRAES256Key;
import io.olvid.engine.encoder.Encoded;
import java.util.Arrays;
import java.util.HashMap;

public class AuthEncAES256ThenSHA256Key
extends AuthEncKey {
    private final MACHmacSha256Key macKey;
    private final SymEncCTRAES256Key encKey;

    public AuthEncAES256ThenSHA256Key(HashMap<DictionaryKey, Encoded> key) {
        super((byte)0, key);
        this.macKey = new MACHmacSha256Key(key);
        this.encKey = new SymEncCTRAES256Key(key);
    }

    public static AuthEncAES256ThenSHA256Key of(byte[] macKey, byte[] encKey) {
        HashMap<DictionaryKey, Encoded> key = new HashMap<DictionaryKey, Encoded>();
        key.put(new DictionaryKey("mackey"), Encoded.of(macKey));
        key.put(new DictionaryKey("enckey"), Encoded.of(encKey));
        return new AuthEncAES256ThenSHA256Key(key);
    }

    public static AuthEncAES256ThenSHA256Key generate(PRNG prng) {
        byte[] bytes = prng.bytes(64);
        return AuthEncAES256ThenSHA256Key.of(Arrays.copyOfRange(bytes, 0, 32), Arrays.copyOfRange(bytes, 32, 64));
    }

    public MACHmacSha256Key getMacKey() {
        return this.macKey;
    }

    public SymEncCTRAES256Key getEncKey() {
        return this.encKey;
    }

    public String toString() {
        return Logger.toHexString(this.macKey.getKeyBytes()) + " - " + Logger.toHexString(this.encKey.getKeyBytes());
    }
}

