/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaMDCPublicKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class SignaturePublicKey
extends PublicKey {
    public static final byte ALGO_IMPL_EC_SDSA_MDC = 0;
    public static final byte ALGO_IMPL_EC_SDSA_CURVE25519 = 1;

    public SignaturePublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super((byte)17, algorithmImplementation, key);
    }

    public static SignaturePublicKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new SignatureECSdsaMDCPublicKey(key);
            }
            case 1: {
                return new SignatureECSdsaCurve25519PublicKey(key);
            }
        }
        return null;
    }

    protected EdwardCurve getCurve() {
        switch (this.algorithmImplementation) {
            case 0: {
                return Suite.getCurve("MDC");
            }
            case 1: {
                return Suite.getCurve("Curve_25519");
            }
        }
        return null;
    }
}

