/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class SignatureECSdsaPublicKey
extends SignaturePublicKey {
    public static final String PUBLIC_X_COORD_KEY_NAME = "x";
    public static final String PUBLIC_Y_COORD_KEY_NAME = "y";
    private final BigInteger Ax;
    private final BigInteger Ay;

    public SignatureECSdsaPublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super(algorithmImplementation, key);
        try {
            this.Ay = key.get(new DictionaryKey(PUBLIC_Y_COORD_KEY_NAME)).decodeBigUInt();
            DictionaryKey xKey = new DictionaryKey(PUBLIC_X_COORD_KEY_NAME);
            this.Ax = key.containsKey(xKey) ? key.get(xKey).decodeBigUInt() : null;
        }
        catch (DecodingException e) {
            throw new InvalidParameterException();
        }
    }

    public BigInteger getAx() {
        return this.Ax;
    }

    public BigInteger getAy() {
        return this.Ay;
    }
}

