/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaCurve25519PrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePrivateKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class ServerAuthenticationPrivateKey
extends PrivateKey {
    public ServerAuthenticationPrivateKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super((byte)20, algorithmImplementation, key);
    }

    public static ServerAuthenticationPrivateKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new ServerAuthenticationECSdsaMDCPrivateKey(key);
            }
            case 1: {
                return new ServerAuthenticationECSdsaCurve25519PrivateKey(key);
            }
        }
        return null;
    }

    public SignaturePrivateKey getSignaturePrivateKey() throws Exception {
        switch (this.algorithmImplementation) {
            case 0: 
            case 1: {
                return ((ServerAuthenticationECSdsaPrivateKey)this).getSignaturePrivateKey();
            }
        }
        throw new Exception("This server authentication private key does not implement signature");
    }
}

