/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaMDCPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class ServerAuthenticationECSdsaMDCPublicKey
extends ServerAuthenticationECSdsaPublicKey {
    public static final int COMPACT_KEY_LENGTH = 1 + Suite.getCurve((String)"MDC").byteLength;

    public ServerAuthenticationECSdsaMDCPublicKey(HashMap<DictionaryKey, Encoded> key) {
        super((byte)0, key, new SignatureECSdsaMDCPublicKey(key));
    }

    public static ServerAuthenticationECSdsaMDCPublicKey of(byte[] compactKeyBytes) throws DecodingException {
        if (compactKeyBytes[0] != 0 || compactKeyBytes.length != COMPACT_KEY_LENGTH) {
            throw new DecodingException();
        }
        HashMap<DictionaryKey, Encoded> key = new HashMap<DictionaryKey, Encoded>();
        try {
            key.put(new DictionaryKey("y"), Encoded.of(Encoded.bigUIntFromBytes(Arrays.copyOfRange(compactKeyBytes, 1, compactKeyBytes.length)), COMPACT_KEY_LENGTH - 1));
        }
        catch (EncodingException e) {
            throw new DecodingException();
        }
        return new ServerAuthenticationECSdsaMDCPublicKey(key);
    }
}

