/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.EdwardCurvePoint;
import io.olvid.engine.datatypes.key.asymmetric.KeyPair;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPrivateKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaMDCPublicKey;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;
import java.util.HashMap;

public class ServerAuthenticationECSdsaMDCKeyPair
extends KeyPair {
    @Override
    public ServerAuthenticationECSdsaMDCPublicKey getPublicKey() {
        return (ServerAuthenticationECSdsaMDCPublicKey)this.publicKey;
    }

    @Override
    public ServerAuthenticationECSdsaMDCPrivateKey getPrivateKey() {
        return (ServerAuthenticationECSdsaMDCPrivateKey)this.privateKey;
    }

    public ServerAuthenticationECSdsaMDCKeyPair(ServerAuthenticationECSdsaMDCPublicKey publicKey, ServerAuthenticationECSdsaMDCPrivateKey privateKey) {
        super(publicKey, privateKey);
    }

    public static ServerAuthenticationECSdsaMDCKeyPair generate(PRNGService prng) {
        EdwardCurvePoint A;
        BigInteger a;
        EdwardCurve mdc = Suite.getCurve("MDC");
        while ((a = prng.bigInt(mdc.q)).equals(BigInteger.ZERO) || a.equals(BigInteger.ONE) || (A = mdc.scalarMultiplicationWithX(a, mdc.G)).isLowOrderPoint()) {
        }
        HashMap<DictionaryKey, Encoded> publicKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        HashMap<DictionaryKey, Encoded> privateKeyDictionary = new HashMap<DictionaryKey, Encoded>();
        try {
            publicKeyDictionary.put(new DictionaryKey("x"), Encoded.of(A.getX(), mdc.byteLength));
            publicKeyDictionary.put(new DictionaryKey("y"), Encoded.of(A.getY(), mdc.byteLength));
            privateKeyDictionary.put(new DictionaryKey("n"), Encoded.of(a, mdc.byteLength));
        }
        catch (EncodingException e) {
            return null;
        }
        return new ServerAuthenticationECSdsaMDCKeyPair(new ServerAuthenticationECSdsaMDCPublicKey(publicKeyDictionary), new ServerAuthenticationECSdsaMDCPrivateKey(privateKeyDictionary));
    }

    public static boolean areKeysMatching(ServerAuthenticationECSdsaMDCPublicKey publicKey, ServerAuthenticationECSdsaMDCPrivateKey privateKey) {
        EdwardCurve mdc = Suite.getCurve("MDC");
        EdwardCurvePoint A = mdc.scalarMultiplicationWithX(privateKey.getSignaturePrivateKey().getA(), mdc.G);
        return A.getY().equals(publicKey.getSignaturePublicKey().getAy());
    }
}

