/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationECSdsaPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignatureECSdsaCurve25519PublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.util.Arrays;
import java.util.HashMap;

public class ServerAuthenticationECSdsaCurve25519PublicKey
extends ServerAuthenticationECSdsaPublicKey {
    public static final int COMPACT_KEY_LENGTH = 1 + Suite.getCurve((String)"Curve_25519").byteLength;

    public ServerAuthenticationECSdsaCurve25519PublicKey(HashMap<DictionaryKey, Encoded> key) {
        super((byte)1, key, new SignatureECSdsaCurve25519PublicKey(key));
    }

    public static ServerAuthenticationECSdsaCurve25519PublicKey of(byte[] compactKeyBytes) throws DecodingException {
        if (compactKeyBytes[0] != 1 || compactKeyBytes.length != COMPACT_KEY_LENGTH) {
            throw new DecodingException();
        }
        HashMap<DictionaryKey, Encoded> key = new HashMap<DictionaryKey, Encoded>();
        try {
            key.put(new DictionaryKey("y"), Encoded.of(Encoded.bigUIntFromBytes(Arrays.copyOfRange(compactKeyBytes, 1, compactKeyBytes.length)), COMPACT_KEY_LENGTH - 1));
        }
        catch (EncodingException e) {
            throw new DecodingException();
        }
        return new ServerAuthenticationECSdsaCurve25519PublicKey(key);
    }
}

