/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.CryptographicKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.SignaturePublicKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class PublicKey
extends CryptographicKey {
    public PublicKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        super(algorithmClass, algorithmImplementation, key);
    }

    public static PublicKey of(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmClass) {
            case 18: {
                return EncryptionPublicKey.of(algorithmImplementation, key);
            }
            case 17: {
                return SignaturePublicKey.of(algorithmImplementation, key);
            }
            case 20: {
                return ServerAuthenticationPublicKey.of(algorithmImplementation, key);
            }
        }
        return null;
    }
}

