/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.crypto.EdwardCurve;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesCurve25519PublicKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionEciesMDCPublicKey;
import io.olvid.engine.datatypes.key.asymmetric.PublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class EncryptionPublicKey
extends PublicKey {
    public static final byte ALGO_IMPL_KEM_ECIES_MDC_AND_DEM_CTR_AES256_THEN_HMAC_SHA256 = 0;
    public static final byte ALGO_IMPL_KEM_ECIES_CURVE25519_AND_DEM_CTR_AES256_THEN_HMAC_SHA256 = 1;

    public EncryptionPublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super((byte)18, algorithmImplementation, key);
    }

    public static EncryptionPublicKey of(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        switch (algorithmImplementation) {
            case 0: {
                return new EncryptionEciesMDCPublicKey(key);
            }
            case 1: {
                return new EncryptionEciesCurve25519PublicKey(key);
            }
        }
        return null;
    }

    public static int getCompactKeyLength(byte algorithmImplementation) {
        switch (algorithmImplementation) {
            case 0: {
                return EncryptionEciesMDCPublicKey.COMPACT_KEY_LENGTH;
            }
            case 1: {
                return EncryptionEciesCurve25519PublicKey.COMPACT_KEY_LENGTH;
            }
        }
        return -1;
    }

    public int getCompactKeyLength() {
        return EncryptionPublicKey.getCompactKeyLength(this.algorithmImplementation);
    }

    public static EncryptionPublicKey of(byte[] compactKeyBytes) throws DecodingException {
        switch (compactKeyBytes[0]) {
            case 0: {
                return EncryptionEciesMDCPublicKey.of(compactKeyBytes);
            }
            case 1: {
                return EncryptionEciesCurve25519PublicKey.of(compactKeyBytes);
            }
        }
        throw new DecodingException();
    }

    protected EdwardCurve getCurve() {
        switch (this.algorithmImplementation) {
            case 0: {
                return Suite.getCurve("MDC");
            }
            case 1: {
                return Suite.getCurve("Curve_25519");
            }
        }
        return null;
    }

    public abstract byte[] getCompactKey();
}

