/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPublicKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.encoder.EncodingException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class EncryptionEciesPublicKey
extends EncryptionPublicKey {
    public static final String PUBLIC_X_COORD_KEY_NAME = "x";
    public static final String PUBLIC_Y_COORD_KEY_NAME = "y";
    private final BigInteger Ax;
    private final BigInteger Ay;

    public EncryptionEciesPublicKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super(algorithmImplementation, key);
        try {
            this.Ay = key.get(new DictionaryKey(PUBLIC_Y_COORD_KEY_NAME)).decodeBigUInt();
            DictionaryKey xKey = new DictionaryKey(PUBLIC_X_COORD_KEY_NAME);
            this.Ax = key.containsKey(xKey) ? key.get(xKey).decodeBigUInt() : null;
        }
        catch (DecodingException e) {
            throw new InvalidParameterException();
        }
    }

    public BigInteger getAy() {
        return this.Ay;
    }

    public BigInteger getAx() {
        return this.Ax;
    }

    @Override
    public byte[] getCompactKey() {
        byte[] compactKey = new byte[this.getCompactKeyLength()];
        compactKey[0] = this.algorithmImplementation;
        try {
            byte[] yBytes = Encoded.bytesFromBigUInt(((Encoded)this.key.get(new DictionaryKey(PUBLIC_Y_COORD_KEY_NAME))).decodeBigUInt(), compactKey.length - 1);
            System.arraycopy(yBytes, 0, compactKey, 1, yBytes.length);
        }
        catch (DecodingException | EncodingException exception) {
            // empty catch block
        }
        return compactKey;
    }
}

