/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key.asymmetric;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.key.asymmetric.EncryptionPrivateKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.util.HashMap;

public abstract class EncryptionEciesPrivateKey
extends EncryptionPrivateKey {
    public static final String SECRET_EXPONENT_KEY_NAME = "n";
    private final BigInteger a;

    public EncryptionEciesPrivateKey(byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) throws InvalidParameterException {
        super(algorithmImplementation, key);
        try {
            this.a = key.get(new DictionaryKey(SECRET_EXPONENT_KEY_NAME)).decodeBigUInt();
        }
        catch (DecodingException e) {
            throw new InvalidParameterException();
        }
    }

    public BigInteger getA() {
        return this.a;
    }
}

