/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.key;

import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.encoder.Encoded;
import java.util.HashMap;

public abstract class CryptographicKey {
    public static final byte ALGO_CLASS_SYMMETRIC_ENCRYPTION = 0;
    public static final byte ALGO_CLASS_MAC = 1;
    public static final byte ALGO_CLASS_AUTHENTICATED_SYMMETRIC_ENCRYPTION = 2;
    public static final byte ALGO_CLASS_SIGNATURE = 17;
    public static final byte ALGO_CLASS_PUBLIC_KEY_ENCRYPTION = 18;
    public static final byte ALGO_CLASS_SERVER_AUTHENTICATION = 20;
    protected final byte algorithmClass;
    protected final byte algorithmImplementation;
    protected final HashMap<DictionaryKey, Encoded> key;

    protected CryptographicKey(byte algorithmClass, byte algorithmImplementation, HashMap<DictionaryKey, Encoded> key) {
        this.algorithmClass = algorithmClass;
        this.algorithmImplementation = algorithmImplementation;
        this.key = key;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CryptographicKey)) {
            return false;
        }
        CryptographicKey other = (CryptographicKey)o;
        if (other.getAlgorithmClass() != this.algorithmClass || other.getAlgorithmImplementation() != this.algorithmImplementation) {
            return false;
        }
        return this.key.equals(other.getKey());
    }

    public int hashCode() {
        return this.key.hashCode() + 31 * this.algorithmClass + 631 * this.algorithmImplementation;
    }

    public byte getAlgorithmClass() {
        return this.algorithmClass;
    }

    public byte getAlgorithmImplementation() {
        return this.algorithmImplementation;
    }

    public HashMap<DictionaryKey, Encoded> getKey() {
        return this.key;
    }
}

