/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.containers.GroupV2;
import java.util.Objects;

public class TrustOrigin {
    private final TYPE type;
    private final long timestamp;
    private final Identity mediatorOrGroupOwnerIdentity;
    private final String keycloakServer;
    private final GroupV2.Identifier groupIdentifier;

    public TYPE getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Identity getMediatorOrGroupOwnerIdentity() {
        return this.mediatorOrGroupOwnerIdentity;
    }

    public String getKeycloakServer() {
        return this.keycloakServer;
    }

    public GroupV2.Identifier getGroupIdentifier() {
        return this.groupIdentifier;
    }

    public TrustOrigin(TYPE type, long timestamp, Identity mediatorOrGroupOwnerIdentity, String keycloakServer, GroupV2.Identifier groupIdentifier) {
        this.type = type;
        this.timestamp = timestamp;
        this.mediatorOrGroupOwnerIdentity = mediatorOrGroupOwnerIdentity;
        this.keycloakServer = keycloakServer;
        this.groupIdentifier = groupIdentifier;
    }

    public static TrustOrigin createDirectTrustOrigin(long timestamp) {
        return new TrustOrigin(TYPE.DIRECT, timestamp, null, null, null);
    }

    public static TrustOrigin createIntroductionTrustOrigin(long timestamp, Identity mediatorIdentity) {
        return new TrustOrigin(TYPE.INTRODUCTION, timestamp, mediatorIdentity, null, null);
    }

    public static TrustOrigin createGroupTrustOrigin(long timestamp, Identity groupOwner) {
        return new TrustOrigin(TYPE.GROUP, timestamp, groupOwner, null, null);
    }

    public static TrustOrigin createKeycloakTrustOrigin(long timestamp, String keycloakServer) {
        return new TrustOrigin(TYPE.KEYCLOAK, timestamp, null, keycloakServer, null);
    }

    public static TrustOrigin createServerGroupV2TrustOrigin(long timestamp, GroupV2.Identifier groupIdentifier) {
        return new TrustOrigin(TYPE.SERVER_GROUP_V2, timestamp, null, null, groupIdentifier);
    }

    public boolean equals(Object other) {
        if (!(other instanceof TrustOrigin)) {
            return false;
        }
        TrustOrigin castedOther = (TrustOrigin)other;
        if (castedOther.type != this.type) {
            return false;
        }
        switch (this.type.ordinal()) {
            case 1: 
            case 2: {
                return Objects.equals(castedOther.mediatorOrGroupOwnerIdentity, this.mediatorOrGroupOwnerIdentity);
            }
            case 3: {
                return Objects.equals(castedOther.keycloakServer, this.keycloakServer);
            }
            case 4: {
                return Objects.equals(castedOther.groupIdentifier, this.groupIdentifier);
            }
        }
        return true;
    }

    public static enum TYPE {
        DIRECT,
        INTRODUCTION,
        GROUP,
        KEYCLOAK,
        SERVER_GROUP_V2;

    }
}

