/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

public class ReceptionChannelInfo {
    public static final int LOCAL_TYPE = 0;
    public static final int OBLIVIOUS_CHANNEL_TYPE = 1;
    public static final int ASYMMETRIC_CHANNEL_TYPE = 2;
    public static final int PRE_KEY_CHANNEL_TYPE = 5;
    public static final int ANY_OBLIVIOUS_CHANNEL_OR_PRE_KEY_WITH_OWNED_DEVICE_TYPE = 3;
    public static final int ANY_OBLIVIOUS_OR_PRE_KEY_CHANNEL_TYPE = 4;
    public static final int ANY_OBLIVIOUS_CHANNEL_TYPE = 6;
    private final int channelType;
    private final UID remoteDeviceUid;
    private final Identity remoteIdentity;

    private ReceptionChannelInfo(int channelType) {
        this(channelType, null, null);
    }

    private ReceptionChannelInfo(int channelType, UID remoteDeviceUid, Identity remoteIdentity) {
        this.channelType = channelType;
        this.remoteDeviceUid = remoteDeviceUid;
        this.remoteIdentity = remoteIdentity;
    }

    public static ReceptionChannelInfo createLocalChannelInfo() {
        return new ReceptionChannelInfo(0);
    }

    public static ReceptionChannelInfo createObliviousChannelInfo(UID remoteDeviceUid, Identity remoteIdentity) {
        return new ReceptionChannelInfo(1, remoteDeviceUid, remoteIdentity);
    }

    public static ReceptionChannelInfo createAsymmetricChannelInfo() {
        return new ReceptionChannelInfo(2);
    }

    public static ReceptionChannelInfo createPreKeyChannelInfo(UID remoteDeviceUid, Identity remoteIdentity) {
        return new ReceptionChannelInfo(5, remoteDeviceUid, remoteIdentity);
    }

    public static ReceptionChannelInfo createAnyObliviousChannelOrPreKeyWithOwnedDeviceInfo() {
        return new ReceptionChannelInfo(3);
    }

    public static ReceptionChannelInfo createAnyObliviousChannelOrPreKeyInfo() {
        return new ReceptionChannelInfo(4);
    }

    public static ReceptionChannelInfo createAnyObliviousChannelInfo() {
        return new ReceptionChannelInfo(6);
    }

    public static ReceptionChannelInfo of(Encoded encodedChannelInfo) throws DecodingException {
        Encoded[] listOfEncoded = encodedChannelInfo.decodeList();
        if (listOfEncoded.length == 0) {
            throw new DecodingException();
        }
        int type = (int)listOfEncoded[0].decodeLong();
        switch (type) {
            case 0: {
                if (listOfEncoded.length != 1) {
                    throw new DecodingException();
                }
                return ReceptionChannelInfo.createLocalChannelInfo();
            }
            case 1: {
                if (listOfEncoded.length != 4 && listOfEncoded.length != 3) {
                    throw new DecodingException();
                }
                return ReceptionChannelInfo.createObliviousChannelInfo(listOfEncoded[1].decodeUid(), listOfEncoded[2].decodeIdentity());
            }
            case 2: {
                if (listOfEncoded.length != 1) {
                    throw new DecodingException();
                }
                return ReceptionChannelInfo.createAsymmetricChannelInfo();
            }
            case 5: {
                if (listOfEncoded.length != 3) {
                    throw new DecodingException();
                }
                return ReceptionChannelInfo.createPreKeyChannelInfo(listOfEncoded[1].decodeUid(), listOfEncoded[2].decodeIdentity());
            }
        }
        throw new DecodingException("Unknown reception channel type " + type);
    }

    public Encoded encode() {
        if (this.channelType == 1 || this.channelType == 5) {
            return Encoded.of(new Encoded[]{Encoded.of(this.channelType), Encoded.of(this.remoteDeviceUid), Encoded.of(this.remoteIdentity)});
        }
        return Encoded.of(new Encoded[]{Encoded.of(this.channelType)});
    }

    public int getChannelType() {
        return this.channelType;
    }

    public UID getRemoteDeviceUid() {
        return this.remoteDeviceUid;
    }

    public Identity getRemoteIdentity() {
        return this.remoteIdentity;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ReceptionChannelInfo)) {
            return false;
        }
        ReceptionChannelInfo castedOther = (ReceptionChannelInfo)other;
        if (castedOther.getChannelType() != this.getChannelType()) {
            return false;
        }
        switch (this.getChannelType()) {
            case 1: 
            case 5: {
                return castedOther.remoteDeviceUid.equals(this.remoteDeviceUid) && castedOther.remoteIdentity.equals(this.remoteIdentity);
            }
        }
        return true;
    }
}

