/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.EncryptedBytes;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.UID;

public class NetworkReceivedMessage {
    private final UID messageUid;
    private final long serverTimestamp;
    private final EncryptedBytes encryptedContent;
    private final Header header;
    private final boolean hasExtendedPayload;

    public NetworkReceivedMessage(UID messageUid, long serverTimestamp, EncryptedBytes encryptedContent, Header header, boolean hasExtendedPayload) {
        this.messageUid = messageUid;
        this.serverTimestamp = serverTimestamp;
        this.encryptedContent = encryptedContent;
        this.header = header;
        this.hasExtendedPayload = hasExtendedPayload;
    }

    public UID getMessageUid() {
        return this.messageUid;
    }

    public EncryptedBytes getEncryptedContent() {
        return this.encryptedContent;
    }

    public Header getHeader() {
        return this.header;
    }

    public long getServerTimestamp() {
        return this.serverTimestamp;
    }

    public Identity getOwnedIdentity() {
        return this.header.ownedIdentity;
    }

    public boolean hasExtendedPayload() {
        return this.hasExtendedPayload;
    }

    public static class Header {
        private final Identity ownedIdentity;
        private final EncryptedBytes wrappedKey;

        public Header(Identity ownedIdentity, EncryptedBytes wrappedKey) {
            this.ownedIdentity = ownedIdentity;
            this.wrappedKey = wrappedKey;
        }

        public Identity getOwnedIdentity() {
            return this.ownedIdentity;
        }

        public EncryptedBytes getWrappedKey() {
            return this.wrappedKey;
        }
    }
}

