/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.Logger;
import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.PRNGService;
import io.olvid.engine.crypto.Signature;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Constants;
import io.olvid.engine.datatypes.DictionaryKey;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.Session;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.datatypes.key.asymmetric.ServerAuthenticationPrivateKey;
import io.olvid.engine.datatypes.key.symmetric.AuthEncKey;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import io.olvid.engine.metamanager.IdentityDelegate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GroupV2 {
    public static AuthEncKey getSharedBlobSecretKey(Seed blobMainSeed, Seed blobVersionSeed) {
        return (AuthEncKey)Suite.getKDF("kdf_sha-256").gen(new Seed(blobMainSeed, blobVersionSeed), Suite.getDefaultAuthEnc(0).getKDFDelegate())[0];
    }

    public static class IdentifierAndAdminStatus {
        public final Identifier groupIdentifier;
        public final boolean iAmAdmin;

        public IdentifierAndAdminStatus(Identifier groupIdentifier, boolean iAmAdmin) {
            this.groupIdentifier = groupIdentifier;
            this.iAmAdmin = iAmAdmin;
        }
    }

    public static class IdentifierVersionAndKeys {
        public final Identifier groupIdentifier;
        public final int groupVersion;
        public final BlobKeys blobKeys;

        public IdentifierVersionAndKeys(Identifier groupIdentifier, int groupVersion, BlobKeys blobKeys) {
            this.groupIdentifier = groupIdentifier;
            this.groupVersion = groupVersion;
            this.blobKeys = blobKeys;
        }

        public IdentifierVersionAndKeys(Encoded encoded) throws Exception {
            Encoded[] list = encoded.decodeList();
            if (list.length != 3) {
                throw new Exception();
            }
            this.groupIdentifier = Identifier.of(list[0]);
            this.groupVersion = (int)list[1].decodeLong();
            this.blobKeys = BlobKeys.of(list[2]);
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{this.groupIdentifier.encode(), Encoded.of(this.groupVersion), this.blobKeys.encode()});
        }
    }

    public static class IdentityAndPermissionsAndDetails {
        public final Identity identity;
        public final List<String> permissionStrings;
        public final String serializedIdentityDetails;
        public final byte[] groupInvitationNonce;

        public IdentityAndPermissionsAndDetails(Identity identity, List<String> permissionStrings, String serializedIdentityDetails, byte[] groupInvitationNonce) {
            this.identity = identity;
            this.permissionStrings = permissionStrings;
            this.serializedIdentityDetails = serializedIdentityDetails;
            this.groupInvitationNonce = groupInvitationNonce;
        }

        public static IdentityAndPermissionsAndDetails of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length != 4) {
                throw new DecodingException();
            }
            Identity identity = encodeds[0].decodeIdentity();
            ArrayList<String> permissionStrings = new ArrayList<String>();
            for (Encoded encodedPermission : encodeds[1].decodeList()) {
                permissionStrings.add(encodedPermission.decodeString());
            }
            String serializedIdentityDetails = encodeds[2].decodeString();
            byte[] groupInvitationNonce = encodeds[3].decodeBytes();
            return new IdentityAndPermissionsAndDetails(identity, permissionStrings, serializedIdentityDetails, groupInvitationNonce);
        }

        public Encoded encode() {
            ArrayList<Encoded> encodedPermissions = new ArrayList<Encoded>();
            for (String permissionString : this.permissionStrings) {
                encodedPermissions.add(Encoded.of(permissionString));
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(encodedPermissions.toArray(new Encoded[0])), Encoded.of(this.serializedIdentityDetails), Encoded.of(this.groupInvitationNonce)});
        }

        public int hashCode() {
            return this.identity.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IdentityAndPermissionsAndDetails)) {
                return false;
            }
            return this.identity.equals(((IdentityAndPermissionsAndDetails)obj).identity);
        }
    }

    public static class IdentityAndPermissions {
        public final Identity identity;
        public final HashSet<Permission> permissions;

        public IdentityAndPermissions(Identity identity, HashSet<Permission> permissions) {
            this.identity = identity;
            this.permissions = permissions;
        }

        public static IdentityAndPermissions of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length != 2) {
                throw new DecodingException();
            }
            Identity identity = encodeds[0].decodeIdentity();
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (Encoded encodedPermission : encodeds[1].decodeList()) {
                Permission permission = Permission.fromString(encodedPermission.decodeString());
                if (permission == null) continue;
                permissions.add(permission);
            }
            return new IdentityAndPermissions(identity, permissions);
        }

        public Encoded encode() {
            ArrayList<Encoded> encodedPermissions = new ArrayList<Encoded>();
            for (Permission permission : this.permissions) {
                encodedPermissions.add(Encoded.of(permission.getString()));
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.identity), Encoded.of(encodedPermissions.toArray(new Encoded[0]))});
        }

        public boolean isAdmin() {
            return this.permissions.contains((Object)Permission.GROUP_ADMIN);
        }

        public int hashCode() {
            return this.identity.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IdentityAndPermissions)) {
                return false;
            }
            return this.identity.equals(((IdentityAndPermissions)obj).identity);
        }
    }

    public static class InvitationCollectedData {
        public static final String KEY_INVITER_IDENTITY_AND_MAIN_SEED = "ms";
        public static final String KEY_VERSION_SEED = "vs";
        public static final String KEY_GROUP_ADMIN_PRIVATE_KEY = "ga";
        public final HashMap<Identity, Seed> inviterIdentityAndBlobMainSeedCandidates;
        public final HashSet<Seed> blobVersionSeedCandidates;
        public final HashSet<ServerAuthenticationPrivateKey> groupAdminServerAuthenticationPrivateKeyCandidates;

        public InvitationCollectedData(HashMap<Identity, Seed> inviterIdentityAndBlobMainSeedCandidates, HashSet<Seed> blobVersionSeedCandidates, HashSet<ServerAuthenticationPrivateKey> groupAdminServerAuthenticationPrivateKeyCandidates) {
            this.inviterIdentityAndBlobMainSeedCandidates = inviterIdentityAndBlobMainSeedCandidates;
            this.blobVersionSeedCandidates = blobVersionSeedCandidates;
            this.groupAdminServerAuthenticationPrivateKeyCandidates = groupAdminServerAuthenticationPrivateKeyCandidates;
        }

        public InvitationCollectedData() {
            this.inviterIdentityAndBlobMainSeedCandidates = new HashMap();
            this.blobVersionSeedCandidates = new HashSet();
            this.groupAdminServerAuthenticationPrivateKeyCandidates = new HashSet();
        }

        public Encoded encode() {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            ArrayList<Encoded> encodeds = new ArrayList<Encoded>();
            for (Map.Entry<Identity, Seed> entry : this.inviterIdentityAndBlobMainSeedCandidates.entrySet()) {
                encodeds.add(Encoded.of(new Encoded[]{Encoded.of(entry.getKey()), Encoded.of(entry.getValue())}));
            }
            map.put(new DictionaryKey(KEY_INVITER_IDENTITY_AND_MAIN_SEED), Encoded.of(encodeds.toArray(new Encoded[0])));
            encodeds = new ArrayList();
            for (Seed seed : this.blobVersionSeedCandidates) {
                encodeds.add(Encoded.of(seed));
            }
            map.put(new DictionaryKey(KEY_VERSION_SEED), Encoded.of(encodeds.toArray(new Encoded[0])));
            encodeds = new ArrayList();
            for (ServerAuthenticationPrivateKey key : this.groupAdminServerAuthenticationPrivateKeyCandidates) {
                encodeds.add(Encoded.of(key));
            }
            map.put(new DictionaryKey(KEY_GROUP_ADMIN_PRIVATE_KEY), Encoded.of(encodeds.toArray(new Encoded[0])));
            return Encoded.of(map);
        }

        public static InvitationCollectedData of(Encoded encoded) throws DecodingException {
            HashMap<DictionaryKey, Encoded> map = encoded.decodeDictionary();
            HashMap<Identity, Seed> inviterIdentityAndBlobMainSeedCandidates = new HashMap<Identity, Seed>();
            Encoded value = map.get(new DictionaryKey(KEY_INVITER_IDENTITY_AND_MAIN_SEED));
            if (value == null) {
                throw new DecodingException();
            }
            for (Encoded enc : value.decodeList()) {
                Encoded[] list = enc.decodeList();
                inviterIdentityAndBlobMainSeedCandidates.put(list[0].decodeIdentity(), list[1].decodeSeed());
            }
            HashSet<Seed> blobVersionSeedCandidates = new HashSet<Seed>();
            value = map.get(new DictionaryKey(KEY_VERSION_SEED));
            if (value == null) {
                throw new DecodingException();
            }
            for (Encoded enc : value.decodeList()) {
                blobVersionSeedCandidates.add(enc.decodeSeed());
            }
            HashSet<ServerAuthenticationPrivateKey> groupAdminServerAuthenticationPrivateKeyCandidates = new HashSet<ServerAuthenticationPrivateKey>();
            value = map.get(new DictionaryKey(KEY_GROUP_ADMIN_PRIVATE_KEY));
            if (value == null) {
                throw new DecodingException();
            }
            for (Encoded enc : value.decodeList()) {
                groupAdminServerAuthenticationPrivateKeyCandidates.add((ServerAuthenticationPrivateKey)enc.decodePrivateKey());
            }
            return new InvitationCollectedData(inviterIdentityAndBlobMainSeedCandidates, blobVersionSeedCandidates, groupAdminServerAuthenticationPrivateKeyCandidates);
        }

        public void addBlobKeysCandidates(Identity inviterIdentity, BlobKeys blobKeys) {
            if (inviterIdentity != null && blobKeys.blobMainSeed != null) {
                this.inviterIdentityAndBlobMainSeedCandidates.put(inviterIdentity, blobKeys.blobMainSeed);
            }
            if (blobKeys.blobVersionSeed != null) {
                this.blobVersionSeedCandidates.add(blobKeys.blobVersionSeed);
            }
            if (blobKeys.groupAdminServerAuthenticationPrivateKey != null) {
                this.groupAdminServerAuthenticationPrivateKeyCandidates.add(blobKeys.groupAdminServerAuthenticationPrivateKey);
            }
        }
    }

    public static class BlobKeys {
        public static final String KEY_MAIN_SEED = "ms";
        public static final String KEY_VERSION_SEED = "vs";
        public static final String KEY_GROUP_ADMIN_PRIVATE_KEY = "ga";
        public final Seed blobMainSeed;
        public final Seed blobVersionSeed;
        public final ServerAuthenticationPrivateKey groupAdminServerAuthenticationPrivateKey;

        public BlobKeys(Seed blobMainSeed, Seed blobVersionSeed, ServerAuthenticationPrivateKey groupAdminServerAuthenticationPrivateKey) {
            this.blobMainSeed = blobMainSeed;
            this.blobVersionSeed = blobVersionSeed;
            this.groupAdminServerAuthenticationPrivateKey = groupAdminServerAuthenticationPrivateKey;
        }

        public Encoded encode() {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            if (this.blobMainSeed != null) {
                map.put(new DictionaryKey(KEY_MAIN_SEED), Encoded.of(this.blobMainSeed));
            }
            map.put(new DictionaryKey(KEY_VERSION_SEED), Encoded.of(this.blobVersionSeed));
            if (this.groupAdminServerAuthenticationPrivateKey != null) {
                map.put(new DictionaryKey(KEY_GROUP_ADMIN_PRIVATE_KEY), Encoded.of(this.groupAdminServerAuthenticationPrivateKey));
            }
            return Encoded.of(map);
        }

        public static BlobKeys of(Encoded encoded) throws DecodingException {
            HashMap<DictionaryKey, Encoded> map = encoded.decodeDictionary();
            Encoded value = map.get(new DictionaryKey(KEY_MAIN_SEED));
            Seed blobMainSeed = value == null ? null : value.decodeSeed();
            value = map.get(new DictionaryKey(KEY_VERSION_SEED));
            if (value == null) {
                throw new DecodingException();
            }
            Seed blobVersionSeed = value.decodeSeed();
            value = map.get(new DictionaryKey(KEY_GROUP_ADMIN_PRIVATE_KEY));
            ServerAuthenticationPrivateKey groupAdminServerAuthenticationPrivateKey = value == null ? null : (ServerAuthenticationPrivateKey)value.decodePrivateKey();
            return new BlobKeys(blobMainSeed, blobVersionSeed, groupAdminServerAuthenticationPrivateKey);
        }
    }

    public static class ServerPhotoInfo {
        public final Identity serverPhotoIdentity;
        public final UID serverPhotoLabel;
        public final AuthEncKey serverPhotoKey;

        public ServerPhotoInfo(Identity serverPhotoIdentity, UID serverPhotoLabel, AuthEncKey serverPhotoKey) {
            this.serverPhotoIdentity = serverPhotoIdentity;
            this.serverPhotoLabel = serverPhotoLabel;
            this.serverPhotoKey = serverPhotoKey;
        }

        public Encoded encode() {
            if (this.serverPhotoIdentity == null) {
                return Encoded.of(new Encoded[]{Encoded.of(this.serverPhotoLabel), Encoded.of(this.serverPhotoKey)});
            }
            return Encoded.of(new Encoded[]{Encoded.of(this.serverPhotoIdentity), Encoded.of(this.serverPhotoLabel), Encoded.of(this.serverPhotoKey)});
        }

        public static ServerPhotoInfo of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length == 2) {
                return new ServerPhotoInfo(null, encodeds[0].decodeUid(), (AuthEncKey)encodeds[1].decodeSymmetricKey());
            }
            if (encodeds.length == 3) {
                return new ServerPhotoInfo(encodeds[0].decodeIdentity(), encodeds[1].decodeUid(), (AuthEncKey)encodeds[2].decodeSymmetricKey());
            }
            throw new DecodingException();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ServerPhotoInfo)) {
                return false;
            }
            ServerPhotoInfo other = (ServerPhotoInfo)obj;
            return Objects.equals(this.serverPhotoIdentity, other.serverPhotoIdentity) && Objects.equals(this.serverPhotoLabel, other.serverPhotoLabel) && Objects.equals(this.serverPhotoKey, other.serverPhotoKey);
        }
    }

    public static class ServerBlob {
        public static final String KEY_ADMINISTRATORS_CHAIN = "ac";
        public static final String KEY_GROUP_MEMBER_IDENTITY_AND_PERMISSIONS_AND_DETAILS_LIST = "mem";
        public static final String KEY_VERSION = "v";
        public static final String KEY_SERIALIZED_GROUP_DETAILS = "det";
        public static final String KEY_SERVER_PHOTO_INFO = "ph";
        public static final String KEY_SERIALIZED_GROUP_TYPE = "t";
        public final AdministratorsChain administratorsChain;
        public final HashSet<IdentityAndPermissionsAndDetails> groupMemberIdentityAndPermissionsAndDetailsList;
        public final int version;
        public final String serializedGroupDetails;
        public final ServerPhotoInfo serverPhotoInfo;
        public final String serializedGroupType;

        public ServerBlob(AdministratorsChain administratorsChain, HashSet<IdentityAndPermissionsAndDetails> groupMemberIdentityAndPermissionsAndDetailsList, int version, String serializedGroupDetails, ServerPhotoInfo serverPhotoInfo, String serializedGroupType) {
            this.administratorsChain = administratorsChain;
            this.groupMemberIdentityAndPermissionsAndDetailsList = groupMemberIdentityAndPermissionsAndDetailsList;
            this.version = version;
            this.serializedGroupDetails = serializedGroupDetails;
            this.serverPhotoInfo = serverPhotoInfo;
            this.serializedGroupType = serializedGroupType;
        }

        public Encoded encode() {
            HashMap<DictionaryKey, Encoded> map = new HashMap<DictionaryKey, Encoded>();
            map.put(new DictionaryKey(KEY_ADMINISTRATORS_CHAIN), this.administratorsChain.encode());
            Encoded[] encodedGroupMembers = new Encoded[this.groupMemberIdentityAndPermissionsAndDetailsList.size()];
            int i = 0;
            for (IdentityAndPermissionsAndDetails identityAndPermissionsAndDetails : this.groupMemberIdentityAndPermissionsAndDetailsList) {
                encodedGroupMembers[i] = identityAndPermissionsAndDetails.encode();
                ++i;
            }
            map.put(new DictionaryKey(KEY_GROUP_MEMBER_IDENTITY_AND_PERMISSIONS_AND_DETAILS_LIST), Encoded.of(encodedGroupMembers));
            map.put(new DictionaryKey(KEY_VERSION), Encoded.of(this.version));
            map.put(new DictionaryKey(KEY_SERIALIZED_GROUP_DETAILS), Encoded.of(this.serializedGroupDetails));
            if (this.serverPhotoInfo != null) {
                map.put(new DictionaryKey(KEY_SERVER_PHOTO_INFO), this.serverPhotoInfo.encode());
            }
            if (this.serializedGroupType != null) {
                map.put(new DictionaryKey(KEY_SERIALIZED_GROUP_TYPE), Encoded.of(this.serializedGroupType));
            }
            return Encoded.of(map);
        }

        public static ServerBlob of(Encoded encoded) throws DecodingException {
            HashMap<DictionaryKey, Encoded> map = encoded.decodeDictionary();
            Encoded value = map.get(new DictionaryKey(KEY_ADMINISTRATORS_CHAIN));
            if (value == null) {
                throw new DecodingException();
            }
            AdministratorsChain administratorsChain = AdministratorsChain.of(value);
            value = map.get(new DictionaryKey(KEY_GROUP_MEMBER_IDENTITY_AND_PERMISSIONS_AND_DETAILS_LIST));
            if (value == null) {
                throw new DecodingException();
            }
            Encoded[] encodedGroupMembers = value.decodeList();
            HashSet<IdentityAndPermissionsAndDetails> groupMemberIdentityAndPermissionsAndDetailsList = new HashSet<IdentityAndPermissionsAndDetails>();
            for (Encoded encodedGroupMember : encodedGroupMembers) {
                groupMemberIdentityAndPermissionsAndDetailsList.add(IdentityAndPermissionsAndDetails.of(encodedGroupMember));
            }
            value = map.get(new DictionaryKey(KEY_VERSION));
            if (value == null) {
                throw new DecodingException();
            }
            int version = (int)value.decodeLong();
            value = map.get(new DictionaryKey(KEY_SERIALIZED_GROUP_DETAILS));
            if (value == null) {
                throw new DecodingException();
            }
            String serializedGroupDetails = value.decodeString();
            value = map.get(new DictionaryKey(KEY_SERVER_PHOTO_INFO));
            ServerPhotoInfo serverPhotoInfo = value == null ? null : ServerPhotoInfo.of(value);
            value = map.get(new DictionaryKey(KEY_SERIALIZED_GROUP_TYPE));
            String serializedGroupType = value == null ? null : value.decodeString();
            return new ServerBlob(administratorsChain, groupMemberIdentityAndPermissionsAndDetailsList, version, serializedGroupDetails, serverPhotoInfo, serializedGroupType);
        }

        public List<Identity> consolidateWithLogEntries(Identifier groupIdentifier, List<byte[]> logEntries) {
            HashSet<IdentityAndPermissionsAndDetails> leavers = new HashSet<IdentityAndPermissionsAndDetails>();
            ArrayList<Identity> out = new ArrayList<Identity>();
            block2: for (byte[] logEntry : logEntries) {
                for (IdentityAndPermissionsAndDetails groupMember : this.groupMemberIdentityAndPermissionsAndDetailsList) {
                    try {
                        if (!Signature.verify(Constants.SignatureContext.GROUP_LEAVE_NONCE, groupIdentifier, groupMember.groupInvitationNonce, null, groupMember.identity, logEntry)) continue;
                        leavers.add(groupMember);
                        out.add(groupMember.identity);
                        continue block2;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            this.groupMemberIdentityAndPermissionsAndDetailsList.removeAll(leavers);
            return out;
        }
    }

    public static class AdministratorsChain {
        public final UID groupUid;
        public final Block[] blocks;
        public boolean integrityWasChecked;

        public static AdministratorsChain startNewChain(Session session, IdentityDelegate identityDelegate, Identity ownedIdentity, Identity[] otherAdministratorIdentities, PRNGService prng) throws Exception {
            Block firstBlock = new Block(session, identityDelegate, ownedIdentity, otherAdministratorIdentities, prng);
            return new AdministratorsChain(new UID(firstBlock.computeSha256()), new Block[]{firstBlock}, true);
        }

        public AdministratorsChain withCheckedIntegrity(UID expectedGroupUid, Identity latestUpdateAdministratorIdentity, AdministratorsChain alreadyTrustedPrefixAdministratorChain) throws Exception {
            if (latestUpdateAdministratorIdentity != null) {
                boolean found = false;
                for (Identity identity : this.blocks[this.blocks.length - 1].innerData.administratorIdentities) {
                    if (!identity.equals(latestUpdateAdministratorIdentity)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw new Exception("Administrator is not a valid administrator for this chain");
                }
            }
            if (!Objects.equals(expectedGroupUid, this.groupUid)) {
                throw new Exception("GroupUid of chain does not match expected groupUid");
            }
            if (this.integrityWasChecked) {
                return this;
            }
            if (alreadyTrustedPrefixAdministratorChain != null && alreadyTrustedPrefixAdministratorChain.blocks.length > 0) {
                if (!this.isPrefixedBy(alreadyTrustedPrefixAdministratorChain)) {
                    throw new Exception("Trusted prefix is not a prefix");
                }
                for (i = alreadyTrustedPrefixAdministratorChain.blocks.length; i < this.blocks.length; ++i) {
                    if (!Arrays.equals(this.blocks[i].innerData.previousBlockHash, this.blocks[i - 1].computeSha256())) {
                        throw new Exception("Invalid block hash chaining at block " + i);
                    }
                    if (this.blocks[i].isSignatureValid(this.blocks[i - 1].innerData.administratorIdentities, this.blocks[i].innerData.administratorIdentities[0])) continue;
                    throw new Exception("Invalid block signature at block " + i);
                }
            } else {
                if (!this.groupUid.equals(new UID(this.blocks[0].computeSha256()))) {
                    throw new Exception("Invalid groupUid");
                }
                if (!this.blocks[0].isSignatureValid(this.blocks[0].innerData.administratorIdentities, this.blocks[0].innerData.administratorIdentities[0])) {
                    throw new Exception("Invalid block signature at block 0");
                }
                for (i = 1; i < this.blocks.length; ++i) {
                    if (!Arrays.equals(this.blocks[i].innerData.previousBlockHash, this.blocks[i - 1].computeSha256())) {
                        throw new Exception("Invalid block hash chaining at block " + i);
                    }
                    if (this.blocks[i].isSignatureValid(this.blocks[i - 1].innerData.administratorIdentities, this.blocks[i].innerData.administratorIdentities[0])) continue;
                    throw new Exception("Invalid block signature at block " + i);
                }
            }
            this.integrityWasChecked = true;
            return this;
        }

        public boolean isPrefixedBy(AdministratorsChain prefix) {
            if (!Objects.equals(prefix.groupUid, this.groupUid)) {
                return false;
            }
            if (prefix.blocks.length > this.blocks.length) {
                return false;
            }
            for (int i = 0; i < prefix.blocks.length; ++i) {
                if (Objects.equals(this.blocks[i].encodedInnerData, prefix.blocks[i].encodedInnerData)) continue;
                return false;
            }
            return true;
        }

        private AdministratorsChain(UID groupUid, Block[] blocks, boolean integrityWasChecked) {
            this.groupUid = groupUid;
            this.blocks = blocks;
            this.integrityWasChecked = integrityWasChecked;
        }

        public static AdministratorsChain of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length == 0) {
                throw new DecodingException();
            }
            Block[] blocks = new Block[encodeds.length];
            for (int i = 0; i < blocks.length; ++i) {
                blocks[i] = Block.of(encodeds[i]);
            }
            return new AdministratorsChain(new UID(blocks[0].computeSha256()), blocks, false);
        }

        public Encoded encode() {
            Encoded[] encodeds = new Encoded[this.blocks.length];
            for (int i = 0; i < this.blocks.length; ++i) {
                encodeds[i] = this.blocks[i].encode();
            }
            return Encoded.of(encodeds);
        }

        public HashSet<Identity> getAdminIdentities() {
            if (this.blocks.length == 0) {
                return new HashSet<Identity>();
            }
            return new HashSet<Identity>(Arrays.asList(this.blocks[this.blocks.length - 1].innerData.administratorIdentities));
        }

        public AdministratorsChain buildNewChainByAppendingABlock(Session session, IdentityDelegate identityDelegate, Identity ownedIdentity, Identity[] otherAdministratorIdentities, PRNGService prng) throws Exception {
            if (this.blocks.length == 0) {
                return null;
            }
            if (!Arrays.asList(this.blocks[this.blocks.length - 1].innerData.administratorIdentities).contains(ownedIdentity)) {
                Logger.e("Trying to append block to AdministratorsChain using an identity not in the last block!");
                throw new Exception();
            }
            Block[] newBlocks = new Block[this.blocks.length + 1];
            System.arraycopy(this.blocks, 0, newBlocks, 0, this.blocks.length);
            newBlocks[newBlocks.length - 1] = new Block(session, identityDelegate, this.blocks[this.blocks.length - 1], ownedIdentity, otherAdministratorIdentities, prng);
            return new AdministratorsChain(this.groupUid, newBlocks, true);
        }

        public static class Block {
            public final Encoded encodedInnerData;
            public final InnerData innerData;
            public final byte[] signature;

            private Block(Session session, IdentityDelegate identityDelegate, Identity ownedIdentity, Identity[] otherAdministratorIdentities, PRNGService prng) throws Exception {
                this.innerData = new InnerData(ownedIdentity, otherAdministratorIdentities, prng);
                this.encodedInnerData = this.innerData.encode();
                this.signature = identityDelegate.signBlock(session, Constants.SignatureContext.GROUP_ADMINISTRATORS_CHAIN, this.encodedInnerData.getBytes(), ownedIdentity, prng);
            }

            private Block(Session session, IdentityDelegate identityDelegate, Block previousBlock, Identity ownedIdentity, Identity[] otherAdministratorIdentities, PRNGService prng) throws Exception {
                byte[] previousBlockHash = previousBlock.computeSha256();
                Identity[] administratorIdentities = new Identity[otherAdministratorIdentities.length + 1];
                administratorIdentities[0] = ownedIdentity;
                System.arraycopy(otherAdministratorIdentities, 0, administratorIdentities, 1, otherAdministratorIdentities.length);
                this.innerData = new InnerData(previousBlockHash, administratorIdentities);
                this.encodedInnerData = this.innerData.encode();
                this.signature = identityDelegate.signBlock(session, Constants.SignatureContext.GROUP_ADMINISTRATORS_CHAIN, this.encodedInnerData.getBytes(), ownedIdentity, prng);
            }

            private Block(Encoded encodedInnerData, InnerData innerData, byte[] signature) {
                this.encodedInnerData = encodedInnerData;
                this.innerData = innerData;
                this.signature = signature;
            }

            static Block of(Encoded encoded) throws DecodingException {
                Encoded[] encodeds = encoded.decodeList();
                if (encodeds.length != 2) {
                    throw new DecodingException();
                }
                return new Block(encodeds[0], InnerData.of(encodeds[0]), encodeds[1].decodeBytes());
            }

            Encoded encode() {
                return Encoded.of(new Encoded[]{this.encodedInnerData, Encoded.of(this.signature)});
            }

            byte[] computeSha256() {
                return Suite.getHash("sha-256").digest(this.encode().getBytes());
            }

            boolean isSignatureValid(Identity[] previousBlockAdministratorIdentities, Identity probableSignerIdentity) {
                for (Identity administratorIdentity : previousBlockAdministratorIdentities) {
                    if (!administratorIdentity.equals(probableSignerIdentity)) continue;
                    try {
                        if (Signature.verify(Constants.SignatureContext.GROUP_ADMINISTRATORS_CHAIN, this.encodedInnerData.getBytes(), administratorIdentity, this.signature)) {
                            return true;
                        }
                    }
                    catch (Exception exception) {}
                    break;
                }
                for (Identity administratorIdentity : previousBlockAdministratorIdentities) {
                    try {
                        if (administratorIdentity.equals(probableSignerIdentity) || !Signature.verify(Constants.SignatureContext.GROUP_ADMINISTRATORS_CHAIN, this.encodedInnerData.getBytes(), administratorIdentity, this.signature)) continue;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return false;
            }

            public static class InnerData {
                public final byte[] previousBlockHash;
                public final Identity[] administratorIdentities;

                private InnerData(byte[] previousBlockHash, Identity[] administratorIdentities) {
                    this.previousBlockHash = previousBlockHash;
                    this.administratorIdentities = administratorIdentities;
                }

                InnerData(Identity ownedIdentity, Identity[] otherAdministratorIdentities, PRNGService prng) {
                    this.previousBlockHash = prng.bytes(Suite.getHash("sha-256").outputLength());
                    this.administratorIdentities = new Identity[otherAdministratorIdentities.length + 1];
                    this.administratorIdentities[0] = ownedIdentity;
                    System.arraycopy(otherAdministratorIdentities, 0, this.administratorIdentities, 1, otherAdministratorIdentities.length);
                }

                Encoded encode() {
                    return Encoded.of(new Encoded[]{Encoded.of(this.previousBlockHash), Encoded.of(this.administratorIdentities)});
                }

                static InnerData of(Encoded encoded) throws DecodingException {
                    Encoded[] encodeds = encoded.decodeList();
                    if (encodeds.length != 2) {
                        throw new DecodingException();
                    }
                    return new InnerData(encodeds[0].decodeBytes(), encodeds[1].decodeIdentityArray());
                }
            }
        }
    }

    public static class Identifier {
        public static final int CATEGORY_SERVER = 0;
        public static final int CATEGORY_KEYCLOAK = 1;
        public final UID groupUid;
        public final String serverUrl;
        public final int category;

        public Identifier(UID groupUid, String serverUrl, int category) {
            this.groupUid = groupUid;
            this.serverUrl = serverUrl;
            this.category = category;
        }

        public byte[] getBytes() {
            return this.encode().getBytes();
        }

        public Encoded encode() {
            return Encoded.of(new Encoded[]{Encoded.of(this.groupUid), Encoded.of(this.serverUrl), Encoded.of(this.category)});
        }

        public static Identifier of(byte[] bytesGroupIdentifier) throws DecodingException {
            return Identifier.of(new Encoded(bytesGroupIdentifier));
        }

        public static Identifier of(Encoded encoded) throws DecodingException {
            Encoded[] encodeds = encoded.decodeList();
            if (encodeds.length != 3) {
                throw new DecodingException();
            }
            switch ((int)encodeds[2].decodeLong()) {
                case 0: {
                    return new Identifier(encodeds[0].decodeUid(), encodeds[1].decodeString(), 0);
                }
                case 1: {
                    return new Identifier(encodeds[0].decodeUid(), encodeds[1].decodeString(), 1);
                }
            }
            throw new DecodingException();
        }

        public UID computeProtocolInstanceUid() {
            Seed prngSeed = new Seed(this.getBytes());
            PRNG seededPRNG = Suite.getDefaultPRNG(0, prngSeed);
            return new UID(seededPRNG);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Identifier)) {
                return false;
            }
            Identifier other = (Identifier)obj;
            return this.category == other.category && Objects.equals(this.serverUrl, other.serverUrl) && Objects.equals(this.groupUid, other.groupUid);
        }

        public int hashCode() {
            return this.serverUrl.hashCode() + 31 * this.groupUid.hashCode() + this.category;
        }
    }

    public static enum Permission {
        GROUP_ADMIN,
        REMOTE_DELETE_ANYTHING,
        EDIT_OR_REMOTE_DELETE_OWN_MESSAGES,
        CHANGE_SETTINGS,
        SEND_MESSAGE;

        public static final Permission[] DEFAULT_MEMBER_PERMISSIONS;
        public static final Permission[] DEFAULT_ADMIN_PERMISSIONS;
        private static final Map<String, Permission> valueMap;

        public String getString() {
            switch (this.ordinal()) {
                case 0: {
                    return "ga";
                }
                case 1: {
                    return "rd";
                }
                case 2: {
                    return "eo";
                }
                case 3: {
                    return "cs";
                }
                case 4: {
                    return "sm";
                }
            }
            return "";
        }

        public static Permission fromString(String value) {
            return valueMap.get(value);
        }

        public static HashSet<Permission> fromStrings(Collection<String> permissionStrings) {
            HashSet<Permission> res = new HashSet<Permission>();
            for (String permissionString : permissionStrings) {
                Permission perm = Permission.fromString(permissionString);
                if (perm == null) continue;
                res.add(perm);
            }
            return res;
        }

        public static List<String> deserializePermissions(byte[] serializedPermissions) {
            ArrayList<String> permissionStrings = new ArrayList<String>();
            int startPos = 0;
            for (int i = 0; i < serializedPermissions.length; ++i) {
                if (serializedPermissions[i] != 0) continue;
                permissionStrings.add(new String(Arrays.copyOfRange(serializedPermissions, startPos, i), StandardCharsets.UTF_8));
                startPos = i + 1;
            }
            if (startPos != serializedPermissions.length) {
                permissionStrings.add(new String(Arrays.copyOfRange(serializedPermissions, startPos, serializedPermissions.length), StandardCharsets.UTF_8));
            }
            return permissionStrings;
        }

        public static HashSet<Permission> deserializeKnownPermissions(byte[] serializedPermissions) {
            List<String> permissionStrings = Permission.deserializePermissions(serializedPermissions);
            HashSet<Permission> permissions = new HashSet<Permission>();
            for (String permissionString : permissionStrings) {
                Permission permission = Permission.fromString(permissionString);
                if (permission == null) continue;
                permissions.add(permission);
            }
            return permissions;
        }

        public static byte[] serializePermissionStrings(Collection<String> permissionStrings) {
            Object object;
            if (permissionStrings.size() == 0) {
                return new byte[0];
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (String permissionString : permissionStrings) {
                    if (baos.size() > 0) {
                        baos.write(new byte[]{0});
                    }
                    baos.write(permissionString.getBytes(StandardCharsets.UTF_8));
                }
                object = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            baos.close();
            return object;
        }

        public static byte[] serializePermissions(Collection<Permission> permissions) {
            Object object;
            if (permissions.size() == 0) {
                return new byte[0];
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                for (Permission permission : permissions) {
                    if (baos.size() > 0) {
                        baos.write(new byte[]{0});
                    }
                    baos.write(permission.getString().getBytes(StandardCharsets.UTF_8));
                }
                object = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        baos.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            baos.close();
            return object;
        }

        static {
            DEFAULT_MEMBER_PERMISSIONS = new Permission[]{EDIT_OR_REMOTE_DELETE_OWN_MESSAGES, SEND_MESSAGE};
            DEFAULT_ADMIN_PERMISSIONS = new Permission[]{GROUP_ADMIN, EDIT_OR_REMOTE_DELETE_OWN_MESSAGES, CHANGE_SETTINGS, SEND_MESSAGE};
            valueMap = new HashMap<String, Permission>();
            valueMap.put("ga", GROUP_ADMIN);
            valueMap.put("rd", REMOTE_DELETE_ANYTHING);
            valueMap.put("eo", EDIT_OR_REMOTE_DELETE_OWN_MESSAGES);
            valueMap.put("cs", CHANGE_SETTINGS);
            valueMap.put("sm", SEND_MESSAGE);
        }
    }
}

