/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.crypto.PRNG;
import io.olvid.engine.crypto.Suite;
import io.olvid.engine.datatypes.Identity;
import io.olvid.engine.datatypes.Seed;
import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;

public class GroupInformation {
    public final Identity groupOwnerIdentity;
    public final UID groupUid;
    public final String serializedGroupDetailsWithVersionAndPhoto;

    public GroupInformation(Identity groupOwnerIdentity, UID groupUid, String serializedGroupDetailsWithVersionAndPhoto) {
        this.groupOwnerIdentity = groupOwnerIdentity;
        this.groupUid = groupUid;
        this.serializedGroupDetailsWithVersionAndPhoto = serializedGroupDetailsWithVersionAndPhoto;
    }

    public Encoded encode() {
        return Encoded.of(new Encoded[]{Encoded.of(this.groupOwnerIdentity), Encoded.of(this.groupUid), Encoded.of(this.serializedGroupDetailsWithVersionAndPhoto)});
    }

    public static GroupInformation of(Encoded encoded) throws DecodingException {
        Encoded[] encodeds = encoded.decodeList();
        if (encodeds.length != 3) {
            throw new DecodingException();
        }
        return new GroupInformation(encodeds[0].decodeIdentity(), encodeds[1].decodeUid(), encodeds[2].decodeString());
    }

    public static GroupInformation generate(Identity groupOwner, String serializedGroupDetailsWithVersionAndPhoto, PRNG prng) {
        UID groupUid = new UID(prng);
        return new GroupInformation(groupOwner, groupUid, serializedGroupDetailsWithVersionAndPhoto);
    }

    public UID computeProtocolUid() {
        return GroupInformation.computeProtocolUid(this.groupOwnerIdentity.getBytes(), this.groupUid.getBytes());
    }

    public static UID computeProtocolUid(byte[] bytesGroupOwnerIdentity, byte[] bytesGroupUid) {
        Seed prngSeed = new Seed(new Seed(bytesGroupOwnerIdentity), new Seed(bytesGroupUid));
        PRNG seededPRNG = Suite.getDefaultPRNG(0, prngSeed);
        return new UID(seededPRNG);
    }

    public byte[] getGroupOwnerAndUid() {
        byte[] groupOwnerAndUid = new byte[this.groupOwnerIdentity.getBytes().length + 32];
        System.arraycopy(this.groupOwnerIdentity.getBytes(), 0, groupOwnerAndUid, 0, this.groupOwnerIdentity.getBytes().length);
        System.arraycopy(this.groupUid.getBytes(), 0, groupOwnerAndUid, this.groupOwnerIdentity.getBytes().length, 32);
        return groupOwnerAndUid;
    }
}

