/*
 * Decompiled with CFR 0.152.
 */
package io.olvid.engine.datatypes.containers;

import io.olvid.engine.datatypes.UID;
import io.olvid.engine.encoder.DecodingException;
import io.olvid.engine.encoder.Encoded;
import java.util.ArrayList;
import java.util.List;

public class BackupsV2ListItem {
    public final UID threadId;
    public final long version;
    public final String downloadUrl;

    public BackupsV2ListItem(UID threadId, long version, String downloadUrl) {
        this.threadId = threadId;
        this.version = version;
        this.downloadUrl = downloadUrl;
    }

    public static BackupsV2ListItem manyOf(Encoded encoded) throws DecodingException {
        Encoded[] encodeds = encoded.decodeList();
        if (encodeds.length != 3) {
            throw new DecodingException("Bad encoded list length: " + encodeds.length);
        }
        return new BackupsV2ListItem(encodeds[0].decodeUid(), encodeds[1].decodeLong(), encodeds[2].decodeString());
    }

    public static List<BackupsV2ListItem> manyOf(Encoded[] encodeds) throws DecodingException {
        ArrayList<BackupsV2ListItem> list = new ArrayList<BackupsV2ListItem>();
        for (Encoded encoded : encodeds) {
            list.add(BackupsV2ListItem.manyOf(encoded));
        }
        return list;
    }
}

